/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.TestConfigurationKt;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.LintOptionsConfiguration;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelLintOptions;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestLintOptionsConfiguration;", "Lcom/android/tools/lint/client/api/LintOptionsConfiguration;", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "project", "Lcom/android/tools/lint/detector/api/Project;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "fatalOnly", "", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/model/LintModelLintOptions;Z)V", "getDefinedSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "Lcom/android/tools/lint/client/api/Configuration;", "visibleDefault", "ignore", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "setSeverity", "severity", "toString", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTestLintOptionsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestLintOptionsConfiguration.kt\ncom/android/tools/lint/checks/infrastructure/TestLintOptionsConfiguration\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,80:1\n26#2:81\n*S KotlinDebug\n*F\n+ 1 TestLintOptionsConfiguration.kt\ncom/android/tools/lint/checks/infrastructure/TestLintOptionsConfiguration\n*L\n60#1:81\n*E\n"})
public final class TestLintOptionsConfiguration
extends LintOptionsConfiguration {
    @NotNull
    private final TestLintTask task;
    @NotNull
    private final Project project;

    public TestLintOptionsConfiguration(@NotNull TestLintTask task, @NotNull Project project, @NotNull ConfigurationHierarchy configurations, @NotNull LintModelLintOptions lintOptions, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)lintOptions, (String)"lintOptions");
        super(configurations, lintOptions, fatalOnly);
        this.task = task;
        this.project = project;
        File file = this.project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        this.setAssociatedLocation(Location.Companion.create(file));
    }

    @NotNull
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source2, @NotNull Severity visibleDefault) {
        String[] stringArray;
        Severity parentSeverity;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)visibleDefault, (String)"visibleDefault");
        Severity override = TestConfigurationKt.overrideSeverity(this.task, issue, visibleDefault);
        if (override != null) {
            return override;
        }
        Severity severity = super.getDefinedSeverity(issue, source2, visibleDefault);
        if (severity != null) {
            return severity;
        }
        Configuration configuration = this.getParent();
        Severity severity2 = parentSeverity = configuration != null ? configuration.getDefinedSeverity(issue, source2, visibleDefault) : null;
        if (parentSeverity != null) {
            return parentSeverity;
        }
        String[] stringArray2 = this.task.issueIds;
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        for (String id : stringArray) {
            if (!Intrinsics.areEqual((Object)issue.getId(), (Object)id)) continue;
            return TestConfigurationKt.getNonIgnoredSeverity(visibleDefault, issue);
        }
        return this.task.getCheckedIssues().contains(issue) ? TestConfigurationKt.getNonIgnoredSeverity(visibleDefault, issue) : Severity.IGNORE;
    }

    public void ignore(@NotNull Context context, @NotNull Issue issue, @Nullable Location location, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Assert.fail((String)"Not supported in tests.");
    }

    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Assert.fail((String)"Not supported in tests.");
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.project.getDir();
    }
}

