/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceRepositories;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.TestResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.LintResourceRepository;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReader;
import com.android.tools.lint.XmlWriter;
import com.android.tools.lint.checks.infrastructure.AndroidTestTargetWrapper;
import com.android.tools.lint.checks.infrastructure.GradleModelMocker;
import com.android.tools.lint.checks.infrastructure.KotlinClasspathKt;
import com.android.tools.lint.checks.infrastructure.LintTestUtils;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.ResolveCheckerKt;
import com.android.tools.lint.checks.infrastructure.TestConfiguration;
import com.android.tools.lint.checks.infrastructure.TestIssueRegistry;
import com.android.tools.lint.checks.infrastructure.TestLintOptionsConfiguration;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultState;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UFile;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLintClient
extends LintCliClient {
    protected final StringWriter writer = new StringWriter();
    protected File incrementalCheck;
    TestLintTask task;
    private boolean insideReadAction = false;
    private TextReporter reporter;
    private final StringBuilder output = new StringBuilder();
    protected final Set<File> cleanupDirs = Sets.newHashSet();
    private static final Pattern PATH_PATTERN = Pattern.compile("(\\s|^)(/\\S+/[\\S/]+)\\b");

    public TestLintClient() {
        this("test");
    }

    public TestLintClient(String clientName) {
        this(new LintCliFlags(), clientName);
    }

    public TestLintClient(LintCliFlags flags) {
        this(flags, "test");
    }

    public TestLintClient(LintCliFlags flags, String clientName) {
        super(flags, clientName);
        this.reporter = new TextReporter((LintCliClient)this, flags, (Writer)this.writer, false);
        this.reporter.setForwardSlashPaths(true);
        flags.getReporters().add(this.reporter);
    }

    public String getClientDisplayName() {
        return "Lint Unit Tests";
    }

    public void setLintTask(TestLintTask task) {
        if (task != null && task.optionSetter != null) {
            task.optionSetter.set(this.getFlags());
        }
        if (task != null) {
            this.reporter.setFormat(task.textFormat);
            this.reporter.setIncludeSecondaryLineContent(task.showSecondaryLintContent);
        }
        this.task = task;
        if (task != null && !task.allowMissingSdk) {
            TestLintClient.ensureSdkExists((LintClient)this);
        }
    }

    static void ensureSdkExists(LintClient client2) {
        Object message;
        File sdkHome = client2.getSdkHome();
        if (sdkHome == null) {
            message = "No SDK configured. ";
        } else if (!sdkHome.isDirectory()) {
            message = sdkHome + " is not a directory. ";
        } else {
            return;
        }
        message = "This test requires an Android SDK: " + (String)message + "\nIf this test does not really need an SDK, set TestLintTask#allowMissingSdk(). Otherwise, make sure an SDK is available either by specifically pointing to one via TestLintTask#sdkHome(File), or configure $ANDROID_HOME in the environment";
        Assert.fail((String)message);
    }

    private File findIncrementalProject(List<File> files2) {
        File current;
        String incrementalFileName = this.task.incrementalFileName;
        if (incrementalFileName == null) {
            if (files2.size() == 1) {
                assert (false) : "Need to specify incremental file name if more than one project";
            } else {
                return files2.get(0);
            }
        }
        if (files2.size() > 1) {
            for (File dir : files2) {
                File path;
                File root = dir.getParentFile();
                File current2 = new File(root, incrementalFileName.replace('/', File.separatorChar));
                if (!current2.exists()) continue;
                int index = incrementalFileName.indexOf(47);
                if (index != -1 && (path = new File(root, this.task.incrementalFileName.substring(0, index))).exists()) {
                    return path;
                }
                return dir;
            }
        }
        for (File dir : files2) {
            current = new File(dir, incrementalFileName.replace('/', File.separatorChar));
            if (!current.exists()) continue;
            return dir;
        }
        for (File dir : files2) {
            current = new File(dir, "../" + incrementalFileName.replace('/', File.separatorChar));
            if (!current.exists()) continue;
            return dir;
        }
        for (File root : files2) {
            for (File relative : TestLintClient.getFilesRecursively(root)) {
                if (!relative.getName().equals(incrementalFileName)) continue;
                this.task.incrementalFileName = relative.getPath();
                return root;
            }
        }
        return null;
    }

    protected TestResultState checkLint(File rootDir, List<File> files2, List<Issue> issues, TestMode mode) throws Exception {
        Context.Companion.clearDetectorWarnings();
        String incrementalFileName = this.task.incrementalFileName;
        if (incrementalFileName != null) {
            boolean found = false;
            File dir = this.findIncrementalProject(files2);
            if (dir != null) {
                incrementalFileName = this.task.incrementalFileName;
                File current = new File(dir, incrementalFileName.replace('/', File.separatorChar));
                if (!current.exists()) {
                    current = new File(dir.getParentFile(), incrementalFileName.replace('/', File.separatorChar));
                }
                if (current.exists()) {
                    this.setIncremental(current);
                    found = true;
                }
            }
            if (!found) {
                ArrayList<File> allFiles = new ArrayList<File>();
                for (File file : files2) {
                    allFiles.addAll(TestLintClient.getFilesRecursively(file));
                }
                String all = ((Object)allFiles).toString();
                Assert.fail((String)("Could not find incremental file " + incrementalFileName + " in the test project folders; did you mean one of " + all));
            }
        }
        String result = mode.usePartialAnalysis() ? this.analyzeAndReportProvisionally(rootDir, files2, issues) : this.analyze(rootDir, files2, issues);
        Throwable firstThrowable = this.task.runner.getFirstThrowable();
        return new TestResultState(this, rootDir, result, this.getDefiniteIncidents(), firstThrowable);
    }

    private static List<File> getFilesRecursively(File root) {
        ArrayList<File> result = new ArrayList<File>();
        TestLintClient.addFilesUnder(result, root, root.getPath());
        return result;
    }

    private static void addFilesUnder(List<File> result, File file, String skipPrefix) {
        File[] files2;
        if (file.isFile()) {
            String path = file.getPath();
            if (path.startsWith(skipPrefix)) {
                int length = skipPrefix.length();
                if (path.length() > length && path.charAt(length) == File.separatorChar) {
                    ++length;
                }
                path = path.substring(length);
            }
            result.add(new File(path));
        } else if (file.isDirectory() && (files2 = file.listFiles()) != null) {
            Arrays.sort(files2, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            for (File child : files2) {
                TestLintClient.addFilesUnder(result, child, skipPrefix);
            }
        }
    }

    public File getSdkHome() {
        if (this.task.sdkHome != null) {
            return this.task.sdkHome;
        }
        return super.getSdkHome();
    }

    protected Project createProject(File dir, File referenceDir) {
        TestProject project;
        LintModelVariant buildVariant;
        GradleModelMocker mocker;
        ProjectDescription description2;
        if (this.getProjectDirs().contains(dir)) {
            throw new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.getProjectDirs().add(dir);
        try {
            description2 = this.task.dirToProjectDescription.get(dir.getCanonicalFile());
        }
        catch (IOException ignore) {
            description2 = this.task.dirToProjectDescription.get(dir);
        }
        try {
            mocker = this.task.projectMocks.get(dir.getCanonicalFile());
        }
        catch (IOException ignore) {
            mocker = this.task.projectMocks.get(dir);
        }
        LintCliFlags flags = this.getFlags();
        if (mocker != null) {
            if (mocker.getPrimary()) {
                mocker.syncFlagsTo(flags);
                flags.setFatalOnly(this.task.vital);
                String variantName = null;
                if (description2 != null && description2.getVariantName() != null) {
                    variantName = description2.getVariantName();
                } else if (this.task.variantName != null) {
                    variantName = this.task.variantName;
                }
                if (variantName != null) {
                    mocker.setVariantName(variantName);
                }
            } else if (description2 != null && description2.getVariantName() != null) {
                mocker.setVariantName(description2.getVariantName());
            }
        }
        if (this.task.baselineFile != null) {
            flags.setBaselineFile(this.task.baselineFile);
        }
        if (this.task.overrideConfigFile != null) {
            flags.setOverrideLintConfig(this.task.overrideConfigFile);
        }
        if (mocker != null && description2 != null && mocker.hasJavaOrJavaLibraryPlugin()) {
            description2.type(ProjectDescription.Type.JAVA);
        }
        if (description2 != null && this.task.reportFrom != null && !this.task.reportFrom.isUnder(description2) && !description2.isUnder(this.task.reportFrom)) {
            referenceDir = this.task.reportFrom != description2 ? ProjectDescription.Companion.getProjectDirectory(this.task.reportFrom, referenceDir) : dir;
        }
        if ((buildVariant = (project = new TestProject((LintClient)this, dir, referenceDir, description2, mocker)).getBuildVariant()) != null && !this.task.useTestProject) {
            if (TestLintClient.hasOldDirectoryLayout(dir)) {
                Assert.fail((String)"Warning: This test uses a gradle model mocker but doesn't have a main source set (src/main/java); that's suspicious; check that the test file is in (for example) src/main/res/ rather than res/.\nAlternatively, set useTestProjectImplementation(true) on the lint task.");
            }
            TestProject oldProject = project;
            project = new LintModelModuleProject((LintClient)this, dir, referenceDir, buildVariant, null);
            project.setDirectLibraries(oldProject.getDirectLibraries());
        }
        this.registerProject(dir, project);
        return project;
    }

    private static boolean hasOldDirectoryLayout(File dir) {
        if (new File(dir, "res").exists()) {
            return true;
        }
        if (new File(dir, "src").exists() && !new File(dir, "src/main").exists() && !new File(dir, "src/test").exists()) {
            return true;
        }
        File[] srcs = new File(dir, "src/main").listFiles();
        if (srcs != null) {
            block10: for (File child : srcs) {
                String name = child.getName();
                if (name.startsWith("lint-")) continue;
                switch (name) {
                    case "AndroidManifest.xml": 
                    case "res": 
                    case "java": 
                    case "kotlin": 
                    case "lint.xml": {
                        continue block10;
                    }
                    default: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void storeState(Project project) {
        super.storeState(project);
        String absProjectPath = project.getDir().getAbsolutePath();
        String absTestRootPath = this.task.tempDir.getPath();
        String absHomePrefix = System.getProperty("user.home");
        String absProjectCanonicalPath = absProjectPath;
        String absTestRootCanonicalPath = absTestRootPath;
        try {
            absProjectCanonicalPath = project.getDir().getCanonicalPath();
            absTestRootCanonicalPath = this.task.tempDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (XmlFileType type : XmlFileType.values()) {
            File serializationFile = this.getSerializationFile(project, type);
            if (!serializationFile.exists()) continue;
            String xml = FilesKt.readText((File)serializationFile, (Charset)Charsets.UTF_8);
            if (type != XmlFileType.RESOURCE_REPOSITORY) {
                Document document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)false);
                Assert.assertNotNull((String)"Not valid XML", (Object)document2);
            }
            if (!type.isPersistenceFile() && this.getFlags().isFullPath() || this.task.allowAbsolutePathsInMessages) continue;
            this.ensureNoAbsolutePath(serializationFile, xml, absProjectPath);
            this.ensureNoAbsolutePath(serializationFile, xml, absProjectCanonicalPath);
            this.ensureNoAbsolutePath(serializationFile, xml, absTestRootPath);
            this.ensureNoAbsolutePath(serializationFile, xml, absTestRootCanonicalPath);
            this.ensureNoAbsolutePath(serializationFile, xml, absHomePrefix);
        }
    }

    private void ensureNoAbsolutePath(File file, String xml, String path) {
        int index = xml.indexOf(path);
        if (index != -1) {
            Assert.fail((String)("Found absolute path " + path + " in persistence file " + file + ": " + xml));
        }
    }

    public File getCacheDir(String name, boolean create) {
        File cacheDir;
        if (this.task != null && this.task.tempDir != null) {
            cacheDir = new File(this.task.tempDir, "lint-cache/" + name);
        } else {
            cacheDir = super.getCacheDir(name, create);
            cacheDir = new File(cacheDir, "unit-tests/" + name);
        }
        if (create) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public String getDisplayPath(File file, Project project, TextFormat format) {
        String path = super.getDisplayPath(file, project, format);
        return path.replace(File.separatorChar, '/');
    }

    public String getDisplayPath(ResourceItem item, TextFormat format) {
        String path = super.getDisplayPath(item, format);
        return path.replace(File.separatorChar, '/');
    }

    public String getClientRevision() {
        return "unittest";
    }

    public String analyze(File rootDir, List<File> files2, List<Issue> issues) throws Exception {
        return this.analyze(rootDir, files2, issues, LintDriver::analyze);
    }

    public String analyzeAndReportProvisionally(File rootDir, List<File> files2, List<Issue> issues) throws Exception {
        for (File dir : files2) {
            TestLintClient client2 = this.task.runner.createClient();
            client2.setLintTask(this.task);
            client2.incrementalCheck = this.incrementalCheck;
            client2.analyze(rootDir, Collections.singletonList(dir), issues, LintDriver::analyzeOnly);
        }
        return this.analyze(rootDir, files2, issues, LintDriver::mergeOnly);
    }

    public String analyze(File rootDir, List<File> files2, List<Issue> issues, LintTestAnalysis work) throws Exception {
        GradleModelMocker mocker;
        if (!files2.isEmpty() && (mocker = this.task.projectMocks.get(files2.get(0))) != null && mocker.getPrimary()) {
            mocker.syncFlagsTo(this.getFlags());
        }
        LintRequest request = this.createLintRequest(files2);
        if (this.task.customScope != null) {
            request = request.setScope(this.task.customScope);
        }
        if (this.task.platforms != null) {
            request.setPlatform(this.task.platforms);
        }
        if (files2.size() > 1) {
            request.setSrcRoot(rootDir);
        }
        if (this.incrementalCheck != null) {
            File projectDir = this.findIncrementalProject(files2);
            assert (projectDir != null);
            Assert.assertTrue((boolean)this.isProjectDirectory(projectDir));
            Project project = this.createProject(projectDir, projectDir);
            project.addFile(this.incrementalCheck);
            List<Project> projects = Collections.singletonList(project);
            request.setProjects(projects);
            project.setReportIssues(true);
        }
        this.driver = this.createDriver((IssueRegistry)new TestIssueRegistry(issues), request);
        if (this.task.driverConfigurator != null) {
            this.task.driverConfigurator.configure(this.driver);
        }
        for (LintListener listener : this.task.listeners) {
            this.driver.addLintListener(listener);
        }
        this.validateIssueIds();
        work.analyze(this.driver);
        Incident prev = null;
        List incidents = this.getDefiniteIncidents();
        for (Object incident : incidents) {
            if (prev != null) {
                boolean equals = incident.equals((Object)prev);
                Assert.assertEquals((Object)equals, (Object)prev.equals(incident));
                int compare = incident.compareTo(prev);
                Assert.assertEquals((Object)equals, (Object)(compare == 0 ? 1 : 0));
                Assert.assertEquals((long)(-compare), (long)prev.compareTo((Incident)incident));
            }
            prev = incident;
        }
        Collections.sort(incidents);
        if (this.task.reportFrom != null) {
            this.useProjectRelativePaths(this.task.reportFrom);
        } else {
            this.useRootRelativePaths();
        }
        Incident prev2 = prev;
        prev = null;
        for (Incident incident : incidents) {
            if (prev != null && prev2 != null) {
                Assert.assertTrue((incident.compareTo(prev) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((prev.compareTo(prev2) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((incident.compareTo(prev2) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((prev.compareTo(incident) <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((prev2.compareTo(prev) <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((prev2.compareTo(incident) <= 0 ? 1 : 0) != 0);
            }
            prev2 = prev;
            prev = incident;
        }
        String result = this.writeOutput(incidents);
        for (LintListener listener : this.task.listeners) {
            this.driver.removeLintListener(listener);
        }
        return result;
    }

    protected LintRequest createLintRequest(List<? extends File> files2) {
        TestLintRequest request = new TestLintRequest((LintClient)this, files2);
        File root = null;
        if (files2.size() == 1) {
            File dir = files2.get(0);
            File file = dir.getParentFile();
            root = file != null && new File(file, "gradle").isDirectory() ? file : dir;
        } else {
            for (File file : files2) {
                root = root == null ? file : Lint.getCommonParent((File)root, (File)file);
            }
        }
        request.setSrcRoot(root);
        this.configureLintRequest(request);
        return request;
    }

    public String writeOutput(List<Incident> incidents) throws IOException {
        String result;
        LintStats stats = LintStats.Companion.create(this.getErrorCount(), this.getWarningCount());
        for (Reporter reporter : this.getFlags().getReporters()) {
            reporter.write(stats, incidents, this.driver.getRegistry());
        }
        this.output.append(this.writer.toString());
        if (this.output.length() == 0) {
            this.output.append("No warnings.");
        }
        if ((result = this.output.toString()).equals("No issues found.\n")) {
            result = "No warnings.";
        }
        result = this.cleanup(result);
        return result;
    }

    protected LintDriver createDriver(IssueRegistry registry, LintRequest request) {
        LintDriver driver = super.createDriver(registry, request);
        driver.setFatalOnlyMode(this.task.vital);
        return driver;
    }

    public boolean isProjectDirectory(File dir) {
        if (this.task.dirToProjectDescription.containsKey(dir)) {
            return true;
        }
        return super.isProjectDirectory(dir);
    }

    public void addCleanupDir(File dir) {
        this.cleanupDirs.add(dir);
        try {
            this.cleanupDirs.add(dir.getCanonicalFile());
        }
        catch (IOException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.cleanupDirs.add(dir.getAbsoluteFile());
    }

    protected String cleanup(String result) {
        ArrayList<File> sorted = new ArrayList<File>(this.cleanupDirs);
        sorted.sort((file1, file2) -> {
            String path1 = file1.getPath();
            String path2 = file2.getPath();
            int delta = path2.length() - path1.length();
            if (delta != 0) {
                return delta;
            }
            return path1.compareTo(path2);
        });
        for (File dir : sorted) {
            result = this.task.stripRoot(dir, result);
        }
        return result;
    }

    public String getErrors() {
        return this.writer.toString();
    }

    public XmlParser getXmlParser() {
        if (this.task != null && !this.task.allowCompilationErrors) {
            return new LintCliXmlParser((LintClient)this){

                public Document parseXml(CharSequence xml, File file) {
                    try {
                        return PositionXmlParser.parse((String)xml.toString());
                    }
                    catch (Exception e) {
                        String message = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
                        Assert.fail((String)(message + " : Failure processing source " + file + ".\nIf you want your test to work with broken XML sources, add `allowCompilationErrors()` on the TestLintTask.\n"));
                        return null;
                    }
                }
            };
        }
        return super.getXmlParser();
    }

    public UastParser getUastParser(Project project) {
        return new LintCliClient.LintCliUastParser(project){

            public boolean prepare(List<? extends JavaContext> contexts2, LanguageLevel javaLanguageLevel, LanguageVersionSettings kotlinLanguageLevel) {
                boolean ok = super.prepare(contexts2, javaLanguageLevel, kotlinLanguageLevel);
                if (TestLintClient.this.task.forceSymbolResolutionErrors) {
                    ok = false;
                }
                return ok;
            }

            public UFile parse(JavaContext context) {
                UFile file = super.parse(context);
                if (!TestLintClient.this.task.allowCompilationErrors) {
                    ResolveCheckerKt.checkFile(context, file, TestLintClient.this.task, false);
                }
                return file;
            }
        };
    }

    public void runReadAction(Runnable runnable) {
        boolean prev = this.insideReadAction;
        this.insideReadAction = true;
        try {
            super.runReadAction(runnable);
        }
        finally {
            this.insideReadAction = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runReadAction(Computable<T> computable) {
        boolean prev = this.insideReadAction;
        this.insideReadAction = true;
        try {
            Object object = super.runReadAction(computable);
            return (T)object;
        }
        finally {
            this.insideReadAction = prev;
        }
    }

    public boolean supportsPartialAnalysis() {
        return this.driver.getMode() != LintDriver.DriverMode.GLOBAL;
    }

    protected void mergeIncidents(Project library, Project main, Context mainContext, Map<Project, List<Incident>> definiteMap, Map<Project, List<Incident>> provisionalMap) {
        ProjectDescription reportFrom;
        int mainMinSdk;
        String xml;
        Document document2;
        if (library.getMinSdk() <= 1 && !library.getManifestFiles().isEmpty() && (document2 = XmlUtils.parseDocumentSilently((String)(xml = FilesKt.readText((File)((File)library.getManifestFiles().get(0)), (Charset)Charsets.UTF_8)), (boolean)true)) != null) {
            library.readManifest(document2);
        }
        if (main.getMinSdk() <= 1 && !main.getManifestFiles().isEmpty() && (document2 = XmlUtils.parseDocumentSilently((String)(xml = FilesKt.readText((File)((File)main.getManifestFiles().get(0)), (Charset)Charsets.UTF_8)), (boolean)true)) != null) {
            main.readManifest(document2);
        }
        int libraryMinSdk = library.getMinSdk() == -1 ? 1 : library.getMinSdk();
        int n = mainMinSdk = main.getMinSdk() == -1 ? 1 : main.getMinSdk();
        if (libraryMinSdk > mainMinSdk) {
            Assert.fail((String)("Library project minSdkVersion (" + libraryMinSdk + ") cannot be higher than consuming project's minSdkVersion (" + mainMinSdk + ")"));
        }
        if ((reportFrom = this.task.reportFrom) != null) {
            this.setIncidentProjects(reportFrom, definiteMap);
            this.setIncidentProjects(reportFrom, provisionalMap);
        }
        super.mergeIncidents(library, main, mainContext, definiteMap, provisionalMap);
    }

    private void setIncidentProjects(ProjectDescription project, Map<Project, List<Incident>> map) {
        for (List<Incident> incidents : map.values()) {
            this.useProjectRelativePaths(project, incidents);
        }
    }

    public void report(Context context, Incident incident, TextFormat format) {
        Incident prev;
        Throwable throwable;
        Location location = incident.getLocation();
        LintFix fix = incident.getFix();
        Issue issue = incident.getIssue();
        Assert.assertNotNull((Object)location);
        if (context instanceof JavaContext || context instanceof GradleContext || location.getSource() instanceof PsiElement) {
            Assert.assertTrue((String)"LintClient.report accessing a PSI element should always be called inside a runReadAction", (boolean)this.insideReadAction);
        }
        if (issue == IssueRegistry.LINT_ERROR) {
            if (!this.task.allowSystemErrors) {
                return;
            }
            if (incident.getMessage().startsWith("No `.class` files were found in project")) {
                return;
            }
        }
        this.checkMessage(context, incident, format, fix, issue);
        if (incident.getSeverity() == Severity.FATAL) {
            incident.setSeverity(Severity.ERROR);
        }
        if (location.getSecondary() != null) {
            Location l = location.getSecondary();
            if (l == location) {
                Assert.fail((String)"Location link cycle");
            }
            while (l != null) {
                if (l.getMessage() == null) {
                    l.setMessage("<No location-specific message>");
                }
                if (l == l.getSecondary()) {
                    Assert.fail((String)"Location link cycle");
                }
                l = l.getSecondary();
            }
        }
        if (!this.task.allowExceptions && (throwable = LintFix.getThrowable((LintFix)fix, (String)"throwable")) != null && this.task.runner.getFirstThrowable() == null) {
            this.task.runner.setFirstThrowable(throwable);
        }
        incident = this.checkIncidentSerialization(incident);
        if (fix != null) {
            this.checkFix(fix, incident);
        }
        incident = IncidentKt.copySafe((Incident)incident);
        super.report(context, incident, format);
        List incidents = this.getDefiniteIncidents();
        int incidentCount = incidents.size();
        if (incidentCount > 1 && incident.equals((Object)(prev = (Incident)incidents.get(incidentCount - 2)))) {
            if (this.task.allowDuplicates) {
                incidents.remove(incidentCount - 1);
                if (incident.getSeverity().isError()) {
                    this.setErrorCount(this.getErrorCount() - 1);
                } else if (incident.getSeverity() == Severity.WARNING) {
                    this.setWarningCount(this.getWarningCount() - 1);
                }
            } else {
                TestMode mode = this.task.runner.getCurrentTestMode();
                String field = mode.getFieldName();
                Object prologue = "java.lang.AssertionError: Incident (message, location) reported more\nthan once";
                if (mode != TestMode.DEFAULT) {
                    prologue = (String)prologue + " in test mode " + field;
                }
                prologue = (String)prologue + "; this typically means that your detector is incorrectly reaching the same element twice (for example, visiting each call of a method and reporting the error on the method itself), or that you should incorporate more details in your error message such as specific names of methods or variables to make each message unique if overlapping errors are expected.\n\n";
                if (mode != TestMode.DEFAULT) {
                    prologue = (String)prologue + "To debug the unit test in this test mode, add the following to the lint() test task: testModes(" + field + ")\n\n";
                }
                prologue = SdkUtils.wrap((String)((String)prologue).substring(((String)prologue).indexOf(58) + 2), (int)72, (String)"");
                String interlogue = "";
                if (this.driver.getMode() == LintDriver.DriverMode.MERGE) {
                    interlogue = "This error happened while merging in provisional results; a common\ncause for this is that your detector is\tusing the merged manifest from\neach project to report problems. This means that these same errors are\nreported repeatedly, from each sub project,\tinstead\tof only\tbeing\nreported on the\tmain/app project. To fix this, consider\tadding a check\nfor (context.project == context.mainProject).\n\n";
                }
                String epilogue = "If you *really* want to allow this, add .allowDuplicates() to the test\ntask.\n\nIdentical incident encountered at the same location more than once:\n" + incident;
                Assert.fail((String)((String)prologue + interlogue + epilogue));
            }
        }
        if (fix instanceof LintFix.AnnotateFix && fix.getRange() == null && !(location.getSource() instanceof UAnnotated) && !(location.getSource() instanceof PsiModifierListOwner)) {
            Assert.fail((String)"Could not find the associated modifier list location for the annotation lint fix.\nPlease explicitly initialize it using `annotate(...).range(context.getLocation(member))...`");
        }
    }

    String testModePrefix() {
        if (this.task == null) {
            return "";
        }
        TestMode mode = this.task.runner.getCurrentTestMode();
        return TestLintClient.testModePrefix(mode);
    }

    static String testModePrefix(TestMode mode) {
        if (mode == TestMode.DEFAULT) {
            return "";
        }
        return "NOTE: The following is specific to test mode \"" + mode.getDescription() + "\" (" + mode.getFieldName() + ") :\n\n";
    }

    private void checkMessage(Context context, Incident incident, TextFormat format, LintFix fix, Issue issue) {
        String message = incident.getMessage();
        if (this.task.messageChecker != null && (this.task.allowExceptions || issue != IssueRegistry.LINT_ERROR || !(fix instanceof LintFix.DataMap) || ((LintFix.DataMap)fix).getThrowable("throwable") == null)) {
            this.task.messageChecker.checkReportedError(context, incident.getIssue(), incident.getSeverity(), incident.getLocation(), format.convertTo(message, TextFormat.TEXT), fix);
        }
        if (!this.task.allowAbsolutePathsInMessages) {
            Matcher matcher = PATH_PATTERN.matcher(message);
            int offset = 0;
            while (matcher.find(offset)) {
                String path = matcher.group(2);
                File file = new File(path);
                if (file.exists()) {
                    Assert.fail((String)("Found absolute path\n    " + path + "\nin a reported error message; this is discouraged because absolute\npaths do not play well with baselines, shared HTML reports, remote\ncaching, etc. If you really want this, you can set the property\n`lint().allowAbsolutePathsInMessages(true)`.\n\nError message was: `" + message + "`"));
                }
                offset = matcher.end();
            }
        }
        if (fix != null) {
            this.checkFixMessage(fix, true);
        }
    }

    private void checkFixMessage(LintFix fix, boolean isTopLevel) {
        if (fix instanceof LintFix.DataMap) {
            return;
        }
        if (fix instanceof LintFix.LintFixGroup) {
            LintFix.LintFixGroup group = (LintFix.LintFixGroup)fix;
            if (group.getType() == LintFix.GroupType.ALTERNATIVES) {
                for (LintFix nested : group.getFixes()) {
                    this.checkFixMessage(nested, false);
                }
            } else {
                if (group.hasDisplayName()) {
                    return;
                }
                for (LintFix nested : group.getFixes()) {
                    this.checkFixMessage(nested, false);
                }
            }
        } else {
            if (fix.getDisplayName() != null) {
                return;
            }
            Assert.fail((String)("Missing fix message for associated quickfix (" + fix + ")"));
        }
    }

    private Incident checkIncidentSerialization(Incident incident) {
        try {
            File xmlFile = File.createTempFile("incident", ".xml");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), Charsets.UTF_8));
            XmlWriter xmlWriter = new XmlWriter((LintCliClient)this, XmlFileType.INCIDENTS, (Writer)writer, this.getPathVariables());
            xmlWriter.writeIncidents(Collections.singletonList(incident), Collections.emptyList());
            final List<Issue> issueList = Collections.singletonList(incident.getIssue());
            IssueRegistry registry = new IssueRegistry(){

                public List<Issue> getIssues() {
                    return issueList;
                }
            };
            XmlReader xmlReader = new XmlReader((LintCliClient)this, registry, incident.getProject(), xmlFile);
            Object original = incident.getLocation().getOriginalSource();
            incident = (Incident)xmlReader.getIncidents().get(0);
            incident.getLocation().setOriginalSource(original);
            xmlFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return incident;
    }

    private void checkFix(LintFix fix, Incident incident) {
        if (fix instanceof LintFix.ReplaceString) {
            File file;
            Pattern pattern;
            LintFix.ReplaceString replaceFix = (LintFix.ReplaceString)fix;
            String oldPattern = replaceFix.getOldPattern();
            Location range = replaceFix.getRange();
            String oldString = replaceFix.getOldString();
            Location rangeLocation = range != null ? range : incident.getLocation();
            String contents = this.readFile(rangeLocation.getFile()).toString();
            Position start = rangeLocation.getStart();
            Position end = rangeLocation.getEnd();
            assert (start != null);
            assert (end != null);
            String locationRange = contents.substring(start.getOffset(), end.getOffset());
            if (oldString != null) {
                int startIndex = contents.indexOf(oldString, start.getOffset());
                if (!(startIndex != -1 && startIndex <= end.getOffset() || oldString.equals("_lint_insert_begin_") || oldString.equals("_lint_insert_end_"))) {
                    Assert.fail((String)(this.testModePrefix() + "Did not find \"" + oldString + "\" in \"" + locationRange + "\" as suggested in the quickfix for issue " + incident.getIssue() + " (text in range was \"" + locationRange + "\")"));
                }
            } else if (oldPattern != null && !(pattern = Pattern.compile(oldPattern)).matcher(locationRange).find()) {
                Assert.fail((String)(this.testModePrefix() + "Did not match pattern \"" + oldPattern + "\" in \"" + locationRange + "\" as suggested in the quickfix for issue " + incident.getIssue()));
            }
            File file2 = file = range != null ? range.getFile() : incident.getLocation().getFile();
            if (!file.isFile()) {
                Assert.fail((String)(file + " is not a file. Use fix().newFile() instead of fix().replace."));
            }
        } else if (fix instanceof LintFix.CreateFileFix) {
            LintFix.CreateFileFix createFix = (LintFix.CreateFileFix)fix;
            File file = createFix.getFile();
            if (createFix.getDelete()) {
                Assert.assertTrue((String)(file + " cannot be deleted; does not exist"), (boolean)file.exists());
            } else if (file.exists()) {
                Assert.fail((String)("Cannot create file " + file + ": already exists"));
            }
        }
        this.readFixFiles(incident, fix);
    }

    private void readFixFiles(Incident incident, LintFix fix) {
        if (fix instanceof LintFix.LintFixGroup) {
            for (LintFix f : ((LintFix.LintFixGroup)fix).getFixes()) {
                this.readFixFiles(incident, f);
            }
        } else {
            Location location = LintFixPerformer.Companion.getLocation(incident, fix);
            File file = location.getFile();
            if (file.isFile()) {
                String displayName = fix.getDisplayName();
                Assert.assertTrue((String)("Quickfix file paths must be absolute: " + file + " from " + (displayName != null ? displayName : fix.getClass().getSimpleName())), (boolean)file.isAbsolute());
                this.getSourceText(file);
            }
        }
    }

    protected void sortResults() {
        super.sortResults();
        LintTestUtils.checkTransitiveComparator(this.getDefiniteIncidents());
    }

    private void useRootRelativePaths() {
        boolean multipleProjects = false;
        Iterator iterator = this.getDefiniteIncidents().iterator();
        if (iterator.hasNext()) {
            Incident prev = (Incident)iterator.next();
            Project firstProject = prev.getProject();
            while (iterator.hasNext()) {
                Incident incident = (Incident)iterator.next();
                if (firstProject == incident.getProject()) continue;
                multipleProjects = true;
                break;
            }
        }
        if (multipleProjects) {
            for (Incident incident : this.getDefiniteIncidents()) {
                incident.setProject(null);
            }
        }
    }

    private void useProjectRelativePaths(ProjectDescription from) {
        this.useProjectRelativePaths(from, this.getDefiniteIncidents());
    }

    private void useProjectRelativePaths(ProjectDescription from, List<Incident> incidents) {
        if (incidents.isEmpty()) {
            return;
        }
        Project project = this.findProject(from);
        for (Incident incident : incidents) {
            Project incidentProject = incident.getProject();
            if (incidentProject == null || incidentProject == project) continue;
            File dir = incidentProject.getDir();
            Location location = TestLintClient.ensureAbsolutePaths(dir, incident.getLocation());
            incident.setLocation(location);
            if (project == null) continue;
            incident.setProject(project);
        }
    }

    private Project findProject(ProjectDescription description2) {
        for (Map.Entry<File, ProjectDescription> entry : this.task.dirToProjectDescription.entrySet()) {
            if (entry.getValue() != description2) continue;
            return (Project)this.getDirToProject().get(entry.getKey());
        }
        return null;
    }

    private static Location ensureAbsolutePaths(File base, Location location) {
        Location secondary = location.getSecondary() != null ? TestLintClient.ensureAbsolutePaths(base, location.getSecondary()) : null;
        File file = location.getFile();
        if (!file.isAbsolute() || file.getPath().startsWith("../")) {
            String relative = file.getPath();
            File absolute = new File(base, relative);
            Position start = location.getStart();
            Position end = location.getEnd();
            Location location2 = location = start != null && end != null ? Location.create((File)absolute, (Position)start, (Position)end) : Location.create((File)absolute);
        }
        if (secondary != null) {
            location.setSecondary(secondary);
        }
        return location;
    }

    public void log(Throwable exception, String format, Object ... args) {
        if (exception != null) {
            if (this.task.runner.getFirstThrowable() == null) {
                this.task.runner.setFirstThrowable(exception);
            }
            exception.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        if (format != null) {
            sb.append(String.format(format, args));
        }
        if (exception != null) {
            sb.append(exception);
        }
        System.err.println(sb);
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        if (!this.task.useTestConfiguration) {
            return super.getConfiguration(project, driver);
        }
        return this.getConfigurations().getConfigurationForProject(project, (file, defaultConfiguration) -> this.createConfiguration(project, (Configuration)defaultConfiguration));
    }

    private Configuration createConfiguration(Project project, Configuration defaultConfiguration) {
        ConfigurationHierarchy configurations;
        if (this.task.overrideConfigFile != null && (configurations = this.getConfigurations()).getOverrides() == null) {
            LintXmlConfiguration config = LintXmlConfiguration.create((ConfigurationHierarchy)configurations, (File)this.task.overrideConfigFile);
            configurations.addGlobalConfigurations(null, (Configuration)config);
        }
        LintModelModule model = project.getBuildModule();
        ConfigurationHierarchy configurations2 = this.getConfigurations();
        if (model != null) {
            LintModelLintOptions options = model.getLintOptions();
            return configurations2.createLintOptionsConfiguration(project, options, false, defaultConfiguration, () -> new TestLintOptionsConfiguration(this.task, project, configurations2, options, false));
        }
        return configurations2.createChainedConfigurations(project, null, () -> new TestConfiguration(this.task, configurations2), () -> {
            File lintConfigXml = ConfigurationHierarchy.Companion.getLintXmlFile(project.getDir());
            if (lintConfigXml.isFile()) {
                LintXmlConfiguration configuration = LintXmlConfiguration.create((ConfigurationHierarchy)configurations2, (File)lintConfigXml);
                configuration.setFileLevel(false);
                return configuration;
            }
            return null;
        });
    }

    protected Set<File> getBootClassPath(Collection<? extends Project> knownProjects) {
        Set fromSuper = super.getBootClassPath(knownProjects);
        if (fromSuper != null && TestLintClient.hasKotlin(knownProjects)) {
            HashSet<File> files2 = new HashSet<File>(fromSuper);
            files2.addAll(KotlinClasspathKt.findKotlinStdlibPath());
            return files2;
        }
        return fromSuper;
    }

    private static boolean hasKotlin(Collection<? extends Project> projects) {
        for (Project project : projects) {
            for (File dir : project.getJavaSourceFolders()) {
                if (!TestLintClient.hasKotlin(dir)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasKotlin(File dir) {
        File[] files2;
        if (dir.getPath().endsWith(".kt")) {
            return true;
        }
        if (dir.isDirectory() && (files2 = dir.listFiles()) != null) {
            for (File sub : files2) {
                if (!TestLintClient.hasKotlin(sub)) continue;
                return true;
            }
        }
        return false;
    }

    public List<File> findGlobalRuleJars(LintDriver driver, boolean warnDeprecated) {
        return Collections.emptyList();
    }

    public void setIncremental(File currentFile) {
        this.incrementalCheck = currentFile;
    }

    public ResourceRepository getResources(Project project, ResourceRepositoryScope scope) {
        this.task.requestedResourceRepository = true;
        if (!this.task.forceAgpResourceRepository) {
            super.getResources(project, scope);
            LintResourceRepository.Companion.clearCaches((LintCliClient)this, project);
            ResourceRepository resources = super.getResources(project, scope);
            if (this.driver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY && scope != ResourceRepositoryScope.PROJECT_ONLY) {
                return LintResourceRepository.Companion.removeFileAccess(project, resources);
            }
            return resources;
        }
        ResourceNamespace namespace = project.getResourceNamespace();
        ArrayList<Project> projects = new ArrayList<Project>();
        projects.add(project);
        if (scope.includesDependencies()) {
            for (Project dep : project.getAllLibraries()) {
                if (dep.isExternalLibrary()) continue;
                projects.add(dep);
            }
        }
        ArrayList<Pair<String, List<File>>> resourceSets = new ArrayList<Pair<String, List<File>>>();
        for (Project p2 : projects) {
            List resFolders = p2.getResourceFolders();
            resourceSets.add((Pair<String, List<File>>)new Pair((Object)project.getName(), (Object)resFolders));
        }
        return TestLintClient.getResources(namespace, null, resourceSets, true);
    }

    public static ResourceRepository getResources(ResourceNamespace namespace, String libraryName, List<Pair<String, List<File>>> resourceSets, boolean reportErrors) {
        TestResourceRepository repository;
        block13: {
            repository = new TestResourceRepository(ResourceNamespace.RES_AUTO);
            StdLogger logger = reportErrors ? new StdLogger(StdLogger.Level.INFO) : new NullLogger();
            ResourceMerger merger = new ResourceMerger(0);
            try {
                for (Pair<String, List<File>> pair : resourceSets) {
                    String projectName = (String)pair.getFirst();
                    List resFolders = (List)pair.getSecond();
                    ResourceSet resourceSet = new ResourceSet(projectName, namespace, libraryName, true, null){

                        protected void checkItems() {
                        }
                    };
                    for (File res : resFolders) {
                        resourceSet.addSource(res);
                    }
                    resourceSet.loadFromFiles((ILogger)logger);
                    merger.addDataSet(resourceSet);
                }
                repository.update(merger);
                for (ListMultimap map : repository.getResourceTable().values()) {
                    ResourceRepositories.sortItemLists((ListMultimap)map);
                }
                Map items = repository.getResourceTable().row((Object)ResourceNamespace.TODO());
                ListMultimap layouts = (ListMultimap)items.get(ResourceType.LAYOUT);
                if (layouts != null) {
                    for (ResourceItem item : layouts.values()) {
                        File file;
                        PathString source2 = item.getSource();
                        if (source2 == null || (file = source2.toFile()) == null) continue;
                        String xml = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
                        Document document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                        Assert.assertNotNull((Object)document2);
                        HashSet ids = Sets.newHashSet();
                        TestLintClient.addIds(ids, document2);
                        if (ids.isEmpty()) continue;
                        ListMultimap idMap = items.computeIfAbsent(ResourceType.ID, k -> ArrayListMultimap.create());
                        for (String id : ids) {
                            ResourceMergerItem idItem = new ResourceMergerItem(id, ResourceNamespace.TODO(), ResourceType.ID, null, null, null);
                            String qualifiers = source2.getParentFileName();
                            if (qualifiers == null) {
                                qualifiers = "";
                            } else if (qualifiers.startsWith("layout-")) {
                                qualifiers = qualifiers.substring("layout-".length());
                            } else if (qualifiers.equals("layout")) {
                                qualifiers = "";
                            }
                            ResourceFile.createSingle((File)file, (ResourceMergerItem)idItem, (String)qualifiers);
                            idMap.put((Object)id, (Object)idItem);
                        }
                    }
                }
            }
            catch (MergingException e) {
                if (!reportErrors) break block13;
                throw new RuntimeException(e);
            }
        }
        return repository;
    }

    private static void addIds(Set<String> ids, Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id != null && !id.isEmpty()) {
                ids.add(Lint.stripIdPrefix((String)id));
            }
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String value = attribute.getValue();
                if (!value.startsWith("@+id/")) continue;
                ids.add(value.substring("@+id/".length()));
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            TestLintClient.addIds(ids, child);
        }
    }

    public IAndroidTarget getCompileTarget(Project project) {
        IAndroidTarget compileTarget = super.getCompileTarget(project);
        String targetHash = project.getBuildTargetHash();
        if (compileTarget == null) {
            if (this.task.requireCompileSdk && targetHash != null && project.isAndroidProject()) {
                Assert.fail((String)("Could not find SDK to compile with (" + targetHash + "). Either allow the test to use any installed SDK (it defaults to the highest version) via TestLintTask#requireCompileSdk(false), or make sure the SDK being used is the right  one via TestLintTask#sdkHome(File) or $ANDROID_HOME and that the actual SDK platform (platforms/" + targetHash + " is installed there"));
            }
        } else if (targetHash != null && !compileTarget.hashString().equals(targetHash)) {
            String targetName = StringsKt.removePrefix((String)targetHash, (CharSequence)"android-");
            try {
                return new AndroidTestTargetWrapper(compileTarget, new AndroidVersion(targetName));
            }
            catch (AndroidVersion.AndroidVersionException e) {
                Assert.fail((String)("Invalid `compileSdkVersion` " + targetName));
            }
        }
        return compileTarget;
    }

    public Set<Desugaring> getDesugaring(Project project) {
        if (this.task.desugaring != null) {
            return this.task.desugaring;
        }
        return super.getDesugaring(project);
    }

    public List<File> getExternalAnnotations(Collection<? extends Project> projects) {
        ArrayList externalAnnotations = Lists.newArrayList((Iterable)super.getExternalAnnotations(projects));
        for (Project project : projects) {
            File annotationsJar;
            File annotationsZip = new File(project.getDir(), "annotations.zip");
            if (annotationsZip.isFile()) {
                externalAnnotations.add(annotationsZip);
            }
            if (!(annotationsJar = new File(project.getDir(), "annotations.jar")).isFile()) continue;
            externalAnnotations.add(annotationsJar);
        }
        return externalAnnotations;
    }

    public URLConnection openConnection(URL url, int timeout) throws IOException {
        Map<String, byte[]> mockNetworkData = this.task.mockNetworkData;
        Map<String, Integer> mockNetworkErrorCodes = this.task.mockNetworkErrorCodes;
        Map<String, Map<String, List<String>>> mockNetworkHeaderFields = this.task.mockNetworkHeaderFields;
        if (mockNetworkData != null || mockNetworkErrorCodes != null) {
            Map<String, List<String>> headers;
            String query = url.toExternalForm();
            final Integer response = mockNetworkErrorCodes != null ? mockNetworkErrorCodes.get(query) : null;
            final byte[] bytes2 = mockNetworkData != null ? mockNetworkData.get(query) : null;
            Map<String, List<String>> map = headers = mockNetworkHeaderFields != null ? mockNetworkHeaderFields.get(query) : null;
            if (bytes2 != null || response != null || headers != null) {
                String protocol = url.getProtocol();
                if (protocol.equals("http") || protocol.equals("https") || response != null) {
                    return new HttpURLConnection(url){

                        @Override
                        public void connect() {
                        }

                        @Override
                        public void disconnect() {
                        }

                        @Override
                        public boolean usingProxy() {
                            return false;
                        }

                        @Override
                        public InputStream getInputStream() {
                            if (response != null) {
                                return null;
                            }
                            return new ByteArrayInputStream(bytes2);
                        }

                        @Override
                        public int getResponseCode() {
                            if (response != null) {
                                return response;
                            }
                            return 200;
                        }

                        @Override
                        public Map<String, List<String>> getHeaderFields() {
                            if (headers != null) {
                                return headers;
                            }
                            return super.getHeaderFields();
                        }

                        @Override
                        public String getHeaderField(String name) {
                            if (headers != null) {
                                for (Map.Entry entry : headers.entrySet()) {
                                    List values;
                                    String key = (String)entry.getKey();
                                    if (!key.equalsIgnoreCase(name) || (values = (List)entry.getValue()).size() <= 0) continue;
                                    return (String)values.get(0);
                                }
                            }
                            return super.getHeaderField(name);
                        }

                        @Override
                        public int getHeaderFieldInt(String name, int Default) {
                            String f = this.getHeaderField(name);
                            if (f != null) {
                                try {
                                    return Integer.parseInt(f);
                                }
                                catch (NumberFormatException e) {
                                    return Default;
                                }
                            }
                            return Default;
                        }

                        @Override
                        public long getHeaderFieldLong(String name, long Default) {
                            String f = this.getHeaderField(name);
                            if (f != null) {
                                try {
                                    return Long.parseLong(f);
                                }
                                catch (NumberFormatException e) {
                                    return Default;
                                }
                            }
                            return Default;
                        }
                    };
                }
                return new URLConnection(url){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(bytes2);
                    }
                };
            }
        }
        if (!this.task.allowNetworkAccess) {
            Assert.fail((String)("Lint detector test attempted to read from the network. Normally this means that you have forgotten to set up mock data (calling networkData() on the lint task) or the URL no longer matches. The URL encountered was " + url));
        }
        return super.openConnection(url, timeout);
    }

    public LanguageVersionSettings getKotlinLanguageLevel(Project project) {
        if (this.task.kotlinLanguageLevel != null) {
            return this.task.kotlinLanguageLevel;
        }
        return super.getKotlinLanguageLevel(project);
    }

    public LanguageLevel getJavaLanguageLevel(Project project) {
        if (this.task.javaLanguageLevel != null) {
            return this.task.javaLanguageLevel;
        }
        return super.getJavaLanguageLevel(project);
    }

    public static class TestProject
    extends Project {
        public final GradleModelMocker mocker;
        private final ProjectDescription projectDescription;
        private LintModelVariant cachedLintVariant = null;
        private List<LintModelSourceProvider> mProviders;

        public TestProject(LintClient client2, File dir, File referenceDir, ProjectDescription projectDescription, GradleModelMocker mocker) {
            super(client2, dir, referenceDir);
            this.projectDescription = projectDescription;
            this.mocker = mocker;
            this.mergeManifests = true;
        }

        public boolean isGradleProject() {
            return this.mocker != null || super.isGradleProject();
        }

        public boolean isLibrary() {
            if (this.mocker != null && this.mocker.isLibrary()) {
                return true;
            }
            return super.isLibrary() || this.projectDescription != null && this.projectDescription.getType() == ProjectDescription.Type.LIBRARY;
        }

        public boolean isAndroidProject() {
            if (this.mocker != null && this.mocker.hasJavaOrJavaLibraryPlugin()) {
                return false;
            }
            return this.projectDescription == null || this.projectDescription.getType() != ProjectDescription.Type.JAVA;
        }

        public Boolean dependsOn(String artifact) {
            artifact = AndroidxNameUtils.getCoordinateMapping((String)artifact);
            LintModelVariant variant = this.getBuildVariant();
            if (this.mocker != null && variant != null) {
                for (LintModelLibrary lib : variant.getMainArtifact().getDependencies().getAll()) {
                    if (!TestProject.libraryMatches(artifact, lib)) continue;
                    return true;
                }
            }
            return super.dependsOn(artifact);
        }

        private static boolean libraryMatches(String artifact, LintModelLibrary lib) {
            if (!(lib instanceof LintModelExternalLibrary)) {
                return false;
            }
            LintModelMavenName coordinates = ((LintModelExternalLibrary)lib).getResolvedCoordinates();
            Object c = coordinates.getGroupId() + ":" + coordinates.getArtifactId();
            c = AndroidxNameUtils.getCoordinateMapping((String)c);
            return artifact.equals(c);
        }

        public int getBuildSdk() {
            Integer buildSdk;
            if (this.mocker != null && (buildSdk = this.mocker.getBuildSdk()) != null) {
                return buildSdk;
            }
            return super.getBuildSdk();
        }

        public String getBuildTargetHash() {
            String buildTargetHash;
            if (this.mocker != null && (buildTargetHash = this.mocker.getBuildTargetHash()) != null) {
                return buildTargetHash;
            }
            return super.getBuildTargetHash();
        }

        public boolean getReportIssues() {
            if (this.projectDescription != null && !this.projectDescription.getReport()) {
                return false;
            }
            return super.getReportIssues();
        }

        public LintModelVariant getBuildVariant() {
            if (this.cachedLintVariant != null) {
                return this.cachedLintVariant;
            }
            if (this.mocker != null) {
                this.cachedLintVariant = this.mocker.getLintVariant();
            }
            return this.cachedLintVariant;
        }

        private List<LintModelSourceProvider> getSourceProviders() {
            if (this.mProviders == null) {
                LintModelVariant variant = this.getBuildVariant();
                this.mProviders = variant == null ? Collections.emptyList() : variant.getSourceProviders();
            }
            return this.mProviders;
        }

        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                if (this.mocker != null) {
                    for (LintModelSourceProvider provider : this.getSourceProviders()) {
                        provider.getManifestFiles().stream().filter(File::exists).forEach(manifestFile -> {
                            if (this.manifestFiles == null) {
                                this.manifestFiles = Lists.newArrayList();
                            }
                            this.manifestFiles.add(manifestFile);
                        });
                    }
                }
                if (this.manifestFiles == null) {
                    this.manifestFiles = super.getManifestFiles();
                }
            }
            return this.manifestFiles;
        }

        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                if (this.mocker != null) {
                    for (LintModelSourceProvider provider : this.getSourceProviders()) {
                        Collection list2 = provider.getResDirectories();
                        for (File file : list2) {
                            if (!file.exists()) continue;
                            if (this.resourceFolders == null) {
                                this.resourceFolders = Lists.newArrayList();
                            }
                            this.resourceFolders.add(file);
                        }
                    }
                }
                if (this.resourceFolders == null) {
                    this.resourceFolders = super.getResourceFolders();
                }
            }
            return this.resourceFolders;
        }

        public List<File> getJavaSourceFolders() {
            if (this.javaSourceFolders == null) {
                if (this.mocker != null) {
                    ArrayList list2 = Lists.newArrayList();
                    for (LintModelSourceProvider provider : this.getSourceProviders()) {
                        Collection srcDirs = provider.getJavaDirectories();
                        for (File srcDir : srcDirs) {
                            if (!srcDir.exists()) continue;
                            list2.add(srcDir);
                        }
                    }
                    this.javaSourceFolders = list2;
                }
                if (this.javaSourceFolders == null || this.javaSourceFolders.isEmpty()) {
                    this.javaSourceFolders = super.getJavaSourceFolders();
                }
            }
            return this.javaSourceFolders;
        }

        public List<File> getGeneratedSourceFolders() {
            if (this.generatedSourceFolders == null) {
                if (this.mocker != null) {
                    this.generatedSourceFolders = this.mocker.getGeneratedSourceFolders().stream().filter(File::exists).collect(Collectors.toList());
                }
                if (this.generatedSourceFolders == null || this.generatedSourceFolders.isEmpty()) {
                    this.generatedSourceFolders = super.getGeneratedSourceFolders();
                    if (this.generatedSourceFolders.isEmpty()) {
                        File generated = new File(this.dir, "generated");
                        if (generated.isDirectory()) {
                            this.generatedSourceFolders = Collections.singletonList(generated);
                        } else {
                            generated = new File(this.dir, "gen");
                            if (generated.isDirectory()) {
                                this.generatedSourceFolders = Collections.singletonList(generated);
                            }
                        }
                    }
                    return this.generatedSourceFolders;
                }
            }
            return this.generatedSourceFolders;
        }

        public List<File> getGeneratedResourceFolders() {
            if (this.generatedResourceFolders == null) {
                if (this.mocker != null) {
                    this.generatedResourceFolders = this.mocker.getGeneratedSourceFolders().stream().filter(File::exists).collect(Collectors.toList());
                }
                if (this.generatedResourceFolders == null || this.generatedResourceFolders.isEmpty()) {
                    this.generatedResourceFolders = super.getGeneratedResourceFolders();
                }
            }
            return this.generatedResourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.testSourceFolders == null) {
                LintModelVariant variant = this.getBuildVariant();
                if (this.mocker != null && variant != null) {
                    this.testSourceFolders = Lists.newArrayList();
                    for (LintModelSourceProvider provider : variant.getTestSourceProviders()) {
                        Collection srcDirs = provider.getJavaDirectories();
                        for (File srcDir : srcDirs) {
                            if (!srcDir.exists()) continue;
                            this.testSourceFolders.add(srcDir);
                        }
                    }
                }
                if (this.testSourceFolders == null || this.testSourceFolders.isEmpty()) {
                    this.testSourceFolders = super.getTestSourceFolders();
                }
            }
            return this.testSourceFolders;
        }

        public List<File> getUnitTestSourceFolders() {
            if (this.unitTestSourceFolders == null) {
                File unitTests;
                List testSourceFolders = super.getUnitTestSourceFolders();
                if (testSourceFolders.isEmpty() && (unitTests = new File(this.getDir(), "test")).exists()) {
                    ArrayList all = Lists.newArrayList((Iterable)testSourceFolders);
                    all.add(unitTests);
                    testSourceFolders = all;
                }
                this.unitTestSourceFolders = testSourceFolders;
            }
            return this.unitTestSourceFolders;
        }

        public List<File> getInstrumentationTestSourceFolders() {
            if (this.instrumentationTestSourceFolders == null) {
                File instrumentationTests;
                List testSourceFolders = super.getInstrumentationTestSourceFolders();
                if (testSourceFolders.isEmpty() && (instrumentationTests = new File(this.getDir(), "androidTest")).exists()) {
                    ArrayList all = Lists.newArrayList((Iterable)testSourceFolders);
                    all.add(instrumentationTests);
                    testSourceFolders = all;
                }
                this.instrumentationTestSourceFolders = testSourceFolders;
            }
            return this.instrumentationTestSourceFolders;
        }

        public List<File> getTestFixturesSourceFolders() {
            if (this.testFixturesSourceFolders == null) {
                File instrumentationTests;
                List fixtureFolders = super.getTestFixturesSourceFolders();
                if (fixtureFolders.isEmpty() && (instrumentationTests = new File(this.getDir(), "testFixtures")).exists()) {
                    ArrayList all = Lists.newArrayList((Iterable)fixtureFolders);
                    all.add(instrumentationTests);
                    fixtureFolders = all;
                }
                this.testFixturesSourceFolders = fixtureFolders;
            }
            return this.testFixturesSourceFolders;
        }

        public void setReferenceDir(File dir) {
            this.referenceDir = dir;
        }
    }

    private static interface LintTestAnalysis {
        public void analyze(LintDriver var1);
    }

    public static class TestLintRequest
    extends LintRequest {
        Project mainProject = null;

        public TestLintRequest(LintClient client2, List<? extends File> files2) {
            super(client2, files2);
        }

        public Project getMainProject(Project project) {
            if (this.mainProject != null) {
                return this.mainProject;
            }
            for (Project main : project.getClient().getKnownProjects()) {
                if (main.getType() != LintModelModuleType.APP || !project.getAllLibraries().contains(project)) continue;
                return main;
            }
            return super.getMainProject(project);
        }
    }
}

