/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.ide.common.gradle.Component;
import com.android.tools.lint.checks.infrastructure.BaseLintDetectorTest;
import com.android.tools.lint.checks.infrastructure.ClassName;
import com.android.tools.lint.checks.infrastructure.GradleModelMocker;
import com.android.tools.lint.checks.infrastructure.TestResourceProvider;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.objectweb.asm.Opcodes;

public class TestFile {
    public String sourceRelativePath;
    public String targetRelativePath;
    public String contents;
    public byte[] bytes;
    private TestResourceProvider resourceProvider;
    public String targetRootFolder;

    public TestFile withSource(String source2) {
        this.contents = source2.replace('\uff04', '$');
        return this;
    }

    public TestFile from(String from, TestResourceProvider provider) {
        this.sourceRelativePath = from;
        this.resourceProvider = provider;
        return this;
    }

    public TestFile to(String to) {
        this.targetRelativePath = to;
        return this;
    }

    public TestFile within(String root) {
        this.targetRootFolder = root;
        return this;
    }

    public TestFile copy(String relativePath, TestResourceProvider provider) {
        String targetPath = relativePath;
        int replaceIndex = relativePath.indexOf("=>");
        if (replaceIndex != -1) {
            targetPath = relativePath.substring(replaceIndex + "=>".length());
            relativePath = relativePath.substring(0, replaceIndex);
        }
        this.from(relativePath, provider);
        this.to(targetPath);
        return this;
    }

    public String getTargetPath() {
        Object target = this.targetRelativePath;
        if (this.targetRootFolder != null) {
            target = ((String)target).startsWith("/") ? this.targetRootFolder + (String)target : this.targetRootFolder + "/" + (String)target;
        }
        return target;
    }

    public File createFile(File targetDir) throws IOException {
        InputStream stream;
        if (this.contents != null) {
            stream = new ByteArrayInputStream(this.contents.getBytes(Charsets.UTF_8));
        } else if (this.bytes != null) {
            stream = new ByteArrayInputStream(this.bytes);
        } else {
            assert (this.resourceProvider != null);
            stream = this.resourceProvider.getTestResource(this.sourceRelativePath, true);
            assert (stream != null) : this.sourceRelativePath + " does not exist";
        }
        String target = this.getTargetPath();
        assert (target.indexOf(92) == -1) : target;
        int index = target.lastIndexOf(47);
        String relative = null;
        String name = target;
        if (index != -1) {
            name = target.substring(index + 1);
            relative = target.substring(0, index);
        }
        return BaseLintDetectorTest.makeTestFile(targetDir, name, relative, stream);
    }

    public String getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        if (this.bytes != null) {
            return Base64.getEncoder().encodeToString(this.bytes);
        }
        if (this.sourceRelativePath != null) {
            assert (this.resourceProvider != null);
            InputStream stream = this.resourceProvider.getTestResource(this.sourceRelativePath, true);
            if (stream != null) {
                try {
                    return new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
                }
                catch (IOException ignore) {
                    return "<couldn't open test file " + this.sourceRelativePath + ">";
                }
            }
        }
        return null;
    }

    public String getRawContents() {
        return this.contents;
    }

    public TestFile withBytes(byte[] bytes2) {
        this.bytes = bytes2;
        return this;
    }

    public TestFile indented() {
        this.contents = StringsKt.trimIndent((String)this.contents);
        return this;
    }

    static boolean isComponent(String path) {
        return !path.endsWith(".jar") && path.indexOf(58) != -1 && Component.tryParse((String)path) != null;
    }

    static String componentToJar(String artifact) {
        String path = artifact.replace(':', '/');
        return "build/intermediates/exploded-aar/" + path + "/jars/classes.jar";
    }

    public static File createTempDirectory() {
        try {
            return Files.createTempDirectory("", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class PropertyTestFile
    extends TestFile {
        private final StringBuilder stringBuilder = new StringBuilder();
        private int nextLibraryIndex = 1;

        public PropertyTestFile() {
            this.to("project.properties");
        }

        public PropertyTestFile property(String key, String value) {
            String escapedValue = SdkUtils.escapePropertyValue((String)value);
            this.stringBuilder.append(key).append('=').append(escapedValue).append('\n');
            return this;
        }

        public PropertyTestFile compileSdk(int target) {
            this.stringBuilder.append("target=android-").append(Integer.toString(target)).append('\n');
            return this;
        }

        public PropertyTestFile library(boolean isLibrary) {
            this.stringBuilder.append("android.library=").append(Boolean.toString(isLibrary)).append('\n');
            return this;
        }

        public PropertyTestFile manifestMerger(boolean merger) {
            this.stringBuilder.append("manifestmerger.enabled=").append(Boolean.toString(merger)).append('\n');
            return this;
        }

        public PropertyTestFile dependsOn(String relative) {
            TestCase.assertTrue((boolean)relative.startsWith("../"));
            this.stringBuilder.append("android.library.reference.").append(Integer.toString(this.nextLibraryIndex++)).append("=").append(SdkUtils.escapePropertyValue((String)relative)).append('\n');
            return this;
        }

        @Override
        public TestFile withSource(String source2) {
            TestCase.fail((String)("Don't call withSource on " + this.getClass()));
            return this;
        }

        @Override
        public String getContents() {
            this.contents = this.stringBuilder.toString().replace('\uff04', '$');
            return this.contents;
        }

        @Override
        public File createFile(File targetDir) throws IOException {
            this.getContents();
            return super.createFile(targetDir);
        }
    }

    public static class GradleTestFile
    extends TestFile {
        private final Map<File, GradleModelMocker> mockers = new HashMap<File, GradleModelMocker>();
        private final List<Consumer<GradleModelMocker>> mockerConfigurators = new ArrayList<Consumer<GradleModelMocker>>();

        public GradleTestFile(String to, @Language(value="Groovy") String source2) {
            this.to(to).withSource(source2);
            if (!to.endsWith(".gradle")) {
                throw new IllegalArgumentException("Expected .gradle suffix for Gradle test file");
            }
        }

        public GradleTestFile withMockerConfigurator(Consumer<GradleModelMocker> configurator) {
            this.mockerConfigurators.add(configurator);
            return this;
        }

        public GradleModelMocker getMocker(File projectDir) {
            GradleModelMocker mocker = this.mockers.get(projectDir);
            if (mocker == null) {
                assert (this.contents != null);
                mocker = new GradleModelMocker(this.contents, projectDir);
                for (Consumer<GradleModelMocker> configurator : this.mockerConfigurators) {
                    configurator.accept(mocker);
                }
                this.mockers.put(projectDir, mocker);
            }
            return mocker;
        }

        @Override
        public GradleTestFile indented() {
            super.indented();
            return this;
        }
    }

    public static class BytecodeProducer
    implements ByteProducer,
    Opcodes {
        @Override
        public byte[] produce() {
            return new byte[0];
        }
    }

    public static class BinaryTestFile
    extends TestFile {
        private final ByteProducer producer;

        public BinaryTestFile(String to, ByteProducer producer2) {
            this.to(to);
            this.producer = producer2;
        }

        @Override
        public TestFile withSource(String source2) {
            TestCase.fail((String)("Don't call withSource on " + this.getClass()));
            return this;
        }

        @Override
        public String getContents() {
            TestCase.fail((String)("Don't call getContents on binary " + this.getClass()));
            return null;
        }

        public byte[] getBinaryContents() {
            return this.producer.produce();
        }

        @Override
        public File createFile(File targetDir) throws IOException {
            String target = this.getTargetPath();
            target = target.replace(File.separatorChar, '/');
            int index = target.lastIndexOf(47);
            String relative = null;
            String name = target;
            if (index != -1) {
                name = target.substring(index + 1);
                relative = target.substring(0, index);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(this.getBinaryContents());
            return BaseLintDetectorTest.makeTestFile(targetDir, name, relative, stream);
        }
    }

    @FunctionalInterface
    public static interface ByteProducer {
        public byte[] produce();
    }

    public static class ManifestTestFile
    extends TestFile {
        public String pkg = "test.pkg";
        public String minSdk = "";
        public String targetSdk = "";
        public String[] permissions;

        public ManifestTestFile() {
            this.to("AndroidManifest.xml");
        }

        @Override
        public ManifestTestFile to(String to) {
            super.to(to);
            return this;
        }

        public ManifestTestFile minSdk(int min) {
            this.minSdk = String.valueOf(min);
            return this;
        }

        public ManifestTestFile minSdk(String codename) {
            this.minSdk = codename;
            return this;
        }

        public ManifestTestFile targetSdk(int target) {
            this.targetSdk = String.valueOf(target);
            return this;
        }

        public ManifestTestFile targetSdk(String codename) {
            this.targetSdk = codename;
            return this;
        }

        public ManifestTestFile permissions(String ... permissions) {
            this.permissions = permissions;
            return this;
        }

        public ManifestTestFile pkg(String pkg) {
            this.pkg = pkg;
            return this;
        }

        @Override
        public String getContents() {
            if (this.contents == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                sb.append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n");
                sb.append("    package=\"").append(this.pkg).append("\"\n");
                sb.append("    android:versionCode=\"1\"\n");
                sb.append("    android:versionName=\"1.0\" >\n");
                if (!this.minSdk.isEmpty() || !this.targetSdk.isEmpty()) {
                    sb.append("    <uses-sdk ");
                    if (!this.minSdk.isEmpty()) {
                        sb.append(" android:minSdkVersion=\"").append(this.minSdk).append("\"");
                    }
                    if (!this.targetSdk.isEmpty()) {
                        sb.append(" android:targetSdkVersion=\"").append(this.targetSdk).append("\"");
                    }
                    sb.append(" />\n");
                }
                if (this.permissions != null && this.permissions.length > 0) {
                    StringBuilder permissionBlock = new StringBuilder();
                    for (String permission : this.permissions) {
                        permissionBlock.append("    <uses-permission android:name=\"").append(permission).append("\" />\n");
                    }
                    sb.append((CharSequence)permissionBlock);
                    sb.append("\n");
                }
                sb.append("\n</manifest>");
                this.contents = sb.toString();
            }
            return this.contents;
        }

        @Override
        public File createFile(File targetDir) throws IOException {
            this.getContents();
            return super.createFile(targetDir);
        }
    }

    public static class ImageTestFile
    extends BinaryTestFile {
        private final BufferedImage mImage;
        private String mFormat;

        public ImageTestFile(String to, int width, int height) {
            super(to, new BytecodeProducer());
            if (SdkUtils.endsWithIgnoreCase((String)to, (String)".png")) {
                this.mFormat = "PNG";
            } else if (SdkUtils.endsWithIgnoreCase((String)to, (String)".jpg") || SdkUtils.endsWithIgnoreCase((String)to, (String)".jpeg")) {
                this.mFormat = "JPG";
            } else if (SdkUtils.endsWithIgnoreCase((String)to, (String)".gif")) {
                this.mFormat = "GIF";
            }
            this.mImage = new BufferedImage(width, height, 2);
        }

        public ImageTestFile fill(int argb) {
            return this.fill(0, 0, this.mImage.getWidth(), this.mImage.getHeight(), argb);
        }

        public ImageTestFile fill(int x, int y, int width, int height, int argb) {
            Graphics2D graphics = this.mImage.createGraphics();
            graphics.setColor(new Color(argb, true));
            graphics.fillRect(x, y, width, height);
            graphics.dispose();
            return this;
        }

        public ImageTestFile text(int x, int y, String s, int argb) {
            Graphics2D graphics = this.mImage.createGraphics();
            graphics.setColor(new Color(argb, true));
            graphics.drawString(s, x, y);
            graphics.dispose();
            return this;
        }

        public ImageTestFile fillOval(int x, int y, int width, int height, int argb) {
            Graphics2D graphics = this.mImage.createGraphics();
            graphics.setColor(new Color(argb, true));
            graphics.fillOval(x, y, width, height);
            graphics.dispose();
            return this;
        }

        @Override
        public byte[] getBinaryContents() {
            TestCase.assertNotNull((String)"Must set image type", (Object)this.mFormat);
            ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
            try {
                ImageIO.write((RenderedImage)this.mImage, this.mFormat, output);
            }
            catch (IOException e) {
                TestCase.fail((String)(e.getLocalizedMessage() + " writing " + output + " in format " + this.mFormat));
            }
            return output.toByteArray();
        }

        public ImageTestFile format(String format) {
            this.mFormat = format;
            return this;
        }
    }

    public static class JarTestFile
    extends TestFile {
        protected final List<TestFile> files = Lists.newArrayList();
        private final Map<TestFile, String> path = Maps.newHashMap();

        public JarTestFile(String to) {
            this.to(to);
        }

        public JarTestFile files(TestFile ... files2) {
            this.files.addAll(Arrays.asList(files2));
            return this;
        }

        public JarTestFile add(TestFile file, String path) {
            this.add(file);
            this.path.put(file, path);
            return this;
        }

        public JarTestFile add(TestFile file) {
            this.files.add(file);
            this.path.put(file, null);
            return this;
        }

        @Override
        public TestFile withSource(String source2) {
            TestCase.fail((String)("Don't call withSource on " + this.getClass()));
            return this;
        }

        @Override
        public String getContents() {
            TestCase.fail((String)("Don't call getContents on binary " + this.getClass()));
            return null;
        }

        @Override
        public File createFile(File targetDir) throws IOException {
            File tempFile;
            boolean mkdir;
            String target = this.getTargetPath();
            int index = target.lastIndexOf(47);
            String relative = null;
            String name = target;
            if (index != -1) {
                name = target.substring(index + 1);
                relative = target.substring(0, index);
            }
            File dir = targetDir;
            if (relative != null) {
                if (!(dir = new File(dir, relative)).exists()) {
                    mkdir = dir.mkdirs();
                    TestCase.assertTrue((String)dir.getPath(), (boolean)mkdir);
                }
            } else if (!dir.exists()) {
                mkdir = dir.mkdirs();
                TestCase.assertTrue((String)dir.getPath(), (boolean)mkdir);
            }
            if ((tempFile = new File(dir, name)).exists()) {
                boolean deleted = tempFile.delete();
                TestCase.assertTrue((String)tempFile.getPath(), (boolean)deleted);
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)), manifest);){
                String path;
                HashSet<String> seen = new HashSet<String>();
                HashSet<String> pathSet = new HashSet<String>();
                for (TestFile file : this.files) {
                    path = this.path.get(file);
                    if (path == null) {
                        path = file.targetRelativePath;
                    }
                    if ((index = path.lastIndexOf(47)) == -1) continue;
                    pathSet.add(path.substring(0, index + 1));
                }
                pathSet.stream().sorted().forEach(s -> {
                    try {
                        ZipEntry dirEntry = new ZipEntry((String)s);
                        jarOutputStream.putNextEntry(dirEntry);
                        jarOutputStream.closeEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                for (TestFile file : this.files) {
                    path = this.path.get(file);
                    if (path == null) {
                        path = file.targetRelativePath;
                    }
                    if (!seen.add(path) && path.startsWith("META-INF/") && path.endsWith(".kotlin_module")) continue;
                    jarOutputStream.putNextEntry(new ZipEntry(path));
                    if (file instanceof BinaryTestFile) {
                        byte[] bytes2 = ((BinaryTestFile)file).getBinaryContents();
                        TestCase.assertNotNull((String)file.targetRelativePath, (Object)bytes2);
                        ByteStreams.copy((InputStream)new ByteArrayInputStream(bytes2), (OutputStream)jarOutputStream);
                    } else {
                        String contents = file.getContents();
                        TestCase.assertNotNull((String)file.targetRelativePath, (Object)contents);
                        byte[] bytes3 = contents.getBytes(Charsets.UTF_8);
                        ByteStreams.copy((InputStream)new ByteArrayInputStream(bytes3), (OutputStream)jarOutputStream);
                    }
                    jarOutputStream.closeEntry();
                }
            }
            return tempFile;
        }
    }

    public static class XmlTestFile
    extends TestFile {
        private String rawSource;

        public static TestFile create(String to, @Language(value="XML") String source2) {
            if (!to.endsWith(".xml")) {
                throw new IllegalArgumentException("Expected .xml suffix for XML test file");
            }
            String plainSource = XmlTestFile.stripErrorMarkers(source2);
            return new XmlTestFile().withRawSource(source2).to(to).withSource(plainSource);
        }

        private XmlTestFile withRawSource(String rawSource) {
            this.rawSource = rawSource;
            return this;
        }

        public XmlTestFile keepProcessingInstructions() {
            this.withSource(this.rawSource);
            return this;
        }

        @Override
        public String getRawContents() {
            return this.rawSource;
        }

        private static String stripErrorMarkers(String source2) {
            if (source2.contains("<?error") || source2.contains("<?warning") || source2.contains("?info")) {
                StringBuilder sb = new StringBuilder(source2.length());
                int prev = 0;
                int index = 0;
                while ((index = source2.indexOf("<?", index)) != -1) {
                    if (source2.startsWith("<?xml", index)) {
                        index += 4;
                        continue;
                    }
                    sb.append(source2.substring(prev, index));
                    index = source2.indexOf("?>", index);
                    if (index == -1) break;
                    prev = index += 2;
                }
                sb.append(source2.substring(prev, source2.length()));
                return sb.toString();
            }
            return source2;
        }
    }

    public static class KotlinTestFile
    extends TestFile {
        public static TestFile create(@Language(value="kotlin") String source2) {
            ClassName name = new ClassName(source2, ".kt");
            String pkg = name.packageNameWithDefault();
            String cls = name.getClassName();
            if (cls == null) {
                cls = "test";
            }
            String to = pkg.isEmpty() ? cls + ".kt" : pkg.replace('.', '/') + "/" + cls + ".kt";
            return new KotlinTestFile().to(to).within("src").withSource(source2);
        }

        public static TestFile create(String to, @Language(value="kotlin") String source2) {
            if (!to.endsWith(".kt") && !to.endsWith(".kts")) {
                throw new IllegalArgumentException("Expected .kt or .kts suffix for Kotlin test file");
            }
            return new KotlinTestFile().to(to).withSource(source2);
        }
    }

    public static class JavaTestFile
    extends TestFile {
        public static TestFile create(@Language(value="JAVA") String source2) {
            String to;
            ClassName name = new ClassName(source2, ".java");
            String pkg = name.packageNameWithDefault();
            String cls = name.getClassName();
            if (cls == null) {
                assert (!source2.contains("{")) : "Couldn't find class declaration in source: " + source2;
                to = pkg.replace('.', '/') + "/package-info.java";
            } else {
                to = pkg.replace('.', '/') + "/" + cls + ".java";
            }
            return new JavaTestFile().to(to).within("src").withSource(source2);
        }

        public static TestFile create(String to, @Language(value="JAVA") String source2) {
            if (!to.endsWith(".java")) {
                throw new IllegalArgumentException("Expected .java suffix for Java test file");
            }
            return new JavaTestFile().to(to).withSource(source2);
        }
    }
}

