/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.TestLintRunnerKt;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.detector.api.JavaContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a8\u0006\t"}, d2={"ensureConflictFree", "", "mode", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "edits", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nSourceTransformationTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceTransformationTestMode.kt\ncom/android/tools/lint/checks/infrastructure/SourceTransformationTestModeKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n12474#2,2:233\n*S KotlinDebug\n*F\n+ 1 SourceTransformationTestMode.kt\ncom/android/tools/lint/checks/infrastructure/SourceTransformationTestModeKt\n*L\n212#1:233,2\n*E\n"})
public final class SourceTransformationTestModeKt {
    public static final boolean ensureConflictFree(@NotNull TestMode mode, @NotNull JavaContext context, @NotNull List<Edit> edits) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        Edit prev = null;
        for (Edit edit : CollectionsKt.sorted((Iterable)edits)) {
            if (prev != null && prev.getStartOffset() < edit.getEndOffset()) {
                boolean bl;
                String message;
                block5: {
                    String string = mode.getFieldName();
                    String string2 = context.file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    CharSequence charSequence = context.getContents();
                    if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
                        charSequence = "";
                    }
                    message = "Invalid source transform test mode (" + string + "):\nedits overlap; " + prev + " and " + edit + ".\nThis means that the test mode is broken.\nPlease file a bug with details; the source file where this happened is:\n" + TestLintRunnerKt.listFile(string2, (String)charSequence) + "\nand the list of edits is:\n" + edits;
                    StackTraceElement[] stackTraceElementArray = new Throwable().fillInStackTrace().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    Object[] $this$any$iv = stackTraceElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        StackTraceElement it = (StackTraceElement)element$iv;
                        boolean bl2 = false;
                        String name = it.getClassName();
                        Intrinsics.checkNotNull((Object)name);
                        boolean bl3 = StringsKt.startsWith$default((String)name, (String)"com.android.tools.", (boolean)false, (int)2, null) && (!StringsKt.contains$default((CharSequence)name, (CharSequence)".infrastructure.", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"Test", (boolean)false, (int)2, null));
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (bl) {
                    throw new IllegalStateException(message.toString());
                }
                System.err.println(message);
                return false;
            }
            prev = edit;
        }
        return true;
    }
}

