/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.ReporterKt;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.ResolveCheckerKt;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintRunnerKt;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"checkFile", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "isStub", "", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nResolveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolveChecker.kt\ncom/android/tools/lint/checks/infrastructure/ResolveCheckerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
public final class ResolveCheckerKt {
    public static final void checkFile(@NotNull JavaContext $this$checkFile, @Nullable UFile root, @NotNull TestLintTask task, boolean isStub) {
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence source22;
        Sequence location2;
        Intrinsics.checkNotNullParameter((Object)$this$checkFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (root == null) {
            throw new IllegalStateException(("Failure processing source " + $this$checkFile.getProject().getRelativePath($this$checkFile.file) + ": No UAST AST created").toString());
        }
        PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)root.getSourcePsi()), PsiErrorElement.class);
        if (error != null) {
            Position position = $this$checkFile.getLocation((PsiElement)error).getStart();
            int line2 = position != null ? position.getLine() : -1;
            StringBuilder sb = new StringBuilder();
            sb.append(TestLintClient.testModePrefix(task.runner.getCurrentTestMode()));
            Location location2 = $this$checkFile.getLocation((PsiElement)error);
            String source22 = root.getSourcePsi().getText().toString();
            String lines2 = ReporterKt.getErrorLines((Location)location2, (Function1)((Function1)new Function1<File, CharSequence>(source22){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(1);
                }

                @Nullable
                public final CharSequence invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$source;
                }
            }));
            String string = $this$checkFile.file.getName();
            String string2 = error.getText();
            String string3 = error.getParent().getText();
            String string4 = $this$checkFile.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            sb.append("Found error element " + error + " in " + string + ":" + (line2 + 1) + " with text \"" + string2 + "\" inside \"" + string3 + "\"\n" + lines2 + "\n" + TestLintRunnerKt.listFile(string4, source22));
            String string5 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            String string6 = string5;
            throw new IllegalStateException(string6.toString());
        }
        Object[] sb = task.issues;
        if (sb != null && (location2 = ArraysKt.asSequence((Object[])sb)) != null && (source22 = SequencesKt.map((Sequence)location2, (Function1)checkFile.detectors.1.INSTANCE)) != null && (sequence3 = SequencesKt.distinct((Sequence)source22)) != null && (sequence2 = SequencesKt.map((Sequence)sequence3, (Function1)checkFile.detectors.2.INSTANCE)) != null) {
            sequence = sequence2;
        } else {
            Detector detector = task.detector;
            if (detector != null) {
                Detector it = detector;
                boolean bl = false;
                Object[] objectArray = new Detector[]{it};
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else {
                sequence = SequencesKt.emptySequence();
            }
        }
        Sequence detectors2 = sequence;
        Set applicableCalls2 = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)detectors2, (Function1)checkFile.applicableCalls.1.INSTANCE)));
        Set applicableReferences2 = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)detectors2, (Function1)checkFile.applicableReferences.1.INSTANCE)));
        Set applicableConstructorTypes2 = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)detectors2, (Function1)checkFile.applicableConstructorTypes.1.INSTANCE)));
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new AbstractUastVisitor($this$checkFile, applicableCalls2, applicableConstructorTypes2, applicableReferences2, isStub, task){
            final /* synthetic */ JavaContext $this_checkFile;
            final /* synthetic */ Set<String> $applicableCalls;
            final /* synthetic */ Set<String> $applicableConstructorTypes;
            final /* synthetic */ Set<String> $applicableReferences;
            final /* synthetic */ boolean $isStub;
            final /* synthetic */ TestLintTask $task;
            {
                this.$this_checkFile = $receiver;
                this.$applicableCalls = $applicableCalls;
                this.$applicableConstructorTypes = $applicableConstructorTypes;
                this.$applicableReferences = $applicableReferences;
                this.$isStub = $isStub;
                this.$task = $task;
            }

            private final boolean ignoredImport(String s) {
                if (StringsKt.endsWith$default((String)s, (String)".R", (boolean)false, (int)2, null)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)s, (Object)"androidx.annotation.NonNull") || Intrinsics.areEqual((Object)s, (Object)"androidx.annotation.Nullable")) {
                    return true;
                }
                if (StringsKt.startsWith$default((String)s, (String)"kotlinx.android.synthetic.", (boolean)false, (int)2, null)) {
                    return true;
                }
                return StringsKt.startsWith$default((String)s, (String)"kotlin.", (boolean)false, (int)2, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public boolean visitImportStatement(@NotNull UImportStatement node) {
                String s;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement sourcePsi = node.getSourcePsi();
                UElement importReference = node.getImportReference();
                if (node.isOnDemand() || node.resolve() != null || sourcePsi == null || importReference == null) {
                    return super.visitImportStatement(node);
                }
                PsiElement importReferencePsi = importReference.getSourcePsi();
                if (importReferencePsi instanceof PsiImportStaticReferenceElement) {
                    String name;
                    PsiJavaCodeReferenceElement cls = ((PsiImportStaticReferenceElement)importReferencePsi).getClassReference();
                    PsiElement importedClass = cls.resolve();
                    if (importedClass instanceof PsiClass && this.hasStaticMemberNamed((PsiClass)importedClass, name = ((PsiImportStaticReferenceElement)importReferencePsi).getReferenceName())) {
                        return true;
                    }
                } else if (importReferencePsi instanceof PsiJavaCodeReferenceElement) {
                    Integer index;
                    String fqn;
                    String string = fqn = ((PsiJavaCodeReferenceElement)importReferencePsi).getQualifiedName();
                    Integer n = index = string != null ? Integer.valueOf(StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null)) : null;
                    if (index != null) {
                        int name = -1;
                        if (index != name) {
                            int n2 = index;
                            Intrinsics.checkNotNull((Object)fqn);
                            String string2 = fqn.substring(0, n2);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            String className = string2;
                            String string3 = fqn.substring(index + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            String name2 = string3;
                            JavaPsiFacade facade = JavaPsiFacadeEx.getInstance((Project)((PsiJavaCodeReferenceElement)importReferencePsi).getProject());
                            PsiClass psiClass = facade.findClass(className, GlobalSearchScope.allScope((Project)((PsiJavaCodeReferenceElement)importReferencePsi).getProject()));
                            if (psiClass != null && this.hasStaticMemberNamed(psiClass, name2)) {
                                return true;
                            }
                        }
                    }
                } else if (sourcePsi instanceof KtImportDirective) {
                    String clsName;
                    KtDotQualifiedExpression qualifiedExpression = importReferencePsi instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)importReferencePsi : null;
                    KtDotQualifiedExpression ktDotQualifiedExpression = qualifiedExpression;
                    String string = ktDotQualifiedExpression != null && (ktDotQualifiedExpression = ktDotQualifiedExpression.getReceiverExpression()) != null ? ktDotQualifiedExpression.getText() : (clsName = null);
                    if (clsName != null) {
                        void this_$iv$iv$iv;
                        void this_$iv$iv;
                        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
                        String name = ktExpression != null ? ktExpression.getText() : null;
                        PsiClass importedClass = this.$this_checkFile.getEvaluator().findClass(clsName);
                        if (importedClass != null && this.hasStaticMemberNamed(importedClass, name)) {
                            return super.visitImportStatement(node);
                        }
                        JavaPsiFacade facade = JavaPsiFacadeEx.getInstance((Project)((KtDotQualifiedExpression)importReferencePsi).getProject());
                        PsiPackage pkg = facade.findPackage(clsName);
                        if (pkg != null) {
                            boolean bl;
                            block23: {
                                PsiClass[] psiClassArray = pkg.getClasses();
                                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                                Object[] $this$any$iv = psiClassArray;
                                boolean $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    PsiClass it = (PsiClass)element$iv;
                                    boolean bl2 = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    if (!this.hasStaticMemberNamed(it, name)) continue;
                                    bl = true;
                                    break block23;
                                }
                                bl = false;
                            }
                            if (bl) {
                                return super.visitImportStatement(node);
                            }
                        }
                        boolean $i$f$analyze = false;
                        Project project = ((KtElement)qualifiedExpression).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KtAnalysisSessionProvider $i$f$any = KtAnalysisSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyse = false;
                        void var14_24 = this_$iv$iv;
                        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)qualifiedExpression);
                        boolean $i$f$analyse2 = false;
                        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                        try {
                            KtSimpleNameReference reference;
                            KtAnalysisSession $this$visitImportStatement_u24lambda_u243 = analysisSession$iv$iv$iv;
                            boolean bl = false;
                            Object object = qualifiedExpression.getSelectorExpression();
                            Object object2 = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
                            KtSimpleNameReference ktSimpleNameReference = reference = object2 != null ? ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)object2)) : null;
                            if (reference != null && (object2 = $this$visitImportStatement_u24lambda_u243.resolveToSymbols((KtReference)reference)) != null) {
                                Object object3;
                                Object it = object3 = object2;
                                boolean bl3 = false;
                                KtExpression ktExpression2 = object = !it.isEmpty() ? object3 : null;
                                if (object != null) {
                                    it = object;
                                    boolean bl4 = false;
                                    boolean bl5 = super.visitImportStatement(node);
                                    return bl5;
                                }
                            }
                            Object var25_38 = null;
                        }
                        finally {
                            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                        }
                    }
                }
                PsiElement psiElement = importReferencePsi;
                String string = psiElement != null ? psiElement.getText() : null;
                if (string == null) {
                    string = importReference.asSourceString();
                }
                if (!this.ignoredImport(s = string)) {
                    JavaContext context = this.$this_checkFile;
                    this.reportResolveProblem(context, importReference, "", "import", "", "");
                    throw new KotlinNothingValueException();
                }
                return super.visitImportStatement(node);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean hasStaticMemberNamed(@NotNull PsiClass $this$hasStaticMemberNamed, @Nullable String name) {
                PsiMethod it;
                Intrinsics.checkNotNullParameter((Object)$this$hasStaticMemberNamed, (String)"<this>");
                PsiMethod[] psiMethodArray = $this$hasStaticMemberNamed.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                Object[] $this$any$iv = psiMethodArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    it = (PsiMethod)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                        if (it.getModifierList().hasModifierProperty("static")) return true;
                        if (it.getModifierList().hasModifierProperty("default")) {
                            return true;
                        }
                    }
                    boolean bl2 = false;
                    if (!bl2) continue;
                    return true;
                }
                boolean bl = false;
                if (bl) return true;
                PsiField[] psiFieldArray = $this$hasStaticMemberNamed.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                $this$any$iv = psiFieldArray;
                $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Object element$iv;
                    element$iv = $this$any$iv[n];
                    it = (PsiField)element$iv;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                        boolean bl4;
                        PsiModifierList psiModifierList = it.getModifierList();
                        if (psiModifierList != null) {
                            if (psiModifierList.hasModifierProperty("static")) {
                                return true;
                            }
                            bl4 = false;
                        } else {
                            bl4 = false;
                        }
                        if (bl4) {
                            return true;
                        }
                    }
                    boolean bl5 = false;
                    if (bl5) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (UastExpressionUtils.isMethodCall((UElement)((UElement)node))) {
                    this.visitMethodCallExpression(node);
                } else if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    this.visitNewExpression(node);
                }
                return super.visitCallExpression(node);
            }

            private final void visitMethodCallExpression(UCallExpression node) {
                String name;
                String string = node.getMethodName();
                if (string == null) {
                    UIdentifier uIdentifier = node.getMethodIdentifier();
                    string = uIdentifier != null ? uIdentifier.getName() : null;
                }
                if ((name = string) != null && this.$applicableCalls.contains(name) && node.resolve() == null && !(node.getSourcePsi() instanceof PsiAssertStatement)) {
                    JavaContext context = this.$this_checkFile;
                    this.reportResolveProblem(context, (UElement)node, name, "call", "getApplicableMethodNames", "visitMethodCall");
                    throw new KotlinNothingValueException();
                }
            }

            private final void visitNewExpression(UCallExpression node) {
                String string = UastUtils.getQualifiedName((UReferenceExpression)node.getClassReference());
                if (string == null) {
                    return;
                }
                String fqc = string;
                if (this.$applicableConstructorTypes.contains(fqc) && node.resolve() == null) {
                    JavaContext context = this.$this_checkFile;
                    this.reportResolveProblem(context, (UElement)node, fqc, "constructor call", "getApplicableConstructorTypes", "visitConstructor");
                    throw new KotlinNothingValueException();
                }
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                String name;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String string = node.getResolvedName();
                if (string == null) {
                    string = node.getIdentifier();
                }
                if (this.$applicableReferences.contains(name = string) && node.resolve() == null) {
                    JavaContext context = this.$this_checkFile;
                    this.reportResolveProblem(context, (UElement)node, name, "reference", "getApplicableReferenceNames", "visitReference");
                    throw new KotlinNothingValueException();
                }
                return super.visitSimpleNameReferenceExpression(node);
            }

            /*
             * WARNING - void declaration
             */
            private final Void reportResolveProblem(JavaContext context, UElement node, String name, String symbolType, String nameMethod, String visitMethod) {
                boolean isImport = ((CharSequence)name).length() == 0;
                StringBuilder message = new StringBuilder(this.createErrorMessage(context, node, "Couldn't resolve this " + symbolType));
                if (!isImport) {
                    message.append(StringsKt.trimIndent((String)("\n                    The tested detector returns `" + name + "` from `" + nameMethod + "()`,\n                    which means this reference is probably relevant to the test, but when the\n                    " + symbolType + " cannot be resolved, lint won't invoke `" + visitMethod + "` on it.\n\n                    ")));
                }
                if (this.$isStub) {
                    message.append("This means one of the APIs in the stub are referencing APIs which need\nto be provided via the `compileOnly=` list of test files.\n");
                } else {
                    message.append(StringsKt.trimIndent((String)("\n                    This usually means that the unit test needs to declare a stub file or\n                    placeholder with the expected signature such that type resolving works.\n\n                    If this " + symbolType + " is immaterial to the test, either delete it, or mark\n                    this unit test as allowing resolution errors by setting\n                    `allowCompilationErrors()`.\n\n                    ")));
                }
                if (isImport) {
                    message.append("\n(This check only enforces import references, not all references, so if\nit doesn't matter to the detector, you can just remove the import but\nleave references to the class in the code.)\n");
                }
                message.append("\nFor more information, see the \"Library Dependencies and Stubs\" section in\nhttps://cs.android.com/android-studio/platform/tools/base/+/mirror-goog-studio-main:lint/docs/api-guide/unit-testing.md.html");
                if (this.$task.runner.getCurrentTestMode() instanceof UastSourceTransformationTestMode) {
                    File file;
                    File file2;
                    void $this$sortedBy$iv;
                    File file3 = context.getProject().getDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getDir(...)");
                    Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file3, null, (int)1, null)), (Function1)checkFile.reportResolveProblem.files.1.INSTANCE);
                    boolean $i$f$sortedBy = false;
                    Sequence files2 = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            File it = (File)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getPath());
                            it = (File)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                        }
                    });
                    PsiElement psiElement = node.getSourcePsi();
                    if (psiElement != null && (psiElement = psiElement.getContainingFile()) != null && (psiElement = psiElement.getVirtualFile()) != null) {
                        PsiElement p0 = psiElement;
                        boolean bl = false;
                        file2 = VfsUtilCore.virtualToIoFile((VirtualFile)p0);
                    } else {
                        file2 = file = null;
                    }
                    if (file != null) {
                        message.append("\n\nThis occurred when running in test mode " + this.$task.runner.getCurrentTestMode().getFieldName() + ".\n");
                        message.append("The modified source files are:\n\n");
                        String line2 = StringsKt.repeat((CharSequence)"//", (int)35) + "\n";
                        for (File f : files2) {
                            message.append(line2);
                            String string = f.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            String string2 = context.getProject().getDir().getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                            message.append(StringsKt.removePrefix((String)string, (CharSequence)string2)).append(":\n");
                            message.append(line2);
                            message.append(FilesKt.readText$default((File)f, null, (int)1, null));
                        }
                    }
                }
                String string = message.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string3 = string;
                throw new IllegalStateException(string3.toString());
            }

            private final String createErrorMessage(JavaContext context, UElement locationNode, String message) {
                String output;
                block1: {
                    Incident incident;
                    StringWriter writer = new StringWriter();
                    writer.write("\n");
                    LintCliFlags flags = new LintCliFlags();
                    flags.setFullPath(false);
                    TextReporter reporter = Reporter.Companion.createTextReporter((LintCliClient)new TestLintClient(), flags, null, (Writer)writer, false);
                    reporter.setWriteStats(false);
                    Location location = this.$this_checkFile.getLocation(locationNode);
                    Incident $this$createErrorMessage_u24lambda_u247 = incident = new Incident(IssueRegistry.LINT_ERROR, "\n" + message, location);
                    boolean bl = false;
                    $this$createErrorMessage_u24lambda_u247.setProject(context.getProject());
                    List incidents = CollectionsKt.listOf((Object)incident);
                    reporter.write(new LintStats(1, 0, 0, 0, 0, 0, 0, 124, null), incidents, this.$this_checkFile.getDriver().getRegistry());
                    output = null;
                    String string = writer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    output = string;
                    Map<File, ProjectDescription> map = this.$task.dirToProjectDescription;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"dirToProjectDescription");
                    for (Map.Entry<File, ProjectDescription> entry : map.entrySet()) {
                        File dir = entry.getKey();
                        ProjectDescription desc = entry.getValue();
                        String string2 = dir.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        output = StringsKt.replace$default((String)output, (String)string2, (String)desc.getName(), (boolean)false, (int)4, null);
                    }
                    File file = this.$task.tempDir;
                    if (file == null) break block1;
                    File tempDir = file;
                    boolean bl2 = false;
                    String string3 = tempDir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    output = StringsKt.replace$default((String)output, (String)string3, (String)"TEST_ROOT", (boolean)false, (int)4, null);
                }
                return output;
            }
        }));
    }

    public static /* synthetic */ void checkFile$default(JavaContext javaContext, UFile uFile, TestLintTask testLintTask, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ResolveCheckerKt.checkFile(javaContext, uFile, testLintTask, bl);
    }
}

