/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.BytecodeTestFile;
import com.android.tools.lint.checks.infrastructure.ClassName;
import com.android.tools.lint.checks.infrastructure.CompiledSourceFile;
import com.android.tools.lint.checks.infrastructure.GradleModelMocker;
import com.android.tools.lint.checks.infrastructure.StubClassFile;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Option;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002DEB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0005J\u0011\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010;\u001a\u00020<J\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0018J\b\u0010@\u001a\u00020\bH\u0016J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020'J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0000J\u0010\u0010B\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\bJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R$\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0006R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\n\"\u0004\b\u001f\u0010\fR\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\n\"\u0004\b4\u0010\f\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "", "()V", "files", "", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "([Lcom/android/tools/lint/checks/infrastructure/TestFile;)V", "dependencyGraph", "", "getDependencyGraph", "()Ljava/lang/String;", "setDependencyGraph", "(Ljava/lang/String;)V", "dependsOn", "", "getDependsOn", "()Ljava/util/List;", "dependsOnNames", "getDependsOnNames", "getFiles", "()[Lcom/android/tools/lint/checks/infrastructure/TestFile;", "setFiles", "[Lcom/android/tools/lint/checks/infrastructure/TestFile;", "haveSetType", "", "getHaveSetType", "()Z", "setHaveSetType", "(Z)V", "name", "getName", "setName", "primary", "getPrimary", "setPrimary", "report", "getReport", "setReport", "value", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Type;", "type", "getType", "()Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Type;", "setType", "(Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Type;)V", "under", "getUnder", "()Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "setUnder", "(Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;)V", "variantName", "getVariantName", "setVariantName", "addFile", "file", "compareTo", "", "other", "library", "ensureUnique", "", "([Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "isUnder", "desc", "toString", "parent", "variant", "withDependencyGraph", "Companion", "Type", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nProjectDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDescription.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescription\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,463:1\n26#2:464\n37#3,2:465\n*S KotlinDebug\n*F\n+ 1 ProjectDescription.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescription\n*L\n38#1:464\n113#1:465,2\n*E\n"})
public final class ProjectDescription
implements Comparable<ProjectDescription> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TestFile[] files;
    @NotNull
    private final List<ProjectDescription> dependsOn;
    @NotNull
    private final List<String> dependsOnNames;
    @Nullable
    private String dependencyGraph;
    @NotNull
    private String name;
    @NotNull
    private Type type;
    private boolean haveSetType;
    private boolean report;
    private boolean primary;
    @Nullable
    private ProjectDescription under;
    @Nullable
    private String variantName;

    @NotNull
    public final TestFile[] getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull TestFile[] testFileArray) {
        Intrinsics.checkNotNullParameter((Object)testFileArray, (String)"<set-?>");
        this.files = testFileArray;
    }

    @NotNull
    public final List<ProjectDescription> getDependsOn() {
        return this.dependsOn;
    }

    @NotNull
    public final List<String> getDependsOnNames() {
        return this.dependsOnNames;
    }

    @Nullable
    public final String getDependencyGraph() {
        return this.dependencyGraph;
    }

    public final void setDependencyGraph(@Nullable String string) {
        this.dependencyGraph = string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.type = value;
        this.haveSetType = true;
    }

    public final boolean getHaveSetType() {
        return this.haveSetType;
    }

    public final void setHaveSetType(boolean bl) {
        this.haveSetType = bl;
    }

    public final boolean getReport() {
        return this.report;
    }

    public final void setReport(boolean bl) {
        this.report = bl;
    }

    public final boolean getPrimary() {
        return this.primary;
    }

    public final void setPrimary(boolean bl) {
        this.primary = bl;
    }

    @Nullable
    public final ProjectDescription getUnder() {
        return this.under;
    }

    public final void setUnder(@Nullable ProjectDescription projectDescription) {
        this.under = projectDescription;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    public final void setVariantName(@Nullable String string) {
        this.variantName = string;
    }

    public ProjectDescription() {
        boolean $i$f$emptyArray = false;
        this.files = new TestFile[0];
        this.dependsOn = new ArrayList();
        this.dependsOnNames = new ArrayList();
        this.name = "";
        this.type = Type.APP;
        this.report = true;
        this.primary = true;
    }

    public ProjectDescription(TestFile ... files2) {
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        boolean $i$f$emptyArray = false;
        this.files = new TestFile[0];
        this.dependsOn = new ArrayList();
        this.dependsOnNames = new ArrayList();
        this.name = "";
        this.type = Type.APP;
        this.report = true;
        this.primary = true;
        this.files(Arrays.copyOf(files2, files2.length));
    }

    @NotNull
    public final ProjectDescription name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @NotNull
    public final ProjectDescription files(TestFile ... files2) {
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        this.files = files2;
        return this;
    }

    @NotNull
    public final ProjectDescription dependsOn(@NotNull ProjectDescription library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (!this.dependsOn.contains(library)) {
            this.dependsOn.add(library);
            if (library.type == Type.APP) {
                library.setType(Type.LIBRARY);
            }
        }
        return this;
    }

    @NotNull
    public final ProjectDescription dependsOn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.dependsOnNames.contains(name)) {
            this.dependsOnNames.add(name);
        }
        return this;
    }

    @NotNull
    public final ProjectDescription addFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!ArraysKt.contains((Object[])this.files, (Object)file)) {
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])this.files), (Object)file));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.files = thisCollection$iv.toArray(new TestFile[0]);
        }
        return this;
    }

    @NotNull
    public final ProjectDescription withDependencyGraph(@NotNull String dependencyGraph) {
        Intrinsics.checkNotNullParameter((Object)dependencyGraph, (String)"dependencyGraph");
        this.dependencyGraph = dependencyGraph;
        return this;
    }

    @NotNull
    public final ProjectDescription type(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.setType(type);
        return this;
    }

    @NotNull
    public final ProjectDescription under(@NotNull ProjectDescription parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.under = parent;
        return this;
    }

    @NotNull
    public final ProjectDescription variant(@Nullable String variantName) {
        this.variantName = variantName;
        return this;
    }

    @NotNull
    public final ProjectDescription report(boolean report) {
        this.report = report;
        return this;
    }

    public final void ensureUnique() {
        Set targets = new LinkedHashSet();
        for (TestFile file : this.files) {
            if (file instanceof BytecodeTestFile) continue;
            String string = file.targetRelativePath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
            boolean added = targets.add(string);
            if (added) continue;
            String string2 = file.targetRelativePath;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetRelativePath");
            if (StringsKt.endsWith$default((String)string2, (String)"/test.kt", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)file.targetRelativePath, (Object)"test.kt")) {
                String string3 = file.contents;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contents");
                if (new ClassName(string3, ".kt").getClassName() == null) {
                    String base;
                    String name;
                    String string4;
                    int next = 2;
                    Intrinsics.checkNotNullExpressionValue((Object)file.targetRelativePath, (String)"targetRelativePath");
                    int n = 0;
                    int n2 = file.targetRelativePath.length() - 7;
                    Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n, n2), (String)"substring(...)");
                    while (!targets.add(name = base + "test" + next++ + ".kt")) {
                    }
                    file.targetRelativePath = name;
                    continue;
                }
            }
            Assert.fail((String)(file.targetRelativePath + " is specified multiple times; files must be unique (in older versions, lint tests would just clobber the earlier files of the same name)"));
        }
    }

    @NotNull
    public String toString() {
        return this.type + ":" + (!StringsKt.isBlank((CharSequence)this.name) ? this.name : ProjectDescription.class.getSimpleName());
    }

    public final boolean isUnder(@NotNull ProjectDescription desc) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        ProjectDescription projectDescription = this.under;
        if (projectDescription == null) {
            return false;
        }
        ProjectDescription under = projectDescription;
        return Intrinsics.areEqual((Object)under, (Object)desc) || under.isUnder(desc);
    }

    @Override
    public int compareTo(@NotNull ProjectDescription other) {
        Type t2;
        Type t1;
        int delta;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.dependsOn.contains(other) ? 1 : (other.dependsOn.contains(this) ? -1 : ((delta = (t1 = this.type).compareTo((Enum)(t2 = other.type))) != 0 ? -delta : this.name.compareTo(other.name)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002J3\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0011\"\u00020\f\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Companion;", "", "()V", "addManifestFileIfNecessary", "", "manifest", "Ljava/io/File;", "getProjectDirectory", "project", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "rootDir", "adjustGradleSourceSet", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "populateProjectDirectory", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "projectDir", "testFiles", "", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;Ljava/io/File;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)V", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nProjectDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDescription.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescription$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,463:1\n1747#2,3:464\n37#3,2:467\n12474#4,2:469\n*S KotlinDebug\n*F\n+ 1 ProjectDescription.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescription$Companion\n*L\n317#1:464,3\n354#1:467,2\n385#1:469,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getProjectDirectory(@NotNull ProjectDescription project, @NotNull File rootDir) {
            List segments;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            ProjectDescription curr = null;
            curr = project;
            if (curr.getUnder() == null) {
                return new File(rootDir, curr.getName());
            }
            List $this$getProjectDirectory_u24lambda_u240 = segments = (List)new ArrayList();
            boolean bl = false;
            while (true) {
                $this$getProjectDirectory_u24lambda_u240.add(curr.getName());
                if (curr.getUnder() == null) break;
            }
            CollectionsKt.reverse((List)$this$getProjectDirectory_u24lambda_u240);
            String relativePath = Joiner.on((String)File.separator).join((Iterable)segments);
            return new File(rootDir, relativePath);
        }

        public final void populateProjectDirectory(@NotNull TestLintTask $this$populateProjectDirectory, @NotNull ProjectDescription project, @NotNull File projectDir, TestFile ... testFiles) {
            File manifest;
            TestFile fp3;
            boolean ok;
            Intrinsics.checkNotNullParameter((Object)$this$populateProjectDirectory, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            Intrinsics.checkNotNullParameter((Object)testFiles, (String)"testFiles");
            if (!projectDir.exists() && !(ok = projectDir.mkdirs())) {
                throw new RuntimeException("Couldn't create " + projectDir);
            }
            boolean haveGradle = false;
            int n = testFiles.length;
            for (int i = 0; i < n; ++i) {
                TestFile fp2 = testFiles[i];
                if (!(fp2 instanceof TestFile.GradleTestFile)) {
                    String string = fp2.targetRelativePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
                    if (!StringsKt.endsWith$default((String)string, (String)".gradle", (boolean)false, (int)2, null)) continue;
                }
                haveGradle = true;
                break;
            }
            List jars = new ArrayList();
            List compiled = new ArrayList();
            boolean missingClasses = false;
            int n2 = testFiles.length;
            for (int i = 0; i < n2; ++i) {
                Map<File, GradleModelMocker> $i$f$any22;
                GradleModelMocker dependencyGraph;
                fp3 = testFiles[i];
                if (haveGradle) {
                    this.adjustGradleSourceSet(fp3);
                }
                if (fp3 instanceof TestFiles.LibraryReferenceTestFile) {
                    String string = ((TestFiles.LibraryReferenceTestFile)fp3).getFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    jars.add(string);
                    continue;
                }
                if (fp3 instanceof BytecodeTestFile) {
                    String string = fp3.targetRelativePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
                    if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                        String string2 = fp3.targetRelativePath;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetRelativePath");
                        jars.add(string2);
                    }
                }
                if (fp3 instanceof CompiledSourceFile) {
                    compiled.add(fp3);
                    if (!((CompiledSourceFile)fp3).isMissingClasses()) continue;
                    missingClasses = true;
                    continue;
                }
                if (fp3 instanceof StubClassFile) {
                    ((StubClassFile)fp3).setTask($this$populateProjectDirectory);
                    if (!$this$populateProjectDirectory.allowKotlinClassStubs) {
                        boolean bl;
                        block32: {
                            Iterable $this$any$iv = ((StubClassFile)fp3).getStubSources();
                            boolean $i$f$any22 = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    TestFile it = (TestFile)element$iv;
                                    boolean bl2 = false;
                                    String string = it.targetRelativePath;
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
                                    if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) continue;
                                    bl = true;
                                    break block32;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            throw new IllegalStateException("You cannot use Kotlin in a binaryStub or mavenLibrary unless you also turn on\n`lint().allowKotlinClassStubs(true)`. Kotlin stubs work in general, but module\nmetadata is still missing, which means that if your test relies on this metadata\n(for example to call package level functions from Kotlin, or to access things like\ndefault values or inline methods), that will not work.".toString());
                        }
                    }
                }
                fp3.createFile(projectDir);
                if (Intrinsics.areEqual((Object)"lint-override.xml", (Object)fp3.targetRelativePath)) {
                    $this$populateProjectDirectory.overrideConfig = fp3;
                    continue;
                }
                if (!(fp3 instanceof TestFile.GradleTestFile)) continue;
                GradleModelMocker mocker = null;
                GradleModelMocker gradleModelMocker = ((TestFile.GradleTestFile)fp3).getMocker(projectDir);
                Intrinsics.checkNotNullExpressionValue((Object)gradleModelMocker, (String)"getMocker(...)");
                mocker = gradleModelMocker;
                if ($this$populateProjectDirectory.ignoreUnknownGradleConstructs) {
                    mocker = mocker.withLogger((ILogger)new NullLogger());
                }
                if (project.getDependencyGraph() != null) {
                    boolean bl = false;
                    mocker = mocker.withDependencyGraph((String)((Object)dependencyGraph));
                }
                Intrinsics.checkNotNullExpressionValue($this$populateProjectDirectory.projectMocks, (String)"projectMocks");
                Object object = mocker;
                $i$f$any22.put(projectDir, (GradleModelMocker)object);
                mocker.setPrimary(project.getPrimary());
                try {
                    Map<File, GradleModelMocker> map = $this$populateProjectDirectory.projectMocks;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"projectMocks");
                    $i$f$any22 = map;
                    object = projectDir.getCanonicalFile();
                    dependencyGraph = mocker;
                    $i$f$any22.put((File)object, dependencyGraph);
                    continue;
                }
                catch (IOException $i$f$any22) {
                    // empty catch block
                }
            }
            if (!((Collection)jars).isEmpty()) {
                Collection $this$toTypedArray$iv = jars;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                TestFile classpath2 = TestFiles.classpath(Arrays.copyOf(stringArray, stringArray.length));
                classpath2.createFile(projectDir);
            }
            File file = manifest = haveGradle ? new File(projectDir, "src/main/AndroidManifest.xml") : new File(projectDir, "AndroidManifest.xml");
            if (project.getType() != Type.JAVA) {
                this.addManifestFileIfNecessary(manifest);
            }
            if (missingClasses) {
                for (TestFile fp3 : compiled) {
                    ((CompiledSourceFile)fp3).getSource().createFile(projectDir);
                }
                Iterator iterator = compiled.iterator();
                while (!(!iterator.hasNext() || ((CompiledSourceFile)(fp3 = (CompiledSourceFile)iterator.next())).isMissingClasses() && ((CompiledSourceFile)fp3).compile(projectDir, jars))) {
                }
                Assert.fail((String)"One or more compiled source files were missing class file encodings");
            } else {
                CompiledSourceFile.Companion.createFiles(projectDir, compiled);
            }
            if ($this$populateProjectDirectory.configuredOptions != null) {
                boolean bl;
                block33: {
                    TestFile[] $this$any$iv = testFiles;
                    boolean $i$f$any = false;
                    int thisCollection$iv = $this$any$iv.length;
                    for (int i = 0; i < thisCollection$iv; ++i) {
                        TestFile element$iv;
                        TestFile it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.targetRelativePath, (Object)"lint.xml")) continue;
                        bl = true;
                        break block33;
                    }
                    bl = false;
                }
                if (bl) {
                    Assert.fail((String)"Cannot combine lint.xml with `configureOption`; add options as <option> elements in your custom lint.xml instead");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<lint>\n");
                Map<String, String> map = $this$populateProjectDirectory.configuredOptions;
                Intrinsics.checkNotNullExpressionValue(map, (String)"configuredOptions");
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$populateProjectDirectory.issues, (String)"issues");
                    for (Issue issue : $this$populateProjectDirectory.issues) {
                        for (Option option : issue.getOptions()) {
                            if (!Intrinsics.areEqual((Object)option.getName(), (Object)key)) continue;
                            sb.append("    <issue id=\"" + issue.getId() + "\">\n");
                            sb.append("        <option name=\"" + key + "\" value=\"" + value + "\" />\n");
                            sb.append("    </issue>\n");
                        }
                    }
                }
                sb.append("</lint>");
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                TestFile config = TestFiles.xml("lint.xml", string);
                config.createFile(projectDir);
            }
        }

        private final void adjustGradleSourceSet(TestFile $this$adjustGradleSourceSet) {
            if (Intrinsics.areEqual((Object)"AndroidManifest.xml", (Object)$this$adjustGradleSourceSet.targetRelativePath)) {
                $this$adjustGradleSourceSet.within("src/main");
            } else if ($this$adjustGradleSourceSet instanceof TestFile.JavaTestFile && Intrinsics.areEqual((Object)$this$adjustGradleSourceSet.targetRootFolder, (Object)"src")) {
                $this$adjustGradleSourceSet.within("src/main/java");
            } else if ($this$adjustGradleSourceSet instanceof TestFile.KotlinTestFile && Intrinsics.areEqual((Object)$this$adjustGradleSourceSet.targetRootFolder, (Object)"src")) {
                $this$adjustGradleSourceSet.within("src/main/kotlin");
            } else if ($this$adjustGradleSourceSet instanceof TestFile.XmlTestFile && Intrinsics.areEqual((Object)$this$adjustGradleSourceSet.targetRootFolder, (Object)"res")) {
                $this$adjustGradleSourceSet.within("src/main/res");
            } else if ($this$adjustGradleSourceSet instanceof BytecodeTestFile) {
                for (TestFile source2 : ((BytecodeTestFile)((Object)$this$adjustGradleSourceSet)).getSources()) {
                    this.adjustGradleSourceSet(source2);
                }
            }
        }

        private final void addManifestFileIfNecessary(File manifest) {
            if (!manifest.exists()) {
                File parentFile = manifest.getParentFile();
                if (parentFile != null && !parentFile.isDirectory()) {
                    boolean ok = parentFile.mkdirs();
                    Assert.assertTrue((String)("Couldn't create directory " + parentFile), (boolean)ok);
                }
                FilesKt.writeText$default((File)manifest, (String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    package=\"lint.test.pkg\"\n    android:versionCode=\"1\"\n    android:versionName=\"1.0\" >\n</manifest>", null, (int)2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Type;", "", "(Ljava/lang/String;I)V", "APP", "LIBRARY", "JAVA", "lint-tests"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type APP = new Type();
        public static final /* enum */ Type LIBRARY = new Type();
        public static final /* enum */ Type JAVA = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.APP, Type.LIBRARY, Type.JAVA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

