/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.infrastructure.PartialTestMode;
import com.android.tools.lint.checks.infrastructure.ProjectDescriptionList;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.client.api.LintListener;
import com.android.utils.XmlUtils;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R.\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/infrastructure/PartialTestMode;", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "eventListener", "Lkotlin/Function3;", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "Lcom/android/tools/lint/client/api/LintListener$EventType;", "", "", "getEventListener", "()Lkotlin/jvm/functions/Function3;", "folderName", "getFolderName", "modifiesSources", "", "getModifiesSources", "()Z", "applies", "context", "before", "findManifest", "Ljava/io/File;", "projectDir", "replaceManifestVersions", "manifestFile", "minSdk", "", "targetSdk", "usePartialAnalysis", "State", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nPartialTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialTestMode.kt\ncom/android/tools/lint/checks/infrastructure/PartialTestMode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class PartialTestMode
extends TestMode {
    @NotNull
    private final String folderName;
    private final boolean modifiesSources;
    @NotNull
    private final Function3<TestMode.TestModeContext, LintListener.EventType, Object, Unit> eventListener = eventListener.1.INSTANCE;
    @NotNull
    private final String diffExplanation;

    public PartialTestMode() {
        super("Automatic Partial Analysis and Merging", "TestMode.PARTIAL");
        this.folderName = "partial";
        this.modifiesSources = true;
        this.diffExplanation = "Lint results computed provisionally do\nnot match those computed without provisional support enabled. This\nmeans that the detector is not handling provisional support correctly,\nwhich means that it will not work correctly as part of incremental\nGradle builds, where projects are now analyzed separately and the\nresults merged to generate the report.\n\nAlternatively, if this difference is expected, you can set the\n`testModes(...)` to include only one of these two, or turn off\nthe equality check altogether via `.expectIdenticalTestModeOutput(false)`.\nYou can then check each output by passing in a `testMode` parameter\nto `expect`(...).";
    }

    @Override
    @NotNull
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public boolean getModifiesSources() {
        return this.modifiesSources;
    }

    @Override
    public boolean usePartialAnalysis() {
        return true;
    }

    @Override
    public boolean applies(@NotNull TestMode.TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getTask().incrementalFileName == null;
    }

    @Override
    @NotNull
    public Object before(@NotNull TestMode.TestModeContext context) {
        String contents;
        File manifest;
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TestLintTask task = context.getTask();
            List<File> projectFolders = context.getProjectFolders();
            ProjectDescriptionList projects = task.projects;
            manifest = null;
            contents = null;
            if (projects.getSize() != 1) break block1;
            File file = manifest = this.findManifest((File)CollectionsKt.first(projectFolders));
            if (file != null) {
                File it = file;
                boolean bl = false;
                contents = this.replaceManifestVersions(it, 1, 34);
            }
        }
        return new State(manifest, contents);
    }

    @Override
    @NotNull
    public Function3<TestMode.TestModeContext, LintListener.EventType, Object, Unit> getEventListener() {
        return this.eventListener;
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    private final String replaceManifestVersions(File manifestFile, int minSdk, int targetSdk) {
        int targetStart;
        String originalManifest = FilesKt.readText$default((File)manifestFile, null, (int)1, null);
        int newMinSdk = minSdk;
        int newTargetSdk = targetSdk;
        int currentMin = 0;
        currentMin = 1;
        int currentTarget = 26;
        Document doc = XmlUtils.parseDocumentSilently((String)originalManifest, (boolean)true);
        if (doc != null) {
            NodeList usesSdks = doc.getElementsByTagName("uses-sdk");
            if (usesSdks.getLength() != 1) {
                return null;
            }
            Node node = usesSdks.item(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element e = (Element)node;
            String targetSdkVersion = e.getAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
            String minSdkVersion = e.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            try {
                int n;
                Intrinsics.checkNotNull((Object)minSdkVersion);
                Integer n2 = StringsKt.toIntOrNull((String)minSdkVersion);
                currentMin = n2 != null ? n2 : 1;
                Intrinsics.checkNotNull((Object)targetSdkVersion);
                Integer n3 = StringsKt.toIntOrNull((String)targetSdkVersion);
                if (n3 != null) {
                    n = n3;
                } else {
                    int it = SdkVersionInfo.getApiByBuildCode((String)targetSdkVersion, (boolean)false);
                    boolean bl = false;
                    n = it == -1 ? currentMin : it;
                }
                currentTarget = n;
                newMinSdk = Math.min(newMinSdk, currentMin);
                newTargetSdk = Math.max(newMinSdk, Math.min(currentTarget, newTargetSdk));
            }
            catch (NumberFormatException e2) {
                return null;
            }
        } else {
            newTargetSdk = -1;
        }
        String minAttribute = ":minSdkVersion=\"";
        String targetAttribute = ":targetSdkVersion=\"";
        int minStart = StringsKt.indexOf$default((CharSequence)originalManifest, (String)minAttribute, (int)0, (boolean)false, (int)6, null);
        if (minStart == -1) {
            newMinSdk = -1;
        }
        Object newManifest = originalManifest;
        int minEnd = StringsKt.indexOf$default((CharSequence)originalManifest, (char)'\"', (int)(minStart += minAttribute.length()), (boolean)false, (int)4, null);
        if (newMinSdk != -1 && minEnd != -1) {
            String padding = currentMin >= 10 && newMinSdk < 10 ? "0" : "";
            String string = ((String)newManifest).substring(0, minStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String prefix = string;
            String string2 = ((String)newManifest).substring(minEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String postfix = string2;
            newManifest = prefix + padding + newMinSdk + postfix;
        }
        int targetEnd = StringsKt.indexOf$default((CharSequence)((CharSequence)newManifest), (char)'\"', (int)(targetStart += (targetStart = StringsKt.indexOf$default((CharSequence)((CharSequence)newManifest), (String)targetAttribute, (int)0, (boolean)false, (int)6, null)) != -1 ? targetAttribute.length() : 0), (boolean)false, (int)4, null);
        if (newTargetSdk != -1 && targetStart != -1 && targetEnd > targetStart && newTargetSdk < currentTarget) {
            String padding = currentTarget >= 10 && newTargetSdk < 10 ? "0" : "";
            String string = ((String)newManifest).substring(0, targetStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String prefix = string;
            String string3 = ((String)newManifest).substring(targetEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String postfix = string3;
            newManifest = prefix + padding + newTargetSdk + postfix;
        }
        if (!Intrinsics.areEqual((Object)newManifest, (Object)originalManifest)) {
            FilesKt.writeText$default((File)manifestFile, (String)newManifest, null, (int)2, null);
            return originalManifest;
        }
        return null;
    }

    private final File findManifest(File projectDir) {
        File manifestFile = new File(projectDir, "AndroidManifest.xml");
        if (!manifestFile.exists()) {
            manifestFile = new File(projectDir, "src/main/AndroidManifest.xml");
        }
        if (!manifestFile.exists()) {
            return null;
        }
        return manifestFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/infrastructure/PartialTestMode$State;", "", "manifestFile", "Ljava/io/File;", "originalManifest", "", "(Ljava/io/File;Ljava/lang/String;)V", "getManifestFile", "()Ljava/io/File;", "getOriginalManifest", "()Ljava/lang/String;", "lint-tests"})
    private static final class State {
        @Nullable
        private final File manifestFile;
        @Nullable
        private final String originalManifest;

        public State(@Nullable File manifestFile, @Nullable String originalManifest) {
            this.manifestFile = manifestFile;
            this.originalManifest = originalManifest;
        }

        @Nullable
        public final File getManifestFile() {
            return this.manifestFile;
        }

        @Nullable
        public final String getOriginalManifest() {
            return this.originalManifest;
        }
    }
}

