/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ParenthesisTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "includeUnlikely", "", "(Z)V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "transformMessage", "message", "lint-tests"})
public final class ParenthesisTestMode
extends UastSourceTransformationTestMode {
    private final boolean includeUnlikely;
    @NotNull
    private final String diffExplanation;

    public ParenthesisTestMode(boolean includeUnlikely) {
        super("Extra parentheses added", "TestMode.PARENTHESIZED", "parentheses");
        this.includeUnlikely = includeUnlikely;
        this.diffExplanation = StringsKt.trimIndent((String)("\n        The user is allowed to add extra or\n        unnecessary parentheses in their code, and when they do, these show up\n        as `UParenthesizedExpression` nodes in the abstract syntax tree. For\n        this reason, you shouldn't check something like `if (node.uastParent is\n        UCallExpression)` because it's possible that the parent is a\n        parenthesized expression and you have to look at its parent instead.\n        And in theory the code could even include multiple repeated, redundant\n        parentheses. Therefore, whenever you look at the parent, make sure you\n        surround the call with `skipParenthesizedExprUp(UExpression)`.\n\n        Conversely, if you are looking at a child node, you may also need to be\n        prepared to look inside parentheses; for that, use the method\n        `skipParenthesizedExprDown`, an extension method on UExpression (and\n        from Java import it from UastUtils).\n\n        To help catch these bugs, lint has a special test mode where it inserts\n        various redundant parentheses in your test code, and then makes sure\n        that the same errors are reported. The error output will of course\n        potentially vary slightly (since the source code snippets shown will\n        contain extra parentheses), but the test will ignore these differences\n        and only fail if it sees new errors reported or expected errors not\n        reported.\n\n        In the unlikely event that your lint check is actually doing something\n        parenthesis specific, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));
    }

    public /* synthetic */ ParenthesisTestMode(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        List edits = new ArrayList();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new UastSourceTransformationTestMode.EditVisitor(this, edits){
            final /* synthetic */ ParenthesisTestMode this$0;
            final /* synthetic */ List<Edit> $edits;
            {
                this.this$0 = $receiver;
                this.$edits = $edits;
            }

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                    return super.visitBinaryExpression(node);
                }
                this.parenthesize((UExpression)node);
                return super.visitBinaryExpression(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkCall(node);
                return super.visitCallExpression(node);
            }

            private final void checkCall(UCallExpression node) {
                if (node.getSourcePsi() instanceof KtSuperTypeCallEntry || node.getSourcePsi() instanceof KtConstructorDelegationCall) {
                    return;
                }
                if (node.getSourcePsi() instanceof PsiAssertStatement || node.getSourcePsi() instanceof PsiAnnotation) {
                    return;
                }
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)node))) {
                    return;
                }
                UExpression receiver = node.getReceiver();
                if (receiver != null) {
                    if (receiver instanceof UCallExpression || receiver instanceof UParenthesizedExpression || receiver.getSourcePsi() instanceof KtSafeQualifiedExpression || ParenthesisTestMode.access$getIncludeUnlikely$p(this.this$0) && (receiver instanceof UThisExpression || receiver instanceof USuperExpression) || receiver instanceof UQualifiedReferenceExpression && !(((UQualifiedReferenceExpression)receiver).getSelector() instanceof USimpleNameReferenceExpression) || receiver instanceof USimpleNameReferenceExpression && ((USimpleNameReferenceExpression)receiver).resolve() instanceof PsiVariable) {
                        this.parenthesize(receiver);
                    }
                } else {
                    if (node instanceof UThisExpression || node instanceof USuperExpression) {
                        return;
                    }
                    String name = node.getMethodName();
                    if (Intrinsics.areEqual((Object)name, (Object)"this") || Intrinsics.areEqual((Object)name, (Object)"super")) {
                        return;
                    }
                    this.parenthesize((UExpression)node);
                }
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                block2: {
                    UExpression it;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!node.isTernary()) break block2;
                    this.parenthesize(node.getCondition());
                    UExpression uExpression = node.getThenExpression();
                    if (uExpression != null) {
                        it = uExpression;
                        boolean bl = false;
                        this.parenthesize(it);
                    }
                    UExpression uExpression2 = node.getElseExpression();
                    if (uExpression2 != null) {
                        it = uExpression2;
                        boolean bl = false;
                        this.parenthesize(it);
                    }
                }
                return super.visitIfExpression(node);
            }

            public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (ParenthesisTestMode.access$getIncludeUnlikely$p(this.this$0)) {
                    PsiElement sourcePsi = node.getSourcePsi();
                    if (node.isString() && sourcePsi instanceof KtLiteralStringTemplateEntry) {
                        PsiElement psiElement = ((KtLiteralStringTemplateEntry)sourcePsi).getNextSibling();
                        TreeElement treeElement = psiElement instanceof TreeElement ? (TreeElement)psiElement : null;
                        if (!Intrinsics.areEqual((Object)(treeElement != null ? treeElement.getElementType() : null), (Object)KtTokens.CLOSING_QUOTE)) {
                            return super.visitLiteralExpression(node);
                        }
                    }
                    this.parenthesize((UExpression)node);
                }
                return super.visitLiteralExpression(node);
            }

            public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.parenthesize((UExpression)node);
                return super.visitBinaryExpressionWithType(node);
            }

            public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getSourcePsi() instanceof KtStringTemplateExpression) {
                    return super.visitPolyadicExpression(node);
                }
                for (UExpression child : node.getOperands()) {
                    this.parenthesize((UExpression)node, child);
                }
                return super.visitPolyadicExpression(node);
            }

            public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT)) {
                    this.parenthesize(node.getOperand());
                }
                return super.visitPrefixExpression(node);
            }

            private final void parenthesize(UExpression node) {
                if (node.getUastParent() instanceof USwitchClauseExpression) {
                    return;
                }
                this.parenthesize(node, node);
            }

            private final void parenthesize(UExpression beginNode, UExpression endNode) {
                if (beginNode == endNode && beginNode instanceof UParenthesizedExpression && !ParenthesisTestMode.access$getIncludeUnlikely$p(this.this$0)) {
                    return;
                }
                this.surround(this.$edits, beginNode, endNode, "(", ")");
            }
        }));
        return edits;
    }

    @Override
    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)message, (String)"(", (String)"", (boolean)false, (int)4, null), (String)")", (String)"", (boolean)false, (int)4, null);
    }

    public ParenthesisTestMode() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getIncludeUnlikely$p(ParenthesisTestMode $this) {
        return $this.includeUnlikely;
    }
}

