/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.detector.api.Severity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J=\u0010\u0003\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J5\u0010\u0003\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/infrastructure/LoggingTestLintClient;", "Lcom/android/tools/lint/checks/infrastructure/TestLintClient;", "()V", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getLoggedOutput", "", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "exception", "", "format", "args", "", "", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nLoggingTestLintClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingTestLintClient.kt\ncom/android/tools/lint/checks/infrastructure/LoggingTestLintClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public class LoggingTestLintClient
extends TestLintClient {
    @NotNull
    private final StringBuilder log = new StringBuilder();

    @NotNull
    public String getLoggedOutput() {
        String string = this.log.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public void log(@NotNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.log.append(severity.getDescription()).append(": ");
        String string = format;
        if (string != null) {
            it = string;
            boolean bl = false;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string2 = String.format((String)it, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.log.append(string2);
        }
        Throwable throwable = exception;
        if (throwable != null) {
            it = throwable;
            boolean bl = false;
            if (format != null) {
                this.log.append('\n');
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            this.log.append(sw.toString());
        }
        this.log.append('\n');
    }

    @Override
    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.log(Severity.ERROR, exception, format, Arrays.copyOf(args, args.length));
    }
}

