/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFixPerformer;
import com.android.tools.lint.checks.infrastructure.LintFixVerifier;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintResult;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultState;
import com.android.tools.lint.checks.infrastructure.TestResultTransformer;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.XmlUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 E2\u00020\u0001:\u0001EB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002Jf\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0!2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002J$\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002JH\u0010(\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0!2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0!2\u0006\u0010-\u001a\u00020\u0011H\u0002JL\u0010.\u001a\u00020\u00152 \u0010/\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u000e\u0012\u0006\u0012\u0004\u0018\u00010*002\"\u00101\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020\u001502J\u0018\u00106\u001a\u00020\u00002\b\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u000207J<\u00108\u001a\u00020\u00152\b\u00109\u001a\u0004\u0018\u00010\u001e2\b\u0010:\u001a\u0004\u0018\u0001072\u000e\u0010\u0019\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u001eJ\u0016\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020>J*\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u0012\u0010?\u001a\u0004\u0018\u0001072\u0006\u0010@\u001a\u00020\u001eH\u0002J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0011J\u0006\u0010C\u001a\u00020\u0000J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/checks/infrastructure/LintFixVerifier;", "", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "mode", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "state", "Lcom/android/tools/lint/checks/infrastructure/TestResultState;", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Lcom/android/tools/lint/checks/infrastructure/TestMode;Lcom/android/tools/lint/checks/infrastructure/TestResultState;)V", "client", "Lcom/android/tools/lint/checks/infrastructure/TestLintClient;", "diffWindow", "", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "reformat", "", "Ljava/lang/Boolean;", "robot", "appendDataMap", "", "incident", "map", "Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "diffs", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendDiff", "fixDescription", "", "autoFixable", "initial", "", "edited", "compatMode1", "compatMode2", "appendShowUrl", "fix", "Lcom/android/tools/lint/detector/api/LintFix$ShowUrl;", "applyFix", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "before", "after", "compatMode", "applyFixes", "pickFix", "Lkotlin/Function2;", "apply", "Lkotlin/Function3;", "Lcom/android/tools/lint/detector/api/Project;", "Ljava/io/File;", "", "checkFix", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "checkFixes", "fixName", "expectedFile", "expectFixDiffs", "expected", "transformer", "Lcom/android/tools/lint/checks/infrastructure/TestResultTransformer;", "findTestFile", "path", "reformatDiffs", "isRobot", "window", "size", "Companion", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nLintFixVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFixVerifier.kt\ncom/android/tools/lint/checks/infrastructure/LintFixVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,666:1\n1#2:667\n*E\n"})
public final class LintFixVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestLintTask task;
    @NotNull
    private final TestMode mode;
    @NotNull
    private final List<Incident> incidents;
    @NotNull
    private final TestLintClient client;
    private int diffWindow;
    @Nullable
    private Boolean reformat;
    private boolean robot;
    @NotNull
    private static final Pattern FIX_PATTERN;
    private static final boolean TOLERATE_AUTO_FIX_DIFFS = true;

    public LintFixVerifier(@NotNull TestLintTask task, @NotNull TestMode mode, @NotNull TestResultState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.task = task;
        this.mode = mode;
        List<Incident> list2 = state.incidents;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incidents");
        this.incidents = list2;
        TestLintClient testLintClient = state.client;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)testLintClient), (String)"client");
        this.client = testLintClient;
    }

    @NotNull
    public final LintFixVerifier window() {
        this.diffWindow = 2;
        return this;
    }

    @NotNull
    public final LintFixVerifier robot(boolean isRobot) {
        this.robot = isRobot;
        return this;
    }

    @NotNull
    public final LintFixVerifier window(int size) {
        Assert.assertTrue((boolean)(0 <= size ? size < 101 : false));
        this.diffWindow = size;
        return this;
    }

    @NotNull
    public final LintFixVerifier reformatDiffs(boolean reformatDiffs) {
        this.reformat = reformatDiffs;
        return this;
    }

    @NotNull
    public final LintFixVerifier checkFix(@Nullable String fix, @NotNull TestFile after) {
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        try {
            this.checkFixes(fix, after, null, false, false);
        }
        catch (Throwable throwable) {
            try {
                this.checkFixes(fix, after, null, false, true);
            }
            catch (Throwable ignore) {
                try {
                    this.checkFixes(fix, after, null, true, true);
                }
                catch (Throwable ignore2) {
                    throw throwable;
                }
            }
        }
        return this;
    }

    @NotNull
    public final LintFixVerifier expectFixDiffs(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.expectFixDiffs(expected, expectFixDiffs.1.INSTANCE);
    }

    @NotNull
    public final LintFixVerifier expectFixDiffs(@NotNull String expected, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        try {
            this.expectFixDiffs(expected, false, false, transformer);
        }
        catch (Throwable throwable) {
            if (StringsKt.isBlank((CharSequence)expected)) {
                throw throwable;
            }
            try {
                this.expectFixDiffs(expected, false, true, transformer);
            }
            catch (Throwable ignore) {
                try {
                    this.expectFixDiffs(expected, true, true, transformer);
                }
                catch (Throwable ignore2) {
                    throw throwable;
                }
            }
        }
        return this;
    }

    private final LintFixVerifier expectFixDiffs(String expected, boolean compatMode1, boolean compatMode2, TestResultTransformer transformer) {
        String actual;
        String expected2 = expected;
        StringBuilder diff = new StringBuilder(100);
        this.checkFixes(null, null, diff, compatMode1, compatMode2);
        String string = diff.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = transformer.transform(StringsKt.replace$default((String)StringsKt.trimIndent((String)StringsKt.replace$default((String)string, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null)), (char)'$', (char)'\uff04', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"transform(...)");
        String originalActual = actual = string2;
        expected2 = StringsKt.replace$default((String)StringsKt.trimIndent((String)expected2), (char)'$', (char)'\uff04', (boolean)false, (int)4, null);
        if (!Intrinsics.areEqual((Object)expected2, (Object)actual)) {
            CharSequence charSequence = actual;
            Regex regex = new Regex("\\s+\n");
            String string3 = "\n";
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string3))).toString(), (Object)((Object)StringsKt.trim((CharSequence)(regex = new Regex("\\s+\n")).replace(charSequence = (CharSequence)expected2, string3 = "\n"))).toString())) {
                if (!StringsKt.contains$default((CharSequence)expected2, (CharSequence)"Autofix for ", (boolean)false, (int)2, null)) {
                    actual = StringsKt.replace$default((String)actual, (String)"Autofix for ", (String)"Fix for ", (boolean)false, (int)4, null);
                }
                if (this.diffWindow == 0 && Intrinsics.areEqual((Object)Companion.dropImportLineNumberDiffs(expected2), (Object)Companion.dropImportLineNumberDiffs(actual))) {
                    return this;
                }
                charSequence = expected2;
                regex = new Regex("\\s+\n");
                string3 = "\n";
                if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)Companion.bumpFixLineNumbers(regex.replace(charSequence, string3)))).toString(), (Object)((Object)StringsKt.trim((CharSequence)(regex = new Regex("\\s+\n")).replace(charSequence = (CharSequence)actual, string3 = "\n"))).toString())) {
                    if (this.mode.sameOutput(expected2, actual, TestMode.OutputKind.QUICKFIXES)) {
                        return this;
                    }
                    String string4 = TestLintClient.testModePrefix(this.mode);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"testModePrefix(...)");
                    String modePrefix = string4;
                    String defaultPrefix = ((CharSequence)modePrefix).length() == 0 ? "" : "Default:\n\n";
                    Assert.assertEquals((Object)(defaultPrefix + expected2), (Object)(modePrefix + originalActual));
                }
            }
        }
        return this;
    }

    static /* synthetic */ LintFixVerifier expectFixDiffs$default(LintFixVerifier lintFixVerifier, String string, boolean bl, boolean bl2, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 8) != 0) {
            testResultTransformer = expectFixDiffs.2.INSTANCE;
        }
        return lintFixVerifier.expectFixDiffs(string, bl, bl2, testResultTransformer);
    }

    private final TestFile findTestFile(String path) {
        String targetPath;
        String unixPath = StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        for (ProjectDescription project : this.task.projects) {
            for (TestFile file : project.getFiles()) {
                Intrinsics.checkNotNullExpressionValue((Object)file.getTargetPath(), (String)"getTargetPath(...)");
                if (!Intrinsics.areEqual((Object)targetPath, (Object)unixPath)) continue;
                return file;
            }
        }
        for (ProjectDescription project : this.task.projects) {
            for (TestFile file : project.getFiles()) {
                Intrinsics.checkNotNullExpressionValue((Object)file.getTargetPath(), (String)"getTargetPath(...)");
                if (!StringsKt.endsWith$default((String)unixPath, (String)targetPath, (boolean)false, (int)2, null)) continue;
                return file;
            }
        }
        return null;
    }

    private final void checkFixes(String fixName, TestFile expectedFile, StringBuilder diffs, boolean compatMode1, boolean compatMode2) {
        Assert.assertTrue((expectedFile != null || diffs != null ? 1 : 0) != 0);
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List names = arrayList;
        for (Incident incident : this.incidents) {
            List list2;
            LintFix fix;
            if (incident.getFix() == null || this.robot && !fix.robot) continue;
            List list3 = fix instanceof LintFix.LintFixGroup ? (((LintFix.LintFixGroup)fix).getType() == LintFix.GroupType.COMPOSITE ? CollectionsKt.listOf((Object)fix) : ((LintFix.LintFixGroup)fix).getFixes()) : (list2 = CollectionsKt.listOf((Object)fix));
            if (!this.task.allowNonAlphabeticalFixOrder) {
                Companion.ensureIdeCompatibleSorting(list2);
            }
            for (LintFix lintFix : list2) {
                Object targetPath;
                Location location = LintFixPerformer.Companion.getLocation(incident, lintFix);
                Project project = incident.getProject();
                Object object = project;
                if (object == null || (object = object.getDisplayPath(location.getFile())) == null) {
                    object = targetPath = location.getFile().getPath();
                }
                if (lintFix instanceof LintFix.DataMap && diffs != null) {
                    this.appendDataMap(incident, (LintFix.DataMap)lintFix, diffs);
                } else if (lintFix instanceof LintFix.ShowUrl && diffs != null) {
                    this.appendShowUrl(incident, (LintFix.ShowUrl)lintFix, diffs);
                }
                Boolean reformat = this.reformat;
                Map initial = new HashMap();
                Map edited = new HashMap();
                if (!this.applyFix(incident, lintFix, initial, edited, compatMode2)) continue;
                if (reformat == null && LintFixVerifier.Companion.haveSetAttribute(lintFix)) {
                    reformat = true;
                }
                if (expectedFile != null) {
                    Object v = edited.get(targetPath);
                    Intrinsics.checkNotNull(v);
                    String after = (String)v;
                    String string = expectedFile.getContents();
                    Intrinsics.checkNotNull((Object)string);
                    Assert.assertEquals((Object)StringsKt.trimIndent((String)string), (Object)StringsKt.trimIndent((String)after));
                }
                if (diffs != null) {
                    if (reformat != null && reformat.booleanValue()) {
                        for (Map.Entry entry : edited.entrySet()) {
                            String f = (String)entry.getKey();
                            String contents = (String)entry.getValue();
                            if (!StringsKt.endsWith$default((String)f, (String)".xml", (boolean)false, (int)2, null)) continue;
                            Object v = initial.get(f);
                            Intrinsics.checkNotNull(v);
                            if (((CharSequence)v).length() == 0) continue;
                            try {
                                Map map = initial;
                                Object v2 = initial.get(f);
                                Intrinsics.checkNotNull(v2);
                                String string = XmlPrettyPrinter.prettyPrint((Node)XmlUtils.parseDocument((String)((String)v2), (boolean)true), (boolean)true);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prettyPrint(...)");
                                String string2 = string;
                                map.put(f, string2);
                                map = edited;
                                String string3 = XmlPrettyPrinter.prettyPrint((Node)XmlUtils.parseDocument((String)contents, (boolean)true), (boolean)true);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"prettyPrint(...)");
                                string2 = string3;
                                map.put(f, string2);
                            }
                            catch (SAXException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    this.appendDiff(incident, lintFix.getDisplayName(), lintFix.robot, initial, edited, diffs, compatMode1, compatMode2);
                }
                String name = lintFix.getDisplayName();
                if (fixName != null && !Intrinsics.areEqual((Object)fixName, (Object)name)) {
                    if (names.contains(name)) continue;
                    names.add(name);
                    continue;
                }
                names.add(fixName);
            }
        }
    }

    public final void applyFixes(@NotNull Function2<? super Incident, ? super List<? extends LintFix>, ? extends LintFix> pickFix, @NotNull Function3<? super Project, ? super File, ? super byte[], Unit> apply) {
        Project project;
        block2: {
            Intrinsics.checkNotNullParameter(pickFix, (String)"pickFix");
            Intrinsics.checkNotNullParameter(apply, (String)"apply");
            for (Incident it : (Iterable)this.incidents) {
                boolean bl = false;
                Project project2 = it.getProject();
                if (project2 == null) continue;
                project = project2;
                break block2;
            }
            project = null;
        }
        if (project == null) {
            return;
        }
        Project project3 = project;
        TestLintClient testLintClient = this.client;
        LintCliFixPerformer performer2 = new LintCliFixPerformer(apply, project3, testLintClient){
            final /* synthetic */ Function3<Project, File, byte[], Unit> $apply;
            final /* synthetic */ Project $project;
            {
                this.$apply = $apply;
                this.$project = $project;
                super((LintCliClient)$super_call_param$1, false, false, true, false, false, 48, null);
            }

            protected void writeFile(@NotNull File file, @Nullable byte[] contents) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.$apply.invoke((Object)this.$project, (Object)file, (Object)contents);
            }

            protected void writeFile(@NotNull File file, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                byte[] byArray = contents.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this.$apply.invoke((Object)this.$project, (Object)file, (Object)byArray);
            }
        };
        performer2.fix(this.incidents);
    }

    private final boolean applyFix(Incident incident, LintFix lintFix, Map<String, String> before, Map<String, String> after, boolean compatMode) {
        if (LintFixPerformer.Companion.isEditingFix(lintFix) || lintFix instanceof LintFix.LintFixGroup) {
            List edits = LintFixVerifier.Companion.getLeafFixes(lintFix);
            boolean includeMarkers = this.task.includeSelectionMarkers;
            TestLintClient testLintClient = this.client;
            boolean bl = includeMarkers && !compatMode;
            LintCliFixPerformer performer2 = new LintCliFixPerformer(includeMarkers, incident, this, before, after, testLintClient, bl){
                final /* synthetic */ Incident $incident;
                final /* synthetic */ LintFixVerifier this$0;
                final /* synthetic */ Map<String, String> $before;
                final /* synthetic */ Map<String, String> $after;
                {
                    this.$incident = $incident;
                    this.this$0 = $receiver;
                    this.$before = $before;
                    this.$after = $after;
                    super((LintCliClient)$super_call_param$1, false, false, $includeMarkers, $includeMarkers, $super_call_param$2);
                }

                protected void writeFile(@NotNull File file, @Nullable byte[] contents) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Project project = this.$incident.getProject();
                    Object object = project;
                    if (object == null || (object = object.getDisplayPath(file)) == null) {
                        object = file.getPath();
                    }
                    Object targetPath = object;
                    Intrinsics.checkNotNull((Object)targetPath);
                    Object object2 = LintFixVerifier.access$findTestFile(this.this$0, (String)targetPath);
                    if (object2 == null || (object2 = ((TestFile)object2).getContents()) == null) {
                        object2 = "";
                    }
                    Object initial = object2;
                    this.$before.put((String)targetPath, (String)initial);
                    if (contents == null) {
                        this.$after.put((String)targetPath, "");
                    } else {
                        String base642 = "base64: " + Base64.getEncoder().encodeToString(contents);
                        Map<String, String> map = this.$after;
                        Object object3 = targetPath;
                        Iterable iterable = Splitter.fixedLength((int)60).split((CharSequence)base642);
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"split(...)");
                        String string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)"\n", null, null, (int)0, null, (Function1)applyFix.performer.writeFile.1.INSTANCE, (int)30, null);
                        map.put((String)object3, string);
                    }
                }

                protected void writeFile(@NotNull File file, @NotNull String contents) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                    Project project = this.$incident.getProject();
                    Object object = project;
                    if (object == null || (object = object.getDisplayPath(file)) == null) {
                        object = file.getPath();
                    }
                    Object targetPath = object;
                    String initial = ((Object)this.getSourceText(file)).toString();
                    Intrinsics.checkNotNull((Object)targetPath);
                    this.$before.put((String)targetPath, initial);
                    this.$after.put((String)targetPath, contents);
                }
            };
            performer2.fix(incident, edits);
            return true;
        }
        return false;
    }

    private final void appendDiff(Incident incident, String fixDescription, boolean autoFixable, Map<String, String> initial, Map<String, String> edited, StringBuilder diffs, boolean compatMode1, boolean compatMode2) {
        boolean first = true;
        String incidentPath = incident.getDisplayPath();
        Comparator<String> comparator2 = new Comparator<String>(incidentPath){
            final /* synthetic */ String $incidentPath;
            {
                this.$incidentPath = $incidentPath;
            }

            public int compare(@NotNull String o1, @NotNull String o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                int v1 = Intrinsics.areEqual((Object)o1, (Object)this.$incidentPath) ? 0 : 1;
                int v2 = Intrinsics.areEqual((Object)o2, (Object)this.$incidentPath) ? 0 : 1;
                int delta = v1 - v2;
                if (delta != 0) {
                    return delta;
                }
                return Intrinsics.compare((int)v1, (int)v2);
            }
        };
        List sortedFiles = CollectionsKt.sortedWith((Iterable)edited.keySet(), (Comparator)comparator2);
        for (String file : sortedFiles) {
            String after;
            String before;
            Intrinsics.checkNotNull((Object)edited.get(file));
            Intrinsics.checkNotNull((Object)initial.get(file));
            String diff = TestLintResult.Companion.getDiff(before, after, this.diffWindow, compatMode1, compatMode2);
            if (!(((CharSequence)diff).length() > 0)) continue;
            String targetPath = StringsKt.replace$default((String)file, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            if (first) {
                if (autoFixable) {
                    diffs.append("Autofix ");
                } else {
                    diffs.append("Fix ");
                }
                diffs.append("for ").append(incidentPath).append(" line ").append(incident.getLine() + 1).append(":");
                if (fixDescription != null) {
                    first = false;
                    diffs.append(" ").append(fixDescription).append(":\n");
                } else {
                    diffs.append("\n");
                }
            }
            if (!Intrinsics.areEqual((Object)targetPath, (Object)incidentPath)) {
                diffs.append(targetPath).append(":\n");
            }
            diffs.append(diff).append("\n");
        }
    }

    private final void appendShowUrl(Incident incident, LintFix.ShowUrl fix, StringBuilder diffs) {
        String targetPath = incident.getDisplayPath();
        diffs.append("Show URL for ").append(StringsKt.replace$default((String)targetPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)).append(" line ").append(incident.getLine() + 1).append(": ");
        String fixDescription = fix.getDisplayName();
        if (!Intrinsics.areEqual((Object)fixDescription, (Object)("Show " + fix.getUrl())) && fixDescription != null) {
            diffs.append(fixDescription).append(":\n");
        }
        diffs.append(fix.getUrl());
        diffs.append("\n");
    }

    private final void appendDataMap(Incident incident, LintFix.DataMap map, StringBuilder diffs) {
        String targetPath = incident.getDisplayPath();
        diffs.append("Data for ").append(StringsKt.replace$default((String)targetPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)).append(" line ").append(incident.getLine() + 1).append(": ");
        String fixDescription = map.getDisplayName();
        if (fixDescription != null) {
            diffs.append(fixDescription).append(":\n");
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)map.keys());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List keys = CollectionsKt.sorted((Iterable)arrayList);
        for (String key : keys) {
            diffs.append("  ");
            diffs.append(key);
            diffs.append(" : ");
            diffs.append(map.get(key));
            diffs.append("\n");
        }
    }

    public static final /* synthetic */ TestFile access$findTestFile(LintFixVerifier $this, String path) {
        return $this.findTestFile(path);
    }

    static {
        Pattern pattern = Pattern.compile("((Fix|Data) for .* line )(\\d+)(: .+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        FIX_PATTERN = pattern;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/infrastructure/LintFixVerifier$Companion;", "", "()V", "FIX_PATTERN", "Ljava/util/regex/Pattern;", "getFIX_PATTERN", "()Ljava/util/regex/Pattern;", "TOLERATE_AUTO_FIX_DIFFS", "", "adjustLineNumbers", "", "output", "adjust", "Lkotlin/Function1;", "", "bumpFixLineNumbers", "dropImportLineNumberDiffs", "ensureIdeCompatibleSorting", "", "list", "", "Lcom/android/tools/lint/detector/api/LintFix;", "getLeafFixes", "fix", "haveSetAttribute", "lintFix", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nLintFixVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFixVerifier.kt\ncom/android/tools/lint/checks/infrastructure/LintFixVerifier$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,666:1\n37#2,2:667\n1549#3:669\n1620#3,3:670\n*S KotlinDebug\n*F\n+ 1 LintFixVerifier.kt\ncom/android/tools/lint/checks/infrastructure/LintFixVerifier$Companion\n*L\n554#1:667,2\n610#1:669\n610#1:670,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getFIX_PATTERN() {
            return FIX_PATTERN;
        }

        @NotNull
        public final String bumpFixLineNumbers(@NotNull String output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return this.adjustLineNumbers(output, (Function1<? super Integer, Integer>)((Function1)bumpFixLineNumbers.1.INSTANCE));
        }

        @NotNull
        public final String dropImportLineNumberDiffs(@NotNull String output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            if (StringsKt.contains$default((CharSequence)output, (CharSequence)"@@", (boolean)false, (int)2, null)) {
                List lines2 = StringsKt.lines((CharSequence)output);
                StringBuilder sb = new StringBuilder(output.length());
                int n = lines2.size();
                for (int i = 0; i < n; ++i) {
                    String line2 = (String)lines2.get(i);
                    if (StringsKt.startsWith$default((String)line2, (String)"@@ ", (boolean)false, (int)2, null) && i < lines2.size() - 1 && StringsKt.startsWith$default((String)((String)lines2.get(i + 1)), (String)"+ import ", (boolean)false, (int)2, null)) {
                        sb.append("@@ -x +y");
                    } else {
                        sb.append(line2);
                    }
                    sb.append('\n');
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            return output;
        }

        @NotNull
        public final String adjustLineNumbers(@NotNull String output, @NotNull Function1<? super Integer, Integer> adjust) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(adjust, (String)"adjust");
            StringBuilder sb = new StringBuilder(output.length());
            String[] stringArray = new String[]{"\n"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)output, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (String line2 : thisCollection$iv.toArray(new String[0])) {
                Matcher matcher = this.getFIX_PATTERN().matcher(line2);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    String lineNumber = matcher.group(3);
                    String suffix = matcher.group(4);
                    sb.append(prefix);
                    Intrinsics.checkNotNull((Object)lineNumber);
                    sb.append(((Number)adjust.invoke((Object)Integer.parseInt(lineNumber))).intValue());
                    sb.append(suffix);
                } else {
                    sb.append(line2);
                }
                sb.append('\n');
            }
            if (!StringsKt.endsWith$default((CharSequence)output, (char)'\n', (boolean)false, (int)2, null)) {
                sb.setLength(sb.length() - 1);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final boolean haveSetAttribute(LintFix lintFix) {
            if (lintFix instanceof LintFix.SetAttribute) {
                return true;
            }
            if (lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.COMPOSITE) {
                for (LintFix nested : ((LintFix.LintFixGroup)lintFix).getFixes()) {
                    if (!this.haveSetAttribute(nested)) continue;
                    return true;
                }
            }
            return false;
        }

        private final List<LintFix> getLeafFixes(LintFix fix) {
            List flattened = new ArrayList();
            com.android.tools.lint.checks.infrastructure.LintFixVerifier$Companion.getLeafFixes$flatten(flattened, fix);
            return flattened;
        }

        /*
         * WARNING - void declaration
         */
        public final void ensureIdeCompatibleSorting(@NotNull List<? extends LintFix> list2) {
            String actual;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (list2.size() <= 2) {
                return;
            }
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LintFix lintFix = (LintFix)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf(it.getDisplayName()));
            }
            List labels = (List)destination$iv$iv;
            List logicalOrder = labels.subList(1, labels.size());
            List alphabeticalOrder = CollectionsKt.sorted((Iterable)logicalOrder);
            String expected = labels.get(0) + "\n" + CollectionsKt.joinToString$default((Iterable)alphabeticalOrder, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            if (!Intrinsics.areEqual((Object)expected, (Object)(actual = labels.get(0) + "\n" + CollectionsKt.joinToString$default((Iterable)logicalOrder, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)))) {
                Assert.assertEquals((String)"When a quickfix registers multiple\nalternatives, these will be shown as options for developers as\nintention actions (alt/option+enter) in the IDE.\n\nUnfortunately, IntelliJ imposes an **alphabetical** ordering of\nintention actions. This means that the intended logical order the fixes\nwere registered in (perhaps listing the recommended suggestion first)\nis not necessarily the order the user will see them.\n\nLint has a partial workaround for this; it can mark **one** action as\nhaving top priority which will cause it to be listed first, so for\nlists of up to two items, the order is preserved. However, for 3 or\nmore, the order for the items after the first one will be alphabetical.\n\nThis lint test infrastructure check will look up and flag quickfixes\nwhere the logical order differs from this alphabetical order (well, the\nalphabetical order *after* the first item, which lint can always list\nfirst).\n\nTo fix this you have two options:\n\n1. If the order really doesn't matter and you're okay with the\n   alphabetical order, you can either reorder the way you're\n   registering the alternative fixes, or you can disable this test\n   validation step by setting `lint.allowNonAlphabeticalFixOrder(true)`.\n\n * If the order does matter, your only option is to change the labels\n   of your quickfixes. You need to pick suitable labels that have your\n   intended order alphabetically. Ideally you can find natural ways to\n   express the action, but as a last resort you could prefix your fixes\n   with numbers, as in \"1. Set width\" and \"2. Set height\".)\n\n   If the fix names are implicit (for example, if you create a string\n   replacement quick fix using\n   `fix().replace().text(\"something\").with(\"something-else\"))`, lint\n   will create a default display name for you), you can set the label\n   by calling `.name(\"label here\")` on the fix descriptor.", (Object)expected, (Object)actual);
            }
        }

        private static final void getLeafFixes$flatten(List<LintFix> flattened, LintFix fix) {
            if (LintFixPerformer.Companion.isEditingFix(fix)) {
                flattened.add(fix);
            } else if (fix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)fix).getType() == LintFix.GroupType.COMPOSITE) {
                for (LintFix nested : ((LintFix.LintFixGroup)fix).getFixes()) {
                    com.android.tools.lint.checks.infrastructure.LintFixVerifier$Companion.getLeafFixes$flatten(flattened, nested);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

