/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.infrastructure.BaseLintDetectorTest;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import kotlin.io.FilesKt;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class LintDetectorTest
extends BaseLintDetectorTest {
    private Detector mDetector;
    private StringBuilder mOutput = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BuiltinIssueRegistry.reset();
        LintDriver.clearCrashCount();
    }

    @Override
    protected void tearDown() throws Exception {
        List<Object> issues;
        super.tearDown();
        try {
            issues = this.getIssues();
        }
        catch (Throwable t) {
            issues = Collections.emptyList();
        }
        for (Issue issue : issues) {
            EnumSet scope = issue.getImplementation().getScope();
            if (!scope.contains(Scope.JAVA_FILE) && !scope.contains(Scope.ALL_JAVA_FILES) && !scope.contains(Scope.RESOURCE_FILE) && !scope.contains(Scope.ALL_RESOURCE_FILES)) continue;
            if (LintDriver.getCrashCount() <= 0) break;
            LintDetectorTest.fail((String)"There was a crash during lint execution; consult log for details");
            break;
        }
        UastEnvironment.disposeApplicationEnvironment();
        Disposer.assertIsEmpty((boolean)true);
    }

    protected abstract Detector getDetector();

    protected final Detector getDetectorInstance() {
        if (this.mDetector == null) {
            this.mDetector = this.getDetector();
        }
        return this.mDetector;
    }

    protected boolean allowCompilationErrors() {
        return false;
    }

    protected boolean allowObsoleteCustomRules() {
        return true;
    }

    protected boolean allowMissingSdk() {
        return false;
    }

    protected boolean requireCompileSdk() {
        return false;
    }

    protected abstract List<Issue> getIssues();

    @Deprecated
    protected String lintFiles(TestFile ... relativePaths) throws Exception {
        ArrayList<File> files2 = new ArrayList<File>();
        File targetDir = this.getTargetDir();
        for (TestFile testFile : relativePaths) {
            File file = testFile.createFile(targetDir);
            LintDetectorTest.assertNotNull((Object)file);
            files2.add(file);
        }
        return this.lintFiles(targetDir, files2);
    }

    private String lintFiles(File targetDir, List<File> files2) throws Exception {
        files2.sort((file1, file2) -> {
            ResourceFolderType folder1 = ResourceFolderType.getFolderType((String)file1.getParentFile().getName());
            ResourceFolderType folder2 = ResourceFolderType.getFolderType((String)file2.getParentFile().getName());
            if (folder1 != null && folder2 != null && folder1 != folder2) {
                return folder1.compareTo((Enum)folder2);
            }
            return file1.compareTo((File)file2);
        });
        LintDetectorTest.addManifestFileIfNecessary(new File(targetDir, "AndroidManifest.xml"));
        return this.checkLint(files2);
    }

    @Deprecated
    protected String checkLint(List<File> files2) throws Exception {
        TestLintClient lintClient = this.createClient();
        return this.checkLint(lintClient, files2);
    }

    protected String checkLint(TestLintClient lintClient, List<File> files2) throws Exception {
        if (!this.allowMissingSdk()) {
            com.android.tools.lint.checks.infrastructure.TestLintClient.ensureSdkExists((LintClient)lintClient);
        }
        this.mOutput = new StringBuilder();
        String result = lintClient.analyze(files2);
        for (File f : files2) {
            LintDetectorTest.deleteFile(f);
        }
        UastEnvironment.disposeApplicationEnvironment();
        return result;
    }

    protected void checkReportedError(Context context, Issue issue, Severity severity, Location location, String message) {
    }

    protected void checkReportedError(Context context, Issue issue, Severity severity, Location location, String message, LintFix fixData) {
        this.checkReportedError(context, issue, severity, location, message);
    }

    protected TestLintClient createClient() {
        return new TestLintClient();
    }

    protected void configureDriver(LintDriver driver) {
    }

    @Deprecated
    protected String lintProjectIncrementally(String currentFile, TestFile ... files2) throws Exception {
        File projectDir = this.getProjectDir(null, files2);
        File current = new File(projectDir, currentFile.replace('/', File.separatorChar));
        LintDetectorTest.assertTrue((boolean)current.exists());
        TestLintClient client2 = this.createClient();
        client2.setIncremental(current);
        return this.checkLint(client2, Collections.singletonList(projectDir));
    }

    protected static ProjectDescription project(TestFile ... files2) {
        return new ProjectDescription(files2);
    }

    protected TestLintTask lint() {
        TestLintTask task = TestLintTask.lint();
        task.testName(this.getClass().getSimpleName() + "_" + this.getName());
        task.issues(this.getIssues().toArray(new Issue[0]));
        return task;
    }

    @Deprecated
    protected String lintProject(TestFile ... files2) throws Exception {
        File projectDir = this.getProjectDir(null, files2);
        return this.checkLint(Collections.singletonList(projectDir));
    }

    @Override
    protected File getTargetDir() {
        File targetDir = new File(LintDetectorTest.getTempDir(), this.getClass().getSimpleName() + "_" + this.getName());
        LintDetectorTest.addCleanupDir(targetDir);
        return targetDir;
    }

    public static TestFile file() {
        return TestFiles.file();
    }

    public static TestFile source(String to, String source2) {
        return TestFiles.source(to, source2);
    }

    public static TestFile propertyFile(String to, @Language(value="Properties") String source2) {
        return TestFiles.source(to, source2);
    }

    public static TestFile java(String to, @Language(value="JAVA") String source2) {
        return TestFiles.java(to, source2);
    }

    public static TestFile java(@Language(value="JAVA") String source2) {
        return TestFiles.java(source2);
    }

    public static TestFile kotlin(String to, @Language(value="kotlin") String source2) {
        return TestFiles.kotlin(to, source2);
    }

    public static TestFile kotlin(@Language(value="kotlin") String source2) {
        return TestFiles.kotlin(source2);
    }

    public static TestFile kts(@Language(value="kts") String source2) {
        return TestFiles.kotlin("build.gradle.kts", source2);
    }

    public static TestFile kts(String to, @Language(value="kts") String source2) {
        return TestFiles.kotlin(to, source2);
    }

    public static TestFile xml(String to, @Language(value="XML") String source2) {
        return TestFiles.xml(to, source2);
    }

    public TestFile copy(String from) {
        return TestFiles.copy(from, this);
    }

    public TestFile copy(String from, String to) {
        return TestFiles.copy(from, to, this);
    }

    public static TestFile.GradleTestFile gradle(String to, @Language(value="Groovy") String source2) {
        return TestFiles.gradle(to, source2);
    }

    public static TestFile.GradleTestFile gradle(@Language(value="Groovy") String source2) {
        return TestFiles.gradle(source2);
    }

    public static TestFile.ManifestTestFile manifest() {
        return TestFiles.manifest();
    }

    public static TestFile manifest(@Language(value="XML") String source2) {
        return TestFiles.source("AndroidManifest.xml", source2);
    }

    public static TestFile manifest(String path, @Language(value="XML") String source2) {
        return TestFiles.source(path, source2);
    }

    public static TestFile.PropertyTestFile projectProperties() {
        return TestFiles.projectProperties();
    }

    @Deprecated
    public static TestFile.BinaryTestFile bytecode(String to, TestFile.BytecodeProducer producer2) {
        return TestFiles.bytecode(to, producer2);
    }

    public static TestFile.BinaryTestFile bytes(String to, byte[] bytes2) {
        return TestFiles.bytes(to, bytes2);
    }

    @Deprecated
    public static String toBase64(byte[] bytes2) {
        return TestFiles.toBase64(bytes2);
    }

    public static String toBase64gzip(byte[] bytes2) {
        return TestFiles.toBase64gzip(bytes2);
    }

    @Deprecated
    public static String toBase64(File file) throws IOException {
        return TestFiles.toBase64(file);
    }

    public static String toBase64gzip(File file) throws IOException {
        return TestFiles.toBase64gzip(file);
    }

    @Deprecated
    public static TestFile.BinaryTestFile base64(String to, String encoded) {
        return TestFiles.base64(to, encoded);
    }

    public static TestFile.BinaryTestFile base64gzip(String to, String encoded) {
        return TestFiles.base64gzip(to, encoded);
    }

    public static TestFile classpath(String ... extraLibraries) {
        return TestFiles.classpath(extraLibraries);
    }

    public static TestFile bytecode(String into, TestFile source2, long checksum, String ... encoded) {
        return TestFiles.bytecode(into, source2, checksum, encoded);
    }

    @Deprecated
    public static TestFile bytecode(String into, TestFile source2, String ... encoded) {
        return TestFiles.bytecode(into, source2, encoded);
    }

    public static TestFile compiled(String into, TestFile source2, long checksum, String ... encoded) {
        return TestFiles.compiled(into, source2, checksum, encoded);
    }

    @Deprecated
    public static TestFile compiled(String into, TestFile source2, String ... encoded) {
        return TestFiles.compiled(into, source2, encoded);
    }

    public static TestFile.JarTestFile jar(String to) {
        return TestFiles.jar(to);
    }

    public static TestFile.JarTestFile jar(String to, TestFile ... files2) {
        return TestFiles.jar(to, files2);
    }

    public static TestFile.ImageTestFile image(String to, int width, int height) {
        return TestFiles.image(to, width, height);
    }

    protected static boolean imageFormatSupported(String format) {
        if ("PNG".equals(format)) {
            return true;
        }
        try {
            ImageIO.write((RenderedImage)new BufferedImage(0, 0, 2), format, new ByteArrayOutputStream());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected File getProjectDir(String name, TestFile ... testFiles) throws Exception {
        LintDetectorTest.assertFalse((String)"getTargetDir must be overridden to make a unique directory", (boolean)this.getTargetDir().equals(LintDetectorTest.getTempDir()));
        File projectDir = this.getTargetDir();
        if (name != null) {
            projectDir = new File(projectDir, name);
        }
        LintDetectorTest.populateProjectDirectory(projectDir, testFiles);
        return projectDir;
    }

    public static void populateProjectDirectory(File projectDir, TestFile ... testFiles) throws IOException {
        if (!projectDir.exists()) {
            LintDetectorTest.assertTrue((String)projectDir.getPath(), (boolean)projectDir.mkdirs());
        }
        boolean haveGradle = false;
        for (TestFile fp : testFiles) {
            if (!(fp instanceof TestFile.GradleTestFile)) continue;
            haveGradle = true;
        }
        for (TestFile fp : testFiles) {
            if (haveGradle) {
                if ("AndroidManifest.xml".equals(fp.targetRelativePath)) {
                    fp.within("src/main");
                } else if (fp instanceof TestFile.JavaTestFile && fp.targetRootFolder != null && fp.targetRootFolder.equals("src")) {
                    fp.within("src/main/java");
                } else if (fp instanceof TestFile.KotlinTestFile && fp.targetRootFolder != null && fp.targetRootFolder.equals("src")) {
                    fp.within("src/main/kotlin");
                }
            }
            File file = fp.createFile(projectDir);
            LintDetectorTest.assertNotNull((Object)file);
        }
        File manifest = haveGradle ? new File(projectDir, "src/main/AndroidManifest.xml") : new File(projectDir, "AndroidManifest.xml");
        LintDetectorTest.addManifestFileIfNecessary(manifest);
    }

    private static void addManifestFileIfNecessary(File manifest) throws IOException {
        if (!manifest.exists()) {
            File parentFile = manifest.getParentFile();
            if (parentFile != null && !parentFile.isDirectory()) {
                boolean ok = parentFile.mkdirs();
                LintDetectorTest.assertTrue((String)("Couldn't create directory " + parentFile), (boolean)ok);
            }
            FilesKt.writeText((File)manifest, (String)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    package=\"foo.bar2\"\n    android:versionCode=\"1\"\n    android:versionName=\"1.0\" >\n</manifest>\n", (Charset)Charsets.UTF_8);
        }
    }

    @Override
    public InputStream getTestResource(String relativePath, boolean expectExists) {
        String path = "data" + File.separator + relativePath;
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (!expectExists && stream == null) {
            return null;
        }
        return stream;
    }

    protected boolean isEnabled(Issue issue) {
        if (issue == IssueRegistry.LINT_ERROR) {
            return !this.ignoreSystemErrors();
        }
        if (issue == IssueRegistry.PARSER_ERROR) {
            return !this.allowCompilationErrors();
        }
        if (issue == IssueRegistry.OBSOLETE_LINT_CHECK) {
            return !this.allowObsoleteCustomRules();
        }
        return this.getIssues().contains(issue);
    }

    protected boolean includeParentPath() {
        return false;
    }

    protected EnumSet<Scope> getLintScope(List<File> file) {
        return null;
    }

    public String getSuperClass(Project project, String name) {
        return null;
    }

    protected boolean forceErrors() {
        return false;
    }

    protected boolean ignoreSystemErrors() {
        return true;
    }

    private static void addIds(Set<String> ids, Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id != null && !id.isEmpty()) {
                ids.add(Lint.stripIdPrefix((String)id));
            }
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String value = attribute.getValue();
                if (!value.startsWith("@+id/")) continue;
                ids.add(value.substring("@+id/".length()));
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            LintDetectorTest.addIds(ids, child);
        }
    }

    public class TestLintClient
    extends LintCliClient {
        protected final StringWriter writer;
        protected File incrementalCheck;

        public TestLintClient() {
            super(new LintCliFlags(), "test");
            this.writer = new StringWriter();
            LintCliFlags flags = this.getFlags();
            TextReporter reporter = new TextReporter((LintCliClient)this, flags, (Writer)this.writer, false);
            reporter.setForwardSlashPaths(true);
            flags.getReporters().add(reporter);
        }

        public String getDisplayPath(File file, Project project, TextFormat format) {
            String path = super.getDisplayPath(file, project, format);
            return path.replace(File.separatorChar, '/');
        }

        public File getCacheDir(String name, boolean create) {
            File cacheDir = super.getCacheDir(name, create);
            cacheDir = new File(cacheDir, "unit-tests");
            if (create) {
                cacheDir.mkdirs();
            }
            return cacheDir;
        }

        public String getSuperClass(Project project, String name) {
            String superClass = LintDetectorTest.this.getSuperClass(project, name);
            if (superClass != null) {
                return superClass;
            }
            return super.getSuperClass(project, name);
        }

        protected Project createProject(File dir, File referenceDir) {
            if (this.getProjectDirs().contains(dir)) {
                throw new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
            }
            this.getProjectDirs().add(dir);
            Project project = Project.create((LintClient)this, (File)dir, (File)referenceDir);
            this.registerProject(dir, project);
            return project;
        }

        public String getClientRevision() {
            return "unittest";
        }

        protected String cleanup(String result) {
            ArrayList<File> sorted = new ArrayList<File>(BaseLintDetectorTest.sCleanDirs);
            sorted.sort((file1, file2) -> {
                String path1 = file1.getPath();
                String path2 = file2.getPath();
                int delta = path2.length() - path1.length();
                if (delta != 0) {
                    return delta;
                }
                return path1.compareTo(path2);
            });
            for (File dir : sorted) {
                if (!result.contains(dir.getPath())) continue;
                result = result.replace(dir.getPath(), "/TESTROOT").replace("/TESTROOT/", "").replace("\\TESTROOT\\", "");
            }
            return result;
        }

        public String getErrors() {
            return this.writer.toString();
        }

        public UastParser getUastParser(Project project) {
            return new LintCliClient.LintCliUastParser(project){

                public boolean prepare(List<? extends JavaContext> contexts2, LanguageLevel javaLanguageLevel, LanguageVersionSettings kotlinLanguageLevel) {
                    boolean ok = super.prepare(contexts2, javaLanguageLevel, kotlinLanguageLevel);
                    if (LintDetectorTest.this.forceErrors()) {
                        ok = false;
                    }
                    return ok;
                }

                public UFile parse(JavaContext context) {
                    UFile file = super.parse(context);
                    if (!LintDetectorTest.this.allowCompilationErrors()) {
                        if (file != null) {
                            PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.findChildOfType((PsiElement)file.getSourcePsi(), PsiErrorElement.class);
                            if (error != null) {
                                TestCase.fail((String)("Found error element " + error));
                            }
                        } else {
                            TestCase.fail((String)("Failure processing source " + context.file));
                        }
                    }
                    return file;
                }
            };
        }

        public void report(Context context, Incident incident, TextFormat format) {
            Location location = incident.getLocation();
            Issue issue = incident.getIssue();
            TestCase.assertNotNull((Object)location);
            Severity severity = incident.getSeverity();
            if (LintDetectorTest.this.ignoreSystemErrors() && issue == IssueRegistry.LINT_ERROR) {
                return;
            }
            LintDetectorTest.this.checkReportedError(context, issue, severity, location, format.convertTo(incident.getMessage(), TextFormat.TEXT), incident.getFix());
            if (severity == Severity.FATAL) {
                incident.setSeverity(Severity.ERROR);
            }
            if (location.getSecondary() != null) {
                Location l = location.getSecondary();
                if (l == location) {
                    TestCase.fail((String)"Location link cycle");
                }
                while (l != null) {
                    if (l.getMessage() == null) {
                        l.setMessage("<No location-specific message");
                    }
                    if (l == l.getSecondary()) {
                        TestCase.fail((String)"Location link cycle");
                    }
                    l = l.getSecondary();
                }
            }
            super.report(context, incident, format);
            Incident prev = null;
            for (Incident curr : this.getDefiniteIncidents()) {
                TestCase.assertNotSame((Object)curr, prev);
                assert (prev == null || !curr.equals((Object)prev)) : curr;
                prev = curr;
            }
        }

        public void log(Throwable exception, String format, Object ... args) {
            if (exception != null) {
                exception.printStackTrace();
            }
            StringBuilder sb = new StringBuilder();
            if (format != null) {
                sb.append(String.format(format, args));
            }
            if (exception != null) {
                sb.append(exception.toString());
            }
            System.err.println(sb);
            if (exception != null) {
                throw new RuntimeException(exception);
            }
        }

        public Configuration getConfiguration(Project project, LintDriver driver) {
            return this.getConfigurations().getConfigurationForProject(project, (file, defaultConfiguration) -> this.createConfiguration(project, (Configuration)defaultConfiguration));
        }

        private Configuration createConfiguration(Project project, Configuration defaultConfiguration) {
            ConfigurationHierarchy configurations = this.getConfigurations();
            return configurations.createChainedConfigurations(project, null, () -> new TestConfiguration(configurations), () -> {
                File lintConfigXml = ConfigurationHierarchy.Companion.getLintXmlFile(project.getDir());
                if (lintConfigXml.isFile()) {
                    LintXmlConfiguration configuration = LintXmlConfiguration.create((ConfigurationHierarchy)configurations, (File)lintConfigXml);
                    configuration.setFileLevel(false);
                    return configuration;
                }
                return null;
            });
        }

        public List<File> findGlobalRuleJars(LintDriver driver, boolean warnDeprecated) {
            return Collections.emptyList();
        }

        public void setIncremental(File currentFile) {
            this.incrementalCheck = currentFile;
        }

        public IAndroidTarget getCompileTarget(Project project) {
            IAndroidTarget compileTarget = super.getCompileTarget(project);
            if (compileTarget == null) {
                IAndroidTarget target;
                if (LintDetectorTest.this.requireCompileSdk() && project.getBuildTargetHash() != null) {
                    TestCase.fail((String)("Could not find SDK to compile with (" + project.getBuildTargetHash() + "). Either allow the test to use any installed SDK (it defaults to the highest version) via TestLintTask#requireCompileSdk(false), or make sure the SDK being used is the right  one via TestLintTask#sdkHome(File) or $ANDROID_SDK_ROOT and that the actual SDK platform (platforms/" + project.getBuildTargetHash() + " is installed there"));
                }
                if ((target = this.getLatestSdkTarget(1, true)) != null) {
                    return target;
                }
            }
            return compileTarget;
        }

        public List<File> getTestSourceFolders(Project project) {
            List testSourceFolders = super.getTestSourceFolders(project);
            File tests = new File(project.getDir(), "test");
            if (tests.exists()) {
                ArrayList all = Lists.newArrayList((Iterable)testSourceFolders);
                all.add(tests);
                testSourceFolders = all;
            }
            return testSourceFolders;
        }

        public String analyze(List<File> files2) throws Exception {
            String result;
            LintRequest request = this.createLintRequest(files2);
            request.setScope(LintDetectorTest.this.getLintScope(files2));
            if (this.incrementalCheck != null) {
                TestCase.assertEquals((int)1, (int)files2.size());
                File projectDir = files2.get(0);
                TestCase.assertTrue((boolean)this.isProjectDirectory(projectDir));
                Project project = this.createProject(projectDir, projectDir);
                project.addFile(this.incrementalCheck);
                List<Project> projects = Collections.singletonList(project);
                request.setProjects((Collection)projects);
            }
            this.driver = this.createDriver(new CustomIssueRegistry(), request);
            LintDetectorTest.this.configureDriver(this.driver);
            this.driver.analyze();
            Incident prev = null;
            List incidents = this.getDefiniteIncidents();
            for (Object incident : incidents) {
                if (prev != null) {
                    boolean equals = incident.equals((Object)prev);
                    TestCase.assertEquals((boolean)equals, (boolean)prev.equals(incident));
                    int compare = incident.compareTo(prev);
                    TestCase.assertEquals((boolean)equals, (compare == 0 ? 1 : 0) != 0);
                    TestCase.assertEquals((int)(-compare), (int)prev.compareTo((Incident)incident));
                }
                prev = incident;
            }
            Collections.sort(incidents);
            Incident prev2 = prev;
            prev = null;
            for (Incident incident : incidents) {
                if (prev != null && prev2 != null) {
                    TestCase.assertTrue((incident.compareTo(prev) >= 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((prev.compareTo(prev2) >= 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((incident.compareTo(prev2) >= 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((prev.compareTo(incident) <= 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((prev2.compareTo(prev) <= 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((prev2.compareTo(incident) <= 0 ? 1 : 0) != 0);
                }
                prev2 = prev;
                prev = incident;
            }
            LintStats stats = LintStats.Companion.create(this.getErrorCount(), this.getWarningCount());
            for (Reporter reporter : this.getFlags().getReporters()) {
                reporter.write(stats, incidents, this.driver.getRegistry());
            }
            LintDetectorTest.this.mOutput.append(this.writer.toString());
            if (LintDetectorTest.this.mOutput.length() == 0) {
                LintDetectorTest.this.mOutput.append("No warnings.");
            }
            if ((result = LintDetectorTest.this.mOutput.toString()).equals("No issues found.\n")) {
                result = "No warnings.";
            }
            result = this.cleanup(result);
            return result;
        }
    }

    public class TestConfiguration
    extends Configuration {
        protected TestConfiguration(ConfigurationHierarchy configurations) {
            super(configurations);
        }

        public Severity getDefinedSeverity(Issue issue, Configuration source2, Severity visibleDefault) {
            Severity severity = issue.getDefaultSeverity();
            if (severity == Severity.IGNORE) {
                if (issue.getDefaultSeverity() != Severity.IGNORE) {
                    return issue.getDefaultSeverity();
                }
                return Severity.WARNING;
            }
            return severity;
        }

        public boolean isEnabled(Issue issue) {
            return LintDetectorTest.this.isEnabled(issue);
        }

        public void addConfiguredIssues(Map<String, Severity> targetMap, IssueRegistry registry, boolean specificOnly) {
        }

        public File getBaselineFile() {
            return null;
        }

        public void ignore(Context context, Issue issue, Location location, String message) {
            TestCase.fail((String)"Not supported in tests.");
        }

        public void setSeverity(Issue issue, Severity severity) {
            TestCase.fail((String)"Not supported in tests.");
        }

        public void setBaselineFile(File baselineFile) {
            TestCase.fail((String)"Not supported in tests.");
        }

        public void ignore(Issue issue, File file) {
            TestCase.fail((String)"Not supported in tests.");
        }

        public void ignore(String issueId, File file) {
            TestCase.fail((String)"Not supported in tests.");
        }
    }

    public class CustomIssueRegistry
    extends IssueRegistry {
        public List<Issue> getIssues() {
            return LintDetectorTest.this.getIssues();
        }

        public int getApi() {
            return 14;
        }
    }
}

