/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.KotlinClasspathKt;
import com.intellij.openapi.application.PathManager;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"findFromRuntimeClassPath", "", "Ljava/io/File;", "accept", "Lkotlin/Function1;", "", "findKotlinStdlibPath", "isKotlinStdLib", "file", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nKotlinClasspath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClasspath.kt\ncom/android/tools/lint/checks/infrastructure/KotlinClasspathKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class KotlinClasspathKt {
    @NotNull
    public static final List<File> findKotlinStdlibPath() {
        Iterable iterable;
        block4: {
            Collection collection;
            block2: {
                block3: {
                    collection = KotlinClasspathKt.findFromRuntimeClassPath((Function1<? super File, Boolean>)((Function1)findKotlinStdlibPath.1.INSTANCE));
                    if (!collection.isEmpty()) break block2;
                    boolean bl = false;
                    iterable = PathManager.getJarForClass(KotlinVersion.class);
                    if (iterable == null) break block3;
                    Iterable it = iterable;
                    boolean bl2 = false;
                    List list2 = CollectionsKt.listOf((Object)it.toFile());
                    iterable = list2;
                    if (list2 != null) break block4;
                }
                throw new IllegalStateException(("Did not find kotlin-stdlib-jdk8 in classpath: " + System.getProperty("java.class.path")).toString());
            }
            iterable = collection;
        }
        return (List)iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<File> findFromRuntimeClassPath(@NotNull Function1<? super File, Boolean> accept) {
        Intrinsics.checkNotNullParameter(accept, (String)"accept");
        String string = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String classPath = string;
        List paths = new ArrayList();
        char[] cArray = new char[]{File.pathSeparatorChar};
        for (Object path : StringsKt.split$default((CharSequence)classPath, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            File file = new File((String)path);
            if (!((Boolean)accept.invoke((Object)file)).booleanValue()) continue;
            File file2 = file.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
            paths.add(file2);
        }
        if (paths.isEmpty()) {
            Object path;
            path = new char[1];
            path[0] = File.pathSeparatorChar;
            for (String jar : StringsKt.split$default((CharSequence)classPath, (char[])path, (boolean)false, (int)0, (int)6, null)) {
                try {
                    File jarFile = new File(jar);
                    Closeable closeable = new JarFile(jarFile);
                    Throwable throwable = null;
                    try {
                        JarFile it = (JarFile)closeable;
                        boolean bl = false;
                        String string2 = it.getManifest().getMainAttributes().getValue("Class-Path");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                        String[] stringArray = new String[]{" "};
                        for (String path2 : StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                            File file = new File(new URI(path2).getPath());
                            if (!((Boolean)accept.invoke((Object)file)).booleanValue()) continue;
                            if (!file.isAbsolute()) {
                                paths.add(new File(jarFile.getParentFile(), file.getPath()));
                                continue;
                            }
                            paths.add(file);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    System.err.println("Could not load jar " + jar + ": " + e);
                }
            }
        }
        return paths;
    }

    private static final boolean isKotlinStdLib(File file) {
        String name = file.getName();
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)"kotlin-stdlib", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"kotlin-reflect", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ boolean access$isKotlinStdLib(File file) {
        return KotlinClasspathKt.isKotlinStdLib(file);
    }
}

