/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/infrastructure/FullyQualifyNamesTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "fqnPattern", "Lkotlin/text/Regex;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "transformMessage", "message", "TypeVisitor", "lint-tests"})
public final class FullyQualifyNamesTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        The user is allowed to use fully\n        qualified names, or import aliases, in the source code. This\n        test mode replaces symbols with fully qualified names and imports\n        to make sure the lint detectors are properly handling these scenarios\n        instead of simply hardcoding to simple names in the source.\n\n        In the unlikely event that your lint check is actually doing something\n        specific to fully qualified names, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));
    @NotNull
    private final Regex fqnPattern = new Regex("[^\\p{Alnum}_]([\\p{Alnum}_]+\\.)+");

    public FullyQualifyNamesTestMode() {
        super("Names replaced with Fully Qualified Names", "TestMode.FULLY_QUALIFIED", "qualified-imports");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        Map editMap = new LinkedHashMap();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new TypeVisitor(context, source2, editMap){
            final /* synthetic */ Map<Integer, Edit> $editMap;
            {
                this.$editMap = $editMap;
                super($context, $source);
            }

            public void checkClassReference(@NotNull UElement node, @NotNull PsiClass cls, int offset, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = cls.getQualifiedName();
                if (string == null) {
                    return;
                }
                String fqn = string;
                Integer n = offset;
                this.$editMap.put(n, UastSourceTransformationTestMode.EditVisitor.replace$default(this, offset, offset + name.length(), fqn, false, 8, null));
            }

            public boolean allowKotlinCoreTypes() {
                return false;
            }
        }));
        return CollectionsKt.toMutableList(editMap.values());
    }

    @Override
    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object s = message;
        while (Regex.find$default((Regex)this.fqnPattern, (CharSequence)((CharSequence)s), (int)0, (int)2, null) != null) {
            String after;
            String before;
            MatchResult result;
            MatchGroupCollection groups = result.getGroups();
            MatchGroup matchGroup = groups.get(0);
            if (matchGroup == null || (matchGroup = matchGroup.getRange()) == null) {
                return s;
            }
            MatchGroup range = matchGroup;
            int from = range.getFirst() + 1;
            int to = range.getLast() + 1;
            Intrinsics.checkNotNullExpressionValue((Object)((String)s).substring(0, from), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)((String)s).substring(to), (String)"substring(...)");
            s = before + after;
        }
        return s;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0002J*\u0010(\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0005H\u0002J\"\u00100\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0010\u00101\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001dH\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001fH\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010=\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020,H\u0016J\u0010\u0010B\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020CH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/checks/infrastructure/FullyQualifyNamesTestMode$TypeVisitor;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode$EditVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "source", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Ljava/lang/String;)V", "scopes", "Ljava/util/ArrayDeque;", "", "visitedElements", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/HashSet;", "afterVisitBlockExpression", "", "node", "Lorg/jetbrains/uast/UBlockExpression;", "afterVisitLambdaExpression", "Lorg/jetbrains/uast/ULambdaExpression;", "afterVisitMethod", "Lorg/jetbrains/uast/UMethod;", "allowClassReference", "", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "parent", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "allowKotlinCoreTypes", "checkAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "checkCall", "Lorg/jetbrains/uast/UCallExpression;", "checkClassReference", "Lorg/jetbrains/uast/UElement;", "cls", "Lcom/intellij/psi/PsiClass;", "offset", "", "name", "checkNameReference", "checkTypeReference", "type", "Lcom/intellij/psi/PsiType;", "typeReference", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "isDefined", "isKotlinCoreType", "fqn", "replaceClassReference", "visitAnnotation", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitBlockExpression", "visitCallExpression", "visitCatchClause", "Lorg/jetbrains/uast/UCatchClause;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitLambdaExpression", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitMethod", "visitSimpleNameReferenceExpression", "visitTypeReferenceExpression", "visitVariable", "Lorg/jetbrains/uast/UVariable;", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nFullyQualifyNamesTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullyQualifyNamesTestMode.kt\ncom/android/tools/lint/checks/infrastructure/FullyQualifyNamesTestMode$TypeVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,475:1\n2624#2,3:476\n1549#2:479\n1620#2,3:480\n1549#2:484\n1620#2,3:485\n1747#2,3:488\n1855#2,2:491\n1855#2,2:493\n1#3:483\n*S KotlinDebug\n*F\n+ 1 FullyQualifyNamesTestMode.kt\ncom/android/tools/lint/checks/infrastructure/FullyQualifyNamesTestMode$TypeVisitor\n*L\n194#1:476,3\n252#1:479\n252#1:480,3\n278#1:484\n278#1:485,3\n289#1:488,3\n314#1:491,2\n319#1:493,2\n*E\n"})
    public static abstract class TypeVisitor
    extends UastSourceTransformationTestMode.EditVisitor {
        @NotNull
        private final JavaContext context;
        @NotNull
        private final String source;
        @NotNull
        private final HashSet<PsiElement> visitedElements;
        @NotNull
        private final ArrayDeque<List<String>> scopes;

        public TypeVisitor(@NotNull JavaContext context, @NotNull String source2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            this.context = context;
            this.source = source2;
            this.visitedElements = new HashSet();
            this.scopes = new ArrayDeque();
        }

        public void checkClassReference(@NotNull UElement node, @NotNull PsiClass cls, int offset, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        }

        public void checkTypeReference(@NotNull UElement node, @Nullable PsiClass cls, int offset, @NotNull PsiType type) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        }

        public boolean allowKotlinCoreTypes() {
            return true;
        }

        private final void replaceClassReference(PsiClass cls, UElement node, PsiType type) {
            String first;
            int end;
            String string = cls.getQualifiedName();
            if (string == null) {
                return;
            }
            String fqn = string;
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement psi = psiElement;
            if (psi.getContainingFile() instanceof PsiCompiledFile) {
                return;
            }
            if (psi instanceof KtSuperTypeCallEntry || psi instanceof KtThisExpression || psi instanceof KtConstructorDelegationCall) {
                return;
            }
            if (!this.visitedElements.add(psi)) {
                return;
            }
            TextRange textRange = psi.getTextRange();
            if (textRange == null) {
                return;
            }
            int start = textRange.getStartOffset();
            if (type != null) {
                this.checkTypeReference(node, cls, start, type);
            }
            if (!this.allowKotlinCoreTypes() && this.isKotlinCoreType(fqn) && Lint.isKotlin((Language)node.getLang())) {
                return;
            }
            int nameStart = StringsKt.lastIndexOf$default((CharSequence)fqn, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            if (nameStart == 0) {
                return;
            }
            int nameLength = fqn.length() - nameStart;
            for (end = start; end < this.source.length() && Character.isJavaIdentifierPart(this.source.charAt(end)); ++end) {
            }
            String string2 = this.source.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String name = string2;
            if (Intrinsics.areEqual((Object)name, (Object)"this") || Intrinsics.areEqual((Object)name, (Object)"super")) {
                return;
            }
            if (!StringsKt.regionMatches$default((String)this.source, (int)start, (String)fqn, (int)nameStart, (int)nameLength, (boolean)false, (int)16, null)) {
                boolean bl;
                block17: {
                    UFile uFile = this.context.getUastFile();
                    Intrinsics.checkNotNull((Object)uFile);
                    Iterable $this$none$iv = uFile.getImports();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            UImportStatement it = (UImportStatement)element$iv;
                            boolean bl2 = false;
                            PsiElement psiElement2 = it.getSourcePsi();
                            KtImportDirective ktImportDirective = psiElement2 instanceof KtImportDirective ? (KtImportDirective)psiElement2 : null;
                            String alias = ktImportDirective != null && (ktImportDirective = ktImportDirective.getImportPath()) != null && (ktImportDirective = ktImportDirective.getAlias()) != null ? ktImportDirective.toString() : null;
                            if (!Intrinsics.areEqual(alias, (Object)name)) continue;
                            bl = false;
                            break block17;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
            }
            if (this.isDefined(first = StringsKt.substringBefore$default((String)fqn, (char)'.', null, (int)2, null))) {
                return;
            }
            this.checkClassReference(node, cls, start, name);
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkNameReference(node);
            return super.visitSimpleNameReferenceExpression(node);
        }

        protected boolean allowClassReference(@NotNull USimpleNameReferenceExpression node, @NotNull UQualifiedReferenceExpression parent) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return true;
        }

        private final void checkNameReference(USimpleNameReferenceExpression node) {
            PsiElement resolved;
            UElement parent = node.getUastParent();
            if (parent instanceof UQualifiedReferenceExpression && UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)parent).getReceiver()) == node && (resolved = node.resolve()) instanceof PsiClass) {
                if (!this.allowClassReference(node, (UQualifiedReferenceExpression)parent)) {
                    return;
                }
                PsiClassType type = this.context.getEvaluator().getClassType((PsiClass)resolved);
                this.replaceClassReference((PsiClass)resolved, (UElement)node, (PsiType)type);
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitMethod(@NotNull UMethod node) {
            block1: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Iterable iterable = node.getUastParameters();
                ArrayDeque<List<String>> arrayDeque = this.scopes;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    UParameter uParameter = (UParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(p0.getName());
                }
                arrayDeque.addLast(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
                UTypeReferenceExpression uTypeReferenceExpression = node.getReturnTypeReference();
                if (uTypeReferenceExpression == null) break block1;
                UTypeReferenceExpression it = uTypeReferenceExpression;
                boolean bl = false;
                this.checkTypeReference(it);
            }
            return super.visitMethod(node);
        }

        public boolean visitBlockExpression(@NotNull UBlockExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopes.addLast(new ArrayList());
            return super.visitBlockExpression(node);
        }

        public void afterVisitBlockExpression(@NotNull UBlockExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopes.removeLast();
            super.afterVisitBlockExpression(node);
        }

        public void afterVisitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopes.removeLast();
            super.afterVisitMethod(node);
        }

        public boolean visitLocalVariable(@NotNull ULocalVariable node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                List list2 = (List)CollectionsKt.lastOrNull((Iterable)this.scopes);
                if (list2 == null) break block0;
                String string = node.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                list2.add(string);
            }
            return super.visitLocalVariable(node);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable iterable = node.getValueParameters();
            ArrayDeque<List<String>> arrayDeque = this.scopes;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                UParameter uParameter = (UParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getName());
            }
            arrayDeque.addLast(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
            return super.visitLambdaExpression(node);
        }

        public void afterVisitLambdaExpression(@NotNull ULambdaExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopes.removeLast();
            super.afterVisitLambdaExpression(node);
        }

        private final boolean isDefined(String name) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.scopes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            List it = (List)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            Iterable $this$any$iv2 = it;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    String s = (String)element$iv2;
                                    boolean bl4 = false;
                                    if (!Intrinsics.areEqual((Object)s, (Object)name)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public boolean visitAnnotation(@NotNull UAnnotation node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkAnnotation(node);
            return super.visitAnnotation(node);
        }

        private final void checkAnnotation(UAnnotation node) {
            block3: {
                UIdentifier anchor = node.getUastAnchor();
                if (anchor == null) break block3;
                PsiElement psiElement = anchor.getSourcePsi();
                if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
                    return;
                }
                int start = psiElement.getStartOffset();
                if (start > 0 && (this.source.charAt(start - 1) == '.' || this.source.charAt(start - 1) == ':')) {
                    return;
                }
                PsiClass psiClass = node.resolve();
                if (psiClass != null) {
                    PsiClass cls = psiClass;
                    boolean bl = false;
                    this.replaceClassReference(cls, (UElement)anchor, (PsiType)this.context.getEvaluator().getClassType(cls));
                }
            }
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$forEach$iv = node.getUastSuperTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UTypeReferenceExpression p0 = (UTypeReferenceExpression)element$iv;
                boolean bl = false;
                this.checkTypeReference(p0);
            }
            return super.visitClass(node);
        }

        public boolean visitCatchClause(@NotNull UCatchClause node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$forEach$iv = node.getTypeReferences();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UTypeReferenceExpression p0 = (UTypeReferenceExpression)element$iv;
                boolean bl = false;
                this.checkTypeReference(p0);
            }
            return super.visitCatchClause(node);
        }

        public boolean visitVariable(@NotNull UVariable node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
                if (uTypeReferenceExpression == null) break block0;
                UTypeReferenceExpression p0 = uTypeReferenceExpression;
                boolean bl = false;
                this.checkTypeReference(p0);
            }
            return super.visitVariable(node);
        }

        private final void checkTypeReference(UTypeReferenceExpression typeReference) {
            block6: {
                Unit unit;
                PsiClass cls;
                int index;
                String text;
                PsiElement psiElement = typeReference.getSourcePsi();
                String string = text = psiElement != null ? psiElement.getText() : null;
                if (!(text == null || (index = StringsKt.indexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null)) == -1 || index >= text.length() - 3 && StringsKt.endsWith$default((String)text, (String)"...", (boolean)false, (int)2, null))) {
                    return;
                }
                PsiType type = typeReference.getType();
                if (this.context.getEvaluator().getTypeClass(type) instanceof PsiTypeParameter) {
                    return;
                }
                if (type instanceof PsiDisjunctionType) {
                    return;
                }
                PsiType erased = this.context.getEvaluator().erasure(type.getDeepComponentType());
                PsiClass psiClass = cls = this.context.getEvaluator().getTypeClass(erased);
                if (psiClass != null) {
                    PsiClass it = psiClass;
                    boolean bl = false;
                    this.replaceClassReference(it, (UElement)typeReference, typeReference.getType());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block6;
                TypeVisitor $this$checkTypeReference_u24lambda_u2410 = this;
                boolean bl = false;
                PsiElement psiElement2 = typeReference.getSourcePsi();
                if (psiElement2 == null) {
                    return;
                }
                int offset = psiElement2.getTextOffset();
                $this$checkTypeReference_u24lambda_u2410.checkTypeReference((UElement)typeReference, cls, offset, type);
            }
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkCall(node);
            return super.visitCallExpression(node);
        }

        private final void checkCall(UCallExpression node) {
            if (node.getReceiver() != null || !UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                return;
            }
            UReferenceExpression uReferenceExpression = node.getClassReference();
            if (uReferenceExpression == null) {
                return;
            }
            UReferenceExpression reference = uReferenceExpression;
            UIdentifier identifier = node.getMethodIdentifier();
            if (reference instanceof UQualifiedReferenceExpression || identifier == null) {
                return;
            }
            PsiElement psiElement = reference.resolve();
            PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            if (psiClass == null) {
                return;
            }
            PsiClass cls = psiClass;
            if (reference.getSourcePsi() instanceof KtCallElement) {
                UElement typeReference;
                PsiElement psiElement2 = reference.getSourcePsi();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallElement");
                KtCallElement ktCallElement = (KtCallElement)psiElement2;
                KtExpression ktExpression = ktCallElement.getCalleeExpression();
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ktExpression instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)ktExpression : null;
                UElement uElement = typeReference = ktConstructorCalleeExpression != null && (ktExpression = ktConstructorCalleeExpression.getTypeReference()) != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktExpression)) : null;
                if (typeReference != null) {
                    this.replaceClassReference(cls, typeReference, node.getExpressionType());
                    return;
                }
                PsiElement psiElement3 = identifier.getSourcePsi();
                if (Intrinsics.areEqual(psiElement3 != null && (psiElement3 = psiElement3.getParent()) != null && (psiElement3 = psiElement3.getPrevSibling()) != null ? psiElement3.getText() : null, (Object)".")) {
                    return;
                }
            }
            this.replaceClassReference(cls, (UElement)identifier, node.getExpressionType());
        }

        public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            block5: {
                Integer offset;
                UElement typeReference;
                PsiClass cls;
                PsiType type;
                block6: {
                    UElement uElement;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiType psiType = node.getType();
                    if (psiType == null) break block5;
                    type = psiType;
                    boolean bl = false;
                    PsiType erased = this.context.getEvaluator().erasure(type);
                    cls = this.context.getEvaluator().getTypeClass(erased);
                    PsiElement sourcePsi = node.getSourcePsi();
                    UExpression uExpression = node.getExpression();
                    if (uExpression != null) {
                        uElement = (UElement)uExpression;
                    } else if (sourcePsi instanceof KtClassLiteralExpression) {
                        uElement = UastContextKt.toUElement((PsiElement)((KtClassLiteralExpression)sourcePsi).getLhs());
                        if (uElement == null) {
                            uElement = (UElement)node;
                        }
                    } else {
                        uElement = typeReference = (UElement)node;
                    }
                    if (cls == null) break block6;
                    this.replaceClassReference(cls, typeReference, type);
                    break block5;
                }
                PsiElement psiElement = typeReference.getSourcePsi();
                Integer n = offset = psiElement != null ? Integer.valueOf(psiElement.getTextOffset()) : null;
                if (offset == null) break block5;
                this.checkTypeReference(typeReference, cls, offset, type);
            }
            return super.visitClassLiteralExpression(node);
        }

        public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkTypeReference(node);
            return super.visitTypeReferenceExpression(node);
        }

        public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
                if (uTypeReferenceExpression == null) break block0;
                UTypeReferenceExpression it = uTypeReferenceExpression;
                boolean bl = false;
                this.checkTypeReference(it);
            }
            return super.visitBinaryExpressionWithType(node);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isKotlinCoreType(String fqn) {
            String string = fqn;
            switch (string.hashCode()) {
                case 1630335596: {
                    if (string.equals("java.lang.Throwable")) return true;
                    return false;
                }
                case -527879800: {
                    if (string.equals("java.lang.Float")) return true;
                    return false;
                }
                case -1062240117: {
                    if (string.equals("java.lang.CharSequence")) return true;
                    return false;
                }
                case 499831342: {
                    if (string.equals("java.util.Iterator")) return true;
                    return false;
                }
                case 761287205: {
                    if (string.equals("java.lang.Double")) return true;
                    return false;
                }
                case 577341676: {
                    if (string.equals("java.util.ListIterator")) return true;
                    return false;
                }
                case -688322466: {
                    if (string.equals("java.util.Collection")) return true;
                    return false;
                }
                case -1383343454: {
                    if (string.equals("java.util.Set")) return true;
                    return false;
                }
                case -2056817302: {
                    if (string.equals("java.lang.Integer")) return true;
                    return false;
                }
                case 1275614662: {
                    if (string.equals("java.lang.Iterable")) return true;
                    return false;
                }
                case 65821278: {
                    if (string.equals("java.util.List")) return true;
                    return false;
                }
                case 398585941: {
                    if (string.equals("java.lang.Enum")) return true;
                    return false;
                }
                case 155276373: {
                    if (string.equals("java.lang.Character")) return true;
                    return false;
                }
                case 398795216: {
                    if (string.equals("java.lang.Long")) return true;
                    return false;
                }
                case -515992664: {
                    if (string.equals("java.lang.Short")) return true;
                    return false;
                }
                case -1383349348: {
                    if (string.equals("java.util.Map")) return true;
                    return false;
                }
                case 344809556: {
                    if (string.equals("java.lang.Boolean")) return true;
                    return false;
                }
                case -1571515090: {
                    if (string.equals("java.lang.Comparable")) return true;
                    return false;
                }
                case 1195259493: {
                    if (string.equals("java.lang.String")) return true;
                    return false;
                }
                case 1052881309: {
                    if (string.equals("java.lang.Number")) return true;
                    return false;
                }
                case 398507100: {
                    if (!string.equals("java.lang.Byte")) return false;
                    return true;
                }
            }
            return false;
        }
    }
}

