/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/infrastructure/CharacterDataTestMode;", "Lcom/android/tools/lint/checks/infrastructure/SourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "applies", "", "context", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "before", "", "computeEdits", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "contents", "findRes", "Ljava/io/File;", "projectDir", "transform", "source", "transformMessage", "message", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nCharacterDataTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterDataTestMode.kt\ncom/android/tools/lint/checks/infrastructure/CharacterDataTestMode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,128:1\n1747#2,2:129\n1749#2:133\n12474#3,2:131\n13309#3:134\n13309#3,2:135\n13310#3:137\n*S KotlinDebug\n*F\n+ 1 CharacterDataTestMode.kt\ncom/android/tools/lint/checks/infrastructure/CharacterDataTestMode\n*L\n48#1:129,2\n48#1:133\n49#1:131,2\n59#1:134\n60#1:135,2\n59#1:137\n*E\n"})
public final class CharacterDataTestMode
extends SourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        In XML, text content can be wrapped\n        in special CDATA sections, like <!CDATA[this]]>. Code processing the\n        XML documents need to handle this.\n\n        In the unlikely event that your lint check is actually doing something\n        CDATA specific, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public CharacterDataTestMode() {
        super("Converting text nodes to CDATA XML sections", "TestMode.CDATA", "cdata");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean applies(@NotNull TestMode.TestModeContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$any$iv = context.getProjects();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ProjectDescription it = (ProjectDescription)element$iv;
            boolean bl2 = false;
            TestFile[] $this$any$iv2 = it.getFiles();
            boolean $i$f$any2 = false;
            int n = $this$any$iv2.length;
            for (int i = 0; i < n; ++i) {
                TestFile element$iv2;
                TestFile file = element$iv2 = $this$any$iv2[i];
                boolean bl3 = false;
                if (file instanceof TestFile.XmlTestFile) {
                    String string = file.contents;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"<string", (boolean)false, (int)2, null)) {
                        return true;
                    }
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Override
    @Nullable
    public Object before(@NotNull TestMode.TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<File> projectFolders = context.getProjectFolders();
        for (File project : projectFolders) {
            File[] $this$forEach$iv;
            File res;
            if (this.findRes(project) == null) continue;
            if (res.listFiles() == null) continue;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File[] fileArray;
                File element$iv;
                File resourceFolder = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (fileArray == null) continue;
                fileArray = resourceFolder.listFiles();
                Intrinsics.checkNotNull((Object)fileArray);
                File[] $this$forEach$iv2 = fileArray;
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    File element$iv2;
                    File resourceFile = element$iv2 = $this$forEach$iv2[j];
                    boolean bl2 = false;
                    if (!resourceFile.isFile()) continue;
                    String string = resourceFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNull((Object)resourceFile);
                    String source2 = FilesKt.readText$default((File)resourceFile, null, (int)1, null);
                    String updated = this.transform(source2);
                    if (Intrinsics.areEqual((Object)updated, (Object)source2)) continue;
                    FilesKt.writeText$default((File)resourceFile, (String)updated, null, (int)2, null);
                }
            }
        }
        return null;
    }

    @NotNull
    public final String transform(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        List<Edit> edits = this.computeEdits(source2);
        return Edit.Companion.performEdits(source2, edits);
    }

    private final List<Edit> computeEdits(String contents) {
        int end;
        int next;
        List edits = new ArrayList();
        int offset = 0;
        while ((offset = StringsKt.indexOf$default((CharSequence)contents, (String)"<string ", (int)offset, (boolean)false, (int)4, null)) != -1 && (next = StringsKt.indexOf$default((CharSequence)contents, (char)'>', (int)offset, (boolean)false, (int)4, null) + 1) != 0 && (end = StringsKt.indexOf$default((CharSequence)contents, (String)"</string>", (int)next, (boolean)false, (int)4, null)) != -1) {
            String span;
            Intrinsics.checkNotNullExpressionValue((Object)contents.substring(next, end), (String)"substring(...)");
            if (!(StringsKt.contains$default((CharSequence)span, (CharSequence)"<![CDATA[", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)span)).toString(), (String)"@", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)span, (CharSequence)"<", (boolean)false, (int)2, null))) {
                edits.add(new Edit(next, next, "<![CDATA[", false, 0, 16, null));
                edits.add(new Edit(end, end, "]]>", true, 0, 16, null));
            }
            offset = end;
        }
        return edits;
    }

    @Override
    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)message, (String)"<![CDATA[", (String)"", (boolean)false, (int)4, null), (String)"]]>", (String)"", (boolean)false, (int)4, null);
    }

    private final File findRes(File projectDir) {
        File res = new File(projectDir, "res");
        if (!res.exists()) {
            res = new File(projectDir, "src/main/res");
        }
        if (!res.exists()) {
            return null;
        }
        return res;
    }
}

