/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/infrastructure/BodyRemovalTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "lint-tests"})
public final class BodyRemovalTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        Kotlin offers expression bodies\n        for methods, where instead of declaring a normal method body with\n        a return statement, you simply assign the method to the return\n        expression's operand. This makes the AST slightly different, and\n        in particular there is no `UReturnExpression`, so detectors which\n        are assuming they can just visit return expressions to find the\n        exit values would not work correctly.\n\n        This test mode replaces all eligible method bodies with expression\n        bodies and makes sure the test results remain the same.\n\n        In the unlikely event that your lint check is actually doing something\n        expression body specific, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public BodyRemovalTestMode() {
        super("Body Removal", "TestMode.BODY_REMOVAL", "body-removal");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        List edits = new ArrayList();
        Set seen = new LinkedHashSet();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new UastSourceTransformationTestMode.EditVisitor(seen, edits, source2){
            final /* synthetic */ Set<PsiElement> $seen;
            final /* synthetic */ List<Edit> $edits;
            final /* synthetic */ String $source;
            {
                this.$seen = $seen;
                this.$edits = $edits;
                this.$source = $source;
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkIfExpression(node);
                return super.visitIfExpression(node);
            }

            private final void checkIfExpression(UIfExpression node) {
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement sourcePsi = psiElement;
                if (!this.$seen.add(sourcePsi)) {
                    return;
                }
                if (!node.isTernary() && !UastLintUtilsKt.isElvisIf((UIfExpression)node)) {
                    UExpression elseExpression;
                    this.toggleBraces(node.getThenExpression());
                    UExpression uExpression = node.getElseExpression();
                    Object object = elseExpression = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                    if (elseExpression != null && !(elseExpression instanceof UIfExpression)) {
                        this.toggleBraces(node.getElseExpression());
                    }
                }
            }

            private final void toggleBraces(UExpression node) {
                PsiElement next;
                PsiElement begin;
                if (node == null) {
                    return;
                }
                if (node instanceof UBlockExpression) {
                    List statements = ((UBlockExpression)node).getExpressions();
                    if (statements.size() == 1) {
                        UExpression statement = (UExpression)statements.get(0);
                        if (statement instanceof UDeclarationsExpression) {
                            return;
                        }
                        if (statement instanceof UIfExpression && ((UIfExpression)statement).getElseExpression() == null) {
                            return;
                        }
                        this.unsurround(this.$edits, node, node, "{", "}", this.$source);
                    }
                    return;
                }
                PsiElement end = begin = node.getSourcePsi();
                PsiElement psiElement = node.getSourcePsi();
                Object object = next = psiElement != null ? psiElement.getNextSibling() : null;
                if (next instanceof PsiJavaToken && Intrinsics.areEqual((Object)((PsiJavaToken)next).getTokenType(), (Object)JavaTokenType.SEMICOLON)) {
                    end = next;
                } else if (next instanceof PsiWhiteSpace && (next = ((PsiWhiteSpace)next).getNextSibling()) instanceof PsiJavaToken && Intrinsics.areEqual((Object)((PsiJavaToken)next).getTokenType(), (Object)JavaTokenType.SEMICOLON)) {
                    end = next;
                }
                this.surround(this.$edits, begin, end, "{ ", " }");
            }

            public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkReturnExpression(node);
                return super.visitReturnExpression(node);
            }

            private final void checkReturnExpression(UReturnExpression node) {
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement sourcePsi = psiElement;
                if (!this.$seen.add(sourcePsi)) {
                    return;
                }
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                if (parent instanceof UBlockExpression && Lint.isKotlin((Language)node.getLang())) {
                    String type;
                    int count = ((UBlockExpression)parent).getExpressions().size();
                    if (count != 1) {
                        return;
                    }
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)((UBlockExpression)parent).getUastParent());
                    UMethod uMethod = uElement instanceof UMethod ? (UMethod)uElement : null;
                    if (uMethod == null) {
                        return;
                    }
                    UMethod method = uMethod;
                    PsiType psiType = method.getReturnType();
                    String string = type = psiType != null ? psiType.getCanonicalText() : null;
                    if (type != null && !Intrinsics.areEqual((Object)type, (Object)"void")) {
                        TextRange returnExpressionRange;
                        TextRange blockRange = UastUtils.getTextRange((UElement)parent);
                        UExpression uExpression = node.getReturnExpression();
                        Object object = returnExpressionRange = uExpression != null ? UastUtils.getTextRange((UElement)((UElement)uExpression)) : null;
                        if (blockRange != null && returnExpressionRange != null) {
                            int blockStart = blockRange.getStartOffset();
                            int expressionStart = returnExpressionRange.getStartOffset();
                            int expressionEnd = returnExpressionRange.getEndOffset();
                            int blockEnd = blockRange.getEndOffset();
                            int openBrace = StringsKt.indexOf$default((CharSequence)this.$source, (char)'{', (int)blockStart, (boolean)false, (int)4, null);
                            int returnStart = StringsKt.lastIndexOf$default((CharSequence)this.$source, (String)"return", (int)expressionStart, (boolean)false, (int)4, null);
                            int closeBrace = StringsKt.indexOf$default((CharSequence)this.$source, (char)'}', (int)expressionEnd, (boolean)false, (int)4, null);
                            boolean bl = blockStart <= openBrace ? openBrace < expressionStart : false;
                            if (bl && returnStart >= openBrace) {
                                boolean bl2 = expressionEnd <= closeBrace ? closeBrace < blockEnd : false;
                                if (bl2) {
                                    int returnEnd = returnStart + 6;
                                    if (this.$source.charAt(returnEnd) == ' ') {
                                        ++returnEnd;
                                    }
                                    this.$edits.add(UastSourceTransformationTestMode.EditVisitor.replace$default(this, openBrace, openBrace + 1, "=", false, 8, null));
                                    this.$edits.add(UastSourceTransformationTestMode.EditVisitor.remove$default((UastSourceTransformationTestMode.EditVisitor)this, returnStart, returnEnd, false, 4, null));
                                    this.$edits.add(UastSourceTransformationTestMode.EditVisitor.remove$default((UastSourceTransformationTestMode.EditVisitor)this, closeBrace, closeBrace + 1, false, 4, null));
                                }
                            }
                        }
                    }
                }
            }
        }));
        return edits;
    }
}

