/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.LintTestUtils;
import com.android.tools.lint.checks.infrastructure.MergedSourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestModeKt;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nH\u0002J<\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0 H\u0016J:\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00122\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)0(H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestModeGroup;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "modes", "", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "([Lcom/android/tools/lint/checks/infrastructure/TestMode;)V", "folderName", "", "getFolderName", "()Ljava/lang/String;", "", "getModes", "()Ljava/util/List;", "modifiesSources", "", "getModifiesSources", "()Z", "validModes", "", "applies", "context", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "partition", "Lcom/android/tools/lint/checks/infrastructure/SourceTransformationTestMode;", "testContext", "contexts", "Lcom/android/tools/lint/detector/api/JavaContext;", "processTestFiles", "projectDir", "Ljava/io/File;", "sdkHome", "changeCallback", "Lkotlin/Function2;", "", "transform", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nUastSourceTransformationTestModeGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastSourceTransformationTestModeGroup.kt\ncom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestModeGroup\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n11383#2,9:185\n13309#2:194\n13310#2:196\n11392#2:197\n1#3:195\n800#4,11:198\n1855#4,2:209\n*S KotlinDebug\n*F\n+ 1 UastSourceTransformationTestModeGroup.kt\ncom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestModeGroup\n*L\n51#1:185,9\n51#1:194\n51#1:196\n51#1:197\n51#1:195\n57#1:198,11\n57#1:209,2\n*E\n"})
public final class UastSourceTransformationTestModeGroup
extends UastSourceTransformationTestMode {
    @NotNull
    private final List<TestMode> modes;
    @NotNull
    private final List<UastSourceTransformationTestMode> validModes;
    @NotNull
    private final String folderName;
    private final boolean modifiesSources;

    /*
     * WARNING - void declaration
     */
    public UastSourceTransformationTestModeGroup(TestMode ... modes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        super("Source code transformations", "TestMode.SOURCE_CODE_TRANSFORMATIONS", "default");
        this.modes = ArraysKt.toList((Object[])modes);
        TestMode[] testModeArray = modes;
        UastSourceTransformationTestModeGroup uastSourceTransformationTestModeGroup = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            UastSourceTransformationTestMode it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof UastSourceTransformationTestMode ? (UastSourceTransformationTestMode)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        uastSourceTransformationTestModeGroup.validModes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.folderName = "default";
        this.modifiesSources = true;
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        throw new IllegalStateException();
    }

    @NotNull
    public final List<TestMode> getModes() {
        return this.modes;
    }

    @Override
    @NotNull
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public boolean getModifiesSources() {
        return this.modifiesSources;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean applies(@NotNull TestMode.TestModeContext context) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.validModes.clear();
        Iterable $this$filterIsInstance$iv = this.modes;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UastSourceTransformationTestMode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UastSourceTransformationTestMode it = (UastSourceTransformationTestMode)element$iv;
            boolean bl = false;
            if (!it.applies(context)) continue;
            this.validModes.add(it);
        }
        return !((Collection)this.validModes).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TestMode> partition(@NotNull TestMode.TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair pair = LintTestUtils.parse$default((File)CollectionsKt.first(context.getProjectFolders()), null, null, false, context.getTask().sdkHome, false, null, null, 238, null);
        List contexts2 = (List)pair.component1();
        Disposable disposable2 = (Disposable)pair.component2();
        try {
            List<TestMode> list2 = this.partition(context, contexts2);
            return list2;
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private final List<SourceTransformationTestMode> partition(TestMode.TestModeContext testContext, List<? extends JavaContext> contexts2) {
        List currentModes = new ArrayList();
        Map currentEditMap = null;
        currentEditMap = new LinkedHashMap();
        MergedSourceTransformationTestMode current = new MergedSourceTransformationTestMode(currentModes, currentEditMap);
        List partitions = new ArrayList();
        Map contents = new LinkedHashMap();
        File rootDir = testContext.getRootDir();
        block0: for (UastSourceTransformationTestMode mode : this.validModes) {
            File file;
            List edits;
            if (testContext.getTask().ignoredTestModes.contains(mode)) continue;
            Map pending = new LinkedHashMap();
            Map clientData = new LinkedHashMap();
            for (JavaContext bl : contexts2) {
                UFile uFile;
                if (bl.getUastFile() == null) continue;
                String source2 = uFile.getSourcePsi().getText();
                File relativePath = FilesKt.relativeTo((File)bl.file, (File)rootDir);
                Intrinsics.checkNotNull((Object)source2);
                contents.put(relativePath, source2);
                List<Edit> edits2 = mode.transform(source2, bl, uFile, clientData, testContext);
                if (!(!((Collection)edits2).isEmpty())) continue;
                CollectionsKt.sort(edits2);
                if (!SourceTransformationTestModeKt.ensureConflictFree(mode, bl, edits2)) continue block0;
                pending.put(relativePath, edits2);
            }
            if (pending.isEmpty()) continue;
            boolean conflict = false;
            for (Map.Entry entry : pending.entrySet()) {
                Pair pair;
                List currentEdits;
                File file2 = (File)entry.getKey();
                edits = (List)entry.getValue();
                Pair pair2 = (Pair)currentEditMap.get(file2);
                if (pair2 == null) {
                    Pair pair3;
                    Object v = contents.get(file2);
                    Intrinsics.checkNotNull(v);
                    Pair it = pair3 = new Pair(v, (Object)new ArrayList());
                    boolean bl = false;
                    currentEditMap.put(file2, it);
                    pair2 = pair3;
                }
                if (!Edit.Companion.conflicts(currentEdits = (List)(pair = pair2).getSecond(), edits)) continue;
                conflict = true;
                break;
            }
            if (conflict) {
                boolean bl;
                boolean bl2 = bl = !((Collection)currentModes).isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                partitions.add(current);
                currentModes = new ArrayList();
                currentEditMap = new LinkedHashMap();
                current = new MergedSourceTransformationTestMode(currentModes, currentEditMap);
                Iterator iterator = pending.entrySet().iterator();
                while (iterator.hasNext()) {
                    file = (File)iterator.next().getKey();
                    Object v = contents.get(file);
                    Intrinsics.checkNotNull(v);
                    currentEditMap.put(file, new Pair(v, (Object)new ArrayList()));
                }
            }
            for (Map.Entry entry : pending.entrySet()) {
                file = (File)entry.getKey();
                edits = (List)entry.getValue();
                Object object = (Pair)currentEditMap.get(file);
                if (object == null || (object = (List)object.getSecond()) == null) continue;
                object.addAll(edits);
            }
            currentModes.add(mode);
        }
        if (!((Collection)currentModes).isEmpty()) {
            partitions.add(current);
        }
        Map files2 = new LinkedHashMap();
        for (MergedSourceTransformationTestMode mode : partitions) {
            Map<File, Pair<String, List<Edit>>> edits = mode.getEdits$lint_tests();
            for (Map.Entry entry : files2.entrySet()) {
                File file = (File)entry.getKey();
                String original = (String)entry.getValue();
                if (edits.containsKey(file)) continue;
                edits.put(file, (Pair<String, List<Edit>>)new Pair((Object)original, (Object)new ArrayList()));
            }
            for (Map.Entry entry : edits.entrySet()) {
                File file = (File)entry.getKey();
                Pair pair = (Pair)entry.getValue();
                if (files2.containsKey(file)) continue;
                files2.put(file, pair.getFirst());
            }
        }
        return partitions;
    }

    @Override
    public boolean processTestFiles(@NotNull TestMode.TestModeContext testContext, @NotNull File projectDir, @Nullable File sdkHome, @NotNull Function2<? super JavaContext, ? super String, Unit> changeCallback) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(changeCallback, (String)"changeCallback");
        throw new IllegalStateException("Should not be called".toString());
    }
}

