/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.SdkConstants;
import com.android.tools.lint.checks.infrastructure.MergedSourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.ProjectDescriptionList;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintResult;
import com.android.tools.lint.checks.infrastructure.TestLintRunner;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultState;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Files;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.xml.sax.SAXException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001QB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010\"\u001a\u00020\u00172\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bH\u0002J.\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0-2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020-H\u0002J\u0006\u00103\u001a\u00020*J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c0-2\u0006\u0010+\u001a\u00020\u001c2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002060-2\u0006\u00107\u001a\u00020\u0006J2\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a0-2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u000b2\u0006\u00109\u001a\u00020%H\u0002JD\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0-0;2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u001c2\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0-0=H\u0002J\u001c\u0010>\u001a\u00020\u000b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0$H\u0002J\b\u0010?\u001a\u00020@H\u0007J\u0016\u0010A\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u001fH\u0002J\u0016\u0010F\u001a\u00020G*\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u000bH\u0002J\u0086\u0001\u0010H\u001a\u00020\u0017*\u00020\u00032\u0006\u0010&\u001a\u00020\u000b2\u0016\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u000b0Jj\b\u0012\u0004\u0012\u00020\u000b`K2\u0006\u0010+\u001a\u00020\u001c2\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0-0=2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0=2\u0006\u0010L\u001a\u00020\u001c2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0-2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0-H\u0002Jl\u0010H\u001a\u00020\u0017*\u00020\u00032\u0006\u0010&\u001a\u00020\u000b2\u0016\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u000b0Jj\b\u0012\u0004\u0012\u00020\u000b`K2\u0006\u0010+\u001a\u00020\u001c2\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0-0=2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0=2\b\b\u0002\u0010O\u001a\u00020\u0006H\u0002J\f\u0010P\u001a\u00020\u0017*\u00020\u0003H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestLintRunner;", "", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;)V", "<set-?>", "", "alreadyRun", "getAlreadyRun", "()Z", "currentTestMode", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "getCurrentTestMode", "()Lcom/android/tools/lint/checks/infrastructure/TestMode;", "setCurrentTestMode", "(Lcom/android/tools/lint/checks/infrastructure/TestMode;)V", "firstThrowable", "", "getFirstThrowable", "()Ljava/lang/Throwable;", "setFirstThrowable", "(Ljava/lang/Throwable;)V", "addChangedFiles", "", "changed", "", "Lcom/android/tools/lint/checks/infrastructure/TestLintRunner$ChangedFile;", "dir1", "Ljava/io/File;", "dir2", "path", "", "depth", "", "checkConsistentOutput", "results", "", "Lcom/android/tools/lint/checks/infrastructure/TestResultState;", "mode", "first", "checkLint", "client", "Lcom/android/tools/lint/checks/infrastructure/TestLintClient;", "rootDir", "files", "", "computePlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "issues", "Lcom/android/tools/lint/detector/api/Issue;", "createClient", "createProjects", "testMode", "Lcom/android/tools/lint/detector/api/Project;", "keepFiles", "getModifications", "resultState", "getTestModeFiles", "Lkotlin/Pair;", "projectMap", "", "pickDefaultMode", "run", "Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "stripRoot", "validateJson", "json", "validateXml", "xml", "getProjectList", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescriptionList;", "runMode", "notApplicable", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "root", "projectList", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "forceCleanDir", "validateInputs", "ChangedFile", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTestLintRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestLintRunner.kt\ncom/android/tools/lint/checks/infrastructure/TestLintRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,772:1\n1#2:773\n1284#3,3:774\n288#4,2:777\n1855#4:779\n1856#4:782\n13309#5,2:780\n*S KotlinDebug\n*F\n+ 1 TestLintRunner.kt\ncom/android/tools/lint/checks/infrastructure/TestLintRunner\n*L\n170#1:774,3\n581#1:777,2\n700#1:779\n700#1:782\n701#1:780,2\n*E\n"})
public final class TestLintRunner {
    @NotNull
    private final TestLintTask task;
    private boolean alreadyRun;
    @Nullable
    private Throwable firstThrowable;
    @NotNull
    private TestMode currentTestMode;

    public TestLintRunner(@NotNull TestLintTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        this.currentTestMode = TestMode.DEFAULT;
    }

    public final boolean getAlreadyRun() {
        return this.alreadyRun;
    }

    @Nullable
    public final Throwable getFirstThrowable() {
        return this.firstThrowable;
    }

    public final void setFirstThrowable(@Nullable Throwable throwable) {
        this.firstThrowable = throwable;
    }

    private final EnumSet<Platform> computePlatforms(List<Issue> issues) {
        EnumSet<Platform> platforms2 = EnumSet.noneOf(Platform.class);
        for (Issue issue : issues) {
            platforms2.addAll(issue.getPlatforms());
        }
        Intrinsics.checkNotNull(platforms2);
        return platforms2;
    }

    @NotNull
    public final TestMode getCurrentTestMode() {
        return this.currentTestMode;
    }

    public final void setCurrentTestMode(@NotNull TestMode testMode) {
        Intrinsics.checkNotNullParameter((Object)testMode, (String)"<set-?>");
        this.currentTestMode = testMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CheckReturnValue
    @NotNull
    public final TestLintResult run() {
        TestLintResult testLintResult;
        File file;
        this.alreadyRun = true;
        TestLintTask $this$run_u24lambda_u243 = this.task;
        boolean bl = false;
        $this$run_u24lambda_u243.ensureConfigured();
        this.validateInputs($this$run_u24lambda_u243);
        File it = $this$run_u24lambda_u243.rootDirectory != null ? $this$run_u24lambda_u243.rootDirectory : ($this$run_u24lambda_u243.testName != null ? new File($this$run_u24lambda_u243.tempDir, $this$run_u24lambda_u243.testName) : $this$run_u24lambda_u243.tempDir);
        boolean bl2 = false;
        try {
            file = it.getCanonicalFile();
        }
        catch (IOException ignore) {
            file = it;
        }
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"let(...)");
        File rootDir = file2;
        ConfigurationHierarchy.Companion.setDefaultRootDir(rootDir);
        if ($this$run_u24lambda_u243.platforms == null) {
            List<Issue> list2 = $this$run_u24lambda_u243.getCheckedIssues();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getCheckedIssues(...)");
            $this$run_u24lambda_u243.platforms = this.computePlatforms(list2);
        }
        if ($this$run_u24lambda_u243.projects.getImplicitReportFrom() != null && $this$run_u24lambda_u243.platforms.contains(Platform.JDK) && !$this$run_u24lambda_u243.platforms.contains(Platform.ANDROID)) {
            for (ProjectDescription project : $this$run_u24lambda_u243.projects) {
                project.setType(ProjectDescription.Type.JAVA);
            }
        }
        ProjectDescriptionList projectDescriptionList = $this$run_u24lambda_u243.projects;
        ProjectDescription.Type type = $this$run_u24lambda_u243.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"getDefaultType(...)");
        projectDescriptionList.expandProjects(type);
        $this$run_u24lambda_u243.projects.addProject($this$run_u24lambda_u243.reportFrom);
        Map projectMap = new HashMap();
        Map results = new LinkedHashMap();
        HashSet notApplicable = new HashSet();
        try {
            for (TestMode mode : this.task.testModes) {
                Intrinsics.checkNotNull((Object)mode);
                TestLintRunner.runMode$default(this, $this$run_u24lambda_u243, mode, notApplicable, rootDir, projectMap, results, false, 32, null);
            }
            for (TestMode mode : notApplicable) {
                Map ignore = results;
                Intrinsics.checkNotNull((Object)mode);
                TestMode testMode = mode;
                TestResultState testResultState = new TestResultState(this.createClient(), rootDir, "No output because the configured test mode " + mode + " is not applicable in this project context", CollectionsKt.emptyList(), null);
                TestResultState $this$run_u24lambda_u243_u24lambda_u241 = testResultState;
                boolean bl3 = false;
                $this$run_u24lambda_u243_u24lambda_u241.skipped = true;
                ignore.put(testMode, testResultState);
            }
            TestMode defaultMode = this.pickDefaultMode(results);
            testLintResult = new TestLintResult($this$run_u24lambda_u243, results, defaultMode);
        }
        catch (Throwable e2) {
            try {
                TestLintClient testLintClient = this.createClient();
                String string = e2.getMessage();
                if (string == null) {
                    string = "";
                }
                TestResultState state = new TestResultState(testLintClient, rootDir, string, CollectionsKt.emptyList(), e2);
                TestMode defaultType = this.currentTestMode;
                results.put(defaultType, state);
                testLintResult = new TestLintResult($this$run_u24lambda_u243, results, defaultType);
            }
            catch (Throwable throwable) {
                if (SdkConstants.currentPlatform() == 2) {
                    void $this$fold$iv;
                    File file3 = $this$run_u24lambda_u243.tempDir;
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"tempDir");
                    Sequence initial$iv = (Sequence)FilesKt.walkBottomUp((File)file3);
                    boolean initial$iv2 = true;
                    boolean $i$f$fold = false;
                    boolean accumulator$iv = initial$iv2;
                    for (Object element$iv : $this$fold$iv) {
                        void it2;
                        File result = (File)element$iv;
                        boolean result2 = accumulator$iv;
                        boolean bl4 = false;
                        String string = it2.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        accumulator$iv = !StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null) && (it2.delete() || !it2.exists()) && result2;
                    }
                } else {
                    File file4 = $this$run_u24lambda_u243.tempDir;
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"tempDir");
                    FilesKt.deleteRecursively((File)file4);
                }
                throw throwable;
            }
            if (SdkConstants.currentPlatform() == 2) {
                void $this$fold$iv;
                File file5 = $this$run_u24lambda_u243.tempDir;
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"tempDir");
                Sequence e2 = (Sequence)FilesKt.walkBottomUp((File)file5);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    File it3 = (File)element$iv;
                    boolean result = accumulator$iv;
                    boolean bl5 = false;
                    String string = it3.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    accumulator$iv = !StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null) && (it3.delete() || !it3.exists()) && result;
                }
            } else {
                File file6 = $this$run_u24lambda_u243.tempDir;
                Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"tempDir");
                FilesKt.deleteRecursively((File)file6);
            }
        }
        if (SdkConstants.currentPlatform() == 2) {
            void $this$fold$iv;
            TestMode mode;
            File file7 = $this$run_u24lambda_u243.tempDir;
            Intrinsics.checkNotNullExpressionValue((Object)file7, (String)"tempDir");
            mode = (Sequence)FilesKt.walkBottomUp((File)file7);
            boolean initial$iv = true;
            boolean $i$f$fold = false;
            boolean accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void it3;
                File file8 = (File)element$iv;
                boolean result = accumulator$iv;
                boolean bl6 = false;
                String string = it3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                accumulator$iv = !StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null) && (it3.delete() || !it3.exists()) && result;
            }
        } else {
            File file9 = $this$run_u24lambda_u243.tempDir;
            Intrinsics.checkNotNullExpressionValue((Object)file9, (String)"tempDir");
            FilesKt.deleteRecursively((File)file9);
        }
        return testLintResult;
    }

    private final Pair<File, List<File>> getTestModeFiles(TestMode mode, File rootDir, Map<String, List<File>> projectMap) {
        String folderName2 = mode.getFolderName();
        File root = new File(rootDir, folderName2);
        List<File> files2 = projectMap.get(folderName2);
        if (files2 == null) {
            files2 = this.createProjects(root, mode);
            if (TestLintTask.duplicateFinder != null && this.task.testName != null) {
                String string = this.task.testName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testName");
                TestLintTask.duplicateFinder.recordTestProject(string, this.task, mode, files2);
            }
            projectMap.put(folderName2, files2);
        }
        return new Pair((Object)root, files2);
    }

    private final void runMode(TestLintTask $this$runMode, TestMode mode, HashSet<TestMode> notApplicable, File rootDir, Map<String, List<File>> projectMap, Map<TestMode, TestResultState> results, boolean forceCleanDir) {
        List<TestMode> partitions;
        Object object;
        List files2;
        File root;
        List<ProjectDescription> projectList;
        block8: {
            block7: {
                this.currentTestMode = mode;
                this.firstThrowable = null;
                projectList = $this$runMode.projects.getProjects();
                if (!mode.applies(new TestMode.TestModeContext($this$runMode, rootDir, projectList, CollectionsKt.emptyList(), null, null, null, results, 96, null))) {
                    notApplicable.add(mode);
                    return;
                }
                Pair<File, List<File>> pair = this.getTestModeFiles(mode, rootDir, projectMap);
                root = (File)pair.component1();
                files2 = (List)pair.component2();
                object = results.get(TestMode.DEFAULT);
                if (object == null) break block7;
                TestResultState it = object;
                boolean bl = false;
                TestMode.TestModeContext state = new TestMode.TestModeContext($this$runMode, root, projectList, files2, null, null, null, results, 96, null);
                List<TestMode> list2 = mode.partition(state);
                object = list2;
                if (list2 != null) break block8;
            }
            object = CollectionsKt.listOf((Object)mode);
        }
        if ((partitions = object).size() == 1 && Intrinsics.areEqual(partitions.get(0), (Object)mode)) {
            this.runMode($this$runMode, mode, notApplicable, rootDir, projectMap, results, root, projectList, files2);
        } else {
            for (TestMode nestedMode : partitions) {
                this.runMode($this$runMode, nestedMode, notApplicable, rootDir, projectMap, results, forceCleanDir);
            }
        }
    }

    static /* synthetic */ void runMode$default(TestLintRunner testLintRunner, TestLintTask testLintTask, TestMode testMode, HashSet hashSet, File file, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        testLintRunner.runMode(testLintTask, testMode, hashSet, file, map, map2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runMode(TestLintTask $this$runMode, TestMode mode, HashSet<TestMode> notApplicable, File rootDir, Map<String, List<File>> projectMap, Map<TestMode, TestResultState> results, File root, List<ProjectDescription> projectList, List<? extends File> files2) {
        block12: {
            TestMode.TestModeContext beforeState = new TestMode.TestModeContext($this$runMode, root, projectList, files2, null, null, null, results, 96, null);
            Object clientState = mode.before(beforeState);
            if (clientState == TestMode.Companion.getCANCEL()) {
                return;
            }
            LintListener listener = null;
            try {
                TestLintClient lintClient = this.createClient();
                Function3<TestMode.TestModeContext, LintListener.EventType, Object, Unit> function3 = mode.getEventListener();
                if (function3 != null) {
                    Function3<TestMode.TestModeContext, LintListener.EventType, Object, Unit> it = function3;
                    boolean bl = false;
                    listener = new LintListener(this, root, projectList, files2, clientState, results, it){
                        final /* synthetic */ TestLintRunner this$0;
                        final /* synthetic */ File $root;
                        final /* synthetic */ List<ProjectDescription> $projectList;
                        final /* synthetic */ List<File> $files;
                        final /* synthetic */ Object $clientState;
                        final /* synthetic */ Map<TestMode, TestResultState> $results;
                        final /* synthetic */ Function3<TestMode.TestModeContext, LintListener.EventType, Object, Unit> $it;
                        {
                            this.this$0 = $receiver;
                            this.$root = $root;
                            this.$projectList = $projectList;
                            this.$files = $files;
                            this.$clientState = $clientState;
                            this.$results = $results;
                            this.$it = $it;
                        }

                        public void update(@NotNull LintDriver driver, @NotNull LintListener.EventType type, @Nullable Project project, @Nullable Context context) {
                            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                            TestMode.TestModeContext testContext = new TestMode.TestModeContext(TestLintRunner.access$getTask$p(this.this$0), this.$root, this.$projectList, this.$files, this.$clientState, driver, context, this.$results);
                            this.$it.invoke((Object)testContext, (Object)type, this.$clientState);
                        }
                    };
                    $this$runMode.listeners.add(listener);
                }
                TestResultState testResult = this.checkLint(lintClient, root, files2, mode);
                results.put(mode, testResult);
                if ($this$runMode.projectInspector != null) {
                    Collection knownProjects = lintClient.getKnownProjects();
                    List projects = new ArrayList(knownProjects);
                    LintDriver driver = lintClient.getDriver();
                    Iterable iterable = projects;
                    Comparator comparator2 = Comparator.comparing(runMode.2.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
                    CollectionsKt.sortedWith((Iterable)iterable, comparator2);
                    $this$runMode.projectInspector.inspect(driver, projects);
                }
                if (!$this$runMode.testModesIdenticalOutput) break block12;
                if (mode instanceof MergedSourceTransformationTestMode && ((MergedSourceTransformationTestMode)mode).getModes$lint_tests().size() > 1) {
                    try {
                        Collection<TestMode> collection = $this$runMode.testModes;
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"testModes");
                        Object object = CollectionsKt.first((Iterable)collection);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                        this.checkConsistentOutput(results, (TestMode)object, mode);
                        for (TestMode nestedMode : ((MergedSourceTransformationTestMode)mode).getModes$lint_tests()) {
                            results.put(nestedMode, testResult);
                        }
                        break block12;
                    }
                    catch (Throwable exception) {
                        for (TestMode nestedMode : ((MergedSourceTransformationTestMode)mode).getModes$lint_tests()) {
                            this.runMode($this$runMode, nestedMode, notApplicable, rootDir, projectMap, results, true);
                        }
                        break block12;
                    }
                }
                Collection<TestMode> collection = $this$runMode.testModes;
                Intrinsics.checkNotNullExpressionValue(collection, (String)"testModes");
                Object object = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                this.checkConsistentOutput(results, mode, (TestMode)object);
            }
            finally {
                TestMode.TestModeContext afterState = new TestMode.TestModeContext($this$runMode, root, projectList, files2, clientState, null, null, results, 96, null);
                mode.after(afterState);
                if (listener != null) {
                    $this$runMode.listeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TestResultState checkLint(TestLintClient client2, File rootDir, List<? extends File> files2, TestMode mode) {
        TestResultState testResultState;
        client2.addCleanupDir(rootDir);
        client2.setLintTask(this.task);
        try {
            TestLintTask.OptionSetter optionSetter = this.task.optionSetter;
            if (optionSetter != null) {
                optionSetter.set(client2.getFlags());
            }
            testResultState = client2.checkLint(rootDir, files2, this.task.getCheckedIssues(), mode);
            Intrinsics.checkNotNull((Object)testResultState);
        }
        finally {
            client2.setLintTask(null);
        }
        return testResultState;
    }

    private final TestMode pickDefaultMode(Map<TestMode, ? extends TestResultState> results) {
        for (TestMode mode : TestMode.Companion.values()) {
            if (!results.containsKey(mode)) continue;
            return mode;
        }
        Collection<TestMode> collection = this.task.testModes;
        Intrinsics.checkNotNullExpressionValue(collection, (String)"testModes");
        TestMode testMode = (TestMode)CollectionsKt.firstOrNull((Iterable)collection);
        if (testMode == null) {
            throw new RuntimeException("Invalid testModes configuration: " + this.task.testModes + " and " + results);
        }
        return testMode;
    }

    private final void checkConsistentOutput(Map<TestMode, ? extends TestResultState> results, TestMode mode, TestMode first) {
        Object expected;
        if (Intrinsics.areEqual((Object)mode, (Object)first)) {
            return;
        }
        TestResultState testResultState = results.get(mode);
        if (testResultState == null) {
            return;
        }
        TestResultState resultState = testResultState;
        String string = resultState.output;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output");
        String actual = string;
        Object object = results.get(first);
        if (object == null || (object = ((TestResultState)object).output) == null) {
            object = "";
        }
        if (!mode.sameOutput((String)(expected = object), actual, TestMode.OutputKind.REPORT)) {
            List<ChangedFile> modifications;
            String message;
            String string2;
            String line2 = StringsKt.repeat((CharSequence)"-", (int)70);
            String expectedLabel = first.getDescription() + "\n\n" + line2 + "\n\n";
            String actualLabel = mode.getDescription() + "\n(To run in isolation, change .run() to .testModes(" + mode.getFieldName() + ").run())\n" + line2 + "\n\n";
            if (Intrinsics.areEqual((Object)mode, (Object)TestMode.SUPPRESSIBLE)) {
                actualLabel = ((Object)StringsKt.trimEnd((CharSequence)actualLabel)).toString() + "\n(Expected all of these warnings to disappear, not to equal the left hand side,\nbecause suppress annotations have been inserted.\n\n";
            }
            if ((string2 = mode.getDiffExplanation()) == null) {
                string2 = message = StringsKt.trimIndent((String)("\n                The lint output was different between the test types\n                " + first + " and " + mode + ".\n\n                If this difference is expected, you can set the\n                eventType() set to include only one of these two.\n                "));
            }
            if (!((Collection)(modifications = this.getModifications(results, mode, resultState))).isEmpty()) {
                String originalFiles2 = CollectionsKt.joinToString$default((Iterable)modifications, (CharSequence)"\n", null, null, (int)0, null, (Function1)checkConsistentOutput.originalFiles.1.INSTANCE, (int)30, null);
                String modifiedFiles2 = CollectionsKt.joinToString$default((Iterable)modifications, (CharSequence)"\n", null, null, (int)0, null, (Function1)checkConsistentOutput.modifiedFiles.1.INSTANCE, (int)30, null);
                Assert.assertEquals((String)message, (Object)(expectedLabel + (String)expected + originalFiles2), (Object)(actualLabel + actual + modifiedFiles2));
            } else {
                Assert.assertEquals((String)message, (Object)(expectedLabel + (String)expected), (Object)(actualLabel + actual));
            }
        }
    }

    private final List<ChangedFile> getModifications(Map<TestMode, ? extends TestResultState> results, TestMode mode, TestResultState resultState) {
        List changedFiles = new ArrayList();
        TestResultState defaultState = results.get(TestMode.DEFAULT);
        if (mode.getModifiesSources() && !Intrinsics.areEqual((Object)mode, (Object)TestMode.DEFAULT) && defaultState != null) {
            File file = defaultState.rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            File originalDir = file;
            File file2 = resultState.rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"rootDir");
            File modifiedDir = file2;
            this.addChangedFiles(changedFiles, originalDir, modifiedDir, "", 0);
        }
        return changedFiles;
    }

    private final void addChangedFiles(List<ChangedFile> changed, File dir1, File dir2, String path, int depth) {
        File[] fileArray = dir1.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file1 : fileArray) {
            String name = file1.getName();
            String fullPath = ((CharSequence)path).length() == 0 ? name : path + "/" + name;
            File file2 = new File(dir2, name);
            if (file1.isDirectory()) {
                if (depth == 1 && (Intrinsics.areEqual((Object)name, (Object)"libs") || Intrinsics.areEqual((Object)name, (Object)"bin"))) continue;
                Intrinsics.checkNotNull((Object)file1);
                Intrinsics.checkNotNull((Object)fullPath);
                this.addChangedFiles(changed, file1, file2, fullPath, depth + 1);
                continue;
            }
            if (!file1.isFile() || !file2.isFile()) continue;
            Intrinsics.checkNotNull((Object)name);
            if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".kotlin_module", (boolean)false, (int)2, null) || SdkUtils.isBitmapFile((File)file1)) continue;
            Intrinsics.checkNotNull((Object)file1);
            String contents1 = FilesKt.readText$default((File)file1, null, (int)1, null);
            String contents2 = FilesKt.readText$default((File)file2, null, (int)1, null);
            if (Intrinsics.areEqual((Object)contents1, (Object)contents2)) continue;
            Intrinsics.checkNotNull((Object)fullPath);
            changed.add(new ChangedFile(fullPath, contents1, contents2));
        }
    }

    @NotNull
    public final String stripRoot(@NotNull File rootDir, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String s = path;
        String rootPath = rootDir.getPath();
        CharSequence charSequence = s;
        String string = rootPath;
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
            string = rootPath;
            Intrinsics.checkNotNull((Object)string);
            s = StringsKt.replace$default((String)s, (String)string, (String)"TESTROOT", (boolean)false, (int)4, null);
        }
        string = rootPath;
        Intrinsics.checkNotNull((Object)string);
        rootPath = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        CharSequence charSequence2 = s;
        string = rootPath;
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string, (boolean)false, (int)2, null)) {
            s = StringsKt.replace$default((String)s, (String)("file:///" + rootPath), (String)"file://TESTROOT", (boolean)false, (int)4, null);
            string = rootPath;
            Intrinsics.checkNotNull((Object)string);
            s = StringsKt.replace$default((String)s, (String)string, (String)"TESTROOT", (boolean)false, (int)4, null);
        }
        if (this.task.stripRoot && StringsKt.contains$default((CharSequence)s, (CharSequence)"TESTROOT", (boolean)false, (int)2, null)) {
            s = StringsKt.replace$default((String)StringsKt.replace$default((String)s, (String)"TESTROOT/", (String)"", (boolean)false, (int)4, null), (String)"TESTROOT\\", (String)"", (boolean)false, (int)4, null);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TestLintClient createClient() {
        File file;
        ConfigurationHierarchy configurations;
        Object object;
        TestLintClient testLintClient;
        TestLintClient client2 = null;
        TestLintTask $this$createClient_u24lambda_u247 = this.task;
        boolean bl = false;
        if ($this$createClient_u24lambda_u247.clientFactory != null) {
            TestLintClient testLintClient2 = $this$createClient_u24lambda_u247.clientFactory.create();
            Intrinsics.checkNotNull((Object)((Object)testLintClient2));
            testLintClient = testLintClient2;
        } else {
            LintClient.Companion.ensureClientNameInitialized();
            String clientName = LintClient.Companion.getClientName();
            try {
                object = new TestLintClient();
            }
            finally {
                if (!Intrinsics.areEqual((Object)clientName, (Object)"unknown")) {
                    LintClient.Companion.setClientName(clientName);
                }
            }
            testLintClient = client2 = object;
        }
        if (!$this$createClient_u24lambda_u247.useTestConfiguration && $this$createClient_u24lambda_u247.overrideConfigFile != null && (configurations = client2.getConfigurations()).getOverrides() == null) {
            File file2 = $this$createClient_u24lambda_u247.overrideConfigFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"overrideConfigFile");
            Configuration config = (Configuration)LintXmlConfiguration.Companion.create(configurations, file2);
            configurations.addGlobalConfigurations(null, config);
        }
        client2.task = $this$createClient_u24lambda_u247;
        if ($this$createClient_u24lambda_u247.rootDirectory != null) {
            File file3 = $this$createClient_u24lambda_u247.rootDirectory;
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"rootDirectory");
        } else if ($this$createClient_u24lambda_u247.testName != null) {
            file = new File($this$createClient_u24lambda_u247.tempDir, $this$createClient_u24lambda_u247.testName);
        } else {
            File file4 = $this$createClient_u24lambda_u247.tempDir;
            file = file4;
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"tempDir");
        }
        File rootDir = file;
        client2.getPathVariables().add("TEST_ROOT", rootDir, false);
        Object object2 = object = $this$createClient_u24lambda_u247.rootDirectory;
        if (object2 != null) {
            Intrinsics.checkNotNull((Object)object2);
            Object it = object;
            boolean bl2 = false;
            PathVariables.add$default((PathVariables)client2.getPathVariables(), (String)"ROOT", (File)it, (boolean)false, (int)4, null);
        }
        client2.getPathVariables().normalize();
        return client2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Project> createProjects(boolean keepFiles) {
        List list2;
        File rootDir = Files.createTempDir();
        try {
            rootDir = rootDir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = rootDir;
        Intrinsics.checkNotNull((Object)file);
        List projectDirs = TestLintRunner.createProjects$default(this, file, null, 2, null);
        TestLintClient lintClient = this.createClient();
        lintClient.setLintTask(this.task);
        try {
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            List projects = arrayList;
            for (File dir : projectDirs) {
                File file2 = rootDir;
                Intrinsics.checkNotNull((Object)file2);
                projects.add(lintClient.getProject(dir, file2));
            }
            lintClient.initializeProjects(null, projects);
            list2 = projects;
        }
        finally {
            lintClient.setLintTask(null);
            if (!keepFiles) {
                File file3 = rootDir;
                Intrinsics.checkNotNull((Object)file3);
                FilesKt.deleteRecursively((File)file3);
            }
        }
        return list2;
    }

    @JvmOverloads
    @NotNull
    public final List<File> createProjects(@NotNull File rootDir, @Nullable TestMode testMode) {
        ProjectDescription it;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List projectDirs = arrayList;
        TestLintTask $this$createProjects_u24lambda_u2411 = this.task;
        boolean bl = false;
        $this$createProjects_u24lambda_u2411.dirToProjectDescription.clear();
        $this$createProjects_u24lambda_u2411.projectMocks.clear();
        ProjectDescriptionList projects = this.getProjectList($this$createProjects_u24lambda_u2411, testMode);
        projects.assignProjectNames();
        ProjectDescription.Type type = $this$createProjects_u24lambda_u2411.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"getDefaultType(...)");
        projects.expandProjects(type);
        if (this.task.reportFrom == null) {
            ProjectDescription projectDescription = projects.getImplicitReportFrom();
            if (projectDescription != null) {
                it = projectDescription;
                boolean bl2 = false;
                this.task.reportFrom(it);
            }
        }
        if (this.task.reportFrom == null) {
            ProjectDescription app;
            ProjectDescription projectDescription;
            Object v3;
            block24: {
                Iterable $this$firstOrNull$iv = projects;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ProjectDescription it2 = (ProjectDescription)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getType() == ProjectDescription.Type.APP)) continue;
                    v3 = element$iv;
                    break block24;
                }
                v3 = null;
            }
            if ((projectDescription = (ProjectDescription)v3) == null) {
                projectDescription = (ProjectDescription)CollectionsKt.firstOrNull((Iterable)projects);
            }
            ProjectDescription projectDescription2 = app = projectDescription;
            if (projectDescription2 != null) {
                it = projectDescription2;
                boolean bl4 = false;
                this.task.reportFrom(it);
            }
        }
        projects.sort();
        List<ProjectDescription> allProjects = projects.getProjects();
        int primaryCount = 0;
        ProjectDescription app = null;
        for (ProjectDescription project : allProjects) {
            if (project.getPrimary()) {
                ++primaryCount;
            }
            if (project.getType() != ProjectDescription.Type.APP) continue;
            app = project;
        }
        if (primaryCount != 1) {
            if (app == null) {
                app = allProjects.get(allProjects.size() - 1);
            }
            for (ProjectDescription project : allProjects) {
                project.setPrimary(false);
            }
            app.setPrimary(true);
        }
        for (ProjectDescription project : allProjects) {
            try {
                project.ensureUnique();
                File projectDir = ProjectDescription.Companion.getProjectDirectory(project, rootDir);
                Map<File, ProjectDescription> map = $this$createProjects_u24lambda_u2411.dirToProjectDescription;
                Intrinsics.checkNotNullExpressionValue(map, (String)"dirToProjectDescription");
                map.put(projectDir, project);
                if (!projectDir.isDirectory()) {
                    boolean ok = projectDir.mkdirs();
                    Assert.assertTrue((String)("Couldn't create projectDir " + projectDir), (boolean)ok);
                }
                projectDirs.add(projectDir);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        for (ProjectDescription project : allProjects) {
            try {
                Object[] files2 = project.getFiles();
                File projectDir = ProjectDescription.Companion.getProjectDirectory(project, rootDir);
                if (!((Collection)project.getDependsOn()).isEmpty()) {
                    TestFile.PropertyTestFile propertyFile = null;
                    for (TestFile testFile : files2) {
                        if (!(testFile instanceof TestFile.PropertyTestFile)) continue;
                        propertyFile = (TestFile.PropertyTestFile)testFile;
                        break;
                    }
                    if (propertyFile == null) {
                        propertyFile = TestFiles.projectProperties();
                        Object[] objectArray = ObjectArrays.concat((Object[])files2, (Object)propertyFile);
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"concat(...)");
                        files2 = (TestFile[])objectArray;
                    }
                    int index = 1;
                    for (ProjectDescription dependency : project.getDependsOn()) {
                        File file = ProjectDescription.Companion.getProjectDirectory(dependency, rootDir);
                        TestLintClient client2 = new TestLintClient(LintClient.Companion.getClientName());
                        String relative = client2.getRelativePath(projectDir, file);
                        String referenceKey = "android.library.reference." + index++;
                        propertyFile.property(referenceKey, relative);
                    }
                }
                ProjectDescription.Companion.populateProjectDirectory($this$createProjects_u24lambda_u2411, project, projectDir, Arrays.copyOf(files2, files2.length));
                if ($this$createProjects_u24lambda_u2411.baseline != null) {
                    $this$createProjects_u24lambda_u2411.baselineFile = $this$createProjects_u24lambda_u2411.baseline.createFile(projectDir);
                }
                if ($this$createProjects_u24lambda_u2411.overrideConfig == null) continue;
                $this$createProjects_u24lambda_u2411.overrideConfigFile = $this$createProjects_u24lambda_u2411.overrideConfig.createFile(projectDir);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return projectDirs;
    }

    public static /* synthetic */ List createProjects$default(TestLintRunner testLintRunner, File file, TestMode testMode, int n, Object object) {
        if ((n & 2) != 0) {
            testMode = null;
        }
        return testLintRunner.createProjects(file, testMode);
    }

    private final ProjectDescriptionList getProjectList(TestLintTask $this$getProjectList, TestMode testMode) {
        List<ProjectDescription> currentList;
        List<ProjectDescription> newList;
        if (testMode != null && (newList = testMode.configureProjects(currentList = $this$getProjectList.projects.getProjects())) != currentList) {
            ProjectDescription reportFrom = $this$getProjectList.projects.getReportFrom() == null ? null : (CollectionsKt.contains((Iterable)newList, (Object)$this$getProjectList.projects.getReportFrom()) ? $this$getProjectList.projects.getReportFrom() : (ProjectDescription)CollectionsKt.lastOrNull(newList));
            return new ProjectDescriptionList(CollectionsKt.toMutableList((Collection)newList), reportFrom);
        }
        ProjectDescriptionList projectDescriptionList = $this$getProjectList.projects;
        Intrinsics.checkNotNullExpressionValue((Object)projectDescriptionList, (String)"projects");
        return projectDescriptionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateInputs(TestLintTask $this$validateInputs) {
        if ($this$validateInputs.allowCompilationErrors) {
            return;
        }
        ProjectDescriptionList projectDescriptionList = $this$validateInputs.projects;
        Intrinsics.checkNotNullExpressionValue((Object)projectDescriptionList, (String)"projects");
        Iterable $this$forEach$iv = projectDescriptionList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectDescription project = (ProjectDescription)element$iv;
            boolean bl = false;
            TestFile[] $this$forEach$iv2 = project.getFiles();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                TestFile element$iv2;
                TestFile fp = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (!(fp instanceof TestFile.XmlTestFile)) continue;
                String string = fp.contents;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents");
                this.validateXml(string);
            }
        }
        if ($this$validateInputs.mockNetworkData != null) {
            Map<String, byte[]> map = $this$validateInputs.mockNetworkData;
            Intrinsics.checkNotNullExpressionValue(map, (String)"mockNetworkData");
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                String url = entry.getKey();
                byte[] data = entry.getValue();
                Intrinsics.checkNotNull((Object)url);
                if (StringsKt.endsWith$default((String)url, (String)".xml", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)data);
                    String xml = new String(data, Charsets.UTF_8);
                    this.validateXml(xml);
                    continue;
                }
                if (StringsKt.endsWith$default((String)url, (String)".json", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)data);
                    String json = new String(data, Charsets.UTF_8);
                    this.validateJson(json);
                    continue;
                }
                if (!StringsKt.endsWith$default((String)url, (String)".gz", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)data);
                Closeable closeable = new ByteArrayInputStream(data);
                int n = 8192;
                closeable = new GZIPInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
                Throwable throwable = null;
                try {
                    GZIPInputStream stream = (GZIPInputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    private final void validateJson(String json) {
        try {
            JsonParser.parseString((String)json);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Couldn't parse JSON test data: " + e.getLocalizedMessage() + "\nIf intentional, set `.allowCompilationErrors()` on the lint() test task.\nExact file content=\n\"\"\"" + json + "\"\"\"", e);
        }
    }

    private final void validateXml(String xml) {
        try {
            if (((CharSequence)xml).length() > 0) {
                if (xml.charAt(0) != '<' && StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)xml)).toString(), (String)"<?xml", (boolean)false, (int)2, null)) {
                    throw new RuntimeException("XML prologues (<?xml ...>) cannot be indented; that is not valid XML. Did you forget to call `indented()` on the xml test file?");
                }
                XmlUtils.parseDocument((String)xml, (boolean)true);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Couldn't parse XML test file: " + e.getLocalizedMessage() + "\nIf intentional, set `.allowCompilationErrors()` on the lint() test task.\nExact file content=\n\"\"\"" + xml + "\"\"\"", e);
        }
    }

    @JvmOverloads
    @NotNull
    public final List<File> createProjects(@NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        return TestLintRunner.createProjects$default(this, rootDir, null, 2, null);
    }

    public static final /* synthetic */ TestLintTask access$getTask$p(TestLintRunner $this) {
        return $this.task;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestLintRunner$ChangedFile;", "", "path", "", "before", "after", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAfter", "()Ljava/lang/String;", "getBefore", "getPath", "lint-tests"})
    private static final class ChangedFile {
        @NotNull
        private final String path;
        @NotNull
        private final String before;
        @NotNull
        private final String after;

        public ChangedFile(@NotNull String path, @NotNull String before, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            this.path = path;
            this.before = before;
            this.after = after;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getBefore() {
            return this.before;
        }

        @NotNull
        public final String getAfter() {
            return this.after;
        }
    }
}

