/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.infrastructure.LintFixVerifier;
import com.android.tools.lint.checks.infrastructure.LintTestUtils;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintResult;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultChecker;
import com.android.tools.lint.checks.infrastructure.TestResultState;
import com.android.tools.lint.checks.infrastructure.TestResultTransformer;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 p2\u00020\u0001:\u0001pB+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJL\u0010\f\u001a\u00020\u00002 \u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2\"\u0010\u0012\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u0013J\u001a\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!J)\u0010\"\u001a\u00020\u00002\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0017H\u0002JU\u0010'\u001a\u00020\u00002\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020*0\u000e2\u0006\u0010+\u001a\u00020\u001f2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001a\u00a2\u0006\u0002\u0010.J]\u0010'\u001a\u00020\u00002\b\b\u0002\u0010/\u001a\u00020-2\b\b\u0002\u00100\u001a\u00020-2\b\b\u0002\u00101\u001a\u00020-2\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u00104J)\u00105\u001a\u00020\u00002\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010%J)\u00106\u001a\u00020\u00002\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010%J=\u00106\u001a\u00020\u00002\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$\"\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u00107\u001a\u0002032\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u00108J\u0006\u00109\u001a\u00020\u0017J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001fH\u0002J&\u0010>\u001a\u00020\u001f2\u0012\b\u0002\u0010?\u001a\f\u0012\u0006\b\u0001\u0012\u00020A\u0018\u00010@2\b\b\u0002\u0010B\u001a\u00020\u0006H\u0002J8\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u001f2\u0012\b\u0002\u0010?\u001a\f\u0012\u0006\b\u0001\u0012\u00020A\u0018\u00010@2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010B\u001a\u00020\u0006H\u0007J\u0006\u0010E\u001a\u00020\u0000J$\u0010F\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010B\u001a\u00020\u0006H\u0007J'\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u000b2\u0012\u0010I\u001a\n\u0012\u0006\b\u0001\u0012\u00020J0$\"\u00020J\u00a2\u0006\u0002\u0010KJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u000bJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u001fJ\u001a\u0010O\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010P\u001a\u00020\u00002\b\b\u0002\u0010Q\u001a\u00020-J\u001c\u0010R\u001a\u00020\u00002\b\b\u0001\u0010S\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J:\u0010T\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f2\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020*0\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010V\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010W\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u000bJ\u001a\u0010X\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u001f2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ.\u0010X\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u001f2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u00107\u001a\u0002032\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010Z\u001a\u00020\u001f2\u0006\u0010[\u001a\u00020\u0006H\u0002J4\u0010\\\u001a\u00020\u001f2\u0006\u0010]\u001a\u00020\u001f2\b\u0010^\u001a\u0004\u0018\u00010A2\u0010\u0010_\u001a\f\u0012\u0006\b\u0001\u0012\u00020A\u0018\u00010@2\u0006\u0010`\u001a\u00020\u0015H\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010a\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001fH\u0002J \u0010b\u001a\u00020\u00172\u0006\u0010c\u001a\u00020-2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u001fH\u0002J\u0006\u0010g\u001a\u00020hJ\u000e\u0010g\u001a\u00020h2\u0006\u0010B\u001a\u00020\u0006J@\u0010i\u001a\u0004\u0018\u0001Hj\"\u0004\b\u0000\u0010k\"\b\b\u0001\u0010j*\u00020\u0001*\b\u0012\u0004\u0012\u0002Hk0l2\u0014\u0010m\u001a\u0010\u0012\u0004\u0012\u0002Hk\u0012\u0006\u0012\u0004\u0018\u0001Hj0nH\u0082\b\u00a2\u0006\u0002\u0010oR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "states", "", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "Lcom/android/tools/lint/checks/infrastructure/TestResultState;", "defaultMode", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Ljava/util/Map;Lcom/android/tools/lint/checks/infrastructure/TestMode;)V", "maxLineLength", "", "applyFixes", "pickFix", "Lkotlin/Function2;", "Lcom/android/tools/lint/detector/api/Incident;", "", "Lcom/android/tools/lint/detector/api/LintFix;", "apply", "Lkotlin/Function3;", "Lcom/android/tools/lint/detector/api/Project;", "Ljava/io/File;", "", "", "check", "checker", "Lcom/android/tools/lint/checks/infrastructure/TestResultChecker;", "transformer", "Lcom/android/tools/lint/checks/infrastructure/TestResultTransformer;", "checkFix", "fix", "", "after", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "checkHtmlReport", "checkers", "", "([Lcom/android/tools/lint/checks/infrastructure/TestResultChecker;Lcom/android/tools/lint/checks/infrastructure/TestResultTransformer;)Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "checkPendingErrors", "checkReport", "reporterFactory", "Lcom/android/tools/lint/LintCliClient;", "Lcom/android/tools/lint/Reporter;", "extension", "fullPaths", "", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;ZLcom/android/tools/lint/checks/infrastructure/TestResultTransformer;[Lcom/android/tools/lint/checks/infrastructure/TestResultChecker;)Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "xml", "html", "sarif", "xmlReportType", "Lcom/android/tools/lint/XmlFileType;", "(ZZZLcom/android/tools/lint/XmlFileType;ZLcom/android/tools/lint/checks/infrastructure/TestResultTransformer;[Lcom/android/tools/lint/checks/infrastructure/TestResultChecker;)Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "checkSarifReport", "checkXmlReport", "reportType", "([Lcom/android/tools/lint/checks/infrastructure/TestResultChecker;ZLcom/android/tools/lint/XmlFileType;Lcom/android/tools/lint/checks/infrastructure/TestResultTransformer;)Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "cleanup", "computeSubstringMatch", "pattern", "Ljava/util/regex/Pattern;", "output", "describeOutput", "expectedException", "Ljava/lang/Class;", "", "testMode", "expect", "expectedText", "expectClean", "expectContains", "expectCount", "expectedCount", "severities", "Lcom/android/tools/lint/detector/api/Severity;", "(I[Lcom/android/tools/lint/detector/api/Severity;)Lcom/android/tools/lint/checks/infrastructure/TestLintResult;", "expectErrorCount", "expectFixDiffs", "expected", "expectHtml", "expectInlinedMessages", "useRaw", "expectMatches", "regexp", "expectReported", "reporter", "expectSarif", "expectWarningCount", "expectXml", "findIncidents", "targetFile", "mode", "formatOutput", "originalOutput", "throwable", "expectedThrowable", "rootDir", "normalizeOutput", "stripMarkers", "isXml", "doc", "Ljavax/swing/text/Document;", "contents", "verifyFixes", "Lcom/android/tools/lint/checks/infrastructure/LintFixVerifier;", "firstNotNullResult", "R", "T", "", "transform", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTestLintResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestLintResult.kt\ncom/android/tools/lint/checks/infrastructure/TestLintResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1128:1\n766#1,5:1133\n1#2:1129\n1268#3,3:1130\n*S KotlinDebug\n*F\n+ 1 TestLintResult.kt\ncom/android/tools/lint/checks/infrastructure/TestLintResult\n*L\n826#1:1133,5\n783#1:1130,3\n*E\n"})
public final class TestLintResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestLintTask task;
    @NotNull
    private final Map<TestMode, TestResultState> states;
    @NotNull
    private final TestMode defaultMode;
    private int maxLineLength;
    @NotNull
    private static final String TRUNCATION_MARKER = "\u2026";
    @NotNull
    private static final Comparator<Incident> comparator = Companion.comparator.1.INSTANCE;
    @NotNull
    private static final String OLD_ERROR_MESSAGE = "No location-specific message";
    @NotNull
    private static final Regex MATCH_OLD_ERROR_MESSAGE = new Regex("No location-specific message[^>]");

    public TestLintResult(@NotNull TestLintTask task, @NotNull Map<TestMode, TestResultState> states, @NotNull TestMode defaultMode) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Intrinsics.checkNotNullParameter((Object)defaultMode, (String)"defaultMode");
        this.task = task;
        this.states = states;
        this.defaultMode = defaultMode;
    }

    @NotNull
    public final TestLintResult maxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expect(@NotNull String expectedText, @Nullable Class<? extends Throwable> expectedException, @NotNull TestResultTransformer transformer, @NotNull TestMode testMode) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)testMode, (String)"testMode");
        if (expectedException == null) {
            this.checkPendingErrors();
        }
        String string = transformer.transform(this.describeOutput(expectedException, testMode));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transform(...)");
        String actual = string;
        String expected = this.normalizeOutput(expectedText);
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)actual)).toString(), (Object)((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)expected))).toString())) {
            if (Intrinsics.areEqual((Object)actual, (Object)StringsKt.replace$default((String)expected, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null))) {
                Assert.assertEquals((String)"The expected lint output does not match, but it *does* match when Windows file separators (\\) are replaced by Unix ones.\nMake sure your lint detector calls LintClient.getDisplayPath(File) instead of displaying paths directly (in unit tests they will then be converted to forward slashes for test output stability.)\n", (Object)expected, (Object)actual);
            }
            Assert.assertEquals((Object)StringsKt.trimIndent((String)expected), (Object)StringsKt.trimIndent((String)actual));
        }
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult expect$default(TestLintResult testLintResult, String string, Class clazz, TestResultTransformer testResultTransformer, TestMode testMode, int n, Object object) {
        if ((n & 2) != 0) {
            clazz = null;
        }
        if ((n & 4) != 0) {
            testResultTransformer = expect.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            testMode = testLintResult.defaultMode;
        }
        return testLintResult.expect(string, clazz, testResultTransformer, testMode);
    }

    private final void checkPendingErrors() {
        Throwable throwable;
        if (!this.task.allowExceptions && (throwable = (Throwable)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(this.states), (Function1)checkPendingErrors.1.INSTANCE))) != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expectContains(@NotNull String expectedText, @NotNull TestResultTransformer transformer, @NotNull TestMode testMode) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)testMode, (String)"testMode");
        this.checkPendingErrors();
        String string = transformer.transform(this.describeOutput(null, testMode));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transform(...)");
        String actual = string;
        String expected = this.normalizeOutput(expectedText);
        String expectedWithoutIndent = StringsKt.trimIndent((String)expected);
        String unixPath = StringsKt.replace$default((String)expectedWithoutIndent, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        if (!StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)actual)).toString(), (CharSequence)((Object)StringsKt.trim((CharSequence)expectedWithoutIndent)).toString(), (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)actual, (CharSequence)unixPath, (boolean)false, (int)2, null)) {
            Assert.assertEquals((String)"The expected lint output does not match, but it *does* match when Windows file separators (\\) are replaced by Unix ones.\nMake sure your lint detector calls LintClient.getDisplayPath(File) instead of displaying paths directly (in unit tests they will then be converted to forward slashes for test output stability.)\n", (Object)expected, (Object)actual);
        }
        Assert.assertTrue((String)("Not true that\n\"" + expectedWithoutIndent + "\nis found in lint output\n\"" + actual), (boolean)StringsKt.contains$default((CharSequence)actual, (CharSequence)expectedWithoutIndent, (boolean)false, (int)2, null));
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult expectContains$default(TestLintResult testLintResult, String string, TestResultTransformer testResultTransformer, TestMode testMode, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = expectContains.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            testMode = testLintResult.defaultMode;
        }
        return testLintResult.expectContains(string, testResultTransformer, testMode);
    }

    private final String describeOutput(Class<? extends Throwable> expectedException, TestMode testMode) {
        TestResultState testResultState = this.states.get(testMode);
        Intrinsics.checkNotNull((Object)testResultState);
        TestResultState state = testResultState;
        String string = state.output;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output");
        Throwable throwable = state.firstThrowable;
        File file = state.rootDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
        return this.formatOutput(string, throwable, expectedException, file);
    }

    static /* synthetic */ String describeOutput$default(TestLintResult testLintResult, Class clazz, TestMode testMode, int n, Object object) {
        if ((n & 1) != 0) {
            clazz = null;
        }
        if ((n & 2) != 0) {
            testMode = testLintResult.defaultMode;
        }
        return testLintResult.describeOutput(clazz, testMode);
    }

    private final String formatOutput(String originalOutput, Throwable throwable, Class<? extends Throwable> expectedThrowable, File rootDir) {
        String string;
        String output = originalOutput;
        if (this.maxLineLength > 1) {
            StringBuilder sb = new StringBuilder();
            for (String line2 : Splitter.on((char)'\n').split((CharSequence)output)) {
                Object object;
                if (line2.length() > this.maxLineLength) {
                    Intrinsics.checkNotNull((Object)line2);
                    String string2 = line2.substring(0, this.maxLineLength - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    object = string2 + TRUNCATION_MARKER;
                } else {
                    object = line2;
                }
                String truncated = object;
                sb.append(truncated).append('\n');
            }
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            output = string3;
            if (StringsKt.endsWith$default((String)output, (String)"\n\n", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)originalOutput, (String)"\n\n", (boolean)false, (int)2, null)) {
                String string4 = output.substring(0, output.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                output = string4;
            }
        }
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            if (expectedThrowable != null && expectedThrowable.isInstance(throwable)) {
                String throwableMessage = throwable.getMessage();
                if (throwableMessage != null && !StringsKt.contains$default((CharSequence)output, (CharSequence)throwableMessage, (boolean)false, (int)2, null)) {
                    writer.write(this.task.stripRoot(rootDir, throwableMessage) + "\n");
                }
            } else {
                throwable.printStackTrace(new PrintWriter(writer));
            }
            if (((CharSequence)output).length() > 0) {
                writer.write(this.task.stripRoot(rootDir, this.normalizeOutput(output)));
            }
            String string5 = writer.toString();
            Intrinsics.checkNotNull((Object)string5);
            string = string5;
        } else {
            string = this.normalizeOutput(output);
        }
        return string;
    }

    private final String normalizeOutput(String output) {
        if (StringsKt.contains$default((CharSequence)output, (CharSequence)OLD_ERROR_MESSAGE, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)output, (CharSequence)"$", (boolean)false, (int)2, null)) {
            String first = StringsKt.replace$default((String)output, (char)'$', (char)'\uff04', (boolean)false, (int)4, null);
            return MATCH_OLD_ERROR_MESSAGE.replace((CharSequence)first, (Function1)new Function1<MatchResult, CharSequence>(output){
                final /* synthetic */ String $output;
                {
                    this.$output = $output;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return "No location-specific message>" + this.$output.charAt(it.getRange().getLast());
                }
            });
        }
        return output;
    }

    @NotNull
    public final TestLintResult expectClean() {
        TestLintResult.expect$default(this, "No warnings.", null, null, null, 14, null);
        this.cleanup();
        return this;
    }

    @NotNull
    public final TestLintResult expectInlinedMessages(boolean useRaw) {
        this.checkPendingErrors();
        for (ProjectDescription project : this.task.projects) {
            for (TestFile file : project.getFiles()) {
                String targetPath;
                String plainContents = null;
                String contents = null;
                try {
                    plainContents = file.getContents();
                    contents = file.getRawContents();
                    if (contents == null) continue;
                    if (plainContents == null) {
                    }
                }
                catch (Throwable ignore) {}
                continue;
                Intrinsics.checkNotNullExpressionValue((Object)file.getTargetPath(), (String)"getTargetPath(...)");
                boolean isXml = StringsKt.endsWith$default((String)targetPath, (String)".xml", (boolean)false, (int)2, null);
                try {
                    javax.swing.text.Position endPos;
                    javax.swing.text.Position startPos;
                    int endOffset;
                    int startOffset;
                    Position end;
                    Position start;
                    Location location;
                    PlainDocument doc = new PlainDocument();
                    doc.insertString(0, isXml ? plainContents : contents, null);
                    HashMap positionMap = Maps.newHashMap();
                    List<Incident> matches = this.findIncidents(targetPath, this.defaultMode);
                    for (Incident incident : matches) {
                        location = incident.getLocation();
                        start = location.getStart();
                        end = location.getEnd();
                        Position position = start;
                        startOffset = position != null ? position.getOffset() : 0;
                        Position position2 = end;
                        endOffset = position2 != null ? position2.getOffset() : 0;
                        startPos = doc.createPosition(startOffset);
                        endPos = doc.createPosition(endOffset);
                        Integer n = startOffset;
                        Intrinsics.checkNotNull((Object)positionMap);
                        ((Map)positionMap).put(n, startPos);
                        n = endOffset;
                        ((Map)positionMap).put(n, endPos);
                    }
                    this.stripMarkers(isXml, doc, contents);
                    for (Incident incident : matches) {
                        location = incident.getLocation();
                        start = location.getStart();
                        end = location.getEnd();
                        Position position = start;
                        startOffset = position != null ? position.getOffset() : 0;
                        Position position3 = end;
                        endOffset = position3 != null ? position3.getOffset() : 0;
                        Object v = positionMap.get(startOffset);
                        Intrinsics.checkNotNull(v);
                        startPos = (javax.swing.text.Position)v;
                        Object v2 = positionMap.get(endOffset);
                        Intrinsics.checkNotNull(v2);
                        endPos = (javax.swing.text.Position)v2;
                        String startMarker = null;
                        Object endMarker = null;
                        String message = incident.getMessage();
                        if (!useRaw) {
                            message = TextFormat.RAW.convertTo(message, TextFormat.TEXT);
                        }
                        if (isXml) {
                            String tag = incident.getSeverity().toName();
                            startMarker = "<?" + tag + " message=\"" + message + "\"?>";
                            endMarker = "<?" + tag + "?>";
                        } else {
                            startMarker = "/*" + message + "*/";
                            endMarker = "/**/";
                        }
                        startOffset = startPos.getOffset();
                        endOffset = endPos.getOffset();
                        doc.insertString(endOffset, (String)endMarker, null);
                        doc.insertString(startOffset, startMarker, null);
                    }
                    Assert.assertEquals((Object)contents, (Object)doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult expectInlinedMessages$default(TestLintResult testLintResult, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return testLintResult.expectInlinedMessages(bl);
    }

    private final List<Incident> findIncidents(String targetFile, TestMode mode) {
        TestResultState testResultState = this.states.get(mode);
        Intrinsics.checkNotNull((Object)testResultState);
        TestResultState state = testResultState;
        List<Incident> list2 = state.incidents;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incidents");
        List<Incident> incidents = list2;
        Assert.assertTrue((String)targetFile, (!StringsKt.contains$default((CharSequence)targetFile, (CharSequence)"\\", (boolean)false, (int)2, null) ? 1 : 0) != 0);
        ArrayList matches = Lists.newArrayList();
        for (Incident incident : incidents) {
            String string = incident.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            if (!StringsKt.endsWith$default((String)path, (String)targetFile, (boolean)false, (int)2, null)) continue;
            matches.add(incident);
        }
        Intrinsics.checkNotNull((Object)matches);
        CollectionsKt.sortWith((List)matches, comparator);
        return matches;
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expectMatches(@Language(value="RegExp") @NotNull String regexp, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        this.checkPendingErrors();
        String string = transformer.transform(TestLintResult.describeOutput$default(this, null, null, 3, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transform(...)");
        String output = string;
        Pattern pattern = Pattern.compile(regexp, 40);
        boolean found = pattern.matcher(output).find();
        if (!found) {
            pattern = Pattern.compile(StringsKt.trimIndent((String)regexp), 40);
            found = pattern.matcher(output).find();
        }
        if (!found) {
            Pattern pattern2 = pattern;
            Intrinsics.checkNotNull((Object)pattern2);
            int reached = this.computeSubstringMatch(pattern2, output);
            String string2 = output.substring(0, reached);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Assert.fail((String)("Did not find pattern\n  " + regexp + "\n in \n" + output + "; the incomplete match was " + string2));
        }
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult expectMatches$default(TestLintResult testLintResult, String string, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = expectMatches.1.INSTANCE;
        }
        return testLintResult.expectMatches(string, testResultTransformer);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult check(@NotNull TestResultChecker checker, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        String string = transformer.transform(TestLintResult.describeOutput$default(this, null, null, 3, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transform(...)");
        String output = string;
        checker.check(output);
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult check$default(TestLintResult testLintResult, TestResultChecker testResultChecker, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = check.1.INSTANCE;
        }
        return testLintResult.check(testResultChecker, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectWarningCount(int expectedCount) {
        Severity[] severityArray = new Severity[]{Severity.WARNING};
        return this.expectCount(expectedCount, severityArray);
    }

    @NotNull
    public final TestLintResult expectErrorCount(int expectedCount) {
        Severity[] severityArray = new Severity[]{Severity.ERROR, Severity.FATAL};
        return this.expectCount(expectedCount, severityArray);
    }

    @NotNull
    public final TestLintResult expectCount(int expectedCount, Severity ... severities) {
        Intrinsics.checkNotNullParameter((Object)severities, (String)"severities");
        this.checkPendingErrors();
        TestResultState testResultState = this.states.get(this.defaultMode);
        Intrinsics.checkNotNull((Object)testResultState);
        TestResultState state = testResultState;
        Throwable throwable = state.firstThrowable;
        List<Incident> list2 = state.incidents;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incidents");
        List<Incident> incidents = list2;
        if (!this.task.allowExceptions && throwable != null) {
            throw throwable;
        }
        int count = 0;
        for (Incident incident : incidents) {
            if (!ArrayUtil.contains((Object)incident.getSeverity(), (Object[])Arrays.copyOf(severities, severities.length))) continue;
            ++count;
        }
        if (count != expectedCount) {
            Assert.assertEquals((String)("Expected " + expectedCount + " problems with severity " + Joiner.on((String)" or ").join((Object[])severities) + " but was " + count), (long)expectedCount, (long)count);
        }
        return this;
    }

    @NotNull
    public final TestLintResult applyFixes(@NotNull Function2<? super Incident, ? super List<? extends LintFix>, ? extends LintFix> pickFix, @NotNull Function3<? super Project, ? super File, ? super byte[], Unit> apply) {
        Intrinsics.checkNotNullParameter(pickFix, (String)"pickFix");
        Intrinsics.checkNotNullParameter(apply, (String)"apply");
        TestResultState testResultState = this.states.get(this.defaultMode);
        Intrinsics.checkNotNull((Object)testResultState);
        new LintFixVerifier(this.task, this.defaultMode, testResultState).applyFixes(pickFix, apply);
        return this;
    }

    @NotNull
    public final LintFixVerifier verifyFixes() {
        TestResultState testResultState = this.states.get(this.defaultMode);
        Intrinsics.checkNotNull((Object)testResultState);
        return new LintFixVerifier(this.task, this.defaultMode, testResultState);
    }

    @NotNull
    public final LintFixVerifier verifyFixes(@NotNull TestMode testMode) {
        Intrinsics.checkNotNullParameter((Object)testMode, (String)"testMode");
        TestResultState testResultState = this.states.get(testMode);
        Intrinsics.checkNotNull((Object)testResultState);
        return new LintFixVerifier(this.task, testMode, testResultState);
    }

    @NotNull
    public final TestLintResult checkFix(@Nullable String fix, @NotNull TestFile after) {
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.verifyFixes().checkFix(fix, after);
        return this;
    }

    @NotNull
    public final TestLintResult expectFixDiffs(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.checkPendingErrors();
        for (Map.Entry<TestMode, TestResultState> entry : this.states.entrySet()) {
            TestMode mode = entry.getKey();
            TestResultState result = entry.getValue();
            if (result.skipped || !Intrinsics.areEqual((Object)mode, (Object)TestMode.DEFAULT) && !(mode instanceof SourceTransformationTestMode)) continue;
            this.verifyFixes(mode).expectFixDiffs(expected);
        }
        return this;
    }

    @NotNull
    public final TestLintResult checkHtmlReport(@NotNull TestResultChecker[] checkers, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        XmlFileType xmlFileType = XmlFileType.REPORT;
        TestResultChecker[] testResultCheckerArray = Arrays.copyOf(checkers, checkers.length);
        return TestLintResult.checkReport$default(this, false, true, false, xmlFileType, false, transformer, testResultCheckerArray, 5, null);
    }

    public static /* synthetic */ TestLintResult checkHtmlReport$default(TestLintResult testLintResult, TestResultChecker[] testResultCheckerArray, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = checkHtmlReport.1.INSTANCE;
        }
        return testLintResult.checkHtmlReport(testResultCheckerArray, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectHtml(@Language(value="HTML") @NotNull String expected, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        String trimmed = this.normalizeOutput(StringsKt.trimIndent((String)expected));
        TestResultChecker[] testResultCheckerArray = new TestResultChecker[]{new TestResultChecker(this, trimmed){
            final /* synthetic */ TestLintResult this$0;
            final /* synthetic */ String $trimmed;
            {
                this.this$0 = $receiver;
                this.$trimmed = $trimmed;
            }

            public final void check(@NotNull String actual) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                String s = TestLintResult.access$normalizeOutput(this.this$0, StringsKt.trimIndent((String)actual));
                if (Intrinsics.areEqual((Object)s, (Object)this.$trimmed) || !Intrinsics.areEqual((Object)LintTestUtils.dos2unix$default(s, false, 1, null), (Object)LintTestUtils.dos2unix$default(this.$trimmed, false, 1, null))) {
                    Assert.assertEquals((Object)this.$trimmed, (Object)s);
                }
            }
        }};
        return this.checkHtmlReport(testResultCheckerArray, transformer);
    }

    public static /* synthetic */ TestLintResult expectHtml$default(TestLintResult testLintResult, String string, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = expectHtml.1.INSTANCE;
        }
        return testLintResult.expectHtml(string, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectReported(@NotNull String expected, @NotNull String extension, @NotNull Function2<? super LintCliClient, ? super File, ? extends Reporter> reporter, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        String trimmed = this.normalizeOutput(StringsKt.trimIndent((String)expected));
        TestResultChecker[] testResultCheckerArray = new TestResultChecker[]{new TestResultChecker(this, trimmed){
            final /* synthetic */ TestLintResult this$0;
            final /* synthetic */ String $trimmed;
            {
                this.this$0 = $receiver;
                this.$trimmed = $trimmed;
            }

            public final void check(@NotNull String actual) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                String s = TestLintResult.access$normalizeOutput(this.this$0, StringsKt.trimIndent((String)actual));
                if (Intrinsics.areEqual((Object)s, (Object)this.$trimmed) || !Intrinsics.areEqual((Object)LintTestUtils.dos2unix$default(s, false, 1, null), (Object)LintTestUtils.dos2unix$default(this.$trimmed, false, 1, null))) {
                    Assert.assertEquals((Object)this.$trimmed, (Object)s);
                }
            }
        }};
        return this.checkReport(reporter, extension, false, transformer, testResultCheckerArray);
    }

    public static /* synthetic */ TestLintResult expectReported$default(TestLintResult testLintResult, String string, String string2, Function2 function2, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 8) != 0) {
            testResultTransformer = expectReported.1.INSTANCE;
        }
        return testLintResult.expectReported(string, string2, (Function2<? super LintCliClient, ? super File, ? extends Reporter>)function2, testResultTransformer);
    }

    @NotNull
    public final TestLintResult checkXmlReport(@NotNull TestResultChecker[] checkers, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        XmlFileType xmlFileType = XmlFileType.REPORT;
        TestResultChecker[] testResultCheckerArray = Arrays.copyOf(checkers, checkers.length);
        return TestLintResult.checkReport$default(this, true, false, false, xmlFileType, false, transformer, testResultCheckerArray, 6, null);
    }

    public static /* synthetic */ TestLintResult checkXmlReport$default(TestLintResult testLintResult, TestResultChecker[] testResultCheckerArray, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = checkXmlReport.1.INSTANCE;
        }
        return testLintResult.checkXmlReport(testResultCheckerArray, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectXml(@Language(value="XML") @NotNull String expected, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        TestResultChecker[] testResultCheckerArray = new TestResultChecker[]{new TestResultChecker(this, expected){
            final /* synthetic */ TestLintResult this$0;
            final /* synthetic */ String $expected;
            {
                this.this$0 = $receiver;
                this.$expected = $expected;
            }

            public final void check(@NotNull String actual) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                String s = TestLintResult.access$normalizeOutput(this.this$0, StringsKt.trimIndent((String)actual));
                if (Intrinsics.areEqual((Object)s, (Object)this.$expected) || !Intrinsics.areEqual((Object)LintTestUtils.dos2unix$default(s, false, 1, null), (Object)LintTestUtils.dos2unix$default(this.$expected, false, 1, null))) {
                    Assert.assertEquals((Object)this.$expected, (Object)s);
                }
            }
        }};
        return this.checkXmlReport(testResultCheckerArray, transformer);
    }

    public static /* synthetic */ TestLintResult expectXml$default(TestLintResult testLintResult, String string, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = expectXml.1.INSTANCE;
        }
        return testLintResult.expectXml(string, testResultTransformer);
    }

    @NotNull
    public final TestLintResult checkXmlReport(@NotNull TestResultChecker[] checkers, boolean fullPaths, @NotNull XmlFileType reportType, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter((Object)reportType, (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        TestResultChecker[] testResultCheckerArray = Arrays.copyOf(checkers, checkers.length);
        return TestLintResult.checkReport$default(this, true, false, false, reportType, fullPaths, transformer, testResultCheckerArray, 6, null);
    }

    public static /* synthetic */ TestLintResult checkXmlReport$default(TestLintResult testLintResult, TestResultChecker[] testResultCheckerArray, boolean bl, XmlFileType xmlFileType, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            xmlFileType = XmlFileType.REPORT;
        }
        if ((n & 8) != 0) {
            testResultTransformer = checkXmlReport.2.INSTANCE;
        }
        return testLintResult.checkXmlReport(testResultCheckerArray, bl, xmlFileType, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectXml(@Language(value="XML") @NotNull String expected, boolean fullPaths, @NotNull XmlFileType reportType, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)reportType, (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        String trimmed = this.normalizeOutput(StringsKt.trimIndent((String)expected));
        TestResultChecker[] testResultCheckerArray = new TestResultChecker[]{new TestResultChecker(this, trimmed){
            final /* synthetic */ TestLintResult this$0;
            final /* synthetic */ String $trimmed;
            {
                this.this$0 = $receiver;
                this.$trimmed = $trimmed;
            }

            public final void check(@NotNull String actual) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                String s = TestLintResult.access$normalizeOutput(this.this$0, StringsKt.trimIndent((String)actual));
                if (Intrinsics.areEqual((Object)s, (Object)this.$trimmed) || !Intrinsics.areEqual((Object)LintTestUtils.dos2unix$default(s, false, 1, null), (Object)LintTestUtils.dos2unix$default(this.$trimmed, false, 1, null))) {
                    Assert.assertEquals((Object)this.$trimmed, (Object)s);
                }
            }
        }};
        TestResultChecker[] testResultCheckerArray2 = testResultCheckerArray;
        return this.checkXmlReport(testResultCheckerArray2, fullPaths, reportType, transformer);
    }

    public static /* synthetic */ TestLintResult expectXml$default(TestLintResult testLintResult, String string, boolean bl, XmlFileType xmlFileType, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            xmlFileType = XmlFileType.REPORT;
        }
        if ((n & 8) != 0) {
            testResultTransformer = expectXml.3.INSTANCE;
        }
        return testLintResult.expectXml(string, bl, xmlFileType, testResultTransformer);
    }

    @NotNull
    public final TestLintResult expectSarif(@Language(value="JSON") @NotNull String expected, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        String trimmed = this.normalizeOutput(StringsKt.trimIndent((String)expected));
        TestResultChecker[] testResultCheckerArray = new TestResultChecker[]{new TestResultChecker(this, trimmed){
            final /* synthetic */ TestLintResult this$0;
            final /* synthetic */ String $trimmed;
            {
                this.this$0 = $receiver;
                this.$trimmed = $trimmed;
            }

            public final void check(@NotNull String actual) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                String s = TestLintResult.access$normalizeOutput(this.this$0, StringsKt.trimIndent((String)actual));
                if (Intrinsics.areEqual((Object)s, (Object)this.$trimmed) || !Intrinsics.areEqual((Object)LintTestUtils.dos2unix$default(s, false, 1, null), (Object)LintTestUtils.dos2unix$default(this.$trimmed, false, 1, null))) {
                    Assert.assertEquals((Object)this.$trimmed, (Object)s);
                }
            }
        }};
        TestResultChecker[] testResultCheckerArray2 = testResultCheckerArray;
        return this.checkSarifReport(testResultCheckerArray2, transformer);
    }

    public static /* synthetic */ TestLintResult expectSarif$default(TestLintResult testLintResult, String string, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = expectSarif.1.INSTANCE;
        }
        return testLintResult.expectSarif(string, testResultTransformer);
    }

    @NotNull
    public final TestLintResult checkSarifReport(@NotNull TestResultChecker[] checkers, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        return TestLintResult.checkReport$default(this, false, false, true, null, false, transformer, Arrays.copyOf(checkers, checkers.length), 27, null);
    }

    public static /* synthetic */ TestLintResult checkSarifReport$default(TestLintResult testLintResult, TestResultChecker[] testResultCheckerArray, TestResultTransformer testResultTransformer, int n, Object object) {
        if ((n & 2) != 0) {
            testResultTransformer = checkSarifReport.1.INSTANCE;
        }
        return testLintResult.checkSarifReport(testResultCheckerArray, testResultTransformer);
    }

    private final <T, R> R firstNotNullResult(Iterable<? extends T> $this$firstNotNullResult, Function1<? super T, ? extends R> transform2) {
        boolean $i$f$firstNotNullResult = false;
        for (T element : $this$firstNotNullResult) {
            Object result;
            Object object = result = transform2.invoke(element);
            if (object == null) continue;
            return (R)object;
        }
        return null;
    }

    private final TestLintResult checkReport(boolean xml, boolean html, boolean sarif, XmlFileType xmlReportType, boolean fullPaths, TestResultTransformer transformer, TestResultChecker ... checkers) {
        this.checkPendingErrors();
        Object[] objectArray = new Boolean[]{xml, html, sarif};
        Sequence $this$count$iv = SequencesKt.sequenceOf((Object[])objectArray);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            boolean it = (Boolean)element$iv;
            boolean bl = false;
            if (!it || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        Assert.assertTrue((count$iv == 1 ? 1 : 0) != 0);
        Function2 reporterFactory2 = (Function2)new Function2<LintCliClient, File, Reporter>(html, xml, xmlReportType, sarif){
            final /* synthetic */ boolean $html;
            final /* synthetic */ boolean $xml;
            final /* synthetic */ XmlFileType $xmlReportType;
            final /* synthetic */ boolean $sarif;
            {
                this.$html = $html;
                this.$xml = $xml;
                this.$xmlReportType = $xmlReportType;
                this.$sarif = $sarif;
                super(2);
            }

            @NotNull
            public final Reporter invoke(@NotNull LintCliClient client2, @NotNull File file) {
                Reporter reporter;
                Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (this.$html) {
                    reporter = Reporter.Companion.createHtmlReporter(client2, file, client2.getFlags());
                } else if (this.$xml) {
                    reporter = (Reporter)Reporter.Companion.createXmlReporter(client2, file, this.$xmlReportType);
                } else if (this.$sarif) {
                    reporter = Reporter.Companion.createSarifReporter(client2, file);
                } else {
                    throw new IllegalStateException();
                }
                Reporter reporter2 = reporter;
                return reporter2;
            }
        };
        String extension = html ? ".html" : (sarif ? ".sarif" : ".xml");
        return this.checkReport((Function2<? super LintCliClient, ? super File, ? extends Reporter>)reporterFactory2, extension, fullPaths, transformer, Arrays.copyOf(checkers, checkers.length));
    }

    static /* synthetic */ TestLintResult checkReport$default(TestLintResult testLintResult, boolean bl, boolean bl2, boolean bl3, XmlFileType xmlFileType, boolean bl4, TestResultTransformer testResultTransformer, TestResultChecker[] testResultCheckerArray, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            xmlFileType = XmlFileType.REPORT;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            testResultTransformer = checkReport.1.INSTANCE;
        }
        return testLintResult.checkReport(bl, bl2, bl3, xmlFileType, bl4, testResultTransformer, testResultCheckerArray);
    }

    @NotNull
    public final TestLintResult checkReport(@NotNull Function2<? super LintCliClient, ? super File, ? extends Reporter> reporterFactory2, @NotNull String extension, boolean fullPaths, @NotNull TestResultTransformer transformer, TestResultChecker ... checkers) {
        Intrinsics.checkNotNullParameter(reporterFactory2, (String)"reporterFactory");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        TestResultState testResultState = this.states.get(this.defaultMode);
        Intrinsics.checkNotNull((Object)testResultState);
        TestResultState state = testResultState;
        Throwable throwable = state.firstThrowable;
        List<Incident> list2 = state.incidents;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incidents");
        List<Incident> incidents = list2;
        if (!this.task.allowExceptions && throwable != null) {
            throw throwable;
        }
        try {
            TestLintClient testLintClient;
            TestLintClient testLintClient2;
            File file;
            block12: {
                File file2 = (File)CollectionsKt.firstOrNull((Iterable)this.task.dirToProjectDescription.keySet());
                File root = file2 != null ? file2.getParentFile() : null;
                String name = "test-lint";
                file = root != null ? new File(root, name + extension) : File.createTempFile(name, extension);
                TestLintResult testLintResult = this;
                Iterable $this$firstNotNullResult$iv = incidents;
                boolean $i$f$firstNotNullResult = false;
                for (Object element$iv : $this$firstNotNullResult$iv) {
                    Incident it = (Incident)element$iv;
                    boolean bl = false;
                    Project project = it.getProject();
                    Object object = project != null ? project.getClient() : null;
                    TestLintClient result$iv = object instanceof TestLintClient ? (TestLintClient)((Object)object) : null;
                    testLintClient2 = result$iv;
                    if (testLintClient2 == null) {
                        continue;
                    }
                    break block12;
                }
                testLintClient2 = testLintClient = null;
            }
            if (testLintClient2 == null) {
                checkReport.client.2 this_$iv;
                var $this$checkReport_u24lambda_u243 = this_$iv = new TestLintClient(){

                    @NotNull
                    public String getClientRevision() {
                        if (this.getRegistry() == null) {
                            this.setRegistry((IssueRegistry)new BuiltinIssueRegistry());
                        }
                        String string = super.getClientRevision();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientRevision(...)");
                        return string;
                    }
                };
                boolean bl = false;
                $this$checkReport_u24lambda_u243.getClientRevision();
                testLintClient = this_$iv;
            }
            TestLintClient client2 = testLintClient;
            file.getParentFile().mkdirs();
            Intrinsics.checkNotNull((Object)file);
            Reporter reporter = (Reporter)reporterFactory2.invoke(client2, (Object)file);
            boolean oldFullPath = client2.getFlags().isFullPath();
            if (fullPaths) {
                client2.getFlags().setFullPath(true);
            }
            LintStats stats = LintStats.Companion.create(incidents, null);
            IssueRegistry issueRegistry = state.client.getRegistry();
            if (issueRegistry == null) {
                issueRegistry = client2.getDriver().getRegistry();
            }
            reporter.write(stats, incidents, issueRegistry);
            String string = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read(...)");
            String actual = this.normalizeOutput(string);
            TestResultState testResultState2 = this.states.get(this.defaultMode);
            Intrinsics.checkNotNull((Object)testResultState2);
            TestResultState defaultState = testResultState2;
            String transformed = this.task.stripRoot(defaultState.rootDir, transformer.transform(actual));
            for (TestResultChecker checker : checkers) {
                checker.check(transformed);
            }
            if (Intrinsics.areEqual((Object)extension, (Object)".xml")) {
                try {
                    org.w3c.dom.Document document2 = PositionXmlParser.parse((String)actual);
                    Assert.assertNotNull((Object)document2);
                    Assert.assertEquals((long)incidents.size(), (long)document2.getElementsByTagName("issue").getLength());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not parse XML report file: " + t.getMessage(), t);
                }
            }
            client2.getFlags().setFullPath(oldFullPath);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        this.cleanup();
        return this;
    }

    public static /* synthetic */ TestLintResult checkReport$default(TestLintResult testLintResult, Function2 function2, String string, boolean bl, TestResultTransformer testResultTransformer, TestResultChecker[] testResultCheckerArray, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            testResultTransformer = checkReport.3.INSTANCE;
        }
        return testLintResult.checkReport((Function2<? super LintCliClient, ? super File, ? extends Reporter>)function2, string, bl, testResultTransformer, testResultCheckerArray);
    }

    public final void cleanup() {
        for (TestResultState state : this.states.values()) {
            state.client.disposeProjects(CollectionsKt.emptyList());
        }
        UastEnvironment.Companion.disposeApplicationEnvironment();
        File file = this.task.tempDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tempDir");
        FilesKt.deleteRecursively((File)file);
    }

    private final void stripMarkers(boolean isXml, Document doc, String contents) throws BadLocationException {
        if (isXml) {
            int endStartOffset;
            int endEndOffset;
            int index = contents.length();
            while (index >= 0 && (endEndOffset = StringsKt.lastIndexOf$default((CharSequence)contents, (String)"?>", (int)index, (boolean)false, (int)4, null)) != -1 && (endStartOffset = StringsKt.lastIndexOf$default((CharSequence)contents, (String)"<?", (int)endEndOffset, (boolean)false, (int)4, null)) != -1) {
                if (StringsKt.startsWith$default((String)contents, (String)"<?xml", (int)endStartOffset, (boolean)false, (int)4, null)) {
                    index = endStartOffset - 1;
                    continue;
                }
                doc.remove(endStartOffset, endEndOffset + 2 - endStartOffset);
                index = endStartOffset;
            }
        } else {
            int commentEnd;
            int regionStart;
            int endOffset;
            int index = contents.length();
            while (index >= 0 && (endOffset = StringsKt.lastIndexOf$default((CharSequence)contents, (String)"/**/", (int)index, (boolean)false, (int)4, null)) != -1 && (regionStart = StringsKt.lastIndexOf$default((CharSequence)contents, (String)"/*", (int)(endOffset - 1), (boolean)false, (int)4, null)) != -1 && (commentEnd = StringsKt.indexOf$default((CharSequence)contents, (String)"*/", (int)(regionStart + 2), (boolean)false, (int)4, null)) != -1 && commentEnd <= endOffset) {
                doc.remove(endOffset, 4);
                doc.remove(regionStart, commentEnd + 2 - regionStart);
                index = regionStart;
            }
        }
    }

    private final int computeSubstringMatch(Pattern pattern, String output) {
        for (int i = output.length() - 1; 0 < i; --i) {
            String partial;
            Intrinsics.checkNotNullExpressionValue((Object)output.substring(0, i), (String)"substring(...)");
            Matcher matcher = pattern.matcher(partial);
            if (matcher.matches() || !matcher.hitEnd()) continue;
            return i;
        }
        return 0;
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expect(@NotNull String expectedText, @Nullable Class<? extends Throwable> expectedException, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        return TestLintResult.expect$default(this, expectedText, expectedException, transformer, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expect(@NotNull String expectedText, @Nullable Class<? extends Throwable> expectedException) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        return TestLintResult.expect$default(this, expectedText, expectedException, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expect(@NotNull String expectedText) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        return TestLintResult.expect$default(this, expectedText, null, null, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expectContains(@NotNull String expectedText, @NotNull TestResultTransformer transformer) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        return TestLintResult.expectContains$default(this, expectedText, transformer, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expectContains(@NotNull String expectedText) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        return TestLintResult.expectContains$default(this, expectedText, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult expectMatches(@Language(value="RegExp") @NotNull String regexp) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        return TestLintResult.expectMatches$default(this, regexp, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final TestLintResult check(@NotNull TestResultChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return TestLintResult.check$default(this, checker, null, 2, null);
    }

    public static final /* synthetic */ String access$normalizeOutput(TestLintResult $this, String output) {
        return $this.normalizeOutput(output);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0017J*\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015J2\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestLintResult$Companion;", "", "()V", "MATCH_OLD_ERROR_MESSAGE", "Lkotlin/text/Regex;", "OLD_ERROR_MESSAGE", "", "TRUNCATION_MARKER", "comparator", "Ljava/util/Comparator;", "Lcom/android/tools/lint/detector/api/Incident;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "getDiff", "before", "", "after", "windowSize", "", "diffCompatMode", "", "diffCompatMode2", "([Ljava/lang/String;[Ljava/lang/String;IZZ)Ljava/lang/String;", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nTestLintResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestLintResult.kt\ncom/android/tools/lint/checks/infrastructure/TestLintResult$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1128:1\n26#2:1129\n26#2:1132\n37#3,2:1130\n37#3,2:1133\n*S KotlinDebug\n*F\n+ 1 TestLintResult.kt\ncom/android/tools/lint/checks/infrastructure/TestLintResult$Companion\n*L\n990#1:1129\n991#1:1132\n990#1:1130,2\n991#1:1133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Incident> getComparator() {
            return comparator;
        }

        @NotNull
        public final String getDiff(@NotNull String before, @NotNull String after, boolean diffCompatMode, boolean diffCompatMode2) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            return this.getDiff(before, after, 0, diffCompatMode, diffCompatMode2);
        }

        public static /* synthetic */ String getDiff$default(Companion companion, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.getDiff(string, string2, bl, bl2);
        }

        @NotNull
        public final String getDiff(@NotNull String before, @NotNull String after, int windowSize, boolean diffCompatMode, boolean diffCompatMode2) {
            String[] stringArray;
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            String[] stringArray2;
            boolean $i$f$emptyArray2;
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            if (((CharSequence)before).length() == 0) {
                $i$f$emptyArray2 = false;
                stringArray2 = new String[]{};
            } else {
                String[] $i$f$emptyArray2 = new String[]{"\n"};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)before, (String[])$i$f$emptyArray2, (boolean)false, (int)0, (int)6, null);
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                stringArray2 = thisCollection$iv.toArray(new String[0]);
            }
            if (((CharSequence)after).length() == 0) {
                $i$f$emptyArray2 = false;
                stringArray = new String[]{};
            } else {
                String[] $i$f$emptyArray3 = new String[]{"\n"};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)after, (String[])$i$f$emptyArray3, (boolean)false, (int)0, (int)6, null);
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            }
            return this.getDiff(stringArray2, stringArray, windowSize, diffCompatMode, diffCompatMode2);
        }

        public static /* synthetic */ String getDiff$default(Companion companion, String string, String string2, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = false;
            }
            return companion.getDiff(string, string2, n, bl, bl2);
        }

        @NotNull
        public final String getDiff(@NotNull String[] before, @NotNull String[] after, int windowSize, boolean diffCompatMode, boolean diffCompatMode2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            StringBuilder sb = new StringBuilder();
            int n2 = before.length;
            int m = after.length;
            int n3 = 0;
            int n4 = n2 + 1;
            int[][] nArrayArray = new int[n4][];
            while (n3 < n4) {
                n = n3++;
                nArrayArray[n] = new int[m + 1];
            }
            int[][] lcs = nArrayArray;
            for (int i = n2 - 1; -1 < i; --i) {
                for (int j = m - 1; -1 < j; --j) {
                    lcs[i][j] = Intrinsics.areEqual((Object)before[i], (Object)after[j]) ? lcs[i + 1][j + 1] + 1 : Math.max(lcs[i + 1][j], lcs[i][j + 1]);
                }
            }
            int lastLine = Integer.MIN_VALUE;
            int i = 0;
            int j = 0;
            while (i < n2 && j < m) {
                if (Intrinsics.areEqual((Object)before[i], (Object)after[j])) {
                    ++i;
                    ++j;
                    continue;
                }
                if (lastLine < i - 1 || !diffCompatMode2 && lastLine == i - 1 && windowSize == 0) {
                    sb.append("@@ -");
                    sb.append(String.valueOf(i + 1));
                    sb.append(" +");
                    sb.append(String.valueOf(j + 1));
                    sb.append('\n');
                }
                com.android.tools.lint.checks.infrastructure.TestLintResult$Companion.getDiff$appendContext(windowSize, before, diffCompatMode, sb, RangesKt.until((int)Math.max(lastLine, Math.max(0, i - windowSize)), (int)i));
                while (i < n2 && j < m && !Intrinsics.areEqual((Object)before[i], (Object)after[j])) {
                    if (lcs[i + 1][j] >= lcs[i][j + 1]) {
                        sb.append('-');
                        if (((CharSequence)((Object)StringsKt.trim((CharSequence)before[i])).toString()).length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(((Object)StringsKt.trimEnd((CharSequence)before[i])).toString());
                        sb.append('\n');
                        ++i;
                        continue;
                    }
                    sb.append('+');
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)after[j])).toString()).length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(((Object)StringsKt.trimEnd((CharSequence)after[j])).toString());
                    sb.append('\n');
                    ++j;
                }
                if (diffCompatMode) {
                    com.android.tools.lint.checks.infrastructure.TestLintResult$Companion.getDiff$appendContext(windowSize, before, diffCompatMode, sb, RangesKt.until((int)i, (int)Math.min(n2, i + windowSize)));
                    continue;
                }
                lastLine = i;
                for (int window = 0; window < windowSize; ++window) {
                    int xi = i + window;
                    int xj = j + window;
                    if (xi == n2 || xj == m || !Intrinsics.areEqual((Object)before[xi], (Object)after[xj])) break;
                    ++lastLine;
                }
                com.android.tools.lint.checks.infrastructure.TestLintResult$Companion.getDiff$appendContext(windowSize, before, diffCompatMode, sb, RangesKt.until((int)i, (int)lastLine));
            }
            if (i < n2 || j < m) {
                int n5 = n = i == n2 || j == m ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (lastLine < i - 1) {
                    sb.append("@@ -");
                    sb.append(String.valueOf(i + 1));
                    sb.append(" +");
                    sb.append(String.valueOf(j + 1));
                    sb.append('\n');
                }
                if (!diffCompatMode) {
                    com.android.tools.lint.checks.infrastructure.TestLintResult$Companion.getDiff$appendContext(windowSize, before, diffCompatMode, sb, RangesKt.until((int)Math.max(lastLine, Math.max(0, i - windowSize)), (int)i));
                }
                while (i < n2) {
                    sb.append('-');
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)before[i])).toString()).length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(before[i]);
                    sb.append('\n');
                    ++i;
                }
                while (j < m) {
                    sb.append('+');
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)after[j])).toString()).length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(after[j]);
                    sb.append('\n');
                    ++j;
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }

        public static /* synthetic */ String getDiff$default(Companion companion, String[] stringArray, String[] stringArray2, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = false;
            }
            return companion.getDiff(stringArray, stringArray2, n, bl, bl2);
        }

        private static final void getDiff$appendContext(int $windowSize, String[] $before, boolean $diffCompatMode, StringBuilder sb, IntRange intRange) {
            int n;
            int context;
            if ($windowSize > 0 && (context = intRange.getFirst()) <= (n = intRange.getLast())) {
                while (true) {
                    String line2 = ((Object)StringsKt.trimEnd((CharSequence)$before[context])).toString();
                    if ($diffCompatMode || ((CharSequence)line2).length() > 0) {
                        sb.append("  ").append(line2);
                    }
                    sb.append("\n");
                    if (context == n) break;
                    ++context;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

