/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.infrastructure.BytecodeTestFile;
import com.android.tools.lint.checks.infrastructure.CompiledSourceFile;
import com.android.tools.lint.checks.infrastructure.KlibTestFile;
import com.android.tools.lint.checks.infrastructure.KotlinClasspathKt;
import com.android.tools.lint.checks.infrastructure.MavenLibrary;
import com.android.tools.lint.checks.infrastructure.StubClassFile;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.android.tools.lint.checks.infrastructure.TestResourceProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J1\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0015J9\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J%\u0010\u001d\u001a\u00020\n2\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\"\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u001fJ1\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0015J9\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0007J \u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020\nH\u0007J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J)\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0007\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u0002012\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u001a\u00100\u001a\u0002012\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u0012\u00102\u001a\u00020\n2\b\b\u0001\u00103\u001a\u00020\u0006H\u0007J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J \u00105\u001a\u0002062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0007J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J)\u0010<\u001a\u00020=2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010?J\u0012\u0010@\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u001a\u0010@\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J)\u0010A\u001a\u00020B2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010CJ=\u0010A\u001a\u00020B2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u0001082\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010DJ\u0012\u0010E\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u001a\u0010E\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u0012\u0010F\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\u001a\u0010F\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J\b\u0010G\u001a\u00020HH\u0007J\u0012\u0010G\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J3\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u00062\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J8\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010K\u001a\u00020LH\u0007J)\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u00062\u0012\u0010O\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010PJ\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010Q\u001a\u00020\u00062\u0006\u0010%\u001a\u00020;H\u0007J\u0010\u0010Q\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010R\u001a\u00020\u00062\u0006\u0010%\u001a\u00020;H\u0007J\u0010\u0010R\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J(\u0010S\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u000fH\u0007J(\u0010W\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u000fH\u0007J\u0015\u0010Y\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bZJ\u0010\u0010[\u001a\u00020\u00062\u0006\u0010%\u001a\u00020;H\u0007J\u0010\u0010[\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u00103\u001a\u00020\u0006H\u0007J\u001a\u0010\\\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007\u00a8\u0006^"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestFiles;", "", "()V", "base64", "Lcom/android/tools/lint/checks/infrastructure/TestFile$BinaryTestFile;", "to", "", "encoded", "base64gzip", "binaryStub", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "into", "source", "", "byteOnly", "", "(Ljava/lang/String;[Lcom/android/tools/lint/checks/infrastructure/TestFile;Z)Lcom/android/tools/lint/checks/infrastructure/TestFile;", "stubSources", "", "compileOnly", "bytecode", "(Ljava/lang/String;Lcom/android/tools/lint/checks/infrastructure/TestFile;[Ljava/lang/String;)Lcom/android/tools/lint/checks/infrastructure/TestFile;", "checksum", "", "(Ljava/lang/String;Lcom/android/tools/lint/checks/infrastructure/TestFile;J[Ljava/lang/String;)Lcom/android/tools/lint/checks/infrastructure/TestFile;", "producer", "Lcom/android/tools/lint/checks/infrastructure/TestFile$BytecodeProducer;", "bytes", "", "classpath", "extraLibraries", "([Ljava/lang/String;)Lcom/android/tools/lint/checks/infrastructure/TestFile;", "compiled", "copy", "from", "resourceProvider", "Lcom/android/tools/lint/checks/infrastructure/TestResourceProvider;", "file", "getByteProducerForBase64gzip", "Lcom/android/tools/lint/checks/infrastructure/TestFile$ByteProducer;", "getByteProducerForHexBytes", "getCompileType", "Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;", "default", "sources", "(Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;", "getLintClassPath", "()[Lcom/android/tools/lint/checks/infrastructure/TestFile;", "gradle", "Lcom/android/tools/lint/checks/infrastructure/TestFile$GradleTestFile;", "gradleToml", "toml", "hexBytes", "image", "Lcom/android/tools/lint/checks/infrastructure/TestFile$ImageTestFile;", "width", "", "height", "isLintJar", "Ljava/io/File;", "jar", "Lcom/android/tools/lint/checks/infrastructure/TestFile$JarTestFile;", "files", "(Ljava/lang/String;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lcom/android/tools/lint/checks/infrastructure/TestFile$JarTestFile;", "java", "klib", "Lcom/android/tools/lint/checks/infrastructure/KlibTestFile;", "(Ljava/lang/String;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lcom/android/tools/lint/checks/infrastructure/KlibTestFile;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lcom/android/tools/lint/checks/infrastructure/KlibTestFile;", "kotlin", "kt", "manifest", "Lcom/android/tools/lint/checks/infrastructure/TestFile$ManifestTestFile;", "mavenLibrary", "artifact", "projectProperties", "Lcom/android/tools/lint/checks/infrastructure/TestFile$PropertyTestFile;", "rClass", "pkg", "urls", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/android/tools/lint/checks/infrastructure/TestFile;", "toBase64", "toBase64gzip", "toBase64gzipJava", "indent", "indentStart", "includeEmptyPrefix", "toBase64gzipKotlin", "includeQuotes", "toBase64gzipString", "toBase64gzipString$lint_tests", "toHexBytes", "xml", "LibraryReferenceTestFile", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTestFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestFiles.kt\ncom/android/tools/lint/checks/infrastructure/TestFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,640:1\n1#2:641\n37#3,2:642\n37#3,2:644\n37#3,2:646\n*S KotlinDebug\n*F\n+ 1 TestFiles.kt\ncom/android/tools/lint/checks/infrastructure/TestFiles\n*L\n486#1:642,2\n516#1:644,2\n602#1:646,2\n*E\n"})
public final class TestFiles {
    @NotNull
    public static final TestFiles INSTANCE = new TestFiles();

    private TestFiles() {
    }

    @JvmStatic
    @NotNull
    public static final TestFile file() {
        return new TestFile();
    }

    @JvmStatic
    @NotNull
    public static final TestFile source(@NotNull String to, @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        TestFile testFile = INSTANCE.file().to(to).withSource(source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"withSource(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile java(@NotNull String to, @Language(value="JAVA") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        TestFile testFile = TestFile.JavaTestFile.create(to, source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"create(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile java(@Language(value="JAVA") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        TestFile testFile = TestFile.JavaTestFile.create(source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"create(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile kt(@Language(value="kotlin") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return TestFiles.kotlin(source2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile kt(@NotNull String to, @Language(value="kotlin") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return TestFiles.kotlin(to, source2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile kotlin(@Language(value="kotlin") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        TestFile testFile = TestFile.KotlinTestFile.create(source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"create(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile kotlin(@NotNull String to, @Language(value="kotlin") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        TestFile testFile = TestFile.KotlinTestFile.create(to, source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"create(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile xml(@NotNull String to, @Language(value="XML") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        if (!StringsKt.endsWith$default((String)to, (String)".xml", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "Expected .xml suffix for XML test file";
            throw new IllegalArgumentException(string.toString());
        }
        TestFile testFile = TestFile.XmlTestFile.create(to, source2);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"create(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile copy(@NotNull String from, @NotNull TestResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        TestFile testFile = INSTANCE.file().from(from, resourceProvider).to(from);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"to(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile copy(@NotNull String from, @NotNull String to, @NotNull TestResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        TestFile testFile = INSTANCE.file().from(from, resourceProvider).to(to);
        Intrinsics.checkNotNullExpressionValue((Object)testFile, (String)"to(...)");
        return testFile;
    }

    @JvmStatic
    @NotNull
    public static final TestFile.GradleTestFile gradle(@NotNull String to, @Language(value="Groovy") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return new TestFile.GradleTestFile(to, source2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile.GradleTestFile gradle(@Language(value="Groovy") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return new TestFile.GradleTestFile("build.gradle", source2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile gradleToml(@Language(value="TOML") @NotNull String toml) {
        Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
        return TestFiles.source("../gradle/libs.versions.toml", toml);
    }

    @JvmStatic
    @NotNull
    public static final TestFile toml(@NotNull String into, @Language(value="TOML") @NotNull String toml) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
        return TestFiles.source(into, toml);
    }

    @JvmStatic
    @NotNull
    public static final TestFile.ManifestTestFile manifest() {
        return new TestFile.ManifestTestFile();
    }

    @JvmStatic
    @NotNull
    public static final TestFile manifest(@Language(value="XML") @NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return TestFiles.source("AndroidManifest.xml", source2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile.PropertyTestFile projectProperties() {
        return new TestFile.PropertyTestFile();
    }

    @JvmStatic
    @NotNull
    public static final TestFile.BinaryTestFile bytecode(@NotNull String to, @NotNull TestFile.BytecodeProducer producer2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)producer2, (String)"producer");
        return new TestFile.BinaryTestFile(to, producer2);
    }

    @JvmStatic
    @NotNull
    public static final TestFile rClass(@NotNull String pkg, String ... urls) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        if (ResourceUrl.parse((String)pkg) != null) {
            Assert.fail((String)("The argument in rClass should be a package! (was " + pkg + ")"));
        }
        int id = 2130968576;
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(pkg).append(";\n");
        sb.append("public final class R {\n");
        Map map = new EnumMap(ResourceType.class);
        int n = urls.length;
        for (int i = 0; i < n; ++i) {
            String url = urls[i];
            ResourceUrl reference = ResourceUrl.parse((String)url);
            Assert.assertNotNull((String)("Resource reference was not a valid URL: " + url), (Object)reference);
            ResourceUrl resourceUrl = reference;
            Intrinsics.checkNotNull((Object)resourceUrl);
            Object v = map.computeIfAbsent(resourceUrl.type, rClass.list.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(v, (String)"computeIfAbsent(...)");
            List list2 = (List)v;
            list2.add(reference);
        }
        for (ResourceType type : ResourceType.values()) {
            List resources;
            if ((List)map.get(type) == null) continue;
            sb.append("    public static final class ").append(type).append(" {\n");
            for (ResourceUrl resource : resources) {
                StringBuilder stringBuilder = sb.append("        public static final int ");
                ResourceUrl resourceUrl = resource;
                Intrinsics.checkNotNull((Object)resourceUrl);
                stringBuilder.append(resourceUrl.name).append(" = 0x").append(Integer.toHexString(id++)).append(";\n");
            }
            sb.append("    }\n");
        }
        sb.append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return TestFiles.java(string);
    }

    @JvmStatic
    @NotNull
    public static final TestFile.BinaryTestFile bytes(@NotNull String to, @NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        TestFile.BytecodeProducer producer2 = new TestFile.BytecodeProducer(bytes2){
            final /* synthetic */ byte[] $bytes;
            {
                this.$bytes = $bytes;
            }

            @NotNull
            public byte[] produce() {
                return this.$bytes;
            }
        };
        return new TestFile.BinaryTestFile(to, producer2);
    }

    @JvmStatic
    @NotNull
    public static final String toBase64(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        String base642 = Base64.getEncoder().encodeToString(bytes2);
        return "\"\"\n+ \"" + Joiner.on((String)"\"\n+ \"").join(Splitter.fixedLength((int)60).split((CharSequence)base642)) + "\"";
    }

    @JvmStatic
    @NotNull
    public static final String toBase64gzip(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return TestFiles.toBase64gzipJava(bytes2, 0, false, true);
    }

    @JvmStatic
    @NotNull
    public static final String toBase64gzipJava(@NotNull byte[] bytes2, int indent, boolean indentStart, boolean includeEmptyPrefix) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        String base642 = INSTANCE.toBase64gzipString$lint_tests(bytes2);
        StringBuilder indentString = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentString.append(' ');
        }
        Iterable lines2 = Splitter.fixedLength((int)60).split((CharSequence)base642);
        StringBuilder result = new StringBuilder();
        if (indentStart) {
            result.append((CharSequence)indentString);
        }
        if (includeEmptyPrefix) {
            result.append("\"\" +\n");
            result.append((CharSequence)indentString);
        }
        result.append("\"");
        String separator = "\" +\n" + indentString + "\"";
        result.append(Joiner.on((String)separator).join(lines2));
        result.append("\"");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String toBase64gzipKotlin(@NotNull byte[] bytes2, int indent, boolean indentStart, boolean includeQuotes) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        String base642 = StringsKt.replace$default((String)INSTANCE.toBase64gzipString$lint_tests(bytes2), (char)'$', (char)'\uff04', (boolean)false, (int)4, null);
        StringBuilder indentString = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentString.append(' ');
        }
        Iterable lines2 = Splitter.fixedLength((int)60).split((CharSequence)base642);
        StringBuilder result = new StringBuilder();
        if (indentStart) {
            result.append((CharSequence)indentString);
        }
        if (includeQuotes) {
            result.append("\"\"\"\n");
            result.append((CharSequence)indentString);
        }
        result.append(Joiner.on((String)("\n" + indentString)).join(lines2));
        if (includeQuotes) {
            result.append("\"\"\"");
        }
        result.append("\n");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String toBase64gzipString$lint_tests(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream(out);
        Throwable throwable = null;
        try {
            GZIPOutputStream stream = (GZIPOutputStream)closeable;
            boolean bl = false;
            stream.write(bytes2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] gzipped = out.toByteArray();
        String string = Base64.getEncoder().encodeToString(gzipped);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return StringsKt.replace$default((String)string, (char)'$', (char)'\uff04', (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final String toBase64(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TestFiles.toBase64(FilesKt.readBytes((File)file));
    }

    @JvmStatic
    @NotNull
    public static final String toBase64gzip(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TestFiles.toBase64gzip(FilesKt.readBytes((File)file));
    }

    @JvmStatic
    @NotNull
    public static final String toHexBytes(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TestFiles.toHexBytes(FilesKt.readBytes((File)file));
    }

    @JvmStatic
    @NotNull
    public static final String toHexBytes(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        StringBuilder sb = new StringBuilder();
        int column = 0;
        sb.append('\"');
        for (byte b : bytes2) {
            String hex;
            int i = b & 0xFF;
            String string = hex = Integer.toHexString(i);
            Intrinsics.checkNotNull((Object)string);
            hex = CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)string);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            if ((column += 2) <= 60) continue;
            sb.append("\\n\" +\n\"");
            column = 0;
        }
        sb.append('\"');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @Deprecated(message="Use {@link #base64gzip(String, String)} instead")
    @NotNull
    public static final TestFile.BinaryTestFile base64(@NotNull String to, @NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        String escaped = StringsKt.replace$default((String)encoded, (char)'\uff04', (char)'$', (boolean)false, (int)4, null);
        byte[] bytes2 = Base64.getDecoder().decode(escaped);
        return new TestFile.BinaryTestFile(to, new TestFile.BytecodeProducer(bytes2){
            final /* synthetic */ byte[] $bytes;
            {
                this.$bytes = $bytes;
            }

            @NotNull
            public byte[] produce() {
                Intrinsics.checkNotNullExpressionValue((Object)this.$bytes, (String)"$bytes");
                return this.$bytes;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final TestFile.BinaryTestFile base64gzip(@NotNull String to, @NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        return new TestFile.BinaryTestFile(to, TestFiles.getByteProducerForBase64gzip(encoded));
    }

    @JvmStatic
    @NotNull
    public static final TestFile.ByteProducer getByteProducerForBase64gzip(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)encoded, (char)'\uff04', (char)'$', (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\t", (String)"", (boolean)false, (int)4, null);
        byte[] gzipBytes = Base64.getDecoder().decode(escaped);
        try {
            GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(gzipBytes));
            byte[] bytes2 = ByteStreams.toByteArray((InputStream)stream);
            return new TestFile.BytecodeProducer(bytes2){
                final /* synthetic */ byte[] $bytes;
                {
                    this.$bytes = $bytes;
                }

                @NotNull
                public byte[] produce() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.$bytes, (String)"$bytes");
                    return this.$bytes;
                }
            };
        }
        catch (ZipException e) {
            Intrinsics.checkNotNull((Object)gzipBytes);
            String message = "The unit test data is not in gzip format. Perhaps this was\nencoded using base64() instead of base64gzip? If so, the base64gzip data\nshould have been:\n" + TestFiles.toBase64gzip(gzipBytes);
            throw new IllegalStateException(message.toString());
        }
    }

    @JvmStatic
    @NotNull
    public static final TestFile.BinaryTestFile hexBytes(@NotNull String to, @NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        return new TestFile.BinaryTestFile(to, TestFiles.getByteProducerForHexBytes(encoded));
    }

    @JvmStatic
    @NotNull
    public static final TestFile.ByteProducer getByteProducerForHexBytes(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)encoded, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\t", (String)"", (boolean)false, (int)4, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < escaped.length(); i += 2) {
            String string = escaped.substring(i, i + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int b = Integer.parseInt(string, CharsKt.checkRadix((int)16));
            out.write(b);
        }
        byte[] finalBytes = out.toByteArray();
        return new TestFile.BytecodeProducer(finalBytes){
            final /* synthetic */ byte[] $finalBytes;
            {
                this.$finalBytes = $finalBytes;
            }

            @NotNull
            public byte[] produce() {
                Intrinsics.checkNotNullExpressionValue((Object)this.$finalBytes, (String)"$finalBytes");
                return this.$finalBytes;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final TestFile classpath(String ... extraLibraries) {
        Intrinsics.checkNotNullParameter((Object)extraLibraries, (String)"extraLibraries");
        String newline = "\n";
        String source2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"src\" path=\"gen\"/>\n    <classpathentry kind=\"con\" path=\"com.android.ide.eclipse.adt.ANDROID_FRAMEWORK\"/>\n    <classpathentry kind=\"con\" path=\"com.android.ide.eclipse.adt.LIBRARIES\"/>\n    <classpathentry kind=\"output\" path=\"bin/classes\"/>\n    <classpathentry kind=\"output\" path=\"build/intermediates/javac/debug/classes\"/>\n" + ArraysKt.joinToString$default((Object[])extraLibraries, (CharSequence)newline, null, null, (int)0, null, (Function1)classpath.source.1.INSTANCE, (int)30, null) + "\n</classpath>";
        return TestFiles.source(".classpath", source2);
    }

    @JvmStatic
    @NotNull
    public static final KlibTestFile klib(@NotNull String to, TestFile ... files2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        return TestFiles.klib(to, null, null, Arrays.copyOf(files2, files2.length));
    }

    @JvmStatic
    @NotNull
    public static final KlibTestFile klib(@NotNull String to, @Nullable String encoded, @Nullable Integer checksum, TestFile ... files2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        return new KlibTestFile(to, encoded, checksum, Arrays.copyOf(files2, files2.length));
    }

    @JvmStatic
    @NotNull
    public static final TestFile.JarTestFile jar(@NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return new TestFile.JarTestFile(to);
    }

    @JvmStatic
    @NotNull
    public static final TestFile binaryStub(@NotNull String into, @NotNull TestFile[] source2, boolean byteOnly) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return TestFiles.binaryStub(into, ArraysKt.toList((Object[])source2), CollectionsKt.emptyList(), byteOnly);
    }

    public static /* synthetic */ TestFile binaryStub$default(String string, TestFile[] testFileArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return TestFiles.binaryStub(string, testFileArray, bl);
    }

    @JvmStatic
    @NotNull
    public static final TestFile binaryStub(@NotNull String into, @NotNull List<? extends TestFile> stubSources, @NotNull List<? extends TestFile> compileOnly, boolean byteOnly) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter(stubSources, (String)"stubSources");
        Intrinsics.checkNotNullParameter(compileOnly, (String)"compileOnly");
        BytecodeTestFile.Type type = byteOnly ? BytecodeTestFile.Type.BYTECODE_ONLY : BytecodeTestFile.Type.SOURCE_AND_BYTECODE;
        Collection $this$toTypedArray$iv = stubSources;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TestFile[] testFileArray = thisCollection$iv.toArray(new TestFile[0]);
        BytecodeTestFile.Type type2 = INSTANCE.getCompileType(type, Arrays.copyOf(testFileArray, testFileArray.length));
        return new StubClassFile(into, type2, stubSources, compileOnly);
    }

    public static /* synthetic */ TestFile binaryStub$default(String string, List list2, List list3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return TestFiles.binaryStub(string, list2, list3, bl);
    }

    @JvmStatic
    @NotNull
    public static final TestFile mavenLibrary(@NotNull String artifact, @NotNull List<? extends TestFile> stubSources, @NotNull List<? extends TestFile> compileOnly, boolean byteOnly) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter(stubSources, (String)"stubSources");
        Intrinsics.checkNotNullParameter(compileOnly, (String)"compileOnly");
        BytecodeTestFile.Type type = byteOnly ? BytecodeTestFile.Type.BYTECODE_ONLY : BytecodeTestFile.Type.SOURCE_AND_BYTECODE;
        Collection $this$toTypedArray$iv = stubSources;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TestFile[] testFileArray = thisCollection$iv.toArray(new TestFile[0]);
        BytecodeTestFile.Type type2 = INSTANCE.getCompileType(type, Arrays.copyOf(testFileArray, testFileArray.length));
        return new MavenLibrary(artifact, type2, stubSources, compileOnly);
    }

    public static /* synthetic */ TestFile mavenLibrary$default(String string, List list2, List list3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return TestFiles.mavenLibrary(string, list2, list3, bl);
    }

    @JvmStatic
    @NotNull
    public static final TestFile mavenLibrary(@NotNull String artifact, @NotNull TestFile[] files2, boolean byteOnly) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        BytecodeTestFile.Type type = byteOnly ? BytecodeTestFile.Type.BYTECODE_ONLY : BytecodeTestFile.Type.SOURCE_AND_BYTECODE;
        BytecodeTestFile.Type type2 = INSTANCE.getCompileType(type, Arrays.copyOf(files2, files2.length));
        return new MavenLibrary(artifact, type2, CollectionsKt.listOf((Object[])Arrays.copyOf(files2, files2.length)), CollectionsKt.emptyList());
    }

    public static /* synthetic */ TestFile mavenLibrary$default(String string, TestFile[] testFileArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return TestFiles.mavenLibrary(string, testFileArray, bl);
    }

    @Deprecated(message="")
    @JvmStatic
    @NotNull
    public static final TestFile compiled(@NotNull String into, @NotNull TestFile source2, String ... encoded) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        TestFile[] testFileArray = new TestFile[]{source2};
        BytecodeTestFile.Type type = INSTANCE.getCompileType(BytecodeTestFile.Type.SOURCE_AND_BYTECODE, testFileArray);
        return new CompiledSourceFile(into, type, source2, null, encoded);
    }

    @JvmStatic
    @NotNull
    public static final TestFile compiled(@NotNull String into, @NotNull TestFile source2, long checksum, String ... encoded) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        TestFile[] testFileArray = new TestFile[]{source2};
        BytecodeTestFile.Type type = INSTANCE.getCompileType(BytecodeTestFile.Type.SOURCE_AND_BYTECODE, testFileArray);
        return new CompiledSourceFile(into, type, source2, checksum, encoded);
    }

    @Deprecated(message="")
    @JvmStatic
    @NotNull
    public static final TestFile bytecode(@NotNull String into, @NotNull TestFile source2, String ... encoded) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        TestFile[] testFileArray = new TestFile[]{source2};
        BytecodeTestFile.Type type = INSTANCE.getCompileType(BytecodeTestFile.Type.BYTECODE_ONLY, testFileArray);
        return new CompiledSourceFile(into, type, source2, null, encoded);
    }

    @JvmStatic
    @NotNull
    public static final TestFile bytecode(@NotNull String into, @NotNull TestFile source2, long checksum, String ... encoded) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        TestFile[] testFileArray = new TestFile[]{source2};
        BytecodeTestFile.Type type = INSTANCE.getCompileType(BytecodeTestFile.Type.BYTECODE_ONLY, testFileArray);
        return new CompiledSourceFile(into, type, source2, checksum, encoded);
    }

    private final BytecodeTestFile.Type getCompileType(BytecodeTestFile.Type type, TestFile ... sources) {
        for (TestFile source2 : sources) {
            String targetRelativePath = source2.targetRelativePath;
            Intrinsics.checkNotNull((Object)targetRelativePath);
            if (!StringsKt.endsWith$default((String)targetRelativePath, (String)".java", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)targetRelativePath, (String)".kt", (boolean)false, (int)2, null)) continue;
            return type;
        }
        return BytecodeTestFile.Type.RESOURCE;
    }

    @JvmStatic
    @NotNull
    public static final TestFile.JarTestFile jar(@NotNull String to, TestFile ... files2) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        if (!(StringsKt.endsWith$default((String)to, (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)to, (String)".zip", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Expected .jar/.zip suffix for jar test file";
            throw new IllegalArgumentException(string.toString());
        }
        TestFile.JarTestFile jar = new TestFile.JarTestFile(to);
        jar.files(Arrays.copyOf(files2, files2.length));
        return jar;
    }

    @JvmStatic
    @NotNull
    public static final TestFile.ImageTestFile image(@NotNull String to, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return new TestFile.ImageTestFile(to, width, height);
    }

    @JvmStatic
    @NotNull
    public static final TestFile[] getLintClassPath() {
        List paths = new ArrayList();
        List<File> libraries2 = KotlinClasspathKt.findFromRuntimeClassPath((Function1<? super File, Boolean>)((Function1)getLintClassPath.libraries.1.INSTANCE));
        for (File file : libraries2) {
            TestFile testFile = new LibraryReferenceTestFile(file);
            paths.add(testFile);
        }
        Collection $this$toTypedArray$iv = paths;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TestFile[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLintJar(File file) {
        String name = file.getName();
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"lint-", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"kotlin-compiler", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"uast-", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"intellij-core", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"uast.jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"android.sdktools.lint", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)".lint-api-base", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"lint-api.jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)".lint.checks-base", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"lint-checks.jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)".lint-model-base", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"lint-model.jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"lint-model", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)".testutils", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"testutils.jar", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"testutils-", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)".lint.tests", (boolean)false, (int)2, null)) return true;
        if (StringsKt.endsWith$default((String)name, (String)"lint-tests.jar", (boolean)false, (int)2, null)) return true;
        if (Intrinsics.areEqual((Object)name, (Object)"main")) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"lint-tests", (boolean)false, (int)2, null)) return true;
        }
        if (!StringsKt.endsWith$default((String)name, (String)".lint.cli", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isLintJar(TestFiles $this, File file) {
        return $this.isLintJar(file);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestFiles$LibraryReferenceTestFile;", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "to", "", "(Ljava/lang/String;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "lint-tests"})
    public static final class LibraryReferenceTestFile
    extends TestFile {
        @NotNull
        private final File file;

        public LibraryReferenceTestFile(@NotNull String to, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.targetRelativePath = to;
            this.file = file;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public LibraryReferenceTestFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this(string, file);
        }
    }
}

