/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.TestConfigurationKt;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J*\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\bH\u0016J\u001a\u0010%\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u0013H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Lcom/android/tools/lint/client/api/ConfigurationHierarchy;)V", "value", "Ljava/io/File;", "baselineFile", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "addConfiguredIssues", "", "targetMap", "", "", "Lcom/android/tools/lint/detector/api/Severity;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "specificOnly", "", "getDefinedSeverity", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "visibleDefault", "ignore", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "file", "issueId", "setSeverity", "severity", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTestConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestConfiguration.kt\ncom/android/tools/lint/checks/infrastructure/TestConfiguration\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,137:1\n26#2:138\n26#2:139\n*S KotlinDebug\n*F\n+ 1 TestConfiguration.kt\ncom/android/tools/lint/checks/infrastructure/TestConfiguration\n*L\n47#1:138\n77#1:139\n*E\n"})
public final class TestConfiguration
extends Configuration {
    @NotNull
    private final TestLintTask task;

    public TestConfiguration(@NotNull TestLintTask task, @NotNull ConfigurationHierarchy configurations) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        super(configurations);
        this.task = task;
    }

    @NotNull
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source2, @NotNull Severity visibleDefault) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)visibleDefault, (String)"visibleDefault");
        Severity override = TestConfigurationKt.overrideSeverity(this.task, issue, visibleDefault);
        if (override != null) {
            return override;
        }
        Severity severity = super.getDefinedSeverity(issue, source2, visibleDefault);
        if (severity != null) {
            return severity;
        }
        String[] stringArray2 = this.task.issueIds;
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        for (String id : stringArray) {
            if (!Intrinsics.areEqual((Object)issue.getId(), (Object)id)) continue;
            return TestConfigurationKt.getNonIgnoredSeverity(visibleDefault, issue);
        }
        return this.task.getCheckedIssues().contains(issue) ? TestConfigurationKt.getNonIgnoredSeverity(visibleDefault, issue) : Severity.IGNORE;
    }

    public void addConfiguredIssues(@NotNull Map<String, Severity> targetMap, @NotNull IssueRegistry registry, boolean specificOnly) {
        block7: {
            String[] stringArray;
            Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Configuration configuration = this.getParent();
            if (configuration != null) {
                configuration.addConfiguredIssues(targetMap, registry, specificOnly);
            }
            for (Issue issue : registry.getIssues()) {
                Severity override = TestConfigurationKt.overrideSeverity(this.task, issue, issue.getDefaultSeverity());
                if (override != null) {
                    targetMap.put(issue.getId(), override);
                    continue;
                }
                Configuration configuration2 = this.getParent();
                Severity inherited = configuration2 != null ? Configuration.getDefinedSeverity$default((Configuration)configuration2, (Issue)issue, (Configuration)this, null, (int)4, null) : null;
                if (inherited == null) continue;
                targetMap.put(issue.getId(), inherited);
            }
            String[] stringArray2 = this.task.issueIds;
            if (stringArray2 == null) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            } else {
                stringArray = stringArray2;
            }
            for (String id : stringArray) {
                Intrinsics.checkNotNull((Object)id);
                Issue issue = registry.getIssue(id);
                if (issue != null) {
                    targetMap.put(id, TestConfigurationKt.getNonIgnoredSeverity(issue.getDefaultSeverity(), issue));
                    continue;
                }
                targetMap.put(id, Severity.WARNING);
            }
            Configuration configuration3 = this.getOverrides();
            if (configuration3 == null) break block7;
            configuration3.addConfiguredIssues(targetMap, registry, specificOnly);
        }
    }

    public void ignore(@NotNull Context context, @NotNull Issue issue, @Nullable Location location, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Assert.fail((String)"Not supported in tests.");
    }

    @Nullable
    public File getBaselineFile() {
        return null;
    }

    public void setBaselineFile(@Nullable File value) {
        Assert.fail((String)"Not supported in tests.");
    }

    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Assert.fail((String)"Not supported in tests.");
    }

    public void ignore(@NotNull Issue issue, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Assert.fail((String)"Not supported in tests.");
    }

    public void ignore(@NotNull String issueId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Assert.fail((String)"Not supported in tests.");
    }
}

