/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.BytecodeTestFile;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002J\u0014\u0010\u001a\u001a\u00020\u00172\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u0011\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0006\u0010%\u001a\u00020&J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0096\u0002J\u001e\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0006\u0010+\u001a\u00020\u0017R\"\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ProjectDescriptionList;", "", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "projects", "", "reportFrom", "(Ljava/util/List;Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;)V", "<set-?>", "implicitReportFrom", "getImplicitReportFrom", "()Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "getProjects", "()Ljava/util/List;", "setProjects", "(Ljava/util/List;)V", "getReportFrom", "setReportFrom", "(Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;)V", "size", "", "getSize", "()I", "addNamedDependencies", "", "addProject", "project", "addProjects", "", "assignProjectNames", "expandProjects", "defaultType", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription$Type;", "get", "index", "getProjectNames", "", "", "isEmpty", "", "iterator", "", "pickUniqueName", "usedNames", "sort", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nProjectDescriptionList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDescriptionList.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescriptionList\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,251:1\n37#2,2:252\n37#2,2:254\n*S KotlinDebug\n*F\n+ 1 ProjectDescriptionList.kt\ncom/android/tools/lint/checks/infrastructure/ProjectDescriptionList\n*L\n137#1:252,2\n150#1:254,2\n*E\n"})
public final class ProjectDescriptionList
implements Iterable<ProjectDescription>,
KMappedMarker {
    @NotNull
    private List<ProjectDescription> projects;
    @Nullable
    private ProjectDescription reportFrom;
    @Nullable
    private ProjectDescription implicitReportFrom;

    public ProjectDescriptionList(@NotNull List<ProjectDescription> projects, @Nullable ProjectDescription reportFrom) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        this.projects = projects;
        this.reportFrom = reportFrom;
    }

    public /* synthetic */ ProjectDescriptionList(List list2, ProjectDescription projectDescription, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 2) != 0) {
            projectDescription = null;
        }
        this(list2, projectDescription);
    }

    @NotNull
    public final List<ProjectDescription> getProjects() {
        return this.projects;
    }

    public final void setProjects(@NotNull List<ProjectDescription> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.projects = list2;
    }

    @Nullable
    public final ProjectDescription getReportFrom() {
        return this.reportFrom;
    }

    public final void setReportFrom(@Nullable ProjectDescription projectDescription) {
        this.reportFrom = projectDescription;
    }

    @Nullable
    public final ProjectDescription getImplicitReportFrom() {
        return this.implicitReportFrom;
    }

    public final int getSize() {
        return this.projects.size();
    }

    public final boolean isEmpty() {
        return this.projects.isEmpty();
    }

    @NotNull
    public final ProjectDescription get(int index) {
        return this.projects.get(index);
    }

    public final void addProject(@Nullable ProjectDescription project) {
        if (project != null && !this.projects.contains(project)) {
            this.projects.add(project);
        }
    }

    public final void addProjects(@NotNull List<ProjectDescription> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        for (ProjectDescription project : projects) {
            this.addProject(project);
            this.addProjects(project.getDependsOn());
        }
    }

    public final void expandProjects(@NotNull ProjectDescription.Type defaultType) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultType), (String)"defaultType");
        List allProjects = new ArrayList(this.projects);
        Map nameMap = new HashMap();
        for (ProjectDescription project : allProjects) {
            nameMap.put(project.getName(), project);
        }
        List added = new ArrayList();
        for (ProjectDescription project : allProjects) {
            TestFile[] files2 = project.getFiles();
            List filtered = new ArrayList();
            for (TestFile file : files2) {
                String path = file.targetRelativePath;
                Intrinsics.checkNotNull((Object)path);
                if (!(!StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)3, (boolean)false, (int)4, null) == -1 || StringsKt.startsWith$default((String)path, (String)"../gradle/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)path, (String)".versions.toml", (boolean)false, (int)2, null))) {
                    Iterator<TestFile> iterator;
                    String name;
                    Intrinsics.checkNotNullExpressionValue((Object)path.substring(3, StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)3, (boolean)false, (int)4, null)), (String)"substring(...)");
                    ProjectDescription newProject = (ProjectDescription)nameMap.get(name);
                    if (newProject == null) {
                        newProject = new ProjectDescription();
                        newProject.setName(name);
                        nameMap.put(name, newProject);
                        newProject.setPrimary(false);
                        added.add(newProject);
                        if (StringsKt.startsWith$default((String)name, (String)"lib", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"Lib", (boolean)false, (int)2, null)) {
                            project.dependsOn(newProject);
                            newProject.setType(ProjectDescription.Type.LIBRARY);
                            this.implicitReportFrom = project;
                        } else {
                            newProject.dependsOn(project);
                            newProject.setType(ProjectDescription.Type.APP);
                            this.implicitReportFrom = newProject;
                            if (((CharSequence)project.getName()).length() == 0) {
                                project.setType(ProjectDescription.Type.LIBRARY);
                                this.pickUniqueName(this.getProjectNames(), project);
                            }
                        }
                    }
                    if (this.reportFrom == null) {
                        this.reportFrom = StringsKt.startsWith$default((String)name, (String)"app", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"main", (boolean)false, (int)2, null) ? newProject : project;
                    }
                    List list2 = Lists.asList((Object)file, (Object[])newProject.getFiles());
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"asList(...)");
                    Collection $this$toTypedArray$iv = list2;
                    int $i$f$toTypedArray = 0;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    newProject.setFiles(thisCollection$iv.toArray(new TestFile[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)file.targetRelativePath, (String)"targetRelativePath");
                    $i$f$toTypedArray = name.length() + 4;
                    Intrinsics.checkNotNullExpressionValue((Object)((String)((Object)iterator)).substring($i$f$toTypedArray), (String)"substring(...)");
                    file.targetRelativePath = file.targetRelativePath;
                    if (!(file instanceof BytecodeTestFile)) continue;
                    iterator = ((BytecodeTestFile)((Object)file)).getSources().iterator();
                    while (iterator.hasNext()) {
                        String string;
                        TestFile source2 = (TestFile)iterator.next();
                        String string2 = source2.targetRelativePath;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetRelativePath");
                        if (!StringsKt.startsWith$default((String)string2, (String)("../" + name + "/"), (boolean)false, (int)2, null)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)source2.targetRelativePath, (String)"targetRelativePath");
                        int n = name.length() + 4;
                        Intrinsics.checkNotNullExpressionValue((Object)string.substring(n), (String)"substring(...)");
                        source2.targetRelativePath = source2.targetRelativePath;
                    }
                    continue;
                }
                filtered.add(file);
            }
            Collection $this$toTypedArray$iv = filtered;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            project.setFiles(thisCollection$iv.toArray(new TestFile[0]));
        }
        allProjects.addAll(added);
        this.projects = allProjects;
        for (ProjectDescription project : this.projects) {
            if (project.getHaveSetType()) continue;
            project.setType(defaultType);
        }
        this.addNamedDependencies();
    }

    private final Set<String> getProjectNames() {
        Set names = new HashSet();
        for (ProjectDescription project : this.projects) {
            String projectName = project.getName();
            if (((CharSequence)projectName).length() > 0) {
                names.add(projectName);
            }
            for (TestFile file : project.getFiles()) {
                String name;
                String path = file.targetRelativePath;
                Intrinsics.checkNotNull((Object)path);
                if (!StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)3, (boolean)false, (int)4, null) == -1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)path.substring(3, StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)3, (boolean)false, (int)4, null)), (String)"substring(...)");
                names.add(name);
            }
        }
        return names;
    }

    public final void assignProjectNames() {
        Set usedNames = new HashSet(this.getProjectNames());
        for (ProjectDescription project : this.projects) {
            if (!(((CharSequence)project.getName()).length() == 0)) continue;
            String name = this.pickUniqueName(usedNames, project);
            usedNames.add(name);
            project.setName(name);
        }
    }

    private final String pickUniqueName(Set<String> usedNames, ProjectDescription project) {
        String name;
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[project.getType().ordinal()]) {
            case 1: {
                string = "app";
                break;
            }
            case 2: {
                string = "lib";
                break;
            }
            case 3: {
                string = "javalib";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String root = string;
        if (!usedNames.contains(root)) {
            return root;
        }
        int index = 2;
        while (usedNames.contains(name = root + index++)) {
        }
        return name;
    }

    private final void addNamedDependencies() {
        Map nameMap = new HashMap();
        for (ProjectDescription project : this.projects) {
            nameMap.put(project.getName(), project);
        }
        for (ProjectDescription project : this.projects) {
            for (String name : project.getDependsOnNames()) {
                ProjectDescription dependency = (ProjectDescription)nameMap.get(name);
                if (dependency == null) {
                    Assert.fail((String)("Unknown named project " + name + " from " + project.getName()));
                    continue;
                }
                project.dependsOn(dependency);
            }
        }
    }

    public final void sort() {
        CollectionsKt.sort(this.projects);
    }

    @Override
    @NotNull
    public Iterator<ProjectDescription> iterator() {
        return this.projects.iterator();
    }

    public ProjectDescriptionList() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectDescription.Type.values().length];
            try {
                nArray[ProjectDescription.Type.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDescription.Type.LIBRARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDescription.Type.JAVA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

