/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.SdkConstants;
import com.android.tools.lint.checks.infrastructure.CTestFile;
import com.android.tools.lint.checks.infrastructure.CompiledSourceFile;
import com.android.tools.lint.checks.infrastructure.DefTestFile;
import com.android.tools.lint.checks.infrastructure.KlibTestFileKt;
import com.android.tools.lint.checks.infrastructure.LintDetectorTest;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b\"\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/infrastructure/KlibTestFile;", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "to", "", "encoded", "checksum", "", "files", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)V", "getChecksum", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getEncoded", "()Ljava/lang/String;", "getFiles", "()[Lcom/android/tools/lint/checks/infrastructure/TestFile;", "[Lcom/android/tools/lint/checks/infrastructure/TestFile;", "sourceLanguage", "Lcom/android/tools/lint/checks/infrastructure/KlibTestFile$KLibLanguage;", "compile", "", "targetDir", "Ljava/io/File;", "createFile", "KLibLanguage", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nKlibTestFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibTestFile.kt\ncom/android/tools/lint/checks/infrastructure/KlibTestFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n12271#3,2:120\n11065#3:122\n11400#3,3:123\n4098#3,11:126\n1360#4:137\n1446#4,5:138\n*S KotlinDebug\n*F\n+ 1 KlibTestFile.kt\ncom/android/tools/lint/checks/infrastructure/KlibTestFile\n*L\n31#1:120,2\n83#1:122\n83#1:123,3\n87#1:126,11\n87#1:137\n87#1:138,5\n*E\n"})
public final class KlibTestFile
extends TestFile {
    @Nullable
    private final String encoded;
    @Nullable
    private final Integer checksum;
    @NotNull
    private final TestFile[] files;
    @NotNull
    private final KLibLanguage sourceLanguage;

    public KlibTestFile(@NotNull String to, @Nullable String encoded, @Nullable Integer checksum, TestFile ... files2) {
        KLibLanguage kLibLanguage;
        block6: {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
            this.encoded = encoded;
            this.checksum = checksum;
            this.files = files2;
            KLibLanguage[] kLibLanguageArray = KLibLanguage.values();
            KlibTestFile klibTestFile = this;
            KLibLanguage[] kLibLanguageArray2 = kLibLanguageArray;
            int n = kLibLanguageArray2.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                KLibLanguage kLibLanguage2;
                block5: {
                    KLibLanguage lang = kLibLanguage2 = kLibLanguageArray2[i];
                    boolean bl2 = false;
                    TestFile[] $this$all$iv = this.files;
                    boolean $i$f$all = false;
                    int n2 = $this$all$iv.length;
                    for (int j = 0; j < n2; ++j) {
                        TestFile element$iv;
                        TestFile it = element$iv = $this$all$iv[j];
                        boolean bl3 = false;
                        if (lang.getSourceFileTypes().contains(Reflection.getOrCreateKotlinClass(it.getClass()))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl) continue;
                kLibLanguage = kLibLanguage2;
                break block6;
            }
            kLibLanguage = null;
        }
        if (kLibLanguage == null) {
            throw new IllegalArgumentException("Mismatched or unsupported source files in klib");
        }
        klibTestFile.sourceLanguage = kLibLanguage;
        this.to(to);
        if (this.encoded != null && this.checksum != null) {
            int computedChecksum;
            boolean bl;
            Integer n = this.checksum;
            boolean bl4 = bl = n != null && (computedChecksum = KlibTestFileKt.access$computeChecksum(this.encoded)) == n;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = Integer.toString(computedChecksum, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = Integer.toString(this.checksum, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = "Expected checksum is " + string + ", given " + string2 + "Encoded:\n" + this.encoded;
                throw new AssertionError((Object)string3);
            }
        }
    }

    @Nullable
    public final String getEncoded() {
        return this.encoded;
    }

    @Nullable
    public final Integer getChecksum() {
        return this.checksum;
    }

    @NotNull
    public final TestFile[] getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public File createFile(@NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        if (this.encoded == null) {
            this.compile(targetDir);
        }
        String string = this.encoded;
        Intrinsics.checkNotNull((Object)string);
        File file = LintDetectorTest.base64gzip(this.targetRelativePath, string).createFile(targetDir);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createFile(...)");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final void compile(File targetDir) {
        List list2;
        CompiledSourceFile.Companion companion;
        File file = TestFile.createTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File tmpDir = file;
        this.targetRootFolder = targetDir.getPath();
        CompiledSourceFile.Companion companion2 = CompiledSourceFile.Companion;
        switch (WhenMappings.$EnumSwitchMapping$0[this.sourceLanguage.ordinal()]) {
            case 1: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] objectArray = new String[5];
                objectArray[0] = KlibTestFile.compile$findNativeCompiler(this);
                objectArray[1] = "-p";
                objectArray[2] = "library";
                objectArray[3] = "-o";
                Intrinsics.checkNotNullExpressionValue((Object)this.getTargetPath(), (String)"getTargetPath(...)");
                Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
                objectArray = this.files;
                Collection collection3 = collection2;
                CompiledSourceFile.Companion companion3 = companion2;
                boolean $i$f$map = false;
                void var7_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_25 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.createFile(tmpDir).getPath());
                }
                collection = (List)destination$iv$iv;
                companion = companion3;
                list2 = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                TestFile[] $this$map$iv = this.files;
                String string = KlibTestFile.compile$findCinterop(this);
                CompiledSourceFile.Companion companion4 = companion2;
                boolean $i$f$filterIsInstance = false;
                void $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof DefTestFile)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                $this$filterIsInstance$iv = list3;
                boolean $i$f$flatMap = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    DefTestFile it = (DefTestFile)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new String[]{"-def", it.createFile(tmpDir).getPath()};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv;
                companion = companion4;
                Object[] objectArray = new String[2];
                objectArray[0] = "-o";
                String string2 = this.getTargetPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTargetPath(...)");
                objectArray[1] = StringsKt.removeSuffix((String)string2, (CharSequence)".klib");
                list2 = CollectionsKt.listOf((Object)(string + list3 + CollectionsKt.listOf((Object[])objectArray)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        companion.executeProcess$lint_tests(list2);
        FilesKt.deleteRecursively((File)tmpDir);
        File target = new File(this.getTargetPath());
        int checksum = KlibTestFileKt.access$computeChecksum(TestFiles.INSTANCE.toBase64gzipString$lint_tests(FilesKt.readBytes((File)target)));
        String string = TestFiles.toBase64gzip(target);
        String string3 = Integer.toString(checksum, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Assert.fail((String)("Update the test source declaration for " + this.targetRelativePath + " with this encoding: \n\n" + string + "\n\nAlso the checksum is " + string3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String compile$findOnPath(String target) {
        String string;
        String string2;
        String string3 = System.getenv("PATH");
        Object object = string3;
        if (string3 == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        List list2 = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object = list2;
        if (list2 == null) return null;
        Iterator iterator = ((Iterable)object).iterator();
        do {
            String string4;
            if (!iterator.hasNext()) return null;
            String binDir = (String)iterator.next();
            boolean bl = false;
            File file = new File(binDir + File.separator + target);
            String it = string4 = file.getPath();
            boolean bl2 = false;
            if (file.isFile()) {
                string = string4;
                continue;
            }
            string = null;
        } while ((string2 = string) == null);
        String string5 = string2;
        return string5;
    }

    private static final String compile$find(KlibTestFile this$0, String tag, String flag) {
        boolean isWindows = SdkConstants.currentPlatform() == 2;
        String string = System.getenv(flag);
        if (string == null && (string = KlibTestFile.compile$findOnPath(tag + (isWindows ? ".bat" : ""))) == null) {
            throw new IllegalStateException(("Couldn't find " + tag + " to update test file " + this$0.getTargetPath() + " with. Point to it with $" + flag).toString());
        }
        String target = string;
        if (!new File(target).isFile()) {
            Assert.fail((String)(target + " is not a file"));
        }
        if (!new File(target).canExecute()) {
            Assert.fail((String)(target + " is not executable"));
        }
        return target;
    }

    private static final String compile$findNativeCompiler(KlibTestFile this$0) {
        return KlibTestFile.compile$find(this$0, "kotlinc-native", "LINT_TEST_KOTLINC_NATIVE");
    }

    private static final String compile$findCinterop(KlibTestFile this$0) {
        return KlibTestFile.compile$find(this$0, "cinterop", "LINT_TEST_INTEROP");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/infrastructure/KlibTestFile$KLibLanguage;", "", "sourceFileTypes", "", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;ILjava/util/Set;)V", "getSourceFileTypes", "()Ljava/util/Set;", "Kotlin", "C", "lint-tests"})
    private static final class KLibLanguage
    extends Enum<KLibLanguage> {
        @NotNull
        private final Set<KClass<?>> sourceFileTypes;
        public static final /* enum */ KLibLanguage Kotlin = new KLibLanguage(SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(TestFile.KotlinTestFile.class)));
        public static final /* enum */ KLibLanguage C;
        private static final /* synthetic */ KLibLanguage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KLibLanguage(Set<? extends KClass<?>> sourceFileTypes) {
            this.sourceFileTypes = sourceFileTypes;
        }

        @NotNull
        public final Set<KClass<?>> getSourceFileTypes() {
            return this.sourceFileTypes;
        }

        public static KLibLanguage[] values() {
            return (KLibLanguage[])$VALUES.clone();
        }

        public static KLibLanguage valueOf(String value) {
            return Enum.valueOf(KLibLanguage.class, value);
        }

        @NotNull
        public static EnumEntries<KLibLanguage> getEntries() {
            return $ENTRIES;
        }

        static {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(CTestFile.class), Reflection.getOrCreateKotlinClass(DefTestFile.class)};
            C = new KLibLanguage(SetsKt.setOf((Object[])objectArray));
            $VALUES = kLibLanguageArray = new KLibLanguage[]{KLibLanguage.Kotlin, KLibLanguage.C};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KLibLanguage.values().length];
            try {
                nArray[KLibLanguage.Kotlin.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KLibLanguage.C.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

