/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.SdkConstants;
import com.android.tools.lint.checks.infrastructure.TestResourceProvider;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import junit.framework.TestCase;
import kotlin.io.FilesKt;

public abstract class BaseLintDetectorTest
extends TestCase
implements TestResourceProvider {
    private static final boolean UPDATE_DIFFERENT_FILES = false;
    private static final boolean UPDATE_MISSING_FILES = true;
    private static File sTempDir = null;
    protected static final Set<File> sCleanDirs = Sets.newHashSet();

    protected void setUp() throws Exception {
        super.setUp();
        LintClient.setClientName((String)"test");
    }

    protected void tearDown() throws Exception {
        LintClient.Companion.resetClientName();
        super.tearDown();
    }

    protected String getTestDataRelPath() {
        BaseLintDetectorTest.fail((String)"Must be overridden");
        return null;
    }

    public static int getCaretOffset(String fileContent, String caretLocation) {
        String caretContext;
        BaseLintDetectorTest.assertTrue((String)caretLocation, (boolean)caretLocation.contains("^"));
        int caretDelta = caretLocation.indexOf(94);
        BaseLintDetectorTest.assertTrue((String)caretLocation, (caretDelta != -1 ? 1 : 0) != 0);
        if (caretLocation.contains("[^")) {
            BaseLintDetectorTest.assertTrue((String)caretLocation, (boolean)caretLocation.startsWith("[^", --caretDelta));
            int caretRangeEnd = caretLocation.indexOf(93, caretDelta + 2);
            BaseLintDetectorTest.assertTrue((String)caretLocation, (caretRangeEnd != -1 ? 1 : 0) != 0);
            caretContext = caretLocation.substring(0, caretDelta) + caretLocation.substring(caretDelta + 2, caretRangeEnd) + caretLocation.substring(caretRangeEnd + 1);
        } else {
            caretContext = caretLocation.substring(0, caretDelta) + caretLocation.substring(caretDelta + 1);
        }
        int caretContextIndex = fileContent.indexOf(caretContext);
        BaseLintDetectorTest.assertTrue((String)("Caret content " + caretContext + " not found in file"), (caretContextIndex != -1 ? 1 : 0) != 0);
        return caretContextIndex + caretDelta;
    }

    public static String addSelection(String newFileContents, int selectionBegin, int selectionEnd) {
        String newFileWithCaret = selectionBegin < selectionEnd ? newFileContents.substring(0, selectionBegin) + "[^" + newFileContents.substring(selectionBegin, selectionEnd) + "]" + newFileContents.substring(selectionEnd) : newFileContents.substring(0, selectionBegin) + "^" + newFileContents.substring(selectionBegin);
        return newFileWithCaret;
    }

    public static String getCaretContext(String file, int offset) {
        int windowSize = 20;
        int begin = Math.max(0, offset - windowSize / 2);
        int end = Math.min(file.length(), offset + windowSize / 2);
        return "..." + file.substring(begin, offset) + "^" + file.substring(offset, end) + "...";
    }

    protected File getTargetDir() {
        File testData;
        File sdkPath;
        String sdk = System.getenv("ADT_SDK_SOURCE_PATH");
        if (sdk != null && (sdkPath = new File(sdk)).exists() && (testData = new File(sdkPath, this.getTestDataRelPath().replace('/', File.separatorChar))).exists()) {
            BaseLintDetectorTest.addCleanupDir(testData);
            return testData;
        }
        return BaseLintDetectorTest.getTempDir();
    }

    public static File getTempDir() {
        if (sTempDir == null) {
            File base = new File(System.getProperty("java.io.tmpdir"));
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                base = new File("/tmp");
            }
            Calendar c = Calendar.getInstance();
            String name = String.format("sdkTests_%1$tF_%1$tT", c).replace(':', '-');
            File tmpDir = new File(base, name);
            sTempDir = !tmpDir.exists() && tmpDir.mkdir() ? tmpDir : base;
            BaseLintDetectorTest.addCleanupDir(sTempDir);
        }
        return sTempDir;
    }

    protected String removeSessionData(String data) {
        return data;
    }

    @Override
    public InputStream getTestResource(String relativePath, boolean expectExists) {
        String path = "testdata" + File.separator + relativePath;
        InputStream stream = BaseLintDetectorTest.class.getResourceAsStream(path);
        if (!expectExists && stream == null) {
            return null;
        }
        return stream;
    }

    protected String readTestFile(String relativePath, boolean expectExists) throws IOException {
        InputStream stream = this.getTestResource(relativePath, expectExists);
        if (expectExists) {
            BaseLintDetectorTest.assertNotNull((String)(relativePath + " does not exist"), (Object)stream);
        } else if (stream == null) {
            return null;
        }
        String xml = new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
        try {
            Closeables.close((Closeable)stream, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BaseLintDetectorTest.assertTrue((!xml.isEmpty() ? 1 : 0) != 0);
        xml = this.removeSessionData(xml);
        return xml;
    }

    protected void assertEqualsGolden(String basename, String actual) throws IOException {
        this.assertEqualsGolden(basename, actual, basename.substring(basename.lastIndexOf(46) + 1));
    }

    protected void assertEqualsGolden(String basename, String actual, String newExtension) throws IOException {
        String expectedName;
        String expected;
        Object testName = this.getName();
        if (((String)testName).startsWith("test") && Character.isUpperCase(((String)(testName = ((String)testName).substring(4))).charAt(0))) {
            testName = Character.toLowerCase(((String)testName).charAt(0)) + ((String)testName).substring(1);
        }
        String extension = basename.substring(basename.lastIndexOf(46) + 1);
        if (newExtension == null) {
            newExtension = extension;
        }
        if ((expected = this.readTestFile(expectedName = basename.substring(0, basename.indexOf(46)) + "-expected-" + (String)testName + "." + newExtension, false)) == null) {
            File expectedPath = new File(this.getTargetDir(), expectedName);
            com.google.common.io.Files.asCharSink((File)expectedPath, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)actual);
            System.out.println("Expected - written to " + expectedPath + ":\n");
            System.out.println(actual);
            BaseLintDetectorTest.fail((String)("Did not find golden file (" + expectedName + "): Wrote contents as " + expectedPath));
        } else if (!expected.replaceAll("\r\n", "\n").equals(actual.replaceAll("\r\n", "\n"))) {
            File expectedPath = new File(BaseLintDetectorTest.getTempDir(), expectedName);
            File actualPath = new File(BaseLintDetectorTest.getTempDir(), expectedName.replace("expected", "actual"));
            com.google.common.io.Files.asCharSink((File)expectedPath, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)expected);
            com.google.common.io.Files.asCharSink((File)actualPath, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)actual);
            System.out.println("The files differ: diff " + expectedPath + " " + actualPath);
            BaseLintDetectorTest.assertEquals((String)("The files differ - see " + expectedPath + " versus " + actualPath), (String)expected, (String)actual);
        }
    }

    protected static void deleteFile(File dir) {
        FilesKt.deleteRecursively((File)dir);
    }

    protected static File makeTestFile(File dir, String name, String relative, InputStream contents) throws IOException {
        File tempFile;
        boolean mkdir;
        if (relative != null) {
            if (!(dir = new File(dir, relative)).exists()) {
                mkdir = dir.mkdirs();
                BaseLintDetectorTest.assertTrue((String)dir.getPath(), (boolean)mkdir);
            }
        } else if (!dir.exists()) {
            mkdir = dir.mkdirs();
            BaseLintDetectorTest.assertTrue((String)dir.getPath(), (boolean)mkdir);
        }
        if ((tempFile = new File(dir, name)).exists()) {
            tempFile.delete();
        }
        Files.copy(contents, tempFile.toPath(), new CopyOption[0]);
        return tempFile;
    }

    protected File getTestfile(File targetDir, String relativePath) throws IOException {
        String targetPath = relativePath;
        int replaceIndex = relativePath.indexOf("=>");
        if (replaceIndex != -1) {
            targetPath = relativePath.substring(replaceIndex + "=>".length());
            relativePath = relativePath.substring(0, replaceIndex);
        }
        InputStream stream = this.getTestResource(relativePath, true);
        BaseLintDetectorTest.assertNotNull((String)(relativePath + " does not exist"), (Object)stream);
        int index = targetPath.lastIndexOf(47);
        String relative = null;
        String name = targetPath;
        if (index != -1) {
            name = targetPath.substring(index + 1);
            relative = targetPath.substring(0, index);
        }
        return BaseLintDetectorTest.makeTestFile(targetDir, name, relative, stream);
    }

    protected static void addCleanupDir(File dir) {
        sCleanDirs.add(dir);
        try {
            sCleanDirs.add(dir.getCanonicalFile());
        }
        catch (IOException e) {
            BaseLintDetectorTest.fail((String)e.getLocalizedMessage());
        }
        sCleanDirs.add(dir.getAbsoluteFile());
    }

    protected String cleanup(String result) {
        ArrayList<File> sorted = new ArrayList<File>(sCleanDirs);
        sorted.sort((file1, file2) -> {
            String path1 = file1.getPath();
            String path2 = file2.getPath();
            int delta = path2.length() - path1.length();
            if (delta != 0) {
                return delta;
            }
            return path1.compareTo(path2);
        });
        for (File dir : sorted) {
            if (!result.contains(dir.getPath())) continue;
            result = result.replace(dir.getPath(), "/TESTROOT");
        }
        if (File.separatorChar != '/') {
            result = result.replace(File.separatorChar, '/');
        }
        result = result.replace(System.lineSeparator(), "\n");
        return result;
    }

    static {
        LintClient.setClientName((String)"test");
    }
}

