/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelLibraryResolver;
import com.android.tools.lint.model.DefaultLintModelModuleLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelReader;
import com.android.tools.lint.model.LintModelSerialization;
import java.io.File;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/model/LintModelLibrariesReader;", "Lcom/android/tools/lint/model/LintModelReader;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "libraryResolver", "Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;", "root", "Ljava/io/File;", "variantName", "", "artifactName", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/io/Reader;)V", "libraryResolverMap", "", "Lcom/android/tools/lint/model/LintModelLibrary;", "path", "getPath", "()Ljava/lang/String;", "readLibraries", "readLibrary", "lint-model"})
final class LintModelLibrariesReader
extends LintModelReader {
    @NotNull
    private final String variantName;
    @NotNull
    private final String artifactName;
    @NotNull
    private final Map<String, LintModelLibrary> libraryResolverMap;
    @NotNull
    private final DefaultLintModelLibraryResolver libraryResolver;

    public LintModelLibrariesReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable DefaultLintModelLibraryResolver libraryResolver, @Nullable File root, @NotNull String variantName, @NotNull String artifactName, @NotNull Reader reader) {
        Map map;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        super(adapter, root, reader);
        this.variantName = variantName;
        this.artifactName = artifactName;
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver = libraryResolver;
        Map map2 = defaultLintModelLibraryResolver == null ? null : defaultLintModelLibraryResolver.getLibraryMap();
        Object object2 = object = TypeIntrinsics.isMutableMap(map2) ? map2 : null;
        if (object == null) {
            boolean bl = false;
            map = new LinkedHashMap();
        } else {
            map = object;
        }
        this.libraryResolverMap = map;
        object = libraryResolver;
        this.libraryResolver = object == null ? new DefaultLintModelLibraryResolver(this.libraryResolverMap) : object;
    }

    public /* synthetic */ LintModelLibrariesReader(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, DefaultLintModelLibraryResolver defaultLintModelLibraryResolver, File file, String string, String string2, Reader reader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            defaultLintModelLibraryResolver = null;
        }
        if ((n & 0x20) != 0) {
            reader = lintModelSerializationAdapter.getReader(LintModelSerialization.TargetFile.LIBRARY_TABLE, string, string2);
        }
        this(lintModelSerializationAdapter, defaultLintModelLibraryResolver, file, string, string2, reader);
    }

    @Override
    @NotNull
    protected String getPath() {
        String string;
        File file = this.getAdapter().file(LintModelSerialization.TargetFile.DEPENDENCIES, this.variantName, this.artifactName);
        return file == null ? "<unknown>" : ((string = file.getPath()) == null ? "<unknown>" : string);
    }

    @NotNull
    public final DefaultLintModelLibraryResolver readLibraries() {
        this.getParser().nextTag();
        this.expectTag("libraries");
        block4: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            switch (eventType) {
                case 2: {
                    String string = this.getParser().getName();
                    if (Intrinsics.areEqual((Object)string, (Object)"library")) {
                        LintModelLibrary library = this.readLibrary();
                        Map<String, LintModelLibrary> map = this.libraryResolverMap;
                        String string2 = library.getArtifactAddress();
                        boolean bl = false;
                        map.put(string2, library);
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag("libraries");
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return this.libraryResolver;
    }

    private final LintModelLibrary readLibrary() {
        LintModelLibrary lintModelLibrary;
        this.expectTag("library");
        boolean android = false;
        String artifactAddress = this.getName();
        List<File> jars = this.getFiles("jars");
        String project = this.getOptionalAttribute("project");
        String string = this.getOptionalAttribute("resolved");
        LintModelMavenName resolved = string == null ? null : this.toMavenCoordinate(string);
        boolean provided = this.getOptionalBoolean("provided", false);
        File manifestFile = null;
        File resFolder = null;
        File assetsFolder = null;
        File lintJar = null;
        File publicResources = null;
        File symbolFile = null;
        File externalAnnotations = null;
        File proguardRules = null;
        File folder = this.getOptionalFile("folder");
        if (folder != null) {
            android = true;
            resFolder = this.getRequiredFile("resFolder", folder);
            assetsFolder = this.getRequiredFile("assetsFolder", folder);
            lintJar = this.getRequiredFile("lintJar", folder);
            publicResources = this.getRequiredFile("publicResources", folder);
            symbolFile = this.getRequiredFile("symbolFile", folder);
            manifestFile = this.getRequiredFile("manifest", folder);
            externalAnnotations = this.getRequiredFile("externalAnnotations", folder);
            proguardRules = this.getRequiredFile("proguardRules", folder);
        }
        this.finishTag("library");
        if (project != null) {
            lintModelLibrary = new DefaultLintModelModuleLibrary(artifactAddress, project, lintJar, provided);
        } else if (android) {
            if (manifestFile == null) {
                Intrinsics.throwNpe();
            }
            File file = manifestFile;
            if (folder == null) {
                Intrinsics.throwNpe();
            }
            File file2 = folder;
            if (resFolder == null) {
                Intrinsics.throwNpe();
            }
            File file3 = resFolder;
            if (assetsFolder == null) {
                Intrinsics.throwNpe();
            }
            File file4 = assetsFolder;
            if (lintJar == null) {
                Intrinsics.throwNpe();
            }
            File file5 = lintJar;
            if (publicResources == null) {
                Intrinsics.throwNpe();
            }
            File file6 = publicResources;
            if (symbolFile == null) {
                Intrinsics.throwNpe();
            }
            File file7 = symbolFile;
            if (externalAnnotations == null) {
                Intrinsics.throwNpe();
            }
            File file8 = externalAnnotations;
            if (proguardRules == null) {
                Intrinsics.throwNpe();
            }
            File file9 = proguardRules;
            if (resolved == null) {
                Intrinsics.throwNpe();
            }
            LintModelMavenName lintModelMavenName = resolved;
            lintModelLibrary = new DefaultLintModelAndroidLibrary(jars, artifactAddress, file, file2, file3, file4, file5, file6, file7, file8, file9, provided, lintModelMavenName);
        } else {
            if (resolved == null) {
                Intrinsics.throwNpe();
            }
            LintModelMavenName lintModelMavenName = resolved;
            lintModelLibrary = new DefaultLintModelJavaLibrary(artifactAddress, jars, lintModelMavenName, provided);
        }
        return lintModelLibrary;
    }
}

