/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/ServiceCastDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkContextReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkWifiContextType", "type", "Lcom/intellij/psi/PsiType;", "flagPlainContext", "checkWifiService", "", "getApplicableMethodNames", "", "", "isClipboard", "cls", "reportWifiServiceLeak", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "stripPackage", "fqcn", "visitMethodCall", "node", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class ServiceCastDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ServiceCastDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final Issue WIFI_MANAGER;
    @JvmField
    @NotNull
    public static final Issue WIFI_MANAGER_UNCERTAIN;
    @NotNull
    private static final String GET_APPLICATION_CONTEXT = "getApplicationContext";
    @NotNull
    private static final String WIFI_SERVICE = "WIFI_SERVICE";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getSystemService");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        UElement parent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List args = node.getValueArguments();
        if (args.size() != 1) {
            return;
        }
        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)));
        UReferenceExpression uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
        if (uReferenceExpression == null) {
            return;
        }
        UReferenceExpression argument = uReferenceExpression;
        PsiElement psiElement = argument.resolve();
        PsiField psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
        if (psiField == null) {
            return;
        }
        PsiField resolvedServiceConst = psiField;
        String string = resolvedServiceConst.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (Intrinsics.areEqual((Object)WIFI_SERVICE, (Object)name)) {
            this.checkWifiService(context, node);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)node)).getUastParent())) != null && UastExpressionUtils.isTypeCast((UElement)parent)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)parent;
            String expectedClass = Companion.getExpectedType(name);
            if (expectedClass != null) {
                String string2 = cast.getType().getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
                String castType = string2;
                if (StringsKt.indexOf$default((CharSequence)castType, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                    expectedClass = this.stripPackage(expectedClass);
                }
                if (!Intrinsics.areEqual((Object)castType, (Object)expectedClass)) {
                    String expected;
                    if (this.isClipboard(castType) && this.isClipboard(expectedClass)) {
                        return;
                    }
                    String actual = this.stripPackage(castType);
                    if (Intrinsics.areEqual((Object)actual, (Object)(expected = this.stripPackage(expectedClass))) && StringsKt.contains$default((CharSequence)expectedClass, (CharSequence)".", (boolean)false, (int)2, null)) {
                        actual = castType;
                        expected = expectedClass;
                    }
                    String message2 = "Suspicious cast to `" + actual + "` for a `" + name + "`: expected `" + expected + "`";
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)cast), (String)message2, null, (int)16, null);
                }
            }
        }
    }

    private final void checkWifiService(JavaContext context, UCallExpression call) {
        JavaEvaluator evaluator = context.getEvaluator();
        UExpression qualifier = call.getReceiver();
        PsiMethod resolvedMethod = call.resolve();
        if (resolvedMethod != null && (evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.app.Activity", false) || evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.view.View", false))) {
            this.reportWifiServiceLeak(WIFI_MANAGER, context, call);
            return;
        }
        if (qualifier == null) {
            UMethod currentMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)call), UMethod.class, (boolean)true);
            if (currentMethod != null && !evaluator.isMemberInSubClassOf((PsiMember)currentMethod, "android.app.Application", true)) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context, call);
            }
        } else {
            this.checkContextReference(context, (UElement)qualifier, call);
        }
    }

    private final boolean checkContextReference(JavaContext context, UElement element, UCallExpression call) {
        if (element == null) {
            return false;
        }
        if (element instanceof UCallExpression) {
            PsiMethod resolvedMethod = ((UCallExpression)element).resolve();
            if (resolvedMethod != null && !Intrinsics.areEqual((Object)GET_APPLICATION_CONTEXT, (Object)resolvedMethod.getName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context, call);
                return true;
            }
        } else if (element instanceof UQualifiedReferenceExpression) {
            PsiElement resolved = ((UQualifiedReferenceExpression)element).resolve();
            if (resolved instanceof PsiMethod && !Intrinsics.areEqual((Object)GET_APPLICATION_CONTEXT, (Object)((UQualifiedReferenceExpression)element).getResolvedName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context, call);
                return true;
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiField) {
                PsiType psiType = ((PsiField)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                return this.checkWifiContextType(context, call, type, true);
            }
            if (resolved instanceof PsiParameter) {
                PsiType psiType = ((PsiParameter)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                return this.checkWifiContextType(context, call, type, true);
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiType psiType = ((PsiLocalVariable)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                if (!type.isValid()) {
                    return false;
                }
                if (this.checkWifiContextType(context, call, type, false)) {
                    return true;
                }
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)call);
                if (lastAssignment != null) {
                    return this.checkContextReference(context, (UElement)lastAssignment, call);
                }
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.checkContextReference(context, (UElement)((UParenthesizedExpression)element).getExpression(), call);
        }
        return false;
    }

    private final boolean checkWifiContextType(JavaContext context, UCallExpression call, PsiType type, boolean flagPlainContext) {
        PsiClass psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        if (type instanceof PsiClassType && evaluator.extendsClass(psiClass = ((PsiClassType)type).resolve(), "android.app.Application", false)) {
            return false;
        }
        if (evaluator.typeMatches(type, "android.content.Context")) {
            if (flagPlainContext) {
                this.reportWifiServiceLeak(WIFI_MANAGER_UNCERTAIN, context, call);
                return true;
            }
            return false;
        }
        this.reportWifiServiceLeak(WIFI_MANAGER, context, call);
        return true;
    }

    private final void reportWifiServiceLeak(Issue issue, JavaContext context, UCallExpression call) {
        String qualifier;
        if (context.getProject().getMinSdk() >= 24) {
            return;
        }
        Object message2 = "The WIFI_SERVICE must be looked up on the Application context or memory will leak on devices < Android N. ";
        LintFix fix = null;
        if (call.getReceiver() != null) {
            UExpression uExpression = call.getReceiver();
            Intrinsics.checkNotNull((Object)uExpression);
            qualifier = uExpression.asSourceString();
            message2 = (String)message2 + "Try changing `" + qualifier + "` to `" + qualifier + ".getApplicationContext()`";
            fix = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with(qualifier + ".getApplicationContext()").build();
        } else {
            qualifier = Lint.getMethodName((UCallExpression)call);
            message2 = (String)message2 + "Try changing `" + qualifier + "` to `getApplicationContext()." + qualifier + "`";
            fix = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with("getApplicationContext()." + qualifier).build();
        }
        Incident incident = new Incident(issue, (Object)call, context.getLocation((UElement)call), (String)message2, fix);
        context.report(incident, Constraints.minSdkLessThan((int)24));
    }

    private final boolean isClipboard(String cls) {
        return Intrinsics.areEqual((Object)cls, (Object)"android.content.ClipboardManager") || Intrinsics.areEqual((Object)cls, (Object)"android.text.ClipboardManager");
    }

    private final String stripPackage(String fqcn) {
        return StringsKt.substringAfterLast$default((String)fqcn, (char)'.', null, (int)2, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ServiceCast", (String)"Wrong system service casts", (String)"\n          When you call `Context#getSystemService()`, the result is typically cast to \\\n          a specific interface. This lint check ensures that the cast is compatible with \\\n          the expected type of the return value.\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        WIFI_MANAGER = Issue.Companion.create$default((Issue.Companion)companion, (String)"WifiManagerLeak", (String)"WifiManager Leak", (String)"\n          On versions prior to Android N (24), initializing the `WifiManager` via \\\n          `Context#getSystemService` can cause a memory leak if the context is not \\\n          the application context. Change `context.getSystemService(...)` to \\\n          `context.getApplicationContext().getSystemService(...)`.\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        WIFI_MANAGER_UNCERTAIN = Issue.Companion.create$default((Issue.Companion)companion, (String)"WifiManagerPotentialLeak", (String)"WifiManager Potential Leak", (String)"\n          On versions prior to Android N (24), initializing the `WifiManager` \\\n          via `Context#getSystemService` can cause a memory leak if the context \\\n          is not the application context.\n\n          In many cases, it's not obvious from the code where the `Context` is \\\n          coming from (e.g. it might be a parameter to a method, or a field \\\n          initialized from various method calls). It's possible that the context \\\n          being passed in is the application context, but to be on the safe side, \\\n          you should consider changing `context.getSystemService(...)` to \\\n          `context.getApplicationContext().getSystemService(...)`.\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/ServiceCastDetector$Companion;", "", "()V", "GET_APPLICATION_CONTEXT", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WIFI_MANAGER", "WIFI_MANAGER_UNCERTAIN", "WIFI_SERVICE", "getExpectedType", "value", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @VisibleForTesting
        @Nullable
        public final String getExpectedType(@Nullable String value) {
            String string;
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ACCESSIBILITY_SERVICE": {
                    string = "android.view.accessibility.AccessibilityManager";
                    break;
                }
                case "ACCOUNT_SERVICE": {
                    string = "android.accounts.AccountManager";
                    break;
                }
                case "ACTIVITY_SERVICE": {
                    string = "android.app.ActivityManager";
                    break;
                }
                case "ALARM_SERVICE": {
                    string = "android.app.AlarmManager";
                    break;
                }
                case "APPWIDGET_SERVICE": {
                    string = "android.appwidget.AppWidgetManager";
                    break;
                }
                case "APP_OPS_SERVICE": {
                    string = "android.app.AppOpsManager";
                    break;
                }
                case "APP_SEARCH_SERVICE": {
                    string = "android.app.appsearch.AppSearchManager";
                    break;
                }
                case "AUDIO_SERVICE": {
                    string = "android.media.AudioManager";
                    break;
                }
                case "BATTERY_SERVICE": {
                    string = "android.os.BatteryManager";
                    break;
                }
                case "BIOMETRIC_SERVICE": {
                    string = "android.hardware.biometrics.BiometricManager";
                    break;
                }
                case "BLOB_STORE_SERVICE": {
                    string = "android.app.blob.BlobStoreManager";
                    break;
                }
                case "BLUETOOTH_SERVICE": {
                    string = "android.bluetooth.BluetoothManager";
                    break;
                }
                case "CAMERA_SERVICE": {
                    string = "android.hardware.camera2.CameraManager";
                    break;
                }
                case "CAPTIONING_SERVICE": {
                    string = "android.view.accessibility.CaptioningManager";
                    break;
                }
                case "CARRIER_CONFIG_SERVICE": {
                    string = "android.telephony.CarrierConfigManager";
                    break;
                }
                case "CLIPBOARD_SERVICE": {
                    string = "android.text.ClipboardManager";
                    break;
                }
                case "COMPANION_DEVICE_SERVICE": {
                    string = "android.companion.CompanionDeviceManager";
                    break;
                }
                case "CONNECTIVITY_DIAGNOSTICS_SERVICE": {
                    string = "android.net.ConnectivityDiagnosticsManager";
                    break;
                }
                case "CONNECTIVITY_SERVICE": {
                    string = "android.net.ConnectivityManager";
                    break;
                }
                case "CONSUMER_IR_SERVICE": {
                    string = "android.hardware.ConsumerIrManager";
                    break;
                }
                case "CREDENTIAL_SERVICE": {
                    string = "android.credentials.CredentialManager";
                    break;
                }
                case "CROSS_PROFILE_APPS_SERVICE": {
                    string = "android.content.pm.CrossProfileApps";
                    break;
                }
                case "DEVICE_LOCK_SERVICE": {
                    string = "android.devicelock.DeviceLockManager";
                    break;
                }
                case "DEVICE_POLICY_SERVICE": {
                    string = "android.app.admin.DevicePolicyManager";
                    break;
                }
                case "DISPLAY_HASH_SERVICE": {
                    string = "android.view.displayhash.DisplayHashManager";
                    break;
                }
                case "DISPLAY_SERVICE": {
                    string = "android.hardware.display.DisplayManager";
                    break;
                }
                case "DOMAIN_VERIFICATION_SERVICE": {
                    string = "android.content.pm.verify.domain.DomainVerificationManager";
                    break;
                }
                case "DOWNLOAD_SERVICE": {
                    string = "android.app.DownloadManager";
                    break;
                }
                case "DROPBOX_SERVICE": {
                    string = "android.os.DropBoxManager";
                    break;
                }
                case "EUICC_SERVICE": {
                    string = "android.telephony.euicc.EuiccManager";
                    break;
                }
                case "FILE_INTEGRITY_SERVICE": {
                    string = "android.security.FileIntegrityManager";
                    break;
                }
                case "FINGERPRINT_SERVICE": {
                    string = "android.hardware.fingerprint.FingerprintManager";
                    break;
                }
                case "GAME_SERVICE": {
                    string = "android.app.GameManager";
                    break;
                }
                case "GRAMMATICAL_INFLECTION_SERVICE": {
                    string = "android.app.GrammaticalInflectionManager";
                    break;
                }
                case "HARDWARE_PROPERTIES_SERVICE": {
                    string = "android.os.HardwarePropertiesManager";
                    break;
                }
                case "HEALTHCONNECT_SERVICE": {
                    string = "android.health.connect.HealthConnectManager";
                    break;
                }
                case "INPUT_METHOD_SERVICE": {
                    string = "android.view.inputmethod.InputMethodManager";
                    break;
                }
                case "INPUT_SERVICE": {
                    string = "android.hardware.input.InputManager";
                    break;
                }
                case "IPSEC_SERVICE": {
                    string = "android.net.IpSecManager";
                    break;
                }
                case "JOB_SCHEDULER_SERVICE": {
                    string = "android.app.job.JobScheduler";
                    break;
                }
                case "KEYGUARD_SERVICE": {
                    string = "android.app.KeyguardManager";
                    break;
                }
                case "LAUNCHER_APPS_SERVICE": {
                    string = "android.content.pm.LauncherApps";
                    break;
                }
                case "LAYOUT_INFLATER_SERVICE": {
                    string = "android.view.LayoutInflater";
                    break;
                }
                case "LOCALE_SERVICE": {
                    string = "android.app.LocaleManager";
                    break;
                }
                case "LOCATION_SERVICE": {
                    string = "android.location.LocationManager";
                    break;
                }
                case "MEDIA_COMMUNICATION_SERVICE": {
                    string = "android.media.MediaCommunicationManager";
                    break;
                }
                case "MEDIA_METRICS_SERVICE": {
                    string = "android.media.metrics.MediaMetricsManager";
                    break;
                }
                case "MEDIA_PROJECTION_SERVICE": {
                    string = "android.media.projection.MediaProjectionManager";
                    break;
                }
                case "MEDIA_ROUTER_SERVICE": {
                    string = "android.media.MediaRouter";
                    break;
                }
                case "MEDIA_SESSION_SERVICE": {
                    string = "android.media.session.MediaSessionManager";
                    break;
                }
                case "MIDI_SERVICE": {
                    string = "android.media.midi.MidiManager";
                    break;
                }
                case "NETWORK_STATS_SERVICE": {
                    string = "android.app.usage.NetworkStatsManager";
                    break;
                }
                case "NFC_SERVICE": {
                    string = "android.nfc.NfcManager";
                    break;
                }
                case "NOTIFICATION_SERVICE": {
                    string = "android.app.NotificationManager";
                    break;
                }
                case "NSD_SERVICE": {
                    string = "android.net.nsd.NsdManager";
                    break;
                }
                case "OVERLAY_SERVICE": {
                    string = "android.content.om.OverlayManager";
                    break;
                }
                case "PEOPLE_SERVICE": {
                    string = "android.app.people.PeopleManager";
                    break;
                }
                case "PERFORMANCE_HINT_SERVICE": {
                    string = "android.os.PerformanceHintManager";
                    break;
                }
                case "POWER_SERVICE": {
                    string = "android.os.PowerManager";
                    break;
                }
                case "PRINT_SERVICE": {
                    string = "android.print.PrintManager";
                    break;
                }
                case "RESTRICTIONS_SERVICE": {
                    string = "android.content.RestrictionsManager";
                    break;
                }
                case "ROLE_SERVICE": {
                    string = "android.app.role.RoleManager";
                    break;
                }
                case "SEARCH_SERVICE": {
                    string = "android.app.SearchManager";
                    break;
                }
                case "SENSOR_SERVICE": {
                    string = "android.hardware.SensorManager";
                    break;
                }
                case "SHORTCUT_SERVICE": {
                    string = "android.content.pm.ShortcutManager";
                    break;
                }
                case "STATUS_BAR_SERVICE": {
                    string = "android.app.StatusBarManager";
                    break;
                }
                case "STORAGE_SERVICE": {
                    string = "android.os.storage.StorageManager";
                    break;
                }
                case "STORAGE_STATS_SERVICE": {
                    string = "android.app.usage.StorageStatsManager";
                    break;
                }
                case "SYSTEM_HEALTH_SERVICE": {
                    string = "android.os.health.SystemHealthManager";
                    break;
                }
                case "TELECOM_SERVICE": {
                    string = "android.telecom.TelecomManager";
                    break;
                }
                case "TELEPHONY_IMS_SERVICE": {
                    string = "android.telephony.ims.ImsManager";
                    break;
                }
                case "TELEPHONY_SERVICE": {
                    string = "android.telephony.TelephonyManager";
                    break;
                }
                case "TELEPHONY_SUBSCRIPTION_SERVICE": {
                    string = "android.telephony.SubscriptionManager";
                    break;
                }
                case "TEXT_CLASSIFICATION_SERVICE": {
                    string = "android.view.textclassifier.TextClassificationManager";
                    break;
                }
                case "TEXT_SERVICES_MANAGER_SERVICE": {
                    string = "android.view.textservice.TextServicesManager";
                    break;
                }
                case "TV_INPUT_SERVICE": {
                    string = "android.media.tv.TvInputManager";
                    break;
                }
                case "TV_INTERACTIVE_APP_SERVICE": {
                    string = "android.media.tv.interactive.TvInteractiveAppManager";
                    break;
                }
                case "UI_MODE_SERVICE": {
                    string = "android.app.UiModeManager";
                    break;
                }
                case "USAGE_STATS_SERVICE": {
                    string = "android.app.usage.UsageStatsManager";
                    break;
                }
                case "USB_SERVICE": {
                    string = "android.hardware.usb.UsbManager";
                    break;
                }
                case "USER_SERVICE": {
                    string = "android.os.UserManager";
                    break;
                }
                case "VIBRATOR_MANAGER_SERVICE": {
                    string = "android.os.VibratorManager";
                    break;
                }
                case "VIBRATOR_SERVICE": {
                    string = "android.os.Vibrator";
                    break;
                }
                case "VIRTUAL_DEVICE_SERVICE": {
                    string = "android.companion.virtual.VirtualDeviceManager";
                    break;
                }
                case "VPN_MANAGEMENT_SERVICE": {
                    string = "android.net.VpnManager";
                    break;
                }
                case "WALLPAPER_SERVICE": {
                    string = "android.app.WallpaperManager";
                    break;
                }
                case "WIFI_AWARE_SERVICE": {
                    string = "android.net.wifi.aware.WifiAwareManager";
                    break;
                }
                case "WIFI_P2P_SERVICE": {
                    string = "android.net.wifi.p2p.WifiP2pManager";
                    break;
                }
                case "WIFI_RTT_RANGING_SERVICE": {
                    string = "android.net.wifi.rtt.WifiRttManager";
                    break;
                }
                case "WIFI_SERVICE": {
                    string = "android.net.wifi.WifiManager";
                    break;
                }
                case "WINDOW_SERVICE": {
                    string = "android.view.WindowManager";
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

