/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/KotlincFE10Detector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "lint-checks"})
public final class KotlincFE10Detector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(KotlincFE10Detector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UCallableReferenceExpression.class, UClassLiteralExpression.class, UParameter.class, USimpleNameReferenceExpression.class, UTypeReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            @NotNull
            private final Map<Pair<File, Integer>, Set<String>> reportHistory;
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
                this.reportHistory = new LinkedHashMap<K, V>();
            }

            public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getType();
                if (object == null || (object = object.getCanonicalText()) == null) {
                    return;
                }
                Object fqName = object;
                if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, (String)fqName)) {
                    this.reportFE10Usage((UElement)node, (String)fqName);
                }
            }

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkFE10Usage((UResolvable)node);
            }

            public void visitParameter(@NotNull UParameter node) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
                    if (uTypeReferenceExpression == null) break block0;
                    UTypeReferenceExpression it = uTypeReferenceExpression;
                    boolean bl = false;
                    this.visitTypeReferenceExpression(it);
                }
            }

            public void visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkFE10Usage(node);
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getSourcePsi() == null) {
                    return;
                }
                this.checkFE10Usage((UResolvable)node);
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkFE10Usage((UResolvable)node);
            }

            private final <T extends UResolvable & UElement> void checkFE10Usage(T uElement) {
                block0: {
                    PsiElement psiElement = uElement.resolve();
                    if (psiElement == null) break block0;
                    PsiElement it = psiElement;
                    boolean bl = false;
                    this.checkFE10Usage(uElement, it);
                }
            }

            private final <T extends UElement> void checkFE10Usage(T uElement, PsiElement resolvedElement) {
                PsiElement psiElement = resolvedElement;
                if (psiElement instanceof PsiClass) {
                    String string = ((PsiClass)resolvedElement).getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    String fqName = string;
                    if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, fqName)) {
                        this.reportFE10Usage(uElement, fqName);
                    }
                } else if (psiElement instanceof PsiMember) {
                    PsiClass psiClass = ((PsiMember)resolvedElement).getContainingClass();
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass containingClass = psiClass;
                    String string = containingClass.getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    String fqName = string;
                    if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, fqName)) {
                        this.reportFE10Usage(uElement, fqName);
                        return;
                    }
                    if (resolvedElement instanceof PsiMethod) {
                        Object object = ((PsiMethod)resolvedElement).getReturnType();
                        if (object == null || (object = object.getCanonicalText()) == null) {
                            return;
                        }
                        Object returnType = object;
                        if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, (String)returnType)) {
                            this.reportFE10Usage(uElement, (String)returnType);
                        }
                    }
                } else if (psiElement instanceof PsiVariable) {
                    String string = ((PsiVariable)resolvedElement).getType().getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                    String fqName = string;
                    if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, fqName)) {
                        this.reportFE10Usage(uElement, fqName);
                    }
                }
            }

            private final void checkFE10Usage(UTypeReferenceExpression node) {
                String string = node.getQualifiedName();
                if (string == null) {
                    return;
                }
                String fqName = string;
                if (com.android.tools.lint.checks.KotlincFE10Detector$Companion.access$isFE10Specific(KotlincFE10Detector.Companion, fqName)) {
                    this.reportFE10Usage((UElement)node, fqName);
                }
            }

            private final void reportFE10Usage(UElement node, String fqName) {
                Location location = this.$context.getLocation(node);
                if (this.isAlreadyReported(location, fqName)) {
                    return;
                }
                this.recordReport(location, fqName);
                String message2 = fqName + " appears to be part of the old K1 Kotlin compiler. Avoid using it if possible; K1 will be going away soon.";
                JavaContext.report$default((JavaContext)this.$context, (Issue)KotlincFE10Detector.ISSUE, (UElement)node, (Location)location, (String)message2, null, (int)16, null);
            }

            private final Pair<File, Integer> toReportKey(Location $this$toReportKey) {
                Position position = $this$toReportKey.getStart();
                return TuplesKt.to((Object)$this$toReportKey.getFile(), (Object)(position != null ? position.getLine() : 0));
            }

            /*
             * WARNING - void declaration
             */
            private final boolean isAlreadyReported(Location location, String name) {
                Object object;
                void $this$getOrPut$iv;
                Map<Pair<File, Integer>, Set<String>> map = this.reportHistory;
                Pair<File, Integer> key$iv = this.toReportKey(location);
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set reportHistoryInFile = (Set)object;
                return reportHistoryInFile.contains(name);
            }

            /*
             * WARNING - void declaration
             */
            private final void recordReport(Location location, String name) {
                Object object;
                void $this$getOrPut$iv;
                Map<Pair<File, Integer>, Set<String>> map = this.reportHistory;
                Pair<File, Integer> key$iv = this.toReportKey(location);
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set reportHistoryInFile = (Set)object;
                reportHistoryInFile.add(name);
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CUSTOM_LINT_CHECKS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet enumSet = Platform.JDK_SET;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"KotlincFE10", (String)"Avoid using old K1 Kotlin compiler APIs", (String)"\n                K2, the new version of Kotlin compiler, which encompasses the new frontend, is coming. \\\n                Try to avoid using internal APIs from the old frontend if possible.\n            ", (Implementation)implementation, null, (Category)category, (int)4, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2576, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/KotlincFE10Detector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "isAllowed", "", "fqName", "", "isFE10Specific", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAllowed(String fqName) {
            boolean bl;
            switch (fqName) {
                case "org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget": {
                    bl = true;
                    break;
                }
                case "org.jetbrains.kotlin.descriptors.Modality": {
                    bl = true;
                    break;
                }
                case "org.jetbrains.kotlin.descriptors.Visibility": {
                    bl = true;
                    break;
                }
                case "org.jetbrains.kotlin.resolve.ImportPath": {
                    bl = true;
                    break;
                }
                case "org.jetbrains.kotlin.resolve.jvm.checkers.DalvikIdentifierUtils": {
                    bl = true;
                    break;
                }
                default: {
                    bl = StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.descriptors.EffectiveVisibility", (boolean)false, (int)2, null) ? true : StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.descriptors.Visibilities", (boolean)false, (int)2, null);
                }
            }
            return bl;
        }

        private final boolean isFE10Specific(String fqName) {
            return this.isAllowed(fqName) ? false : (StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.descriptors", (boolean)false, (int)2, null) ? true : (StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.load.java.descriptors", (boolean)false, (int)2, null) ? true : (StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.resolve", (boolean)false, (int)2, null) ? true : StringsKt.startsWith$default((String)fqName, (String)"org.jetbrains.kotlin.types", (boolean)false, (int)2, null))));
        }

        public static final /* synthetic */ boolean access$isFE10Specific(Companion $this, String fqName) {
            return $this.isFE10Specific(fqName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

