/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/IntentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class IntentDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String INTENT_CLASS = "android.content.Intent";
    @NotNull
    private static final String ANDROID_NET_URI = "android.net.Uri";
    @NotNull
    private static final String SET_DATA = "setData";
    @NotNull
    private static final String SET_TYPE = "setType";

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)INTENT_CLASS);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Ref.BooleanRef seenInConstructor = new Ref.BooleanRef();
        Ref.ObjectRef seenData = new Ref.ObjectRef();
        Ref.ObjectRef seenType = new Ref.ObjectRef();
        for (UExpression topArgument : node.getValueArguments()) {
            PsiType type;
            UExpression argument;
            if (UastUtils.skipParenthesizedExprDown((UExpression)topArgument) == null || argument.getExpressionType() == null || !Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)ANDROID_NET_URI) || argument instanceof ULiteralExpression && ((ULiteralExpression)argument).isNull()) continue;
            seenInConstructor.element = true;
            seenData.element = argument;
            break;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        List list = CollectionsKt.listOf((Object)node);
        DataFlowAnalyzer analyzer2 = new DataFlowAnalyzer((Ref.ObjectRef<UElement>)seenData, (Ref.ObjectRef<UElement>)seenType, seenInConstructor, context, list){
            final /* synthetic */ Ref.ObjectRef<UElement> $seenData;
            final /* synthetic */ Ref.ObjectRef<UElement> $seenType;
            final /* synthetic */ Ref.BooleanRef $seenInConstructor;
            final /* synthetic */ JavaContext $context;
            {
                this.$seenData = $seenData;
                this.$seenType = $seenType;
                this.$seenInConstructor = $seenInConstructor;
                this.$context = $context;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                String string;
                UElement prev;
                UExpression parent;
                UElement typeParent;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                List args = call.getValueArguments();
                if (args.size() != 1) {
                    return;
                }
                UExpression arg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)));
                if (arg instanceof ULiteralExpression && ((ULiteralExpression)arg).isNull()) {
                    return;
                }
                String name = call.getMethodName();
                String string2 = name;
                if (Intrinsics.areEqual((Object)string2, (Object)"setData")) {
                    this.$seenData.element = call;
                } else if (Intrinsics.areEqual((Object)string2, (Object)"setType")) {
                    this.$seenType.element = call;
                } else {
                    return;
                }
                if ((UElement)this.$seenData.element == null) {
                    return;
                }
                if ((UElement)this.$seenType.element == null) {
                    return;
                }
                UElement dataParent = this.findParent((UElement)this.$seenData.element);
                if (!Intrinsics.areEqual((Object)dataParent, (Object)(typeParent = this.findParent((UElement)this.$seenType.element)))) {
                    return;
                }
                if (dataParent instanceof UIfExpression && (parent = ((UIfExpression)dataParent).getThenExpression()) != null) {
                    Object object = this.$seenData.element;
                    Intrinsics.checkNotNull((Object)object);
                    boolean bl = UastLintUtilsKt.isBelow$default((UElement)((UElement)object), (UElement)((UElement)parent), (boolean)false, (int)2, null);
                    Object object2 = this.$seenType.element;
                    Intrinsics.checkNotNull((Object)object2);
                    if (bl != UastLintUtilsKt.isBelow$default((UElement)((UElement)object2), (UElement)((UElement)parent), (boolean)false, (int)2, null)) {
                        return;
                    }
                }
                UElement uElement = prev = Intrinsics.areEqual((Object)name, (Object)"setData") ? (UElement)this.$seenType.element : (UElement)this.$seenData.element;
                if (this.$seenInConstructor.element) {
                    string = "setting URI in `Intent` constructor";
                } else {
                    UCallExpression uCallExpression = prev instanceof UCallExpression ? (UCallExpression)prev : null;
                    string = "calling `" + (uCallExpression == null ? null : uCallExpression.getMethodName()) + '`';
                }
                String prevDesc = string;
                String data = Intrinsics.areEqual((Object)name, (Object)"setData") ? "type" : "data";
                Location location = Location.withSecondary$default((Location)this.$context.getCallLocation(call, false, true), (Location)Context.getLocation$default((Context)((Context)this.$context), (Object)prev, null, (int)2, null), (String)"Originally set here", (boolean)false, (int)4, null);
                String message2 = "Calling `" + name + "` after " + prevDesc + " will clear the " + data + ": Call `setDataAndType` instead?";
                this.$context.report(IntentDetector.ISSUE, (UElement)call, location, message2, null);
                this.$seenData.element = null;
                this.$seenType.element = null;
            }

            private final UElement findParent(UElement call) {
                if (call == null) {
                    return null;
                }
                Class[] classArray = new Class[]{UBlockExpression.class, UIfExpression.class, USwitchClauseExpression.class};
                return UastUtils.getParentOfType((UElement)call, (boolean)true, UMethod.class, (Class[])classArray);
            }
        };
        method.accept((UastVisitor)analyzer2);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(IntentDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"IntentReset", (String)"Suspicious mix of `setType` and `setData`", (String)"\n                Intent provides the following APIs: `setData(Uri)` and `setType(String)`. \\\n                Unfortunately, setting one clears the other. If you want to set both, you \\\n                should call `setDataAndType(Uri, String)` instead.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/IntentDetector$Companion;", "", "()V", "ANDROID_NET_URI", "", "INTENT_CLASS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SET_DATA", "SET_TYPE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

