/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J*\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00132\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J(\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0015H\u0016J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/DefaultEncodingDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "addCharsetArgFixes", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "fixes", "", "Lcom/android/tools/lint/detector/api/LintFix;", "isKotlin", "", "name", "", "languageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "addFix", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "qualifiedName", "createFix", "getApplicableConstructorTypes", "", "getApplicableMethodNames", "getOuterBufferWrapper", "Lorg/jetbrains/uast/UExpression;", "haveCharset", "call", "firstStringCharsetIndex", "", "isBufferWrapper", "report", "visitConstructor", "constructor", "visitMethodCall", "Issues", "lint-checks"})
public final class DefaultEncodingDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(DefaultEncodingDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String JAVA_IO_INPUT_STREAM_READER = "java.io.InputStreamReader";
    @NotNull
    private static final String JAVA_IO_FILE_INPUT_STREAM = "java.io.FileInputStream";
    @NotNull
    private static final String JAVA_IO_FILE_OUTPUT_STREAM = "java.io.FileOutputStream";
    @NotNull
    private static final String JAVA_IO_OUTPUT_STREAM_WRITER = "java.io.OutputStreamWriter";
    @NotNull
    private static final String JAVA_IO_INPUT_STREAM = "java.io.InputStream";
    @NotNull
    private static final String JAVA_IO_FILE_READER = "java.io.FileReader";
    @NotNull
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    @NotNull
    private static final String JAVA_NIO_CHANNELS_READABLE_BYTE_CHANNEL = "java.nio.channels.ReadableByteChannel";
    @NotNull
    private static final String JAVA_IO_FILE = "java.io.File";
    @NotNull
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    @NotNull
    private static final String JAVA_IO_OUTPUT_STREAM = "java.io.OutputStream";
    @NotNull
    private static final String JAVA_IO_PRINT_WRITER = "java.io.PrintWriter";
    @NotNull
    private static final String JAVA_IO_FILE_WRITER = "java.io.FileWriter";
    @NotNull
    private static final String JAVA_IO_FILE_DESCRIPTOR = "java.io.FileDescriptor";
    @NotNull
    private static final String JAVA_NIO_CHARSET_CHARSET = "java.nio.charset.Charset";
    @NotNull
    private static final String JAVA_IO_BYTE_ARRAY_OUTPUT_STREAM = "java.io.ByteArrayOutputStream";
    @NotNull
    private static final String JAVA_UTF8_CHARSET = "java.nio.charset.StandardCharsets.UTF_8";
    @NotNull
    private static final String KOTLIN_UTF8_CHARSET = "kotlin.text.Charsets.UTF_8";
    @NotNull
    private static final String DEFAULT_CHARSET = "java.nio.charset.Charset.defaultCharset()";
    @NotNull
    private static final String TYPE_BYTE_ARRAY = "byte[]";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getBytes", "toString"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        JavaEvaluator evaluator = context.getEvaluator();
        if (Intrinsics.areEqual((Object)name, (Object)"toString") && node.getValueArgumentCount() == 0 && evaluator.isMemberInClass((PsiMember)method, JAVA_IO_BYTE_ARRAY_OUTPUT_STREAM)) {
            this.report(context, node, method, JAVA_IO_BYTE_ARRAY_OUTPUT_STREAM);
        } else if (Intrinsics.areEqual((Object)name, (Object)"getBytes") && evaluator.isMemberInClass((PsiMember)method, "java.lang.String") && !this.haveCharset(node, 0)) {
            String constant;
            UExpression uExpression = node.getReceiver();
            String string2 = constant = uExpression == null ? null : UastUtils.evaluateString((UExpression)uExpression);
            if (constant != null) {
                boolean bl;
                block6: {
                    CharSequence $this$all$iv = constant;
                    boolean $i$f$all = false;
                    CharSequence charSequence = $this$all$iv;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence.charAt(i);
                        boolean bl2 = false;
                        if (it <= '\u0080') continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
            }
            this.report(context, node, method, "java.lang.String");
        }
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{"java.lang.String", JAVA_IO_FILE_READER, JAVA_IO_FILE_WRITER, JAVA_IO_PRINT_WRITER, JAVA_IO_INPUT_STREAM_READER, JAVA_IO_OUTPUT_STREAM_WRITER, JAVA_UTIL_SCANNER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean haveCharset(UCallExpression call, int firstStringCharsetIndex) {
        List valueArguments = call.getValueArguments();
        int n = 0;
        int n2 = valueArguments.size();
        while (n < n2) {
            boolean bl;
            String type;
            String string;
            int i = n++;
            UExpression argument = (UExpression)valueArguments.get(i);
            PsiType psiType = argument.getExpressionType();
            if (psiType == null) {
                string = "";
            } else {
                string = psiType.getCanonicalText();
                if (string == null) {
                    string = type = "";
                }
            }
            if (StringsKt.startsWith$default((String)type, (String)JAVA_NIO_CHARSET_CHARSET, (boolean)false, (int)2, null)) {
                return true;
            }
            if (i >= firstStringCharsetIndex && Intrinsics.areEqual((Object)type, (Object)"java.lang.String")) {
                return true;
            }
            PsiElement psiElement = argument.getSourcePsi();
            if (psiElement == null) {
                bl = false;
            } else {
                String string2 = psiElement.getText();
                bl = string2 == null ? false : StringsKt.contains$default((CharSequence)string2, (CharSequence)"Charset", (boolean)false, (int)2, null);
            }
            if (!bl) continue;
            throw (Throwable)new IllegalStateException("Unexpected".toString());
        }
        return false;
    }

    static /* synthetic */ boolean haveCharset$default(DefaultEncodingDetector defaultEncodingDetector, UCallExpression uCallExpression, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return defaultEncodingDetector.haveCharset(uCallExpression, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        PsiClass psiClass = constructor.getContainingClass();
        if (psiClass == null) {
            return;
        }
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String qualifiedName = string;
        JavaEvaluator evaluator = context.getEvaluator();
        switch (qualifiedName) {
            case "java.lang.String": {
                UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                if (uExpression == null) {
                    return;
                }
                PsiType psiType = uExpression.getExpressionType();
                if (psiType == null) {
                    return;
                }
                PsiType expressionType = psiType;
                String string2 = expressionType.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expressionType.canonicalText");
                String canonicalText = string2;
                if (!Intrinsics.areEqual((Object)canonicalText, (Object)TYPE_BYTE_ARRAY)) return;
                if (DefaultEncodingDetector.haveCharset$default(this, node, 0, 2, null)) return;
                this.report(context, node, constructor, qualifiedName);
                return;
            }
            case "java.io.FileWriter": 
            case "java.io.FileReader": {
                if (DefaultEncodingDetector.haveCharset$default(this, node, 0, 2, null)) return;
                if (node.getValueArgumentCount() == 1) {
                    PsiType psiType = ((UExpression)node.getValueArguments().get(0)).getExpressionType();
                    if (Intrinsics.areEqual((Object)(psiType == null ? null : psiType.getCanonicalText()), (Object)JAVA_IO_FILE_DESCRIPTOR)) {
                        return;
                    }
                }
                this.report(context, node, constructor, qualifiedName);
                return;
            }
            case "java.io.PrintWriter": {
                UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                if (uExpression == null) {
                    return;
                }
                PsiType psiType = uExpression.getExpressionType();
                if (psiType == null) {
                    return;
                }
                PsiType expressionType = psiType;
                String string3 = expressionType.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"expressionType.canonicalText");
                String canonicalText = string3;
                if (!(Intrinsics.areEqual((Object)canonicalText, (Object)"java.lang.String") || Intrinsics.areEqual((Object)canonicalText, (Object)JAVA_IO_FILE) || StringsKt.endsWith$default((String)canonicalText, (String)"Stream", (boolean)false, (int)2, null))) {
                    if (!JavaEvaluator.extendsClass$default((JavaEvaluator)evaluator, (PsiClass)evaluator.getTypeClass(expressionType), (String)JAVA_IO_OUTPUT_STREAM, (boolean)false, (int)4, null)) return;
                }
                if (DefaultEncodingDetector.haveCharset$default(this, node, 0, 2, null)) return;
                this.report(context, node, constructor, qualifiedName);
                return;
            }
            case "java.io.OutputStreamWriter": 
            case "java.io.InputStreamReader": {
                if (DefaultEncodingDetector.haveCharset$default(this, node, 0, 2, null)) return;
                this.report(context, node, constructor, qualifiedName);
                return;
            }
            case "java.util.Scanner": {
                String string4;
                PsiParameter[] psiParameterArray = constructor.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"constructor.parameterList.parameters");
                PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])psiParameterArray);
                if (psiParameter == null) {
                    string4 = "";
                } else {
                    PsiType psiType = psiParameter.getType();
                    if (psiType == null) {
                        string4 = "";
                    } else {
                        string4 = psiType.getCanonicalText();
                        if (string4 == null) {
                            string4 = "";
                        }
                    }
                }
                switch (string4) {
                    case "java.nio.channels.ReadableByteChannel": 
                    case "java.nio.file.Path": 
                    case "java.io.File": 
                    case "java.io.InputStream": {
                        if (DefaultEncodingDetector.haveCharset$default(this, node, 0, 2, null)) return;
                        this.report(context, node, constructor, qualifiedName);
                    }
                }
            }
        }
    }

    private final void report(JavaContext context, UCallExpression node, PsiMethod method, String qualifiedName) {
        String string;
        String charset = Lint.isKotlin((PsiElement)node.getSourcePsi()) ? "Charsets.UTF_8" : "StandardCharsets.UTF_8";
        String typeName = StringsKt.substringAfterLast$default((String)qualifiedName, (char)'.', null, (int)2, null);
        String message2 = Intrinsics.areEqual((Object)qualifiedName, (Object)"java.lang.String") ? "This string will be interpreted with the default system encoding instead of a specific charset which is usually a mistake" : (StringsKt.startsWith$default((String)typeName, (String)"File", (boolean)false, (int)2, null) ? "This file will be " + (StringsKt.endsWith$default((String)typeName, (String)"Writer", (boolean)false, (int)2, null) ? "written" : "read") + " with the default system encoding instead of a specific charset which is usually a mistake" : (Intrinsics.areEqual((Object)qualifiedName, (Object)JAVA_IO_BYTE_ARRAY_OUTPUT_STREAM) ? "This string will be decoded with the default system encoding instead of a specific charset which is usually a mistake" : "This `" + typeName + "` will use the default system encoding instead of a specific charset which is usually a mistake"));
        LintFix fix = this.createFix(context, node, method, qualifiedName);
        String fixSuggestion = fix != null ? (fix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)fix).getType() == LintFix.GroupType.ALTERNATIVES ? ((LintFix)((LintFix.LintFixGroup)fix).getFixes().get(0)).getDisplayName() : fix.getDisplayName()) : "add `" + charset + '`';
        Location location = context.getLocation((UElement)node);
        StringBuilder stringBuilder = new StringBuilder().append(message2).append("; ");
        String string2 = fixSuggestion;
        if (string2 == null) {
            string = null;
        } else {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            string = StringsKt.decapitalize((String)string2, (Locale)locale);
        }
        Incident incident = new Incident(ISSUE, location, stringBuilder.append((Object)string).append('?').toString());
        incident.fix(fix);
        context.report(incident, Constraints.notAndroidProject());
    }

    private final LintFix createFix(JavaContext context, UCallExpression node, PsiMethod method, String qualifiedName) {
        LintFix lintFix;
        List fixes = new ArrayList();
        this.addFix(fixes, context, node, method, qualifiedName);
        if (fixes.size() > 1) {
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            if (lintFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LintFix[] lintFixArray2 = lintFixArray;
            lintFix = this.fix().alternatives(Arrays.copyOf(lintFixArray2, lintFixArray2.length));
        } else {
            lintFix = (LintFix)CollectionsKt.firstOrNull((List)fixes);
        }
        return lintFix;
    }

    private final void addFix(List<LintFix> fixes, JavaContext context, UCallExpression node, PsiMethod method, String qualifiedName) {
        boolean isKotlin = Lint.isKotlin((PsiElement)node.getSourcePsi());
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        UIdentifier uIdentifier = node.getMethodIdentifier();
        String string2 = uIdentifier == null ? null : uIdentifier.getName();
        if (string2 == null) {
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"method.name");
            string2 = string3;
        }
        String call = string2;
        JavaEvaluator evaluator = context.getEvaluator();
        switch (qualifiedName) {
            case "java.lang.String": {
                if (Intrinsics.areEqual((Object)name, (Object)"getBytes")) {
                    if (isKotlin) {
                        UIdentifier uIdentifier2 = node.getMethodIdentifier();
                        String pattern = Intrinsics.areEqual((Object)(uIdentifier2 == null ? null : uIdentifier2.getName()), (Object)"bytes") ? "bytes" : "getBytes\\s*\\(\\s*\\)";
                        fixes.add(this.fix().name("Replace with `encodeToByteArray()`").replace().pattern(pattern).with("encodeToByteArray()").shortenNames().build());
                        fixes.add(this.fix().name("Replace with `toByteArray(UTF_8)`").replace().pattern(pattern).with("toByteArray(kotlin.text.Charsets.UTF_8)").shortenNames().build());
                        fixes.add(this.fix().name("Replace with `toByteArray(defaultCharset())`").replace().pattern(pattern).with("toByteArray(java.nio.charset.Charset.defaultCharset())").shortenNames().build());
                        break;
                    }
                    String oldPattern = "\\(\\s*\\)";
                    fixes.add(this.fix().name("Add charset argument, `getBytes(UTF_8)`").replace().pattern(oldPattern).with("(java.nio.charset.StandardCharsets.UTF_8)").shortenNames().build());
                    fixes.add(this.fix().name("Add charset argument, `getBytes(defaultCharset())`").replace().pattern(oldPattern).with("(java.nio.charset.Charset.defaultCharset())").shortenNames().build());
                    break;
                }
                String[] oldPattern = new String[]{TYPE_BYTE_ARRAY};
                if (!evaluator.parametersMatch(method, oldPattern) && !evaluator.parametersMatch(method, oldPattern = new String[]{TYPE_BYTE_ARRAY, "int", "int"})) break;
                DefaultEncodingDetector.addCharsetArgFixes$default(this, context, fixes, isKotlin, call, null, 16, null);
                break;
            }
            case "java.io.FileWriter": 
            case "java.io.OutputStreamWriter": 
            case "java.io.FileReader": 
            case "java.io.InputStreamReader": {
                boolean reading;
                boolean fileBased;
                boolean bl = fileBased = Intrinsics.areEqual((Object)qualifiedName, (Object)JAVA_IO_FILE_READER) || Intrinsics.areEqual((Object)qualifiedName, (Object)JAVA_IO_FILE_WRITER);
                if (fileBased && !evaluator.parameterHasType(method, 0, JAVA_IO_FILE)) {
                    return;
                }
                boolean bl2 = reading = Intrinsics.areEqual((Object)qualifiedName, (Object)JAVA_IO_FILE_READER) || Intrinsics.areEqual((Object)qualifiedName, (Object)JAVA_IO_INPUT_STREAM_READER);
                if (isKotlin) {
                    UExpression outer = this.getOuterBufferWrapper(node);
                    UExpression uExpression = outer;
                    if (uExpression == null) {
                        uExpression = (UExpression)node;
                    }
                    UExpression rangeNode = uExpression;
                    Location range = context.getLocation((Object)rangeNode, LocationType.ALL);
                    String replacement = outer != null ? (reading ? "bufferedReader" : "bufferedWriter") : (reading ? "reader" : "writer");
                    UExpression uExpression2 = (UExpression)CollectionsKt.singleOrNull((List)node.getValueArguments());
                    UExpression arg = uExpression2 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
                    String receiver = arg instanceof USimpleNameReferenceExpression ? Intrinsics.stringPlus((String)((USimpleNameReferenceExpression)arg).getIdentifier(), (Object)".") : "";
                    String oldPattern = "(.*" + call + "\\s*\\(\\s*([^)]+)\\s*\\).*)";
                    fixes.add(this.fix().name("Replace with `" + receiver + replacement + "()` (uses UTF-8)").replace().pattern(oldPattern).with("\\k<2>." + replacement + "()").shortenNames().range(range).build());
                    fixes.add(this.fix().name("Replace with `" + receiver + replacement + "(defaultCharset())`").replace().pattern(oldPattern).with("\\k<2>." + replacement + "(java.nio.charset.StandardCharsets.UTF_8)").shortenNames().range(range).build());
                    break;
                }
                if (context.getProject().getJavaLanguageLevel().isAtLeast(LanguageLevel.JDK_11)) {
                    this.addCharsetArgFixes(context, fixes, false, call, LanguageLevel.JDK_11);
                    break;
                }
                if (!fileBased) break;
                String replacement = reading ? "new java.io.InputStreamReader(new java.io.FileInputStream(\\k<2>), %1$s)" : "new java.io.OutputStreamWriter(new java.io.FileOutputStream(\\k<2>), %1$s)";
                Location range = context.getLocation((Object)node, LocationType.ALL);
                String oldPattern = "(.*\\(\\s*([^)]+)\\s*\\).*)";
                String summary = reading ? "InputStreamReader(FileInputStream(" : "OutputStreamWriter(FileOutputStream(..., ";
                LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().name("Replace with `" + summary + "..., UTF8)`").replace().pattern(oldPattern);
                Object[] objectArray = new Object[]{JAVA_UTF8_CHARSET};
                String string4 = String.format(replacement, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                fixes.add(replaceStringBuilder.with(string4).shortenNames().range(range).build());
                LintFix.ReplaceStringBuilder replaceStringBuilder2 = this.fix().name("Replace with `" + summary + "..., defaultCharset())`").replace().pattern(oldPattern);
                objectArray = new Object[]{DEFAULT_CHARSET};
                String string5 = String.format(replacement, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                fixes.add(replaceStringBuilder2.with(string5).shortenNames().range(range).build());
                break;
            }
            case "java.io.PrintWriter": 
            case "java.util.Scanner": {
                this.addCharsetArgFixes(context, fixes, isKotlin, call, LanguageLevel.JDK_10);
            }
        }
    }

    private final void addCharsetArgFixes(JavaContext context, List<LintFix> fixes, boolean isKotlin, String name, LanguageLevel languageLevel) {
        if (context.getProject().getJavaLanguageLevel().isAtLeast(languageLevel)) {
            String utf8 = isKotlin ? KOTLIN_UTF8_CHARSET : JAVA_UTF8_CHARSET;
            String pattern = "\\(\\s*(.*)\\)";
            fixes.add(this.fix().name("Add charset argument, `" + name + "(..., UTF_8)`").replace().pattern(pattern).with(Intrinsics.stringPlus((String)"\\k<1>, ", (Object)utf8)).shortenNames().build());
            fixes.add(this.fix().name("Add charset argument, `" + name + "(..., defaultCharset())`").replace().pattern(pattern).with("\\k<1>, java.nio.charset.Charset.defaultCharset()").shortenNames().build());
        }
    }

    static /* synthetic */ void addCharsetArgFixes$default(DefaultEncodingDetector defaultEncodingDetector, JavaContext javaContext, List list, boolean bl, String string, LanguageLevel languageLevel, int n, Object object) {
        if ((n & 0x10) != 0) {
            languageLevel = LanguageLevel.JDK_1_7;
        }
        defaultEncodingDetector.addCharsetArgFixes(javaContext, list, bl, string, languageLevel);
    }

    private final UExpression getOuterBufferWrapper(UCallExpression node) {
        UElement curr = node.getUastParent();
        if (curr instanceof UQualifiedReferenceExpression) {
            curr = ((UQualifiedReferenceExpression)curr).getUastParent();
        }
        while (curr != null) {
            if (curr instanceof UQualifiedReferenceExpression) {
                UExpression selector = ((UQualifiedReferenceExpression)curr).getSelector();
                if (selector instanceof UCallExpression && this.isBufferWrapper(((UCallExpression)selector).resolve())) {
                    return (UExpression)curr;
                }
                return null;
            }
            if (curr instanceof UCallExpression) {
                if (this.isBufferWrapper(((UCallExpression)curr).resolve())) {
                    return (UExpression)curr;
                }
                return null;
            }
            if (!(curr instanceof UParenthesizedExpression)) break;
            curr = ((UParenthesizedExpression)curr).getUastParent();
        }
        return null;
    }

    private final boolean isBufferWrapper(PsiMethod method) {
        String string;
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            string = null;
        } else {
            PsiClass psiClass = psiMethod.getContainingClass();
            string = psiClass == null ? null : psiClass.getQualifiedName();
        }
        if (string == null) {
            return false;
        }
        String containingClass = string;
        return StringsKt.startsWith$default((String)containingClass, (String)"java.io.Buffered", (boolean)false, (int)2, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet enumSet = Platform.JDK_SET;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"DefaultEncoding", (String)"Using Default Character Encoding", (String)"\n                Some APIs will implicitly use the default system character encoding \\\n                instead of UTF-8 when converting to or from bytes, such as when creating \\\n                a default `FileReader`.\n\n                This is *usually* not correct; you only want to do this if you need to read \\\n                files created by other programs where they have deliberately written in the \\\n                same encoding. The default encoding varies from platform to platform and can \\\n                vary from locale to locale, so this makes it difficult to interpret files \\\n                containing non-ASCII characters.\n\n                We recommend using UTF-8 everywhere.\n\n                Note that on Android, the default file encoding is always UTF-8 (see \\\n                https://developer.android.com/reference/java/nio/charset/Charset#defaultCharset() \\\n                for more), so this lint check deliberately does not flag any problems in \\\n                Android code, since it is always safe to rely on the default character \\\n                encoding there.\n                ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2640, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/DefaultEncodingDetector$Issues;", "", "()V", "DEFAULT_CHARSET", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JAVA_IO_BYTE_ARRAY_OUTPUT_STREAM", "JAVA_IO_FILE", "JAVA_IO_FILE_DESCRIPTOR", "JAVA_IO_FILE_INPUT_STREAM", "JAVA_IO_FILE_OUTPUT_STREAM", "JAVA_IO_FILE_READER", "JAVA_IO_FILE_WRITER", "JAVA_IO_INPUT_STREAM", "JAVA_IO_INPUT_STREAM_READER", "JAVA_IO_OUTPUT_STREAM", "JAVA_IO_OUTPUT_STREAM_WRITER", "JAVA_IO_PRINT_WRITER", "JAVA_NIO_CHANNELS_READABLE_BYTE_CHANNEL", "JAVA_NIO_CHARSET_CHARSET", "JAVA_NIO_FILE_PATH", "JAVA_UTF8_CHARSET", "JAVA_UTIL_SCANNER", "KOTLIN_UTF8_CHARSET", "TYPE_BYTE_ARRAY", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

