/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u001c\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u00101\u001a\u00020,H\u0016J \u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/SliceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkHasContent", "", "qualifiedName", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lorg/jetbrains/uast/UMethod;", "checkListBuilder", "listBuilder", "checkManifest", "Lcom/android/tools/lint/detector/api/Context;", "sliceProvider", "onMapMethodLocation", "Lcom/android/tools/lint/detector/api/Location;", "declarationLocation", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "checkRowBuilder", "ensureSingleToggleType", "endActionItems", "", "Lorg/jetbrains/uast/UExpression;", "message", "findRows", "findSliceActionConstructor", "Lorg/jetbrains/uast/UElement;", "getApplicableConstructorTypes", "isAddRowMethod", "", "methodName", "isBuildConsumer", "call", "isContentMethod", "isCustomToggle", "Lcom/intellij/psi/PsiMethod;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "visitConstructor", "constructor", "warnMissingContent", "builder", "Companion", "lint-checks"})
public final class SliceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SliceDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ICON_CLASS = "android.graphics.drawable.Icon";
    @NotNull
    private static final String ICON_COMPAT_CLASS_1 = "androidx.core.graphics.drawable.IconCompat";
    @NotNull
    private static final String ICON_COMPAT_CLASS_2 = "android.support.v4.graphics.drawable.IconCompat";
    @NotNull
    private static final String SLICE_PROVIDER_CLASS_1 = "androidx.slice.SliceProvider";
    @NotNull
    private static final String SLICE_PROVIDER_CLASS_2 = "android.app.slice.SliceProvider";
    @NotNull
    private static final String SLICE_ACTION_CLASS = "androidx.slice.builders.SliceAction";
    @NotNull
    private static final String LIST_BUILDER_CLASS = "androidx.slice.builders.ListBuilder";
    @NotNull
    private static final String LIST_INPUT_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.InputRangeBuilder";
    @NotNull
    private static final String LIST_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RangeBuilder";
    @NotNull
    private static final String LIST_HEADER_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.HeaderBuilder";
    @NotNull
    private static final String GRID_ROW_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder";
    @NotNull
    private static final String GRID_ROW_CELL_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder.CellBuilder";
    @NotNull
    private static final String ROW_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RowBuilder";
    @NotNull
    private static final String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static final boolean WARN_ABOUT_TOO_MANY_ROWS = false;
    @NotNull
    private static final String KEY_DECLARATION = "declaration";
    @NotNull
    private static final String KEY_MAP_METHOD = "onMapMethod";

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{SLICE_PROVIDER_CLASS_1, SLICE_PROVIDER_CLASS_2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Location location;
        UMethod onMapMethod;
        int n;
        int n2;
        UMethod uMethod;
        String sliceProvider;
        block9: {
            UMethod uMethod2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)KEY_DECLARATION);
            String string = declaration.getQualifiedName();
            if (string == null) {
                return;
            }
            sliceProvider = string;
            UMethod $this$firstOrNull$iv = declaration.getMethods();
            boolean $i$f$firstOrNull = false;
            uMethod = $this$firstOrNull$iv;
            n2 = ((UMethod[])uMethod).length;
            for (n = 0; n < n2; ++n) {
                UMethod element$iv;
                UMethod it = element$iv = uMethod[n];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"onMapIntentToUri") && it.getUastParameters().size() == 1)) continue;
                uMethod2 = element$iv;
                break block9;
            }
            uMethod2 = onMapMethod = null;
        }
        if (onMapMethod != null ? context.getDriver().isSuppressed(context, ISSUE, (UAnnotated)onMapMethod) : context.getDriver().isSuppressed(context, ISSUE, (UAnnotated)declaration)) {
            return;
        }
        UMethod $i$f$firstOrNull = onMapMethod;
        if ($i$f$firstOrNull == null) {
            location = null;
        } else {
            uMethod = $i$f$firstOrNull;
            n2 = 0;
            n = 0;
            UMethod it = uMethod;
            boolean bl = false;
            location = context.getNameLocation(it);
        }
        Location onMapMethodLocation = location;
        Location declarationLocation = context.getNameLocation(declaration);
        if (context.isGlobalAnalysis()) {
            this.checkManifest((Context)context, sliceProvider, onMapMethodLocation, declarationLocation);
        } else {
            PartialResult partial = context.getPartialResults(ISSUE);
            if (onMapMethodLocation != null) {
                LintMap map = new LintMap();
                map.put(KEY_DECLARATION, declarationLocation);
                map.put(KEY_MAP_METHOD, onMapMethodLocation);
                partial.map().put(sliceProvider, map);
            } else {
                partial.map().put(sliceProvider, declarationLocation);
            }
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        for (Map.Entry entry : partialResults) {
            Map.Entry entry2 = entry;
            boolean bl = false;
            LintMap map = (LintMap)entry2.getValue();
            for (String sliceProvider : map) {
                boolean bl2 = StringsKt.contains$default((CharSequence)sliceProvider, (char)'.', (boolean)false, (int)2, null);
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Location onMapMethodLocation = null;
                Location declarationLocation = map.getLocation(sliceProvider);
                if (declarationLocation != null) {
                    onMapMethodLocation = null;
                } else {
                    LintMap providerMap;
                    LintMap lintMap = map.getMap(sliceProvider);
                    if (lintMap == null || (lintMap = (providerMap = lintMap).getLocation(KEY_DECLARATION)) == null) continue;
                    declarationLocation = lintMap;
                    onMapMethodLocation = providerMap.getLocation(KEY_MAP_METHOD);
                }
                this.checkManifest(context, sliceProvider, onMapMethodLocation, declarationLocation);
            }
        }
    }

    private final void checkManifest(Context context, String sliceProvider, Location onMapMethodLocation, Location declarationLocation) {
        String manifestName;
        if (context.getMainProject().isLibrary()) {
            return;
        }
        Project mainProject = context.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element element2 = DomExtensions.subtag((Element)root, (String)"application");
        if (element2 == null) {
            return;
        }
        Element application = element2;
        Element provider = DomExtensions.subtag((Element)application, (String)"provider");
        while (provider != null && !Intrinsics.areEqual((Object)sliceProvider, (Object)(manifestName = Lint.resolveManifestName((Element)provider)))) {
            provider = DomExtensions.next((Element)provider, (String)"provider");
        }
        if (provider == null) {
            return;
        }
        Element firstCategory = null;
        Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
        while (intentFilter != null) {
            boolean foundCategory = false;
            Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
            while (category != null) {
                String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)CATEGORY_SLICE, (Object)name)) {
                    foundCategory = true;
                    if (firstCategory != null) break;
                    firstCategory = category;
                    break;
                }
                category = XmlUtils.getNextTagByName((Node)category, (String)"category");
            }
            if (!foundCategory) {
                Location location;
                Element element3 = intentFilter;
                Location location2 = context.getClient().findManifestSourceLocation((Node)element3);
                Location location3 = location = location2 == null ? null : Location.withSecondary$default((Location)location2, (Location)declarationLocation, (String)"SliceProvider declaration", (boolean)false, (int)4, null);
                if (location != null) {
                    context.report(ISSUE, location, "All `SliceProvider` filters require category slice to be set:  <category android:name=\"android.app.slice.category.SLICE\" />", null);
                }
            }
            intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
        }
        if (onMapMethodLocation != null && firstCategory == null) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)onMapMethodLocation, (String)("Define intent filters in your manifest on your `<provider android:name=\"" + sliceProvider + "\">`; otherwise `onMapIntentToUri` will not be called"), null, (int)8, null);
        } else if (firstCategory != null && onMapMethodLocation == null) {
            Location location = context.getClient().findManifestSourceLocation((Node)firstCategory);
            if (location != null) {
                Location location4 = location;
                boolean bl = false;
                boolean bl2 = false;
                Location it = location4;
                boolean bl3 = false;
                declarationLocation.setSecondary(it);
            }
            Context.report$default((Context)context, (Issue)ISSUE, (Location)declarationLocation, (String)"Implement `SliceProvider#onMapIntentToUri` to handle the intents defined on your slice `<provider>` in your manifest", null, (int)8, null);
        }
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{LIST_BUILDER_CLASS, ROW_BUILDER_CLASS, GRID_ROW_BUILDER_CLASS, GRID_ROW_CELL_BUILDER_CLASS, LIST_HEADER_BUILDER_CLASS, LIST_INPUT_RANGE_BUILDER_CLASS, LIST_RANGE_BUILDER_CLASS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        String string;
        String name;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        PsiClass psiClass = constructor.getContainingClass();
        String string3 = string2 = psiClass == null ? null : psiClass.getQualifiedName();
        if (string2 == null) {
            return;
        }
        switch (name = (string = string2)) {
            case "androidx.slice.builders.ListBuilder": {
                this.checkListBuilder(context, node, method);
                break;
            }
            case "androidx.slice.builders.ListBuilder.RowBuilder": {
                this.checkRowBuilder(context, node, method);
                break;
            }
            case "androidx.slice.builders.ListBuilder.HeaderBuilder": 
            case "androidx.slice.builders.GridRowBuilder.CellBuilder": {
                this.checkHasContent(name, context, node, method);
            }
        }
    }

    private final void checkListBuilder(JavaContext context, UCallExpression listBuilder, UMethod method) {
        List<UCallExpression> rows = this.findRows(listBuilder, method);
        if (rows.isEmpty()) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have at least one row added to it", null, (int)16, null);
            return;
        }
        boolean bl = false;
        List initialReferences = new ArrayList();
        for (UCallExpression call : rows) {
            PsiParameter psiParameter;
            UExpression lambda;
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) || !this.isBuildConsumer(call) || !((lambda = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)call.getValueArguments().get(0)))) instanceof ULambdaExpression)) continue;
            List parameters = ((ULambdaExpression)lambda).getValueParameters();
            PsiElement psiElement = ((UParameter)parameters.get(0)).getSourcePsi();
            PsiParameter psiParameter2 = psiParameter = psiElement instanceof PsiParameter ? (PsiParameter)psiElement : null;
            if (psiParameter == null) continue;
            PsiParameter parameter = psiParameter;
            initialReferences.add(parameter);
        }
        Ref.BooleanRef primaryAction = new Ref.BooleanRef();
        method.accept((UastVisitor)new DataFlowAnalyzer(primaryAction, rows, initialReferences){
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            final /* synthetic */ List<UCallExpression> $rows;
            final /* synthetic */ List<PsiVariable> $initialReferences;
            {
                this.$primaryAction = $primaryAction;
                this.$rows = $rows;
                this.$initialReferences = $initialReferences;
                super((Collection<? extends UElement>)$rows, (Collection<? extends PsiVariable>)$initialReferences);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                if (Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) {
                    this.$primaryAction.element = true;
                }
            }
        });
        if (!primaryAction.element) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have a primary action set on one of its rows", null, (int)16, null);
            return;
        }
        Ref.IntRef rowCount = new Ref.IntRef();
        boolean bl2 = false;
        List endActionItems = new ArrayList();
        List list = CollectionsKt.listOf((Object)listBuilder);
        method.accept((UastVisitor)new DataFlowAnalyzer(primaryAction, endActionItems, this, rowCount, context, listBuilder, list){
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            final /* synthetic */ List<UExpression> $endActionItems;
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.IntRef $rowCount;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $listBuilder;
            {
                this.$primaryAction = $primaryAction;
                this.$endActionItems = $endActionItems;
                this.this$0 = $receiver;
                this.$rowCount = $rowCount;
                this.$context = $context;
                this.$listBuilder = $listBuilder;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                block3: {
                    PsiType psiType;
                    String type;
                    String methodName;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        methodName = call.getMethodName();
                        if (!Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) break block2;
                        this.$primaryAction.element = true;
                        break block3;
                    }
                    if (!Intrinsics.areEqual((Object)methodName, (Object)"addAction")) break block3;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)));
                    UExpression uExpression = first;
                    String string = uExpression == null ? null : (type = (psiType = uExpression.getExpressionType()) == null ? null : psiType.getCanonicalText());
                    if (Intrinsics.areEqual(type, (Object)"androidx.slice.builders.SliceAction")) {
                        this.$endActionItems.add(first);
                    }
                }
            }
        });
        this.ensureSingleToggleType(endActionItems, context, "A mixture of slice actions and icons are not supported on a list, add either actions or icons but not both");
    }

    private final boolean isAddRowMethod(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"addRow") || Intrinsics.areEqual((Object)methodName, (Object)"addInputRange") || Intrinsics.areEqual((Object)methodName, (Object)"addRange") || Intrinsics.areEqual((Object)methodName, (Object)"addGridRow");
    }

    private final void ensureSingleToggleType(List<UExpression> endActionItems, JavaContext context, String message2) {
        if (endActionItems.size() >= 2) {
            UExpression custom = null;
            UExpression uExpression = null;
            for (UExpression action : endActionItems) {
                UCallExpression constructorCall;
                PsiMethod psiMethod;
                UCallExpression uCallExpression = this.findSliceActionConstructor((UElement)action);
                if (uCallExpression == null || (psiMethod = (constructorCall = uCallExpression).resolve()) == null) continue;
                PsiMethod constructorMethod = psiMethod;
                if (this.isCustomToggle(constructorMethod)) {
                    custom = action;
                } else {
                    uExpression = action;
                }
                if (custom == null || uExpression == null) continue;
                Location location = Location.withSecondary$default((Location)context.getLocation((UElement)custom), (Location)context.getLocation((UElement)uExpression), (String)"Conflicting action type here", (boolean)false, (int)4, null);
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)custom), (Location)location, (String)message2, null, (int)16, null);
                break;
            }
        }
    }

    private final List<UCallExpression> findRows(UCallExpression node, UMethod method) {
        boolean bl = false;
        List rows = new ArrayList();
        List list = CollectionsKt.listOf((Object)node);
        method.accept((UastVisitor)new DataFlowAnalyzer(rows, this, list){
            final /* synthetic */ List<UCallExpression> $rows;
            final /* synthetic */ SliceDetector this$0;
            {
                this.$rows = $rows;
                this.this$0 = $receiver;
                super($super_call_param$1, null, 2, null);
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                block18: {
                    String string;
                    String qualifiedName;
                    PsiClass psiClass;
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    if (!UastExpressionUtils.isConstructorCall((UElement)((UElement)call))) break block18;
                    PsiMethod psiMethod = call.resolve();
                    String string3 = psiMethod == null ? null : (string2 = (psiClass = psiMethod.getContainingClass()) == null ? null : psiClass.getQualifiedName());
                    if (string2 == null) {
                        return;
                    }
                    switch (qualifiedName = (string = string2)) {
                        case "androidx.slice.builders.ListBuilder.RangeBuilder": 
                        case "androidx.slice.builders.ListBuilder.HeaderBuilder": 
                        case "androidx.slice.builders.ListBuilder.RowBuilder": 
                        case "androidx.slice.builders.GridRowBuilder.CellBuilder": 
                        case "androidx.slice.builders.ListBuilder.InputRangeBuilder": 
                        case "androidx.slice.builders.GridRowBuilder": {
                            this.$rows.add(call);
                        }
                    }
                }
            }

            public void receiver(@NotNull UCallExpression call) {
                block13: {
                    UExpression uExpression;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    if (SliceDetector.access$isBuildConsumer(this.this$0, call)) {
                        this.$rows.add(call);
                    }
                    if (SliceDetector.access$isAddRowMethod(this.this$0, Lint.getMethodName((UCallExpression)call)) && (uExpression = (UExpression)CollectionsKt.firstOrNull((List)call.getValueArguments())) != null) {
                        UExpression uExpression2 = uExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        UExpression it = uExpression2;
                        boolean bl3 = false;
                        UExpression arg = UastUtils.skipParenthesizedExprDown((UExpression)it);
                        if (arg instanceof UCallExpression) {
                            this.argument((UCallExpression)arg, (UElement)arg);
                        } else if (arg instanceof UQualifiedReferenceExpression) {
                            UElement curr = (UElement)arg;
                            while (true) {
                                if (curr instanceof UQualifiedReferenceExpression) {
                                    UExpression selector = ((UQualifiedReferenceExpression)curr).getSelector();
                                    if (UastExpressionUtils.isConstructorCall((UElement)((UElement)selector))) {
                                        this.argument((UCallExpression)selector, (UElement)selector);
                                    } else {
                                        UExpression uExpression3 = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)curr).getReceiver());
                                        if (uExpression3 != null) {
                                            curr = (UElement)uExpression3;
                                            continue;
                                        }
                                    }
                                } else {
                                    if (!(curr instanceof UPostfixExpression) || !Intrinsics.areEqual((Object)((UPostfixExpression)curr).getOperator().getText(), (Object)"!!")) break;
                                    UExpression uExpression4 = UastUtils.skipParenthesizedExprDown((UExpression)((UPostfixExpression)curr).getOperand());
                                    if (uExpression4 != null) {
                                        curr = (UElement)uExpression4;
                                        continue;
                                    }
                                }
                                break block13;
                                break;
                            }
                            if (curr instanceof UCallExpression) {
                                this.argument((UCallExpression)curr, curr);
                            }
                        }
                    }
                }
            }
        });
        return rows;
    }

    private final boolean isBuildConsumer(UCallExpression call) {
        if (call.getValueArgumentCount() != 1) {
            return false;
        }
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return false;
        }
        PsiMethod calledMethod = psiMethod;
        Object object = calledMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"calledMethod.parameterList.parameters");
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])object);
        if (psiParameter == null) {
            return false;
        }
        PsiParameter arg = psiParameter;
        object = arg.getType().getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"arg.type.canonicalText");
        Object type = object;
        return StringsKt.startsWith$default((String)type, (String)"androidx.core.util.Consumer<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)type, (String)"Builder>", (boolean)false, (int)2, null);
    }

    private final boolean isContentMethod(String methodName) {
        boolean bl;
        switch (methodName) {
            case "setSummary": 
            case "addEndItem": 
            case "setTitleItem": 
            case "setPrimaryAction": 
            case "addText": 
            case "addImage": 
            case "setTitle": 
            case "setSubtitle": 
            case "setSummarySubtitle": 
            case "addTitleText": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final void checkHasContent(String qualifiedName, JavaContext context, UCallExpression node, UMethod method) {
        Ref.BooleanRef hasContent = new Ref.BooleanRef();
        List list = CollectionsKt.listOf((Object)node);
        method.accept((UastVisitor)new DataFlowAnalyzer(this, hasContent, list){
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.BooleanRef $hasContent;
            {
                this.this$0 = $receiver;
                this.$hasContent = $hasContent;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                String string = call.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (SliceDetector.access$isContentMethod(this.this$0, methodName)) {
                    this.$hasContent.element = true;
                }
            }
        });
        if (!hasContent.element) {
            String string = qualifiedName;
            int n = StringsKt.lastIndexOf$default((CharSequence)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String name = string3;
            this.warnMissingContent(name, context, node);
        }
    }

    private final void checkRowBuilder(JavaContext context, UCallExpression node, UMethod method) {
        Ref.ObjectRef timestamp = new Ref.ObjectRef();
        Ref.ObjectRef endActionItem = new Ref.ObjectRef();
        boolean bl = false;
        List endActionItems = new ArrayList();
        Ref.ObjectRef endIconItem = new Ref.ObjectRef();
        Ref.BooleanRef hasContent = new Ref.BooleanRef();
        List list = CollectionsKt.listOf((Object)node);
        method.accept((UastVisitor)new DataFlowAnalyzer(hasContent, (Ref.ObjectRef<UCallExpression>)timestamp, context, (Ref.ObjectRef<UCallExpression>)endIconItem, (Ref.ObjectRef<UCallExpression>)endActionItem, endActionItems, this, list){
            final /* synthetic */ Ref.BooleanRef $hasContent;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $timestamp;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $endIconItem;
            final /* synthetic */ Ref.ObjectRef<UCallExpression> $endActionItem;
            final /* synthetic */ List<UExpression> $endActionItems;
            final /* synthetic */ SliceDetector this$0;
            {
                this.$hasContent = $hasContent;
                this.$timestamp = $timestamp;
                this.$context = $context;
                this.$endIconItem = $endIconItem;
                this.$endActionItem = $endActionItem;
                this.$endActionItems = $endActionItems;
                this.this$0 = $receiver;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                String string = call.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (Intrinsics.areEqual((Object)methodName, (Object)"addEndItem") || Intrinsics.areEqual((Object)methodName, (Object)"setTitleItem")) {
                    Location location;
                    PsiType psiType;
                    String type;
                    this.$hasContent.element = true;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)));
                    UExpression uExpression = first;
                    String string2 = uExpression == null ? null : (type = (psiType = uExpression.getExpressionType()) == null ? null : psiType.getCanonicalText());
                    if (arguments.size() == 1 && Intrinsics.areEqual((Object)type, (Object)"long")) {
                        if (this.$timestamp.element != null) {
                            Location location2 = this.$context.getLocation((UElement)call);
                            Intrinsics.checkNotNull((Object)this.$timestamp.element);
                            location = Location.withSecondary$default((Location)location2, (Location)this.$context.getLocation((UElement)this.$timestamp.element), (String)"Earlier timestamp here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location, (String)"`RowBuilder` can only have one timestamp added to it, remove one of your timestamps", null, (int)16, null);
                        } else {
                            this.$timestamp.element = call;
                        }
                    } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.slice.builders.SliceAction")) {
                        if (this.$endIconItem.element != null) {
                            Location location3 = this.$context.getLocation((UElement)call);
                            Intrinsics.checkNotNull((Object)this.$endIconItem.element);
                            location = Location.withSecondary$default((Location)location3, (Location)this.$context.getLocation((UElement)this.$endIconItem.element), (String)"Earlier icon here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endActionItem.element = call;
                        this.$endActionItems.add(first);
                    } else if (Intrinsics.areEqual((Object)type, (Object)"android.graphics.drawable.Icon") || Intrinsics.areEqual((Object)type, (Object)"androidx.core.graphics.drawable.IconCompat") || Intrinsics.areEqual((Object)type, (Object)"android.support.v4.graphics.drawable.IconCompat")) {
                        if (this.$endActionItem.element != null) {
                            Location location4 = this.$context.getLocation((UElement)call);
                            Intrinsics.checkNotNull((Object)this.$endActionItem.element);
                            location = Location.withSecondary$default((Location)location4, (Location)this.$context.getLocation((UElement)this.$endActionItem.element), (String)"Earlier slice action here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endIconItem.element = call;
                    }
                } else if (SliceDetector.access$isContentMethod(this.this$0, methodName)) {
                    this.$hasContent.element = true;
                }
            }
        });
        String message2 = "`RowBuilder` should not have a mixture of default and custom toggles";
        this.ensureSingleToggleType(endActionItems, context, message2);
        if (!hasContent.element) {
            this.warnMissingContent("RowBuilder", context, node);
        }
    }

    private final void warnMissingContent(String builder, JavaContext context, UCallExpression node) {
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)('`' + builder + "` should have a piece of content added to it"), null, (int)16, null);
    }

    private final boolean isCustomToggle(PsiMethod method) {
        return method.getParameterList().getParametersCount() == 3;
    }

    private final UCallExpression findSliceActionConstructor(UElement node) {
        if (node instanceof UReferenceExpression) {
            UExpression initializer;
            if (node instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)node).getSelector() instanceof UCallExpression) {
                return this.findSliceActionConstructor((UElement)((UQualifiedReferenceExpression)node).getSelector());
            }
            PsiElement psiElement = ((UReferenceExpression)node).resolve();
            if (psiElement == null) {
                return null;
            }
            PsiElement resolved = psiElement;
            if (resolved instanceof ULocalVariable) {
                UExpression uExpression;
                UExpression uExpression2 = ((ULocalVariable)resolved).getUastInitializer();
                UExpression uExpression3 = uExpression = uExpression2 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
                if (uExpression == null) {
                    return null;
                }
                initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
            if (resolved instanceof PsiLocalVariable) {
                UExpression uExpression;
                UExpression uExpression4 = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, node);
                UExpression uExpression5 = uExpression = uExpression4 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression4);
                if (uExpression == null) {
                    return null;
                }
                initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
        } else if (node instanceof UCallExpression && UastExpressionUtils.isConstructorCall((UElement)node)) {
            PsiClass psiClass;
            String name;
            PsiMethod psiMethod = ((UCallExpression)node).resolve();
            String string = psiMethod == null ? null : (name = (psiClass = psiMethod.getContainingClass()) == null ? null : psiClass.getQualifiedName());
            if (Intrinsics.areEqual(name, (Object)SLICE_ACTION_CLASS)) {
                return (UCallExpression)node;
            }
        } else {
            if (node instanceof UQualifiedReferenceExpression) {
                return this.findSliceActionConstructor((UElement)((UQualifiedReferenceExpression)node).getSelector());
            }
            if (node instanceof UParenthesizedExpression) {
                return this.findSliceActionConstructor((UElement)((UParenthesizedExpression)node).getExpression());
            }
        }
        return null;
    }

    public static final /* synthetic */ boolean access$isAddRowMethod(SliceDetector $this, String methodName) {
        return $this.isAddRowMethod(methodName);
    }

    public static final /* synthetic */ boolean access$isBuildConsumer(SliceDetector $this, UCallExpression call) {
        return $this.isBuildConsumer(call);
    }

    public static final /* synthetic */ boolean access$isContentMethod(SliceDetector $this, String methodName) {
        return $this.isContentMethod(methodName);
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Slices", (String)"Slices", (String)"\n            This check analyzes usages of the Slices API and offers suggestions based\n            on best practices.\n            ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/SliceDetector$Companion;", "", "()V", "CATEGORY_SLICE", "", "GRID_ROW_BUILDER_CLASS", "GRID_ROW_CELL_BUILDER_CLASS", "ICON_CLASS", "ICON_COMPAT_CLASS_1", "ICON_COMPAT_CLASS_2", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_DECLARATION", "KEY_MAP_METHOD", "LIST_BUILDER_CLASS", "LIST_HEADER_BUILDER_CLASS", "LIST_INPUT_RANGE_BUILDER_CLASS", "LIST_RANGE_BUILDER_CLASS", "ROW_BUILDER_CLASS", "SLICE_ACTION_CLASS", "SLICE_PROVIDER_CLASS_1", "SLICE_PROVIDER_CLASS_2", "WARN_ABOUT_TOO_MANY_ROWS", "", "isSliceProvider", "provider", "Lorg/w3c/dom/Element;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSliceProvider(@NotNull Element provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
            while (intentFilter != null) {
                Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
                while (category != null) {
                    String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (Intrinsics.areEqual((Object)SliceDetector.CATEGORY_SLICE, (Object)name)) {
                        return true;
                    }
                    category = XmlUtils.getNextTagByName((Node)category, (String)"category");
                }
                intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

