/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.VersionChecksKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\rJ*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J'\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010 R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\rR\u0015\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/SdkIntAnnotation;", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/intellij/psi/PsiAnnotation;)V", "api", "", "codename", "", "parameter", "lambda", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getApi", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getCodename", "()Ljava/lang/String;", "getLambda", "getParameter", "apiLevel", "findArgumentFor", "Lorg/jetbrains/uast/UExpression;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "parameterIndex", "call", "Lorg/jetbrains/uast/UCallExpression;", "getApiLevel", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;Lcom/intellij/psi/PsiModifierListOwner;Lorg/jetbrains/uast/UCallExpression;)Ljava/lang/Integer;", "Companion", "lint-checks"})
public final class SdkIntAnnotation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer api;
    @Nullable
    private final String codename;
    @Nullable
    private final Integer parameter;
    @Nullable
    private final Integer lambda;

    public SdkIntAnnotation(@Nullable Integer api, @Nullable String codename, @Nullable Integer parameter, @Nullable Integer lambda) {
        this.api = api;
        this.codename = codename;
        this.parameter = parameter;
        this.lambda = lambda;
    }

    @Nullable
    public final Integer getApi() {
        return this.api;
    }

    @Nullable
    public final String getCodename() {
        return this.codename;
    }

    @Nullable
    public final Integer getParameter() {
        return this.parameter;
    }

    @Nullable
    public final Integer getLambda() {
        return this.lambda;
    }

    public SdkIntAnnotation(@NotNull PsiAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        this(VersionChecksKt.getAnnotationIntValue$default(annotation, "api", 0, 2, null), VersionChecksKt.getAnnotationStringValue$default(annotation, "codename", null, 2, null), VersionChecksKt.getAnnotationIntValue$default(annotation, "parameter", 0, 2, null), VersionChecksKt.getAnnotationIntValue$default(annotation, "lambda", 0, 2, null));
    }

    @Nullable
    public final Integer getApiLevel(@NotNull JavaEvaluator evaluator, @NotNull PsiModifierListOwner owner, @Nullable UCallExpression call) {
        UExpression argument;
        int index;
        int n;
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Integer apiLevel = this.apiLevel();
        if (apiLevel != null) {
            return apiLevel;
        }
        Integer n2 = this.parameter;
        if (n2 == null) {
            Integer n3 = this.lambda;
            if (n3 == null) {
                return null;
            }
            n = n3;
        } else {
            n = index = n2.intValue();
        }
        if (owner instanceof PsiMethod && call != null && (argument = this.findArgumentFor(evaluator, (PsiMethod)owner, index, call)) != null) {
            Object v = ConstantEvaluator.evaluate(null, (UElement)((UElement)argument));
            Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
            return number == null ? null : Integer.valueOf(number.intValue());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Integer apiLevel() {
        Integer n;
        if (this.codename != null) {
            CharSequence charSequence = this.codename;
            boolean bl = false;
            if (charSequence.length() > 0) {
                int level = SdkVersionInfo.getApiByBuildCode((String)this.codename, (boolean)false);
                n = level != -1 ? level : SdkVersionInfo.getApiByPreviewName((String)this.codename, (boolean)true);
                return n;
            }
        }
        Integer n2 = this.api;
        int n3 = -1;
        if (n2 != null && n2 == n3) {
            n = null;
            return n;
        }
        n = this.api;
        return n;
    }

    private final UExpression findArgumentFor(JavaEvaluator evaluator, PsiMethod calledMethod, int parameterIndex, UCallExpression call) {
        PsiParameter[] parameters = calledMethod.getParameterList().getParameters();
        if (parameterIndex >= 0 && parameterIndex < parameters.length) {
            PsiParameter target2 = parameters[parameterIndex];
            Map mapping = evaluator.computeArgumentMapping(call, calledMethod);
            Object object = mapping;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                UExpression key = (UExpression)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                PsiParameter value1 = (PsiParameter)object3.getValue();
                if (value1 != target2 && !value1.isEquivalentTo((PsiElement)target2)) continue;
                return key;
            }
        }
        return null;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/SdkIntAnnotation$Companion;", "", "()V", "get", "Lcom/android/tools/lint/checks/SdkIntAnnotation;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SdkIntAnnotation get(@NotNull PsiModifierListOwner owner) {
            PsiAnnotation psiAnnotation;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            String[] stringArray = new String[]{"androidx.annotation.ChecksSdkIntAtLeast"};
            PsiAnnotation psiAnnotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])stringArray);
            if (psiAnnotation2 == null) {
                return null;
            }
            PsiAnnotation annotation = psiAnnotation = psiAnnotation2;
            return new SdkIntAnnotation(annotation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

