/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.java.JavaUAnnotation;

public abstract class RangeConstraint {
    public static RangeConstraint create(UAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        if (AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(qualifiedName)) {
            return IntRangeConstraint.create(annotation);
        }
        if (AnnotationDetector.FLOAT_RANGE_ANNOTATION.isEquals(qualifiedName)) {
            return FloatRangeConstraint.create(annotation);
        }
        if (AnnotationDetector.SIZE_ANNOTATION.isEquals(qualifiedName)) {
            return SizeConstraint.create(annotation);
        }
        if (AndroidPlatformAnnotations.isPlatformAnnotation((String)qualifiedName)) {
            return RangeConstraint.create(AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(annotation, qualifiedName));
        }
        return null;
    }

    public static RangeConstraint create(PsiModifierListOwner owner, JavaEvaluator evaluator) {
        for (PsiAnnotation annotation : evaluator.getAllAnnotations(owner, false)) {
            RangeConstraint constraint2 = RangeConstraint.create(JavaUAnnotation.wrap((PsiAnnotation)annotation));
            if (constraint2 == null) continue;
            return constraint2;
        }
        return null;
    }

    public static RangeConstraint create(UAnnotated owner, JavaEvaluator evaluator) {
        for (UAnnotation annotation : evaluator.getAllAnnotations(owner, false)) {
            RangeConstraint constraint2 = RangeConstraint.create(annotation);
            if (constraint2 == null) continue;
            return constraint2;
        }
        return null;
    }

    public Boolean contains(RangeConstraint other) {
        return null;
    }
}

