/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionRequirement;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Set;

public interface PermissionHolder {
    public boolean hasPermission(String var1);

    public boolean isRevocable(String var1);

    public AndroidVersion getMinSdkVersion();

    public AndroidVersion getTargetSdkVersion();

    public static class SetPermissionLookup
    implements PermissionHolder {
        private final Set<String> mGrantedPermissions;
        private final Set<String> mRevocablePermissions;
        private final AndroidVersion mMinSdkVersion;
        private final AndroidVersion mTargetSdkVersion;

        public SetPermissionLookup(Set<String> grantedPermissions, Set<String> revocablePermissions, AndroidVersion minSdkVersion, AndroidVersion targetSdkVersion) {
            this.mGrantedPermissions = grantedPermissions;
            this.mRevocablePermissions = revocablePermissions;
            this.mMinSdkVersion = minSdkVersion;
            this.mTargetSdkVersion = targetSdkVersion;
        }

        @VisibleForTesting
        public SetPermissionLookup(Set<String> grantedPermissions, Set<String> revocablePermissions) {
            this(grantedPermissions, revocablePermissions, AndroidVersion.DEFAULT, AndroidVersion.DEFAULT);
        }

        @VisibleForTesting
        public SetPermissionLookup(Set<String> grantedPermissions) {
            this(grantedPermissions, Collections.emptySet());
        }

        @Override
        public boolean hasPermission(String permission) {
            return this.mGrantedPermissions.contains(permission);
        }

        @Override
        public boolean isRevocable(String permission) {
            return this.mRevocablePermissions.contains(permission);
        }

        @Override
        public AndroidVersion getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        @Override
        public AndroidVersion getTargetSdkVersion() {
            return this.mTargetSdkVersion;
        }

        public static PermissionHolder join(PermissionHolder lookup, PermissionRequirement requirement) {
            SetPermissionLookup empty = new SetPermissionLookup(Collections.emptySet(), Collections.emptySet(), lookup.getMinSdkVersion(), lookup.getTargetSdkVersion());
            return SetPermissionLookup.join(lookup, requirement.getMissingPermissions(empty));
        }

        public static PermissionHolder join(final PermissionHolder lookup, final Set<String> permissions) {
            if (permissions != null && !permissions.isEmpty()) {
                return new PermissionHolder(){

                    @Override
                    public boolean hasPermission(String permission) {
                        return lookup.hasPermission(permission) || permissions.contains(permission);
                    }

                    @Override
                    public boolean isRevocable(String permission) {
                        return lookup.isRevocable(permission);
                    }

                    @Override
                    public AndroidVersion getMinSdkVersion() {
                        return lookup.getMinSdkVersion();
                    }

                    @Override
                    public AndroidVersion getTargetSdkVersion() {
                        return lookup.getTargetSdkVersion();
                    }
                };
            }
            return lookup;
        }
    }
}

