/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0016J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\"J(\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J0\u0010%\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010'\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0012H\u0016\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/NotificationTrampolineDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkBroadcastReceiver", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "broadcastClass", "Lcom/intellij/psi/PsiClass;", "setPendingIntent", "Lorg/jetbrains/uast/UCallExpression;", "checkNonActivityIntent", "pendingConstruction", "node", "isBroadcastReceiver", "checkReceiverOrService", "onReceiveMethod", "Lcom/intellij/psi/PsiMethod;", "description", "", "checkService", "serviceClass", "findClassArgument", "Lorg/jetbrains/uast/UElement;", "constructorCall", "findClassFromLiteral", "argument", "findIntentConstruction", "findPendingIntentConstruction", "pendingIntentArgument", "Lorg/jetbrains/uast/UExpression;", "getApplicableMethodNames", "", "(Lorg/jetbrains/uast/UCallExpression;)Ljava/lang/Boolean;", "reportNonActivityIntent", "", "reportServiceOrReceiver", "startActivity", "visitMethodCall", "method", "Issues", "lint-checks"})
public final class NotificationTrampolineDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(NotificationTrampolineDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue TRAMPOLINE;
    @JvmField
    @NotNull
    public static final Issue ACTIVITY;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setContentIntent", "setFullScreenIntent", "addAction"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, "androidx.core.app.NotificationCompat.Builder")) {
            return;
        }
        UCallExpression uCallExpression = this.findPendingIntentConstruction(node);
        if (uCallExpression == null) {
            return;
        }
        UCallExpression pendingConstruction = uCallExpression;
        Boolean bl = this.isBroadcastReceiver(pendingConstruction);
        if (bl == null) {
            return;
        }
        boolean isBroadcastReceiver = bl;
        boolean foundClass = this.checkNonActivityIntent(context, pendingConstruction, node, isBroadcastReceiver);
        if (!foundClass && !Intrinsics.areEqual((Object)Lint.getMethodName((UCallExpression)node), (Object)"addAction")) {
            this.reportNonActivityIntent(context, node, pendingConstruction, isBroadcastReceiver);
        }
    }

    private final boolean checkNonActivityIntent(JavaContext context, UCallExpression pendingConstruction, UCallExpression node, boolean isBroadcastReceiver) {
        UCallExpression uCallExpression = this.findIntentConstruction(pendingConstruction);
        if (uCallExpression == null) {
            return false;
        }
        UCallExpression intentConstruction = uCallExpression;
        UElement uElement = this.findClassArgument(intentConstruction);
        if (uElement == null) {
            return false;
        }
        UElement classArgument = uElement;
        PsiClass psiClass = this.findClassFromLiteral(classArgument);
        if (psiClass == null) {
            return false;
        }
        PsiClass nonActivityClass = psiClass;
        return isBroadcastReceiver ? this.checkBroadcastReceiver(context, nonActivityClass, node) : this.checkService(context, nonActivityClass, node);
    }

    private final UCallExpression findPendingIntentConstruction(UCallExpression node) {
        UExpression uExpression;
        UExpression uExpression2;
        UExpression uExpression3;
        String methodName = Lint.getMethodName((UCallExpression)node);
        if (Intrinsics.areEqual((Object)methodName, (Object)"addAction")) {
            uExpression3 = node.getArgumentForParameter(2);
            UExpression uExpression4 = uExpression2 = uExpression3 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression3);
            if (uExpression2 == null) {
                return null;
            }
            uExpression = uExpression2;
        } else {
            uExpression3 = node.getArgumentForParameter(0);
            UExpression uExpression5 = uExpression2 = uExpression3 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression3);
            if (uExpression2 == null) {
                return null;
            }
            uExpression = uExpression2;
        }
        UExpression pendingIntentArgument = uExpression;
        return this.findPendingIntentConstruction(pendingIntentArgument, (UElement)node);
    }

    private final Boolean isBroadcastReceiver(UCallExpression pendingConstruction) {
        String string = Lint.getMethodName((UCallExpression)pendingConstruction);
        return Intrinsics.areEqual((Object)string, (Object)"getBroadcast") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string, (Object)"getService") ? Boolean.valueOf(false) : null);
    }

    private final UCallExpression findPendingIntentConstruction(UExpression pendingIntentArgument, UElement node) {
        UExpression uExpression = pendingIntentArgument;
        if (uExpression == null) {
            return null;
        }
        PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)pendingIntentArgument));
        if (resolved instanceof PsiVariable) {
            UExpression uExpression2 = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, node);
            UElement uElement = uExpression2 == null ? null : UastLintUtilsKt.findSelector((UElement)((UElement)uExpression2));
            return uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        }
        if (resolved instanceof PsiMethod) {
            if (((PsiMethod)resolved).getContainingFile() instanceof PsiBinaryFile) {
                String name;
                PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
                String string = name = psiClass == null ? null : psiClass.getQualifiedName();
                if (Intrinsics.areEqual((Object)name, (Object)"android.app.PendingIntent")) {
                    UExpression selector;
                    if (pendingIntentArgument instanceof UCallExpression) {
                        return (UCallExpression)pendingIntentArgument;
                    }
                    if (pendingIntentArgument instanceof UQualifiedReferenceExpression && (selector = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)pendingIntentArgument).getSelector())) instanceof UCallExpression) {
                        return (UCallExpression)selector;
                    }
                }
                return null;
            }
            PsiElement $this$toUElementOfType$iv = resolved;
            boolean $i$f$toUElementOfType = false;
            UMethod selector = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (selector == null) {
                return null;
            }
            UMethod method = selector;
            Ref ref = new Ref();
            method.accept((UastVisitor)new AbstractUastVisitor(this, (Ref<UCallExpression>)ref){
                final /* synthetic */ NotificationTrampolineDetector this$0;
                final /* synthetic */ Ref<UCallExpression> $ref;
                {
                    this.this$0 = $receiver;
                    this.$ref = $ref;
                }

                public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UExpression uExpression = node.getReturnExpression();
                    if (uExpression != null) {
                        UExpression uExpression2 = uExpression;
                        NotificationTrampolineDetector notificationTrampolineDetector = this.this$0;
                        Ref<UCallExpression> ref = this.$ref;
                        boolean bl = false;
                        boolean bl2 = false;
                        UExpression it = uExpression2;
                        boolean bl3 = false;
                        UCallExpression construction = NotificationTrampolineDetector.access$findPendingIntentConstruction(notificationTrampolineDetector, UastUtils.skipParenthesizedExprDown((UExpression)it), (UElement)node);
                        if (construction != null && NotificationTrampolineDetector.access$isBroadcastReceiver(notificationTrampolineDetector, construction) != null) {
                            ref.set((Object)construction);
                        }
                    }
                    return super.visitReturnExpression(node);
                }
            });
            return (UCallExpression)ref.get();
        }
        return null;
    }

    private final UCallExpression findIntentConstruction(UCallExpression pendingConstruction) {
        UExpression uExpression;
        PsiMethod psiMethod = pendingConstruction.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod getBroadcastMethod = psiMethod;
        if (getBroadcastMethod.getParameterList().getParametersCount() != 4) {
            return null;
        }
        UExpression uExpression2 = pendingConstruction.getArgumentForParameter(2);
        UExpression uExpression3 = uExpression = uExpression2 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
        if (uExpression == null) {
            return null;
        }
        UExpression intentArg = uExpression;
        PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)intentArg));
        PsiVariable psiVariable = uExpression2 = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
        if (uExpression2 == null) {
            return null;
        }
        UExpression intentDeclaration = uExpression2;
        UExpression uExpression4 = UastLintUtils.Companion.findLastAssignment((PsiVariable)intentDeclaration, (UElement)pendingConstruction);
        UExpression uExpression5 = psiElement = uExpression4 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression4);
        if (psiElement == null) {
            return null;
        }
        PsiElement intentAssignment = psiElement;
        return (psiElement = UastLintUtilsKt.findSelector((UElement)((UElement)intentAssignment))) instanceof UCallExpression ? (UCallExpression)psiElement : null;
    }

    private final UElement findClassArgument(UCallExpression constructorCall) {
        PsiClassType psiClassType;
        int n;
        PsiMethod psiMethod = constructorCall.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod intentConstructor = psiMethod;
        JvmParameter[] constructorParameters = intentConstructor.getParameters();
        int n2 = constructorParameters.length;
        switch (n2) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                return null;
            }
        }
        int classParameterIndex = n;
        JvmParameter classParameterType = constructorParameters[classParameterIndex];
        JvmType jvmType = classParameterType.getType();
        PsiClassType psiClassType2 = psiClassType = jvmType instanceof PsiClassType ? (PsiClassType)jvmType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType type = psiClassType;
        if (!Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)"java.lang.Class<?>")) {
            return null;
        }
        psiClassType = constructorCall.getArgumentForParameter(classParameterIndex);
        return psiClassType == null ? null : UastLintUtilsKt.findSelector((UElement)((UElement)psiClassType));
    }

    private final PsiClass findClassFromLiteral(UElement argument) {
        PsiClass psiClass;
        UElement uElement;
        PsiType psiType;
        if (argument instanceof UClassLiteralExpression) {
            psiType = ((UClassLiteralExpression)argument).getType();
        } else if (argument instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)argument).getResolvedName(), (Object)"getJavaClass")) {
            psiType = ((UClassLiteralExpression)((UQualifiedReferenceExpression)argument).getReceiver()).getType();
        } else if (argument instanceof USimpleNameReferenceExpression && argument.getUastParent() instanceof UQualifiedReferenceExpression) {
            uElement = argument.getUastParent();
            if (uElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
            }
            UExpression receiver = ((UQualifiedReferenceExpression)uElement).getReceiver();
            psiClass = receiver instanceof UClassLiteralExpression ? (UClassLiteralExpression)receiver : null;
            PsiType psiType2 = uElement = psiClass == null ? null : psiClass.getType();
            if (uElement == null) {
                return null;
            }
            psiType = uElement;
        } else {
            return null;
        }
        PsiType type = psiType;
        PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
        PsiClass psiClass2 = psiClass = psiClassType == null ? null : psiClassType.resolve();
        if (psiClass == null) {
            return null;
        }
        uElement = psiClass;
        UElement resolved = uElement;
        if (resolved.getContainingFile() instanceof PsiBinaryFile) {
            return null;
        }
        return resolved;
    }

    private final boolean checkBroadcastReceiver(JavaContext context, PsiClass broadcastClass, UCallExpression setPendingIntent) {
        PsiMethod[] methods = broadcastClass.findMethodsByName("onReceive", false);
        JavaEvaluator evaluator = context.getEvaluator();
        Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
        for (PsiMethod member : methods) {
            Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
            String[] stringArray = new String[]{"android.content.Context", "android.content.Intent"};
            if (!evaluator.parametersMatch(member, stringArray)) continue;
            return this.checkReceiverOrService(context, member, setPendingIntent, broadcastClass, "BroadcastReceiver");
        }
        return true;
    }

    private final boolean checkService(JavaContext context, PsiClass serviceClass, UCallExpression setPendingIntent) {
        PsiMethod[] methods = serviceClass.findMethodsByName("onStartCommand", false);
        JavaEvaluator evaluator = context.getEvaluator();
        Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
        for (PsiMethod member : methods) {
            Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
            String[] stringArray = new String[]{"android.content.Intent", "int", "int"};
            if (!evaluator.parametersMatch(member, stringArray)) continue;
            return this.checkReceiverOrService(context, member, setPendingIntent, serviceClass, "Service");
        }
        return true;
    }

    private final boolean checkReceiverOrService(JavaContext context, PsiMethod onReceiveMethod, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        PsiElement $this$toUElementOfType$iv = (PsiElement)onReceiveMethod;
        boolean $i$f$toUElementOfType = false;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
        if (uMethod == null) {
            return false;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)new AbstractUastVisitor(this, context, setPendingIntent, broadcastClass, description){
            final /* synthetic */ NotificationTrampolineDetector this$0;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $setPendingIntent;
            final /* synthetic */ PsiClass $broadcastClass;
            final /* synthetic */ String $description;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$setPendingIntent = $setPendingIntent;
                this.$broadcastClass = $broadcastClass;
                this.$description = $description;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String methodName = Lint.getMethodName((UCallExpression)node);
                if (Intrinsics.areEqual((Object)methodName, (Object)"startActivity") || Intrinsics.areEqual((Object)methodName, (Object)"startActivities")) {
                    NotificationTrampolineDetector.access$reportServiceOrReceiver(this.this$0, this.$context, node, this.$setPendingIntent, this.$broadcastClass, this.$description);
                }
                return super.visitCallExpression(node);
            }
        });
        return true;
    }

    private final void reportServiceOrReceiver(JavaContext context, UCallExpression startActivity, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        Location primaryLocation = context.getCallLocation(setPendingIntent, false, true);
        Location secondaryLocation = context.getCallLocation(startActivity, true, true);
        primaryLocation.setSecondary(secondaryLocation);
        String message2 = "This intent launches a `" + description + "` (`" + broadcastClass.getName() + "`) which launches activities; this indirection is bad for performance, and activities should be launched directly from the notification";
        JavaContext.report$default((JavaContext)context, (Issue)TRAMPOLINE, (UElement)((UElement)setPendingIntent), (Location)primaryLocation, (String)message2, null, (int)16, null);
    }

    private final void reportNonActivityIntent(JavaContext context, UCallExpression setPendingIntent, UCallExpression pendingConstruction, boolean isBroadcastReceiver) {
        String className = isBroadcastReceiver ? "BroadcastReceiver" : "Service";
        String message2 = "Notifications should only launch a `" + className + "` from notification actions (`addAction`)";
        Location location = context.getCallLocation(setPendingIntent, false, true);
        Location secondary = context.getCallLocation(pendingConstruction, true, true);
        secondary.setMessage("This `" + className + "` intent is launched from a notification; this is discouraged except as notification actions");
        location.setSecondary(secondary);
        JavaContext.report$default((JavaContext)context, (Issue)ACTIVITY, (UElement)((UElement)setPendingIntent), (Location)location, (String)message2, null, (int)16, null);
    }

    public static final /* synthetic */ UCallExpression access$findPendingIntentConstruction(NotificationTrampolineDetector $this, UExpression pendingIntentArgument, UElement node) {
        return $this.findPendingIntentConstruction(pendingIntentArgument, node);
    }

    public static final /* synthetic */ Boolean access$isBroadcastReceiver(NotificationTrampolineDetector $this, UCallExpression pendingConstruction) {
        return $this.isBroadcastReceiver(pendingConstruction);
    }

    public static final /* synthetic */ void access$reportServiceOrReceiver(NotificationTrampolineDetector $this, JavaContext context, UCallExpression startActivity, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        $this.reportServiceOrReceiver(context, startActivity, setPendingIntent, broadcastClass, description);
    }

    static {
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        TRAMPOLINE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NotificationTrampoline", (String)"Notification Trampolines", (String)"\n                Activities should not be launched indirectly from a notification via an \\\n                intermediate `BroadcastReceiver` or `Service`. This can lead to significant lags \\\n                in some scenarios, and is forbidden if `targetSdkVersion` is set to the API level \\\n                for Android 12 or higher.\n\n                To fix this, launch the `Activity` directly from the notification.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ACTIVITY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"LaunchActivityFromNotification", (String)"Notification Launches Services or BroadcastReceivers", (String)"\n                Notifications should only launch activities -- that's what users expect (and \\\n                has been the guidance in both the Android SDK and Material Design documentation \\\n                for a while).\n\n                A `Service` or a `BroadcastReceiver` should not be used as an intermediate, \\\n                because this can lead to significant performance problems, and as a \\\n                result, this will not be allowed in Android 12.\n                ", (Implementation)implementation, null, (Category)category, (int)3, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://developer.android.com/guide/topics/ui/notifiers/notifications?hl=en#Actions").addMoreInfo("https://material.io/design/platform-guidance/android-notifications.html#behavior").addMoreInfo("https://developer.android.com/guide/topics/ui/notifiers/notifications?hl=en");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/NotificationTrampolineDetector$Issues;", "", "()V", "ACTIVITY", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TRAMPOLINE", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

