/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u00012\u00020\u0002:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/FineLocationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "Companion", "lint-checks"})
public final class FineLocationDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FINE_LOCATION_PERMISSION = "android.permission.ACCESS_FINE_LOCATION";
    @NotNull
    private static final String COARSE_LOCATION_PERMISSION = "android.permission.ACCESS_COARSE_LOCATION";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getMainProject().getTargetSdk() < 31) {
            return;
        }
        Element fineElement = null;
        Element coarseElement = null;
        Object object = context.getMainProject().getMergedManifest();
        if (object == null) {
            return;
        }
        Document manifest = object;
        Element element = manifest.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"manifest.documentElement");
        object = DomExtensions.iterator((Element)element);
        while (object.hasNext()) {
            Element node = (Element)object.next();
            if (!Intrinsics.areEqual((Object)node.getTagName(), (Object)"uses-permission")) continue;
            String string = node.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (Intrinsics.areEqual((Object)string, (Object)FINE_LOCATION_PERMISSION)) {
                fineElement = node;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)COARSE_LOCATION_PERMISSION)) continue;
            coarseElement = node;
        }
        if (fineElement != null && coarseElement == null) {
            context.report(new Incident(ISSUE, Context.getLocation$default((Context)context, fineElement, null, (int)2, null), "If you need access to FINE location, you must request both `ACCESS_FINE_LOCATION` and `ACCESS_COARSE_LOCATION`"));
        }
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(FineLocationDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"CoarseFineLocation", (String)"Cannot use `ACCESS_FINE_LOCATION` without `ACCESS_COARSE_LOCATION`", (String)"\n                If your app requires access to FINE location, on Android 12 and higher you must \\\n                now request both FINE and COARSE. Users will have the option to grant only COARSE \\\n                location. Ensure your app can work with just COARSE location.\n            ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/FineLocationDetector$Companion;", "", "()V", "COARSE_LOCATION_PERMISSION", "", "FINE_LOCATION_PERMISSION", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

