/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/DosLineEndingDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "Issues", "lint-checks"})
public final class DosLineEndingDetector
extends LayoutDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        char prev = '\u0000';
        int i = 0;
        int n = contents.length();
        while (i < n) {
            char c = contents.charAt(i);
            if (c == '\r' && prev == '\r') {
                int index;
                String message2 = "Incorrect line ending: found carriage return (`\\r`) without corresponding newline (`\\n`)";
                boolean blankLine = true;
                int n2 = i - 2;
                if (n2 < i) {
                    do {
                        char d;
                        if (Character.isWhitespace(d = contents.charAt(index = n2++))) continue;
                        blankLine = false;
                    } while (n2 < i);
                }
                int lineBegin = i;
                index = i - 2;
                if (0 <= index) {
                    do {
                        int index2;
                        char d;
                        if ((d = contents.charAt(index2 = index--)) == '\n') {
                            lineBegin = index2 + 1;
                            if (blankLine) continue;
                            break;
                        }
                        if (Character.isWhitespace(d)) continue;
                        blankLine = false;
                    } while (0 <= index);
                }
                int lineEnd = Math.min(contents.length(), i + 1);
                Location location = Location.Companion.create(context.file, contents, lineBegin, lineEnd);
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)document.getDocumentElement(), (Location)location, (String)message2, null, (int)16, null);
                return;
            }
            prev = c;
            int n3 = i;
            i = n3 + 1;
        }
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(DosLineEndingDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MangledCRLF", (String)"Mangled file line endings", (String)"\n            On Windows, line endings are typically recorded as carriage return plus newline: \\\\r\\\\n.\n\n            This detector looks for invalid line endings with repeated carriage return characters \\\n            (without newlines). Previous versions of the ADT plugin could accidentally introduce these \\\n            into the file, and when editing the file, the editor could produce confusing visual artifacts.\n            ", (Implementation)implementation, (String)"https://bugs.eclipse.org/bugs/show_bug.cgi?id=375421", (Category)category, (int)2, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/DosLineEndingDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

