/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnpackedNativeCodeDetector
extends ResourceXmlDetector
implements XmlScanner,
SourceCodeScanner,
ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"UnpackedNativeCode", (String)"Missing `android:extractNativeLibs=false`", (String)"This app loads native libraries using `System.loadLibrary()`.\n\nConsider adding `android:extractNativeLibs=\"false\"` to the `<application>` tag in AndroidManifest.xml. Starting with Android 6.0, this will make installation faster, the app will take up less space on the device and updates will have smaller download sizes.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UnpackedNativeCodeDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE, Scope.JAVA_LIBRARIES), new EnumSet[]{EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE)})).setEnabledByDefault(false);
    private static final String SYSTEM_CLASS = "java.lang.System";
    private static final String RUNTIME_CLASS = "java.lang.Runtime";
    private static final String SYSTEM_CLASS_ALT = "java/lang/System";
    private static final String RUNTIME_CLASS_ALT = "java/lang/Runtime";
    private static final String LOAD_LIBRARY = "loadLibrary";
    private static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.parse((String)"2.2.0");
    private boolean mHasNativeLibs;
    private boolean mSuppress;

    public List<String> getApplicableCallNames() {
        if (this.mSuppress) {
            return null;
        }
        return Collections.singletonList(LOAD_LIBRARY);
    }

    public void checkCall(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        String owner = call.owner;
        String name = call.name;
        if (name.equals(LOAD_LIBRARY) && (owner.equals(SYSTEM_CLASS_ALT) || owner.equals(RUNTIME_CLASS_ALT))) {
            this.mHasNativeLibs = true;
        }
    }

    public List<String> getApplicableMethodNames() {
        if (this.mSuppress) {
            return null;
        }
        return Collections.singletonList(LOAD_LIBRARY);
    }

    public void visitMethodCall(JavaContext context, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator;
        if (LOAD_LIBRARY.equals(method.getName()) && ((evaluator = context.getEvaluator()).isMemberInSubClassOf((PsiMember)method, RUNTIME_CLASS, false) || evaluator.isMemberInSubClassOf((PsiMember)method, SYSTEM_CLASS, false))) {
            this.mHasNativeLibs = true;
        }
    }

    public Collection<String> getApplicableElements() {
        return Collections.singleton("application");
    }

    public void beforeCheckRootProject(Context context) {
        this.mHasNativeLibs = false;
        if (!context.getProject().isGradleProject() || context.getProject().getGradleModelVersion() == null) {
            this.mSuppress = true;
            return;
        }
        boolean projectSupportsAttribute = context.getProject().getBuildSdk() >= 23;
        GradleVersion gradleVersion = context.getProject().getGradleModelVersion();
        boolean gradleSupportsAttribute = MIN_GRADLE_VERSION.compareIgnoringQualifiers(gradleVersion) <= 0;
        this.mSuppress = !projectSupportsAttribute || !gradleSupportsAttribute;
    }

    public void afterCheckRootProject(Context context) {
        if (context.isGlobalAnalysis() && context.getProject() == context.getMainProject()) {
            this.checkManifest(context);
        } else if (this.mHasNativeLibs && !this.mSuppress) {
            context.getPartialResults(ISSUE).map().put("hasNativeLibs", true);
        }
    }

    public void checkPartialResults(Context context, PartialResult partialResults) {
        this.mHasNativeLibs = true;
        this.checkManifest(context);
    }

    private void checkManifest(Context context) {
        if (context.getMainProject().isLibrary()) {
            return;
        }
        if (!this.mSuppress && this.mHasNativeLibs) {
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "extractNativeLibs", "false").build();
            Document mergedManifest = context.getProject().getMergedManifest();
            if (mergedManifest == null) {
                return;
            }
            NodeList tags = mergedManifest.getElementsByTagName("application");
            if (tags.getLength() == 0) {
                return;
            }
            Element application = (Element)tags.item(0);
            if (application.hasAttributeNS("http://schemas.android.com/apk/res/android", "extractNativeLibs")) {
                return;
            }
            Location location = context.getLocation((Object)application, LocationType.DEFAULT);
            Incident incident = new Incident(ISSUE, "Missing attribute `android:extractNativeLibs=\"false\"` on the `<application>` tag", location, fix);
            context.report(incident);
        }
    }

    public void visitElement(XmlContext context, Element element) {
        if (context.getProject().isLibrary()) {
            return;
        }
        if (context.getDriver().isSuppressed(context, ISSUE, (Node)element) || element.hasAttributeNS("http://schemas.android.com/apk/res/android", "extractNativeLibs")) {
            this.mSuppress = true;
        }
    }
}

