/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/SdCardDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "lint-checks"})
public final class SdCardDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(ULiteralExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;

            public void visitLiteralExpression(@NotNull ULiteralExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                String s = UastUtils.evaluateString((UExpression)((UExpression)node));
                if (s != null) {
                    CharSequence charSequence = s;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        char c = s.charAt(0);
                        if (c != '/' && c != 'f') {
                            return;
                        }
                        if (StringsKt.startsWith$default((String)s, (String)"/sdcard", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/mnt/sdcard/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/system/media/sdcard", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"file://sdcard/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"file:///sdcard/", (boolean)false, (int)2, null)) {
                            String message2 = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                            Location location = this.$context.getLocation((UElement)node);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SdCardDetector.ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
                        } else if (StringsKt.startsWith$default((String)s, (String)"/data/data/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/data/user/", (boolean)false, (int)2, null)) {
                            String message3 = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                            Location location = this.$context.getLocation((UElement)node);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SdCardDetector.ISSUE, (UElement)((UElement)node), (Location)location, (String)message3, null, (int)16, null);
                        }
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/training/data-storage#filesExternal";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"SdCardPath", (String)"Hardcoded reference to `/sdcard`", (String)"\n            Your code should not reference the `/sdcard` path directly; instead use \\\n            `Environment.getExternalStorageDirectory().getPath()`.\n\n            Similarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. \\\n            Instead, use `Context.getFilesDir().getPath()`.", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/SdCardDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

