/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.DomExtensions;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002?@B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010 H\u0016J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001bH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001dH\u0002J\u0018\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u0010\u0011\u001a\u000201H\u0002J<\u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0018\u00109\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J \u0010=\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010#\u001a\u000205H\u0016R\u0018\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "mAlreadyWarned", "", "", "sceneIds", "", "Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkProperty", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "propertyNameExpression", "Lorg/jetbrains/uast/UExpression;", "targetClass", "Lcom/intellij/psi/PsiClass;", "expectedType", "", "checkPropertyValueHolders", "expressions", "", "findHolderConstruction", "Lorg/jetbrains/uast/UCallExpression;", "arg", "getApplicableElements", "", "getApplicableMethodNames", "getExpectedType", "method", "evaluatorIndex", "", "getMethodName", "prefix", "propertyName", "isHolderConstructionMethod", "callExpression", "isInSameCompilationUnit", "element1", "Lorg/jetbrains/uast/UElement;", "element2", "Lcom/intellij/psi/PsiElement;", "isShrinking", "Lcom/android/tools/lint/detector/api/Context;", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/intellij/psi/PsiMethod;", "originalMessage", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "node", "Companion", "SceneReference", "lint-checks"})
public final class ObjectAnimatorDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    private Set<Object> mAlreadyWarned;
    private List<SceneReference> sceneIds;
    private static final String MOTION_LAYOUT_URI = "http://schemas.android.com/apk/res-auto";
    private static final AndroidxName KEEP_ANNOTATION;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING_KEEP;
    @JvmField
    @NotNull
    public static final Issue BROKEN_PROPERTY;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder"});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || Intrinsics.areEqual((Object)method.getName(), (Object)"ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        List expressions = node.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        PsiType psiType = TypeEvaluator.evaluate((UElement)((UElement)expressions.get(0)));
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"type.resolve() ?: return");
        PsiClass targetClass = psiClass;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)methodName, (Object)"ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context, targetClass, expressions);
        } else {
            String string2 = this.getExpectedType(node, 2);
            if (string2 == null) {
                return;
            }
            String expectedType = string2;
            this.checkProperty(context, (UExpression)expressions.get(1), targetClass, expectedType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPropertyValueHolders(JavaContext context, PsiClass targetClass, List<? extends UExpression> expressions) {
        int n = 1;
        int n2 = expressions.size();
        while (n < n2) {
            UCallExpression holder;
            void i;
            UExpression arg = expressions.get((int)i);
            if (this.findHolderConstruction(context, arg) == null) {
                return;
            }
            List args = holder.getValueArguments();
            if (args.size() >= 2) {
                String expectedType;
                if (this.getExpectedType(holder, 1) == null) {
                    return;
                }
                this.checkProperty(context, (UExpression)args.get(0), targetClass, expectedType);
            }
            ++i;
        }
    }

    private final void checkProperty(JavaContext context, UExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)propertyNameExpression));
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String property = string;
        String string2 = targetClass.getQualifiedName();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"targetClass.qualifiedName ?: return");
        String qualifiedName = string2;
        if (StringsKt.indexOf$default((CharSequence)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            return;
        }
        String methodName = this.getMethodName("set", property);
        PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        PsiMethod[] psiMethodArray = methods;
        int n = psiMethodArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMethod m;
            PsiMethod psiMethod = m = psiMethodArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"m");
            PsiParameterList psiParameterList = psiMethod.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"m.parameterList");
            if (psiParameterList.getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m;
                }
                if (!context.getEvaluator().parametersMatch(m, new String[]{expectedType})) continue;
                bestMethod = m;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m;
        }
        if (bestMethod == null) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, null, "Could not find property setter method `" + methodName + "` on `" + qualifiedName + '`', null);
            return;
        }
        if (!isExactMatch) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property does not match the " + "expected signature (`public void " + methodName + '(' + expectedType + " arg`)", null);
        } else if (context.getEvaluator().isStatic((PsiModifierListOwner)bestMethod)) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property (" + qualifiedName + '.' + methodName + ") should not be static", null);
        } else {
            PsiModifierListOwner owner = (PsiModifierListOwner)bestMethod;
            while (owner != null) {
                for (PsiAnnotation annotation : context.getEvaluator().getAllAnnotations(owner, false)) {
                    if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                    return;
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
            }
            if (!this.isShrinking((Context)context)) {
                return;
            }
            this.report(context, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", this.fix().map().put(PsiMethod.class, (Object)bestMethod).build());
        }
    }

    private final void report(JavaContext context, Issue issue, UExpression propertyNameExpression, PsiMethod method, String originalMessage, LintFix fix) {
        boolean reportOnMethod;
        String message2 = originalMessage;
        boolean bl = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        UExpression locationNode = reportOnMethod && method != null ? method : propertyNameExpression;
        Set set = this.mAlreadyWarned;
        if (set == null) {
            Set set2;
            ObjectAnimatorDetector objectAnimatorDetector = this;
            boolean bl2 = false;
            boolean bl3 = false;
            ObjectAnimatorDetector $this$run = objectAnimatorDetector;
            boolean bl4 = false;
            Set set3 = Sets.newIdentityHashSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"Sets.newIdentityHashSet()");
            $this$run.mAlreadyWarned = set2 = set3;
            set = set2;
        }
        Set alreadyWarned = set;
        if (alreadyWarned.contains(locationNode)) {
            return;
        }
        alreadyWarned.add((Object)locationNode);
        Location methodLocation = null;
        if (method != null && !(method instanceof PsiCompiledElement)) {
            Location location;
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                PsiElement psiElement = (PsiElement)nameIdentifier;
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                location = context.getRangeLocation(psiElement, 0, (PsiElement)psiParameterList, 0);
            } else {
                location = context.getNameLocation((PsiElement)method);
            }
            methodLocation = location;
        }
        Location location = null;
        if (reportOnMethod && methodLocation != null && method != null) {
            location = methodLocation;
            Location secondary = context.getLocation((UElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (this.isInSameCompilationUnit((UElement)propertyNameExpression, (PsiElement)method)) {
                secondary.setVisible(false);
            } else {
                boolean $this$run = issue == MISSING_KEEP;
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !$this$run) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String secondaryMessage = "The method referenced here (" + method.getName() + ") has " + "not been annotated with `@Keep` which means it could be " + "discarded or renamed in release builds";
                if (location == Location.NONE) {
                    location = secondary;
                    message2 = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else {
            location = context.getNameLocation((UElement)propertyNameExpression);
            if (methodLocation != null) {
                location = Location.withSecondary$default((Location)location, (Location)methodLocation, (String)"Property setter here", (boolean)false, (int)4, null);
            }
        }
        UElement owner = UastUtils.getParentOfType((UElement)((UElement)propertyNameExpression), UDeclaration.class, (boolean)false);
        if (owner != null && context.getDriver().isSuppressed(context, issue, owner)) {
            return;
        }
        context.report(issue, (PsiElement)method, location, message2, fix);
    }

    private final String getExpectedType(UCallExpression method, int evaluatorIndex) {
        String methodName;
        String string = Lint.getMethodName((UCallExpression)method);
        if (string == null) {
            return null;
        }
        switch (methodName = string) {
            case "ofInt": 
            case "ofArgb": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                String string2;
                List args = method.getValueArguments();
                if (args.size() <= evaluatorIndex) break;
                PsiType psiType = TypeEvaluator.evaluate((UElement)((UElement)args.get(evaluatorIndex)));
                if (psiType == null) {
                    return null;
                }
                PsiType evaluatorType = psiType;
                switch (evaluatorType.getCanonicalText()) {
                    case "android.animation.FloatEvaluator": {
                        string2 = "float";
                        break;
                    }
                    case "android.animation.FloatArrayEvaluator": {
                        string2 = "float[]";
                        break;
                    }
                    case "android.animation.IntEvaluator": 
                    case "android.animation.ArgbEvaluator": {
                        string2 = "int";
                        break;
                    }
                    case "android.animation.IntArrayEvaluator": {
                        string2 = "int[]";
                        break;
                    }
                    case "android.animation.PointFEvaluator": {
                        string2 = "android.graphics.PointF";
                        break;
                    }
                    default: {
                        string2 = null;
                    }
                }
                return string2;
            }
        }
        return null;
    }

    private final UCallExpression findHolderConstruction(JavaContext context, UExpression arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof UCallExpression) {
            if (this.isHolderConstructionMethod(context, (UCallExpression)arg)) {
                return (UCallExpression)arg;
            }
        } else if (arg instanceof UReferenceExpression) {
            PsiElement resolved;
            if (arg instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)arg).getSelector() instanceof UCallExpression) {
                UExpression uExpression = ((UQualifiedReferenceExpression)arg).getSelector();
                if (uExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                }
                UCallExpression selector = (UCallExpression)uExpression;
                if (this.isHolderConstructionMethod(context, selector)) {
                    return selector;
                }
            }
            if ((resolved = ((UReferenceExpression)arg).resolve()) instanceof PsiVariable) {
                UExpression expression;
                PsiElement el;
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)arg);
                while (lastAssignment instanceof USimpleNameReferenceExpression && (el = ((USimpleNameReferenceExpression)lastAssignment).resolve()) instanceof PsiLocalVariable) {
                    lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)el, (UElement)lastAssignment);
                }
                if (lastAssignment instanceof UCallExpression) {
                    UExpression callExpression = lastAssignment;
                    if (this.isHolderConstructionMethod(context, (UCallExpression)callExpression)) {
                        return (UCallExpression)callExpression;
                    }
                } else if (lastAssignment instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)(expression = lastAssignment)).getSelector() instanceof UCallExpression) {
                    UExpression uExpression = ((UQualifiedReferenceExpression)expression).getSelector();
                    if (uExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    UCallExpression callExpression = (UCallExpression)uExpression;
                    if (this.isHolderConstructionMethod(context, callExpression)) {
                        return callExpression;
                    }
                }
            }
        }
        return null;
    }

    private final boolean isHolderConstructionMethod(JavaContext context, UCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = Lint.getMethodName((UCallExpression)callExpression);
        return referenceName != null && StringsKt.startsWith$default((String)referenceName, (String)"of", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)referenceName, (Object)"ofKeyframe") ^ true && (resolved = callExpression.resolve()) != null && context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private final boolean isInSameCompilationUnit(UElement element1, PsiElement element2) {
        PsiElement psi;
        PsiFile file;
        UFile containingFile;
        UFile uFile = containingFile = UastUtils.getContainingUFile((UElement)element1);
        Object object = file = uFile != null ? uFile.getPsi() : null;
        if (file == null && (psi = element1.getPsi()) != null) {
            file = psi.getContainingFile();
        }
        return Intrinsics.areEqual((Object)file, (Object)element2.getContainingFile());
    }

    private final String getMethodName(String prefix, String propertyName) {
        block3: {
            block2: {
                if (propertyName == null) break block2;
                CharSequence charSequence = propertyName;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String string = propertyName;
        int n = 1;
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String theRest = string2;
        return prefix + firstLetter + theRest;
    }

    private final boolean isShrinking(Context context) {
        LintModelModule model = context.getMainProject().getBuildModule();
        return model != null ? !model.neverShrinking() : true;
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[3];
        String string = SdkConstants.MOTION_LAYOUT.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MOTION_LAYOUT.oldName()");
        objectArray[0] = string;
        String string2 = SdkConstants.MOTION_LAYOUT.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MOTION_LAYOUT.newName()");
        objectArray[1] = string2;
        objectArray[2] = "CustomAttribute";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            String sceneReference;
            String string = sceneReference = element.getAttributeNS(MOTION_LAYOUT_URI, "layoutDescription");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sceneReference");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
            String string2 = sceneReference;
            int n = StringsKt.indexOf$default((CharSequence)sceneReference, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl2 = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String sceneName = string3;
            Iterator iterator = DomExtensions.iterator((Element)element);
            while (iterator.hasNext()) {
                boolean bl3;
                Element view = (Element)iterator.next();
                String string4 = view.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"view.tagName");
                if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)".", (boolean)false, (int)2, null)) continue;
                String id = Lint.stripIdPrefix((String)view.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
                CharSequence charSequence2 = id;
                boolean bl4 = false;
                if (!(charSequence2.length() > 0)) continue;
                List list = this.sceneIds;
                if (list == null) {
                    ObjectAnimatorDetector objectAnimatorDetector = this;
                    boolean bl5 = false;
                    bl3 = false;
                    ObjectAnimatorDetector $this$run = objectAnimatorDetector;
                    boolean bl6 = false;
                    ArrayList list2 = new ArrayList();
                    $this$run.sceneIds = list2;
                    list = list2;
                }
                List list3 = list;
                Collection collection = list3;
                String string5 = view.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"view.tagName");
                SceneReference sceneReference2 = new SceneReference(string5, id, sceneName);
                bl3 = false;
                collection.add(sceneReference2);
            }
        } else {
            boolean sceneReference = context.getResourceFolderType() == ResourceFolderType.XML;
            boolean sceneName = false;
            boolean view = false;
            if (_Assertions.ENABLED && !sceneReference) {
                boolean bl = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            List<SceneReference> list = this.sceneIds;
            if (list == null) {
                return;
            }
            List<SceneReference> ids = list;
            Attr attribute = element.getAttributeNodeNS(MOTION_LAYOUT_URI, "attributeName");
            if (attribute == null) {
                return;
            }
            String attributeName = attribute.getValue();
            Node node = element.getParentNode();
            if (!(node instanceof Element)) {
                node = null;
            }
            Element element2 = (Element)node;
            if (element2 == null) {
                return;
            }
            Element parent = element2;
            String parentId = Lint.stripIdPrefix((String)parent.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            String string = context.file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
            String sceneName2 = Lint.getBaseName((String)string);
            for (SceneReference s : ids) {
                PsiClass targetClass;
                PsiMethod[] methods;
                if (!Intrinsics.areEqual((Object)parentId, (Object)s.getId()) || !Intrinsics.areEqual((Object)s.getScene(), (Object)sceneName2)) continue;
                String viewClass = s.getViewClass();
                UastParser uastParser = context.getClient().getUastParser(context.getProject());
                JavaEvaluator evaluator = uastParser.getEvaluator();
                if (evaluator.findClass(viewClass) == null) {
                    continue;
                }
                String methodName = this.getMethodName("set", attributeName);
                PsiMethod[] psiMethodArray = methods = targetClass.findMethodsByName(methodName, true);
                int n = psiMethodArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiMethod m;
                    PsiMethod psiMethod = m = psiMethodArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"m");
                    PsiParameterList psiParameterList = psiMethod.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"m.parameterList");
                    if (psiParameterList.getParametersCount() != 1) continue;
                    PsiModifierListOwner owner = (PsiModifierListOwner)m;
                    while (owner != null) {
                        PsiModifierList modifierList = owner.getModifierList();
                        if (modifierList != null) {
                            PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                            int n2 = psiAnnotationArray.length;
                            for (int j = 0; j < n2; ++j) {
                                PsiAnnotation annotation;
                                PsiAnnotation psiAnnotation = annotation = psiAnnotationArray[j];
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"annotation");
                                if (!KEEP_ANNOTATION.isEquals(psiAnnotation.getQualifiedName())) continue;
                                return;
                            }
                        }
                        owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
                    }
                    if (!this.isShrinking((Context)context)) {
                        return;
                    }
                    Location location = context.getValueLocation(attribute);
                    LintDriver lintDriver = context.getDriver();
                    Project project = context.getProject();
                    Project project2 = context.getMainProject();
                    PsiFile psiFile = targetClass.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"targetClass.containingFile");
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)psiFile.getVirtualFile());
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoF\u2026ntainingFile.virtualFile)");
                    JavaContext javaContext = new JavaContext(lintDriver, project, project2, file);
                    location.withSecondary(uastParser.getLocation(javaContext, (PsiElement)m), "This method is accessed via reflection from a " + "MotionScene (" + sceneName2 + ") so it should be " + "annotated with `@Keep` to ensure that it is not " + "discarded or renamed in release builds", true);
                    XmlContext.report$default((XmlContext)context, (Issue)MISSING_KEEP, (Node)element, (Location)location, (String)("This attribute references a method or property in " + "custom view " + viewClass + " which is not annotated with " + "`@Keep`; it should be annotated with `@Keep` to " + "ensure that it is not discarded or renamed in " + "release builds"), null, (int)16, null);
                }
            }
        }
    }

    static {
        Companion = new Companion(null);
        KEEP_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Keep");
        IMPLEMENTATION = new Implementation(ObjectAnimatorDetector.class, Scope.JAVA_AND_RESOURCE_FILES, new EnumSet[]{Scope.JAVA_FILE_SCOPE});
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 4;
        String string = null;
        Category category = Category.PERFORMANCE;
        MISSING_KEEP = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"AnimatorKeep", (String)"Missing @Keep for Animated Properties", (String)"\n                    When you use property animators, properties can be accessed via reflection. \\\n                    Those methods should be annotated with @Keep to ensure that during release \\\n                    builds, the methods are not potentially treated as unused and removed, or \\\n                    treated as internal only and get renamed to something shorter.\n\n                    This check will also flag other potential reflection problems it encounters, \\\n                    such as a missing property, wrong argument types, etc.\n                    ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CORRECTNESS;
        BROKEN_PROPERTY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ObjectAnimatorBinding", (String)"Incorrect ObjectAnimator Property", (String)"\n                    This check cross references properties referenced by String from \\\n                    `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that \\\n                    the corresponding setter methods exist and have the right signatures.\n                    ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "", "viewClass", "", "id", "scene", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getScene", "getViewClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
    private static final class SceneReference {
        @NotNull
        private final String viewClass;
        @NotNull
        private final String id;
        @NotNull
        private final String scene;

        @NotNull
        public final String getViewClass() {
            return this.viewClass;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getScene() {
            return this.scene;
        }

        public SceneReference(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            this.viewClass = viewClass;
            this.id = id;
            this.scene = scene;
        }

        @NotNull
        public final String component1() {
            return this.viewClass;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.scene;
        }

        @NotNull
        public final SceneReference copy(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            return new SceneReference(viewClass, id, scene);
        }

        public static /* synthetic */ SceneReference copy$default(SceneReference sceneReference, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = sceneReference.viewClass;
            }
            if ((n & 2) != 0) {
                string2 = sceneReference.id;
            }
            if ((n & 4) != 0) {
                string3 = sceneReference.scene;
            }
            return sceneReference.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SceneReference(viewClass=" + this.viewClass + ", id=" + this.id + ", scene=" + this.scene + ")";
        }

        public int hashCode() {
            String string = this.viewClass;
            String string2 = this.id;
            String string3 = this.scene;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SceneReference)) break block3;
                    SceneReference sceneReference = (SceneReference)object;
                    if (!Intrinsics.areEqual((Object)this.viewClass, (Object)sceneReference.viewClass) || !Intrinsics.areEqual((Object)this.id, (Object)sceneReference.id) || !Intrinsics.areEqual((Object)this.scene, (Object)sceneReference.scene)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$Companion;", "", "()V", "BROKEN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEEP_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getKEEP_ANNOTATION", "()Lcom/android/support/AndroidxName;", "MISSING_KEEP", "MOTION_LAYOUT_URI", "", "lint-checks"})
    public static final class Companion {
        public final AndroidxName getKEEP_ANNOTATION() {
            return KEEP_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

