/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class ViewTagDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"ViewTag", (String)"Tagged object leaks", (String)"Prior to Android 4.0, the implementation of `View.setTag(int, Object)` would store the objects in a static map, where the values were strongly referenced. This means that if the object contains any references pointing back to the context, the context (which points to pretty much everything else) will leak. If you pass a view, the view provides a reference to the context that created it. Similarly, view holders typically contain a view, and cursors are sometimes also associated with views.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewTagDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setTag");
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        String objectType;
        if (context.getMainProject().getMinSdk() >= 14) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        UExpression tagArgument = (UExpression)arguments.get(1);
        if (tagArgument == null) {
            return;
        }
        PsiType type = TypeEvaluator.evaluate((UElement)tagArgument);
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass typeClass = ((PsiClassType)type).resolve();
        if (typeClass == null) {
            return;
        }
        if (evaluator.extendsClass(typeClass, "android.view.View", false)) {
            objectType = "views";
        } else if (evaluator.implementsInterface(typeClass, "android.database.Cursor", false)) {
            objectType = "cursors";
        } else if (typeClass.getName() != null && typeClass.getName().endsWith("ViewHolder")) {
            objectType = "view holders";
        } else {
            return;
        }
        String message2 = String.format("Avoid setting %1$s as values for `setTag`: Can lead to memory leaks in versions older than Android 4.0", objectType);
        context.report(ISSUE, (UElement)call, context.getLocation((UElement)tagArgument), message2);
    }
}

