/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.scopes.impl.AbstractFirOverrideScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideCheckerKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\b0\b\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fJJ\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u0011\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\n0\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ<\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\b\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\b2\u0006\u0010\u0016\u001a\u00020\u0017J#\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u0006\u0012\u0002\b\u00030\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0\u00112\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "createOverridableGroups", "", "Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;", "D", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "members", "", "overrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "extractBothWaysOverridable", "", "overrider", "", "selectMostSpecificMembers", "overridables", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "compareTo", "", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService$MemberWithBaseScopeAndReturnType;", "other", "(Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService$MemberWithBaseScopeAndReturnType;Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService$MemberWithBaseScopeAndReturnType;)Ljava/lang/Integer;", "removeFlagged", "", "E", "flags", "", "MemberWithBaseScopeAndReturnType", "providers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideService.kt\norg/jetbrains/kotlin/fir/scopes/FirOverrideService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,176:1\n1#2:177\n1549#3:178\n1620#3,3:179\n21#4:182\n*S KotlinDebug\n*F\n+ 1 FirOverrideService.kt\norg/jetbrains/kotlin/fir/scopes/FirOverrideService\n*L\n96#1:178\n96#1:179,3\n128#1:182\n*E\n"})
public final class FirOverrideService
implements FirSessionComponent {
    @NotNull
    private final FirSession session;

    public FirOverrideService(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> List<List<MemberWithBaseScope<D>>> createOverridableGroups(@NotNull Collection<? extends MemberWithBaseScope<? extends D>> members, @NotNull FirOverrideChecker overrideChecker) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)overrideChecker, (String)"overrideChecker");
        if (members.size() <= 1) {
            return CollectionsKt.listOf((Object)CollectionsKt.toList((Iterable)members));
        }
        LinkedList<? extends MemberWithBaseScope<? extends D>> queue = new LinkedList<MemberWithBaseScope<? extends D>>(members);
        List result2 = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            MemberWithBaseScope nextHandle = (MemberWithBaseScope)CollectionsKt.first((List)queue);
            Intrinsics.checkNotNullExpressionValue((Object)nextHandle, (String)"nextHandle");
            List<MemberWithBaseScope<D>> overridableGroup2 = this.extractBothWaysOverridable(nextHandle, (Collection)queue, overrideChecker);
            ((Collection)result2).add(overridableGroup2);
        }
        return result2;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> List<MemberWithBaseScope<D>> extractBothWaysOverridable(@NotNull MemberWithBaseScope<? extends D> overrider, @NotNull Collection<MemberWithBaseScope<D>> members, @NotNull FirOverrideChecker overrideChecker) {
        List list2;
        Intrinsics.checkNotNullParameter(overrider, (String)"overrider");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)overrideChecker, (String)"overrideChecker");
        List $this$extractBothWaysOverridable_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$extractBothWaysOverridable_u24lambda_u240.add(overrider);
        List result2 = list2;
        Iterator<MemberWithBaseScope<D>> iterator2 = members.iterator();
        FirCallableDeclaration overrideCandidate = (FirCallableDeclaration)((FirBasedSymbol)overrider.getMember()).getFir();
        while (iterator2.hasNext()) {
            MemberWithBaseScope<D> next = iterator2.next();
            if (Intrinsics.areEqual(next, overrider)) {
                iterator2.remove();
                continue;
            }
            if (!AbstractFirOverrideScopeKt.similarFunctionsOrBothProperties(overrideChecker, overrideCandidate, (FirCallableDeclaration)((FirBasedSymbol)next.getMember()).getFir())) continue;
            result2.add(next);
            iterator2.remove();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <D extends FirCallableSymbol<?>> List<MemberWithBaseScope<D>> selectMostSpecificMembers(@NotNull List<? extends MemberWithBaseScope<? extends D>> overridables, @NotNull ReturnTypeCalculator returnTypeCalculator2) {
        void $this$mapTo$iv$iv;
        Object object;
        Object object2;
        Object withReturnType;
        Intrinsics.checkNotNullParameter(overridables, (String)"overridables");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator2, (String)"returnTypeCalculator");
        if (!(!((Collection)overridables).isEmpty())) {
            boolean $i$a$-require-FirOverrideService$selectMostSpecificMembers$22 = false;
            String $i$a$-require-FirOverrideService$selectMostSpecificMembers$22 = "Should have at least one overridable symbol";
            throw new IllegalArgumentException($i$a$-require-FirOverrideService$selectMostSpecificMembers$22.toString());
        }
        if (overridables.size() == 1) {
            return overridables;
        }
        List maximums = new ArrayList(2);
        for (MemberWithBaseScope<D> candidate2 : overridables) {
            withReturnType = new MemberWithBaseScopeAndReturnType<D>(candidate2, returnTypeCalculator2);
            boolean skip2 = false;
            int n = maximums.size();
            object2 = new boolean[n];
            for (int j = 0; j < n; ++j) {
                boolean bl;
                int n2;
                int n3 = n2 = j;
                object = object2;
                Integer n4 = this.compareTo((MemberWithBaseScopeAndReturnType)maximums.get(n2), (MemberWithBaseScopeAndReturnType<?>)withReturnType);
                if (n4 == null) {
                    bl = false;
                } else {
                    int c = n4;
                    if (c >= 0) {
                        skip2 = true;
                    }
                    bl = c < 0;
                }
                object[n3] = bl;
            }
            boolean[] toRemove = object2;
            this.removeFlagged(maximums, toRemove);
            if (skip2) continue;
            maximums.add(withReturnType);
        }
        Iterable $this$map$iv = maximums;
        boolean $i$f$map = false;
        withReturnType = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object2 = (MemberWithBaseScopeAndReturnType)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getMemberWithBaseScope());
        }
        return (List)destination$iv$iv;
    }

    private final <E> void removeFlagged(List<E> $this$removeFlagged, boolean[] flags) {
        int dest = 0;
        int n = flags.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (flags[i2]) continue;
            $this$removeFlagged.set(dest++, $this$removeFlagged.get(i2));
        }
        while ($this$removeFlagged.size() > dest) {
            CollectionsKt.removeLast($this$removeFlagged);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Integer compareTo(MemberWithBaseScopeAndReturnType<?> $this$compareTo, MemberWithBaseScopeAndReturnType<?> other) {
        Integer n;
        int n2;
        FirCallableDeclaration aFir = (FirCallableDeclaration)((FirBasedSymbol)$this$compareTo.getMemberWithBaseScope().getMember()).getFir();
        FirCallableDeclaration bFir = (FirCallableDeclaration)((FirBasedSymbol)other.getMemberWithBaseScope().getMember()).getFir();
        FirMemberDeclaration $this$visibility$iv = aFir;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = bFir;
        $i$f$getVisibility = false;
        Integer n3 = Visibilities.INSTANCE.compare(visibility2, $this$visibility$iv.getStatus().getVisibility());
        int byVisibility = n3 != null ? n3 : 0;
        ConeSubstitutor coneSubstitutor = FirAbstractOverrideCheckerKt.buildSubstitutorForOverridesCheck(aFir, bFir, this.session);
        if (coneSubstitutor == null) {
            return null;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        ConeKotlinType coneKotlinType = $this$compareTo.getReturnType();
        if (coneKotlinType == null) return null;
        ConeKotlinType p0 = coneKotlinType;
        boolean bl = false;
        ConeKotlinType coneKotlinType2 = substitutor2.substituteOrSelf(p0);
        coneKotlinType = coneKotlinType2;
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType aReturnType = coneKotlinType;
        ConeKotlinType coneKotlinType3 = other.getReturnType();
        if (coneKotlinType3 == null) {
            return null;
        }
        ConeKotlinType bReturnType = coneKotlinType3;
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(this.session).newTypeCheckerState(false, false);
        boolean aSubtypesB = AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)aReturnType, (KotlinTypeMarker)bReturnType, false, 8, null);
        boolean bSubtypesA = AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)bReturnType, (KotlinTypeMarker)aReturnType, false, 8, null);
        if (aSubtypesB && bSubtypesA) {
            Integer n4 = FirOverrideService.compareTo$merge(!(aReturnType instanceof ConeFlexibleType), !(bReturnType instanceof ConeFlexibleType), byVisibility);
            if (n4 == null) return null;
            n2 = n4;
        } else if (aSubtypesB && byVisibility >= 0) {
            n2 = 1;
        } else {
            if (!bSubtypesA || byVisibility > 0) return null;
            n2 = -1;
        }
        int byVisibilityAndType = n2;
        FirCallableDeclaration firCallableDeclaration = aFir;
        if (firCallableDeclaration instanceof FirSimpleFunction) {
            if (!(bFir instanceof FirSimpleFunction)) {
                boolean $i$a$-require-FirOverrideService$compareTo$32 = false;
                String $i$a$-require-FirOverrideService$compareTo$32 = "b is " + bFir.getClass();
                throw new IllegalArgumentException($i$a$-require-FirOverrideService$compareTo$32.toString());
            }
            n = byVisibilityAndType;
            return n;
        } else {
            if (!(firCallableDeclaration instanceof FirProperty)) throw new IllegalArgumentException("Unexpected callable: " + aFir.getClass());
            if (!(bFir instanceof FirProperty)) {
                boolean bl2 = false;
                String string2 = "b is " + bFir.getClass();
                throw new IllegalArgumentException(string2.toString());
            }
            if (((FirProperty)aFir).isVar() && !aSubtypesB) {
                return null;
            }
            if (((FirProperty)bFir).isVar() && !bSubtypesA) {
                return null;
            }
            n = FirOverrideService.compareTo$merge(((FirProperty)aFir).isVar(), ((FirProperty)bFir).isVar(), byVisibilityAndType);
        }
        return n;
    }

    private static final Integer compareTo$merge(boolean preferA, boolean preferB, int previous) {
        return preferA == preferB ? Integer.valueOf(previous) : (preferA && previous >= 0 ? Integer.valueOf(1) : (preferB && previous <= 0 ? Integer.valueOf(-1) : null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService$MemberWithBaseScopeAndReturnType;", "D", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "", "memberWithBaseScope", "Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "(Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "getMemberWithBaseScope", "()Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;", "returnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getReturnType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "providers"})
    private static final class MemberWithBaseScopeAndReturnType<D extends FirCallableSymbol<?>> {
        @NotNull
        private final MemberWithBaseScope<D> memberWithBaseScope;
        @Nullable
        private final ConeKotlinType returnType;

        public MemberWithBaseScopeAndReturnType(@NotNull MemberWithBaseScope<? extends D> memberWithBaseScope, @NotNull ReturnTypeCalculator returnTypeCalculator2) {
            Intrinsics.checkNotNullParameter(memberWithBaseScope, (String)"memberWithBaseScope");
            Intrinsics.checkNotNullParameter((Object)returnTypeCalculator2, (String)"returnTypeCalculator");
            this.memberWithBaseScope = memberWithBaseScope;
            FirResolvedTypeRef firResolvedTypeRef = returnTypeCalculator2.tryCalculateReturnTypeOrNull((FirCallableDeclaration)((FirBasedSymbol)this.memberWithBaseScope.getMember()).getFir());
            this.returnType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        }

        @NotNull
        public final MemberWithBaseScope<D> getMemberWithBaseScope() {
            return this.memberWithBaseScope;
        }

        @Nullable
        public final ConeKotlinType getReturnType() {
            return this.returnType;
        }
    }
}

