/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.impl.base.util.LibraryUtils;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtLibraryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleProviderBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSdkModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSourceModuleBuilder;
import org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a1\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0007\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0086\b\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"buildKtModuleProviderByCompilerConfiguration", "Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectSourceFilePaths", "", "root", "Ljava/nio/file/Path;", "result", "", "", "getPsiFilesFromPaths", "T", "Lcom/intellij/psi/PsiFileSystemItem;", "paths", "", "getSourceFilePaths", "", "includeDirectoryRoot", "", "getAnalyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analysis-api-standalone"})
@SourceDebugExtension(value={"SMAP\nKtModuleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtModuleUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtModuleProviderBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleProviderBuilderKt\n+ 5 KtSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilderKt\n+ 6 KtLibraryModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtLibraryModuleBuilderKt\n+ 7 KtSdkModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSdkModuleBuilderKt\n*L\n1#1,205:1\n136#1,11:233\n148#1:245\n1855#2,2:206\n1549#2:221\n1620#2,3:222\n1549#2:225\n1620#2,3:226\n1#3:208\n1#3:244\n39#4,4:209\n51#5,4:213\n37#6,4:217\n34#7,4:229\n*S KotlinDebug\n*F\n+ 1 KtModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtModuleUtilsKt\n*L\n195#1:233,11\n195#1:245\n70#1:206,2\n168#1:221\n168#1:222,3\n176#1:225\n176#1:226,3\n195#1:244\n156#1:209,4\n159#1:213,4\n164#1:217,4\n180#1:229,4\n*E\n"})
public final class KtModuleUtilsKt {
    @NotNull
    public static final PlatformDependentAnalyzerServices getAnalyzerServices(@NotNull TargetPlatform $this$getAnalyzerServices) {
        PlatformDependentAnalyzerServices platformDependentAnalyzerServices;
        Intrinsics.checkNotNullParameter((Object)$this$getAnalyzerServices, (String)"<this>");
        if (JvmPlatformKt.isJvm($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = JvmPlatformAnalyzerServices.INSTANCE;
        } else if (JsPlatformKt.isJs($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = JsPlatformAnalyzerServices.INSTANCE;
        } else if (NativePlatformKt.isNative($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = NativePlatformAnalyzerServices.INSTANCE;
        } else if (TargetPlatformKt.isCommon($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = CommonPlatformAnalyzerServices.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown target platform: " + $this$getAnalyzerServices).toString());
        }
        return platformDependentAnalyzerServices;
    }

    @NotNull
    public static final Set<String> getSourceFilePaths(@NotNull CompilerConfiguration compilerConfig, boolean includeDirectoryRoot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Set $this$getSourceFilePaths_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = JvmContentRootsKt.getJavaSourceRoots(compilerConfig);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path2 = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path2, new LinkOption[0])) {
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                KtModuleUtilsKt.collectSourceFilePaths(path2, $this$getSourceFilePaths_u24lambda_u241);
                if (!includeDirectoryRoot) continue;
                $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
                continue;
            }
            $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
        }
        return SetsKt.build((Set)set);
    }

    public static /* synthetic */ Set getSourceFilePaths$default(CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KtModuleUtilsKt.getSourceFilePaths(compilerConfiguration, bl);
    }

    private static final void collectSourceFilePaths(Path root, Set<String> result2) {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result2){
            final /* synthetic */ Set<String> $result;
            {
                this.$result = $result;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file2, new LinkOption[0]) || !Files.isReadable(file2)) {
                    return FileVisitResult.CONTINUE;
                }
                String ext = com.google.common.io.Files.getFileExtension((String)((Object)file2.getFileName()).toString());
                if (Intrinsics.areEqual((Object)ext, (Object)"kt") || Intrinsics.areEqual((Object)ext, (Object)"java")) {
                    this.$result.add(((Object)file2).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file2, @Nullable IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final /* synthetic */ <T extends PsiFileSystemItem> List<T> getPsiFilesFromPaths(Project project, Collection<String> paths) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager3 = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String path2 : paths) {
            PsiFileSystemItem it;
            PsiFileSystemItem psiFileSystemItem;
            PsiFileSystemItem psiFileSystemItem2;
            VirtualFile vFile;
            if (fs.findFileByPath(path2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile, (String)"fs.findFileByPath(path) ?: continue");
            if (vFile.isDirectory()) {
                PsiDirectory psiDirectory = psiManager3.findDirectory(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager3.findFile(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = psiFileSystemItem = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem == null) continue;
            boolean bl2 = false;
            Boolean.valueOf($this$getPsiFilesFromPaths_u24lambda_u243.add(it));
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ProjectStructureProvider buildKtModuleProviderByCompilerConfiguration(@NotNull CompilerConfiguration compilerConfig, @NotNull Project project, @NotNull List<? extends KtFile> ktFiles) {
        void paths$iv;
        Iterator it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245;
        void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249;
        KtLibraryModuleBuilder ktLibraryModuleBuilder;
        KtSourceModuleBuilder ktSourceModuleBuilder;
        KtModuleProviderBuilder ktModuleProviderBuilder;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        boolean $i$f$buildProjectStructureProvider = false;
        KtModuleProviderBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410 = ktModuleProviderBuilder = new KtModuleProviderBuilder();
        boolean bl = false;
        TargetPlatform platform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        boolean $i$f$buildKtSourceModule = false;
        KtSourceModuleBuilder ktSourceModuleBuilder2 = ktSourceModuleBuilder = new KtSourceModuleBuilder();
        KtModuleProviderBuilder ktModuleProviderBuilder2 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410;
        boolean bl2 = false;
        String string2 = compilerConfig.get(CommonConfigurationKeys.MODULE_NAME);
        if (string2 == null) {
            string2 = "<no module name provided>";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compilerConfig.get(Commo\u2026no module name provided>\"");
        String moduleName = string2;
        List libraryRoots = CollectionsKt.plus((Collection)JvmContentRootsKt.getJvmModularRoots(compilerConfig), (Iterable)JvmContentRootsKt.getJvmClasspathRoots(compilerConfig));
        boolean $i$f$buildKtLibraryModule22 = false;
        KtLibraryModuleBuilder ktLibraryModuleBuilder2 = ktLibraryModuleBuilder = new KtLibraryModuleBuilder();
        void var18_20 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249;
        boolean bl3 = false;
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(project)");
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245.setContentScope(globalSearchScope);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245.setPlatform(platform);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245.setProject(project);
        Iterable iterable = libraryRoots;
        void var21_24 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245;
        boolean $i$f$map = false;
        void var23_28 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(((File)((Object)it)).toPath());
        }
        var21_24.setBinaryRoots((List)destination$iv$iv);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u245.setLibraryName("Library for " + moduleName);
        var18_20.addRegularDependency(ktLibraryModuleBuilder.build());
        File file3 = compilerConfig.get(JVMConfigurationKeys.JDK_HOME);
        if (file3 != null) {
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247;
            Collection collection;
            KtSdkModuleBuilder $this$mapTo$iv$iv2;
            File jdkHome2 = file3;
            boolean bl5 = false;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
            VirtualFileManager vfm = virtualFileManager;
            Path jdkHomePath = jdkHome2.toPath();
            VirtualFile jdkHomeVirtualFile = vfm.findFileByNioPath(jdkHomePath);
            Intrinsics.checkNotNullExpressionValue((Object)jdkHomePath, (String)"jdkHomePath");
            Iterable $this$map$iv2 = LibraryUtils.INSTANCE.findClassesFromJdkHome(jdkHomePath);
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            it = $this$mapTo$iv$iv2.iterator();
            while (it.hasNext()) {
                void it2;
                Object item$iv$iv = it.next();
                String bl4 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(Paths.get(URLUtil.extractPath((String)it2), new String[0]));
            }
            List binaryRoots = (List)destination$iv$iv2;
            boolean $i$f$buildKtSdkModule = false;
            $this$mapTo$iv$iv2 = $i$f$map2 = new KtSdkModuleBuilder();
            collection = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249;
            boolean bl7 = false;
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.fileScope((Project)project, (VirtualFile)jdkHomeVirtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"fileScope(project, jdkHomeVirtualFile)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setContentScope(globalSearchScope2);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setProject(project);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setBinaryRoots(binaryRoots);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setSdkName("JDK for " + moduleName);
            ((KtModuleBuilder)((Object)collection)).addRegularDependency($i$f$map2.build());
        }
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249.setContentScope(TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, (Collection<? extends KtFile>)ktFiles));
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249.setPlatform(platform);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249.setProject(project);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249.setModuleName(moduleName);
        Collection $i$f$buildKtLibraryModule22 = KtModuleUtilsKt.getSourceFilePaths(compilerConfig, true);
        var18_20 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410_u24lambda_u249;
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs$iv = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager$iv = psiManager2;
        Iterable $this$getPsiFilesFromPaths_u24lambda_u243$iv = iterable = CollectionsKt.createListBuilder();
        boolean bl8 = false;
        for (String path$iv : paths$iv) {
            PsiFileSystemItem it$iv;
            PsiFileSystemItem psiFileSystemItem$iv;
            PsiFileSystemItem psiFileSystemItem;
            VirtualFile vFile$iv;
            if (fs$iv.findFileByPath(path$iv) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile$iv, (String)"fs.findFileByPath(path) ?: continue");
            if (vFile$iv.isDirectory()) {
                PsiDirectory psiDirectory = psiManager$iv.findDirectory(vFile$iv);
                if (!(psiDirectory instanceof PsiFileSystemItem)) {
                    psiDirectory = null;
                }
                psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager$iv.findFile(vFile$iv);
                if (!(psiFile instanceof PsiFileSystemItem)) {
                    psiFile = null;
                }
                psiFileSystemItem = psiFileSystemItem$iv = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem$iv == null) continue;
            boolean bl9 = false;
            $this$getPsiFilesFromPaths_u24lambda_u243$iv.add(it$iv);
        }
        var18_20.addSourceRoots(CollectionsKt.build((List)iterable));
        ktModuleProviderBuilder2.addModule(ktSourceModuleBuilder.build());
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410.setPlatform(platform);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2410.setProject(project);
        return ktModuleProviderBuilder.build();
    }
}

