/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.KtDeclarationAndFirDeclarationEqualityChecker;
import org.jetbrains.kotlin.analysis.low.level.api.fir.project.structure.LLFirModuleDataKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationForCompiledElementSearcherKt;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.utils.errors.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.analysis.utils.errors.ExceptionWithAttachmentBuilderHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0007*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0007H\u0002\u00a8\u0006\u001a"}, d2={"representSameConstructor", "", "psiConstructor", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "firConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "findCallableCandidates", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isTopLevel", "findFunctionCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findPropertyCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "withCandidates", "", "Lorg/jetbrains/kotlin/analysis/utils/errors/ExceptionAttachmentBuilder;", "candidates", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationForCompiledElementSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcherKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n800#2,11:156\n800#2,11:167\n*S KotlinDebug\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcherKt\n*L\n114#1:156,11\n117#1:167,11\n*E\n"})
public final class FirDeclarationForCompiledElementSearcherKt {
    /*
     * WARNING - void declaration
     */
    private static final List<FirFunctionSymbol<?>> findFunctionCandidates(FirSymbolProvider $this$findFunctionCandidates, KtNamedFunction function2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = FirDeclarationForCompiledElementSearcherKt.findCallableCandidates($this$findFunctionCandidates, function2, function2.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FirPropertySymbol> findPropertyCandidates(FirSymbolProvider $this$findPropertyCandidates, KtProperty property2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = FirDeclarationForCompiledElementSearcherKt.findCallableCandidates($this$findPropertyCandidates, property2, property2.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<FirCallableSymbol<?>> findCallableCandidates(FirSymbolProvider $this$findCallableCandidates, KtCallableDeclaration declaration, boolean isTopLevel2) {
        if (isTopLevel2) {
            FqName fqName2 = declaration.getContainingKtFile().getPackageFqName();
            Name name2 = declaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"declaration.nameAsSafeName");
            return $this$findCallableCandidates.getTopLevelCallableSymbols(fqName2, name2);
        }
        Object object = KtPsiUtilKt.getContainingClassOrObject(declaration);
        if (object == null || (object = ((KtClassOrObject)object).getClassId()) == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No containing non-local declaration found for", null, null, null, declaration, null, 46, null);
            throw null;
        }
        Object containerClassId = object;
        Name name3 = declaration.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"declaration.nameAsSafeName");
        Collection collection = FirSymbolProviderKt.getClassDeclaredFunctionSymbols($this$findCallableCandidates, (ClassId)containerClassId, name3);
        Name name4 = declaration.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"declaration.nameAsSafeName");
        return CollectionsKt.plus((Collection)collection, (Iterable)FirSymbolProviderKt.getClassDeclaredPropertySymbols($this$findCallableCandidates, (ClassId)containerClassId, name4));
    }

    private static final boolean representSameConstructor(KtConstructor<?> psiConstructor, FirConstructor firConstructor) {
        if (firConstructor.isPrimary() != psiConstructor instanceof KtPrimaryConstructor) {
            return false;
        }
        return KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(psiConstructor, firConstructor);
    }

    private static final void withCandidates(ExceptionAttachmentBuilder $this$withCandidates, List<? extends FirBasedSymbol<?>> candidates2) {
        $this$withCandidates.withEntry("Candidates count", String.valueOf(candidates2.size()));
        Iterator<FirBasedSymbol<?>> iterator2 = candidates2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirBasedSymbol<?> candidate2 = iterator2.next();
            KtModule ktModule = LLFirModuleDataKt.getLlFirModuleData(candidate2).getKtModule();
            $this$withCandidates.withEntryGroup(String.valueOf(index2), (Function1<? super ExceptionAttachmentBuilder, Unit>)((Function1)new Function1<ExceptionAttachmentBuilder, Unit>(candidate2, ktModule){
                final /* synthetic */ FirBasedSymbol<?> $candidate;
                final /* synthetic */ KtModule $ktModule;
                {
                    this.$candidate = $candidate;
                    this.$ktModule = $ktModule;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionAttachmentBuilder $this$withEntryGroup) {
                    Intrinsics.checkNotNullParameter((Object)$this$withEntryGroup, (String)"$this$withEntryGroup");
                    ExceptionWithAttachmentBuilderHelpersKt.withClassEntry($this$withEntryGroup, "candidateClass", this.$candidate);
                    $this$withEntryGroup.withEntry("module", this.$ktModule, withCandidates.1.INSTANCE);
                    $this$withEntryGroup.withEntry("origin", this.$candidate.getOrigin().toString());
                    ExceptionUtilsKt.withFirEntry($this$withEntryGroup, "candidateFir", (FirElement)this.$candidate.getFir());
                }
            }));
        }
    }

    public static final /* synthetic */ List access$findFunctionCandidates(FirSymbolProvider $receiver, KtNamedFunction function2) {
        return FirDeclarationForCompiledElementSearcherKt.findFunctionCandidates($receiver, function2);
    }

    public static final /* synthetic */ void access$withCandidates(ExceptionAttachmentBuilder $receiver, List candidates2) {
        FirDeclarationForCompiledElementSearcherKt.withCandidates($receiver, candidates2);
    }

    public static final /* synthetic */ List access$findPropertyCandidates(FirSymbolProvider $receiver, KtProperty property2) {
        return FirDeclarationForCompiledElementSearcherKt.findPropertyCandidates($receiver, property2);
    }

    public static final /* synthetic */ boolean access$representSameConstructor(KtConstructor psiConstructor, FirConstructor firConstructor) {
        return FirDeclarationForCompiledElementSearcherKt.representSameConstructor(psiConstructor, firConstructor);
    }
}

