/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.LLFirFileBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.LLFirProviderHelperKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirElementFinder;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ \u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00112\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00112\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010$\u001a\u00020%*\u00020&2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120(2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper;", "", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LLFirFileBuilder;", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "packageProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "canContainKotlinPackage", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LLFirFileBuilder;Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;Z)V", "allowKotlinPackage", "callablesByCallableId", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "", "classifierByClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierByFqName", "classId", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "collectCallableDeclarationsTo", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "list", "", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirProviderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirProviderHelper.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper\n+ 2 FirCachesFactory.kt\norg/jetbrains/kotlin/fir/caches/FirCachesFactoryKt\n+ 3 FirCacheWithPostCompute.kt\norg/jetbrains/kotlin/fir/caches/FirCacheWithPostComputeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n68#2,3:96\n68#2,3:99\n17#3:102\n17#3:103\n800#4,11:104\n800#4,11:115\n1611#4:126\n1855#4:127\n1856#4:129\n1612#4:130\n1#5:128\n1#5:131\n*S KotlinDebug\n*F\n+ 1 LLFirProviderHelper.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper\n*L\n40#1:96,3\n50#1:99,3\n63#1:102\n69#1:103\n73#1:104,11\n77#1:115,11\n81#1:126\n81#1:127\n81#1:129\n81#1:130\n81#1:128\n*E\n"})
public final class LLFirProviderHelper {
    @NotNull
    private final LLFirFileBuilder firFileBuilder;
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;
    @NotNull
    private final KotlinPackageProvider packageProvider;
    private final boolean allowKotlinPackage;
    @NotNull
    private final FirCache classifierByClassId;
    @NotNull
    private final FirCache callablesByCallableId;

    public LLFirProviderHelper(@NotNull FirSession firSession, @NotNull LLFirFileBuilder firFileBuilder, @NotNull KotlinDeclarationProvider declarationProvider, @NotNull KotlinPackageProvider packageProvider, boolean canContainKotlinPackage) {
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        Intrinsics.checkNotNullParameter((Object)firFileBuilder, (String)"firFileBuilder");
        Intrinsics.checkNotNullParameter((Object)declarationProvider, (String)"declarationProvider");
        Intrinsics.checkNotNullParameter((Object)packageProvider, (String)"packageProvider");
        this.firFileBuilder = firFileBuilder;
        this.declarationProvider = declarationProvider;
        this.packageProvider = packageProvider;
        this.allowKotlinPackage = canContainKotlinPackage || FirLanguageSettingsComponentKt.getLanguageVersionSettings(firSession).getFlag(AnalysisFlags.getAllowKotlinPackage()) != false;
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(firSession);
        boolean $i$f$createCache = false;
        this.classifierByClassId = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ LLFirProviderHelper this$0;
            {
                this.this$0 = lLFirProviderHelper;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                FirClassLikeDeclaration firClassLikeDeclaration;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ClassId classId = (ClassId)key;
                boolean bl = false;
                KtClassLikeDeclaration ktClassLikeDeclaration = LLFirProviderHelper.access$getDeclarationProvider$p(this.this$0).getClassLikeDeclarationByClassId(classId);
                if (ktClassLikeDeclaration == null) {
                    firClassLikeDeclaration = null;
                } else {
                    KtClassLikeDeclaration ktClass = ktClassLikeDeclaration;
                    if (ktClass.getClassId() == null) {
                        firClassLikeDeclaration = null;
                    } else {
                        LLFirFileBuilder lLFirFileBuilder = LLFirProviderHelper.access$getFirFileBuilder$p(this.this$0);
                        KtFile ktFile = ktClass.getContainingKtFile();
                        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktClass.containingKtFile");
                        FirFile firFile = lLFirFileBuilder.buildRawFirFileWithCaching(ktFile);
                        firClassLikeDeclaration = FirElementFinder.INSTANCE.findClassifierWithClassId(firFile, classId);
                        if (firClassLikeDeclaration == null) {
                            throw new IllegalStateException(("Classifier " + classId + " was found in file " + ktClass.getContainingKtFile().getVirtualFilePath() + " but was not found in FirFile").toString());
                        }
                    }
                }
                return firClassLikeDeclaration;
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(firSession);
        $i$f$createCache = false;
        this.callablesByCallableId = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ LLFirProviderHelper this$0;
            {
                this.this$0 = lLFirProviderHelper;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                CallableId callableId = (CallableId)key;
                boolean bl = false;
                List list3 = LLFirProviderHelper.access$getDeclarationProvider$p(this.this$0).getTopLevelCallableFiles(callableId);
                if (list3.isEmpty()) {
                    boolean bl2 = false;
                    list2 = CollectionsKt.emptyList();
                } else {
                    List files2 = list3;
                    List $this$callablesByCallableId_u24lambda_u244_u24lambda_u243 = list3 = CollectionsKt.createListBuilder();
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = files2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtFile ktFile = (KtFile)element$iv;
                        boolean bl4 = false;
                        FirFile firFile = LLFirProviderHelper.access$getFirFileBuilder$p(this.this$0).buildRawFirFileWithCaching(ktFile);
                        LLFirProviderHelper.access$collectCallableDeclarationsTo(this.this$0, firFile, $this$callablesByCallableId_u24lambda_u244_u24lambda_u243, callableId.getCallableName());
                    }
                    list2 = CollectionsKt.build((List)list3);
                }
                return list2;
            }
        });
    }

    @Nullable
    public final FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (classId.isLocal()) {
            return null;
        }
        if (!this.allowKotlinPackage && LLFirProviderHelperKt.access$isKotlinPackage(classId)) {
            return null;
        }
        FirCache $this$getValue$iv = this.classifierByClassId;
        boolean $i$f$getValue = false;
        return (FirClassLikeDeclaration)$this$getValue$iv.getValue(classId, null);
    }

    @NotNull
    public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!this.allowKotlinPackage && LLFirProviderHelperKt.access$isKotlinPackage(packageFqName)) {
            return CollectionsKt.emptyList();
        }
        CallableId callableId = new CallableId(packageFqName, name2);
        FirCache $this$getValue$iv = this.callablesByCallableId;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue(callableId, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirNamedFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirPropertySymbol> getTopLevelPropertySymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void collectCallableDeclarationsTo(FirFile $this$collectCallableDeclarationsTo, List<FirCallableSymbol<?>> list2, Name name2) {
        Iterable $this$mapNotNullTo$iv = $this$collectCallableDeclarationsTo.getDeclarations();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<? extends FirCallableDeclaration> it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirDeclaration declaration = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if ((declaration instanceof FirCallableDeclaration && Intrinsics.areEqual((Object)((FirCallableDeclaration)declaration).getSymbol().getCallableId().getCallableName(), (Object)name2) ? ((FirCallableDeclaration)declaration).getSymbol() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            ((Collection)list2).add(it$iv);
        }
    }

    @Nullable
    public final FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (!this.allowKotlinPackage && LLFirProviderHelperKt.access$isKotlinPackage(fqName2)) {
            return null;
        }
        FqName fqName3 = fqName2;
        KotlinPackageProvider kotlinPackageProvider = this.packageProvider;
        FqName p0 = fqName3;
        boolean bl = false;
        return kotlinPackageProvider.doKotlinPackageExists(p0) ? fqName3 : null;
    }

    public static final /* synthetic */ KotlinDeclarationProvider access$getDeclarationProvider$p(LLFirProviderHelper $this) {
        return $this.declarationProvider;
    }

    public static final /* synthetic */ LLFirFileBuilder access$getFirFileBuilder$p(LLFirProviderHelper $this) {
        return $this.firFileBuilder;
    }

    public static final /* synthetic */ void access$collectCallableDeclarationsTo(LLFirProviderHelper $this, FirFile $receiver, List list2, Name name2) {
        $this.collectCallableDeclarationsTo($receiver, list2, name2);
    }
}

