/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtTypeInfoProvider;
import org.jetbrains.kotlin.analysis.api.descriptors.KtFe10AnalysisSession;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.Fe10KtAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.descriptors.types.base.KtFe10Type;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0013\u001a\u00020\r*\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10TypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/Fe10KtAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "canBeNull", "", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "getFunctionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isArrayOrPrimitiveArray", "isDenotable", "isFunctionalInterfaceType", "isNestedArray", "Lorg/jetbrains/kotlin/types/KotlinType;", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nKtFe10TypeInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFe10TypeInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10TypeInfoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1726#2,3:71\n*S KotlinDebug\n*F\n+ 1 KtFe10TypeInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10TypeInfoProvider\n*L\n67#1:71,3\n*E\n"})
public final class KtFe10TypeInfoProvider
extends KtTypeInfoProvider
implements Fe10KtAnalysisSessionComponent {
    @NotNull
    private final KtFe10AnalysisSession analysisSession;

    public KtFe10TypeInfoProvider(@NotNull KtFe10AnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFe10AnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.getAnalysisSession().getToken();
    }

    @Override
    public boolean isFunctionalInterfaceType(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return JavaSingleAbstractMethodUtils.isSamType(((KtFe10Type)((Object)type2)).getFe10Type());
    }

    @Override
    @Nullable
    public FunctionClassKind getFunctionClassKind(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ClassifierDescriptor classifierDescriptor = ((KtFe10Type)((Object)type2)).getFe10Type().getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
    }

    @Override
    public boolean canBeNull(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return TypeUtils.isNullableType(((KtFe10Type)((Object)type2)).getFe10Type());
    }

    @Override
    public boolean isDenotable(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        UnwrappedType kotlinType = ((KtFe10Type)((Object)type2)).getFe10Type();
        return this.isDenotable(kotlinType);
    }

    @Override
    public boolean isArrayOrPrimitiveArray(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return KotlinBuiltIns.isArrayOrPrimitiveArray(((KtFe10Type)((Object)type2)).getFe10Type());
    }

    @Override
    public boolean isNestedArray(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!this.isArrayOrPrimitiveArray(type2)) {
            return false;
        }
        if (!(type2 instanceof KtFe10Type)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        UnwrappedType unwrappedType = ((KtFe10Type)((Object)type2)).getFe10Type();
        KotlinType kotlinType = unwrappedType.getConstructor().getBuiltIns().getArrayElementType(unwrappedType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"unwrappedType.constructo\u2026lementType(unwrappedType)");
        KotlinType elementType = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(elementType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDenotable(KotlinType $this$isDenotable) {
        KotlinType kotlinType;
        if ($this$isDenotable instanceof DefinitelyNotNullType) {
            return false;
        }
        if (!$this$isDenotable.getConstructor().isDenotable()) return false;
        ClassifierDescriptor classifierDescriptor = $this$isDenotable.getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual((Object)(classifierDescriptor != null ? classifierDescriptor.getName() : null), (Object)SpecialNames.NO_NAME_PROVIDED)) return false;
        Iterable $this$all$iv = $this$isDenotable.getArguments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            TypeProjection it = (TypeProjection)element$iv;
            boolean bl = false;
            kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
        } while (this.isDenotable(kotlinType));
        return false;
    }
}

