/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ApiVersionIsAtLeastArgumentsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isApiVersionIsAtLeast", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class ApiVersionIsAtLeastArgumentsChecker
implements CallChecker {
    @NotNull
    public static final ApiVersionIsAtLeastArgumentsChecker INSTANCE = new ApiVersionIsAtLeastArgumentsChecker();

    private ApiVersionIsAtLeastArgumentsChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.resultingDescriptor");
        if (!this.isApiVersionIsAtLeast((CallableDescriptor)obj)) {
            return;
        }
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        boolean shouldInlineConstVals = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineConstVals);
        Iterator<ValueArgument> iterator2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"resolvedCall.valueArguments");
        boolean bl = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Iterator<ValueArgument> iterator4 = iterator2 = iterator3.next();
            boolean bl2 = false;
            ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)iterator4.getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression ktExpression;
                KtExpression ktExpression2;
                ConstantValue<?> constant;
                KtExpression ktExpression3;
                KtExpression ktExpression4 = valueArgument.getArgumentExpression();
                if (ktExpression4 == null || (ktExpression3 = KtPsiUtil.deparenthesize(ktExpression4)) == null || (constant = JvmConstantsKt.getCompileTimeConstant(ktExpression2 = (ktExpression = ktExpression3), bindingContext2, false, shouldInlineConstVals)) != null) continue;
                context2.getTrace().report(ErrorsJvm.API_VERSION_IS_AT_LEAST_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)ktExpression2)));
            }
        }
    }

    private final boolean isApiVersionIsAtLeast(CallableDescriptor descriptor2) {
        PackageFragmentDescriptor packageFragmentDescriptor;
        boolean bl;
        FunctionDescriptor functionDescriptor;
        block9: {
            FunctionDescriptor functionDescriptor2;
            FunctionDescriptor functionDescriptor3 = functionDescriptor2 = descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null;
            if (functionDescriptor2 == null) {
                return false;
            }
            functionDescriptor = functionDescriptor2;
            if (!Intrinsics.areEqual((Object)functionDescriptor.getName().asString(), (Object)"apiVersionIsAtLeast")) {
                return false;
            }
            KotlinType kotlinType = functionDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Object object = kotlinType;
            Object returnType2 = object;
            if (!KotlinBuiltIns.isBoolean((KotlinType)returnType2)) {
                return false;
            }
            object = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDescriptor.valueParameters");
            Iterable $this$all$iv = (Iterable)object;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (KotlinBuiltIns.isInt(it.getType())) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingPackage = packageFragmentDescriptor;
        return Intrinsics.areEqual((Object)containingPackage.getFqName().asString(), (Object)"kotlin.internal");
    }
}

