/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getReferenceExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "staticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getStaticScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "EnumEntriesScope", "frontend"})
public final class TypeAliasQualifier
implements ClassifierQualifier {
    @NotNull
    private final KtSimpleNameExpression referenceExpression;
    @NotNull
    private final TypeAliasDescriptor descriptor;
    @NotNull
    private final ClassDescriptor classDescriptor;

    @Override
    @Nullable
    public ClassValueReceiver getClassValueReceiver() {
        ClassValueReceiver classValueReceiver;
        KotlinType kotlinType2 = DescriptorUtilsKt.getClassValueType(this.classDescriptor);
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            classValueReceiver = new ClassValueReceiver(this, it, null, 4, null);
        } else {
            classValueReceiver = null;
        }
        return classValueReceiver;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2;
        if (DescriptorUtils.isEnumClass(this.classDescriptor)) {
            String string = "Static scope for typealias " + this.getDescriptor().getName();
            Object[] objectArray = new MemberScope[2];
            MemberScope memberScope3 = this.classDescriptor.getStaticScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope3, (String)"classDescriptor.staticScope");
            objectArray[0] = memberScope3;
            objectArray[1] = new EnumEntriesScope();
            memberScope2 = new ChainedMemberScope(string, CollectionsKt.listOf((Object[])objectArray));
        } else {
            MemberScope memberScope4 = this.classDescriptor.getStaticScope();
            memberScope2 = memberScope4;
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope4, (String)"classDescriptor.staticScope");
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public KtSimpleNameExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    @Override
    @NotNull
    public TypeAliasDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public TypeAliasQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TypeAliasDescriptor descriptor2, @NotNull ClassDescriptor classDescriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)referenceExpression, (String)"referenceExpression");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        this.referenceExpression = referenceExpression;
        this.descriptor = descriptor2;
        this.classDescriptor = classDescriptor2;
    }

    @Override
    @Nullable
    public ReceiverValueWithSmartCastInfo getClassValueReceiverWithSmartCastInfo() {
        return ClassifierQualifier.DefaultImpls.getClassValueReceiverWithSmartCastInfo(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier$EnumEntriesScope;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;)V", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "printScopeStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "frontend"})
    private final class EnumEntriesScope
    extends MemberScopeImpl {
        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location2) {
            ClassifierDescriptor classifierDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            ClassifierDescriptor classifierDescriptor2 = TypeAliasQualifier.this.getClassDescriptor().getUnsubstitutedInnerClassesScope().getContributedClassifier(name2, location2);
            if (classifierDescriptor2 != null) {
                ClassifierDescriptor classifierDescriptor3 = classifierDescriptor2;
                boolean bl = false;
                boolean bl2 = false;
                ClassifierDescriptor it = classifierDescriptor3;
                boolean bl3 = false;
                classifierDescriptor = DescriptorUtils.isEnumEntry(it) ? classifierDescriptor3 : null;
            } else {
                classifierDescriptor = null;
            }
            return classifierDescriptor;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
            p.println(this.getClass().getSimpleName(), " {");
            p.pushIndent();
            p.println("descriptor = ", TypeAliasQualifier.this.getDescriptor());
            p.popIndent();
            p.println("}");
        }
    }
}

