/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements MutableResolvedCall<D> {
    private static final Logger LOG = Logger.getInstance(ResolvedCallImpl.class);
    private final Call call;
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverValue dispatchReceiver;
    private ReceiverValue extensionReceiver;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final TypeSubstitutor knownTypeParametersSubstitutor;
    @NotNull
    private final Map<TypeParameterDescriptor, KotlinType> typeArguments;
    @NotNull
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments;
    private final MutableDataFlowInfoForArguments dataFlowInfoForArguments;
    @NotNull
    private final Map<ValueArgument, ArgumentMatchImpl> argumentToParameterMap;
    private DelegatingBindingTrace trace;
    private TracingStrategy tracing;
    private ResolutionStatus status;
    private ConstraintSystem constraintSystem;
    private Boolean hasInferredReturnType;
    private boolean completed;
    private KotlinType smartCastDispatchReceiverType;
    private Queue<Function0<Unit>> remainingTasks;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(1);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(2);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(3);
        }
        ResolvedCallImpl<D> resolvedCallImpl = new ResolvedCallImpl<D>(candidate2, trace, tracing, dataFlowInfoForArguments);
        if (resolvedCallImpl == null) {
            ResolvedCallImpl.$$$reportNull$$$0(4);
        }
        return resolvedCallImpl;
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(5);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(6);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(7);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(8);
        }
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.smartCastDispatchReceiverType = null;
        this.remainingTasks = null;
        this.call = candidate2.getCall();
        this.candidateDescriptor = candidate2.getDescriptor();
        this.dispatchReceiver = candidate2.getDispatchReceiver();
        this.extensionReceiver = null;
        this.explicitReceiverKind = candidate2.getExplicitReceiverKind();
        this.knownTypeParametersSubstitutor = candidate2.getKnownTypeParametersResultingSubstitutor();
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(this.candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(this.candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(this.candidateDescriptor);
    }

    public ResolvedCallImpl(@NotNull Call call2, @NotNull D candidateDescriptor, @Nullable ReceiverValue dispatchReceiver, @Nullable ReceiverValue extensionReceiver2, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersSubstitutor, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(9);
        }
        if (candidateDescriptor == null) {
            ResolvedCallImpl.$$$reportNull$$$0(10);
        }
        if (explicitReceiverKind == null) {
            ResolvedCallImpl.$$$reportNull$$$0(11);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(12);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(13);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(14);
        }
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.smartCastDispatchReceiverType = null;
        this.remainingTasks = null;
        this.call = call2;
        this.candidateDescriptor = candidateDescriptor;
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver2;
        this.explicitReceiverKind = explicitReceiverKind;
        this.knownTypeParametersSubstitutor = knownTypeParametersSubstitutor;
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(candidateDescriptor);
    }

    @NotNull
    private static Map<ValueParameterDescriptor, ResolvedValueArgument> createValueArgumentsMap(CallableDescriptor descriptor2) {
        LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument> linkedHashMap = descriptor2.getValueParameters().isEmpty() ? Collections.emptyMap() : new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>();
        if (linkedHashMap == null) {
            ResolvedCallImpl.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Map<ValueArgument, ArgumentMatchImpl> createArgumentsToParameterMap(CallableDescriptor descriptor2) {
        HashMap<ValueArgument, ArgumentMatchImpl> hashMap = descriptor2.getValueParameters().isEmpty() ? Collections.emptyMap() : new HashMap<ValueArgument, ArgumentMatchImpl>();
        if (hashMap == null) {
            ResolvedCallImpl.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> createTypeArgumentsMap(CallableDescriptor descriptor2) {
        LinkedHashMap<TypeParameterDescriptor, KotlinType> linkedHashMap = descriptor2.getTypeParameters().isEmpty() ? Collections.emptyMap() : new LinkedHashMap<TypeParameterDescriptor, KotlinType>();
        if (linkedHashMap == null) {
            ResolvedCallImpl.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        ResolutionStatus resolutionStatus = this.status;
        if (resolutionStatus == null) {
            ResolvedCallImpl.$$$reportNull$$$0(18);
        }
        return resolutionStatus;
    }

    @Override
    public void addStatus(@NotNull ResolutionStatus status2) {
        if (status2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(19);
        }
        this.status = this.status.combine(status2);
    }

    @Override
    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        this.assertNotCompleted("Trace");
        DelegatingBindingTrace delegatingBindingTrace = this.trace;
        if (delegatingBindingTrace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(20);
        }
        return delegatingBindingTrace;
    }

    @Override
    @NotNull
    public TracingStrategy getTracingStrategy() {
        this.assertNotCompleted("TracingStrategy");
        TracingStrategy tracingStrategy = this.tracing;
        if (tracingStrategy == null) {
            ResolvedCallImpl.$$$reportNull$$$0(21);
        }
        return tracingStrategy;
    }

    @Override
    @NotNull
    public Call getCall() {
        Call call2 = this.call;
        if (call2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(22);
        }
        return call2;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            ResolvedCallImpl.$$$reportNull$$$0(23);
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
        if (d == null) {
            ResolvedCallImpl.$$$reportNull$$$0(24);
        }
        return d;
    }

    @Override
    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(25);
        }
        this.resultingDescriptor = (CallableDescriptor)this.candidateDescriptor.substitute(substitutor2);
        if (this.resultingDescriptor == null) {
            throw new AssertionError((Object)("resultingDescriptor shouldn't be null:\ncandidateDescriptor: " + DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render((DeclarationDescriptor)this.candidateDescriptor) + "\nsubstitution: " + substitutor2.getSubstitution()));
        }
        for (TypeParameterDescriptor typeParameter : this.candidateDescriptor.getTypeParameters()) {
            TypeProjection typeArgumentProjection = substitutor2.getSubstitution().get(typeParameter.getDefaultType());
            if (typeArgumentProjection == null) continue;
            this.typeArguments.put(typeParameter, typeArgumentProjection.getType());
        }
        if (this.candidateDescriptor.getValueParameters().isEmpty()) {
            return;
        }
        List<ValueParameterDescriptor> substitutedParameters = this.resultingDescriptor.getValueParameters();
        SmartList valueArgumentsBeforeSubstitution = new SmartList(this.valueArguments.entrySet());
        this.valueArguments.clear();
        for (Map.Entry entry : valueArgumentsBeforeSubstitution) {
            ValueParameterDescriptor substitutedVersion = substitutedParameters.get(((ValueParameterDescriptor)entry.getKey()).getIndex());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
        SmartList unsubstitutedArgumentMappings = new SmartList(this.argumentToParameterMap.entrySet());
        this.argumentToParameterMap.clear();
        for (Map.Entry entry : unsubstitutedArgumentMappings) {
            ArgumentMatchImpl argumentMatch = (ArgumentMatchImpl)entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = argumentMatch.getValueParameter();
            ValueParameterDescriptor substitutedVersion = substitutedParameters.get(valueParameterDescriptor.getIndex());
            assert (substitutedVersion != null) : valueParameterDescriptor;
            this.argumentToParameterMap.put((ValueArgument)entry.getKey(), argumentMatch.replaceValueParameter(substitutedVersion));
        }
    }

    @Override
    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            ResolvedCallImpl.$$$reportNull$$$0(26);
        }
        this.constraintSystem = constraintSystem;
    }

    @Override
    @Nullable
    public ConstraintSystem getConstraintSystem() {
        this.assertNotCompleted("ConstraintSystem");
        return this.constraintSystem;
    }

    @Override
    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        if (valueParameter == null) {
            ResolvedCallImpl.$$$reportNull$$$0(27);
        }
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(28);
        }
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
        for (ValueArgument argument : valueArgument.getArguments()) {
            this.argumentToParameterMap.put(argument, new ArgumentMatchImpl(valueParameter));
        }
    }

    @Override
    @Nullable
    public ReceiverValue getExtensionReceiver() {
        return this.extensionReceiver;
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            ResolvedCallImpl.$$$reportNull$$$0(29);
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.valueArguments;
        if (map2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(30);
        }
        return map2;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments2 = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments2.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument value = entry.getValue();
            ResolvedValueArgument oldValue = arguments2.set(parameterDescriptor.getIndex(), value);
            if (oldValue == null) continue;
            return null;
        }
        for (int i = 0; i < arguments2.size(); ++i) {
            Object o = arguments2.get(i);
            if (o != null) continue;
            return null;
        }
        return arguments2;
    }

    @Override
    public void recordArgumentMatchStatus(@NotNull ValueArgument valueArgument, @NotNull ArgumentMatchStatus matchStatus) {
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(31);
        }
        if (matchStatus == null) {
            ResolvedCallImpl.$$$reportNull$$$0(32);
        }
        ArgumentMatchImpl argumentMatch = this.argumentToParameterMap.get(valueArgument);
        argumentMatch.recordMatchStatus(matchStatus);
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        ArgumentMatch argumentMatch;
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(33);
        }
        if ((argumentMatch = (ArgumentMatch)this.argumentToParameterMap.get(valueArgument)) == null) {
            if (ArgumentMappingKt.isReallySuccess(this)) {
                LOG.error("ArgumentUnmapped for " + valueArgument + " in successfully resolved call: " + this.call.getCallElement().getText());
            }
            ArgumentUnmapped argumentUnmapped = ArgumentUnmapped.INSTANCE;
            if (argumentUnmapped == null) {
                ResolvedCallImpl.$$$reportNull$$$0(34);
            }
            return argumentUnmapped;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        if (argumentMatch2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(35);
        }
        return argumentMatch2;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
        Map<TypeParameterDescriptor, KotlinType> map2 = this.typeArguments;
        if (map2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(36);
        }
        return map2;
    }

    @Override
    @NotNull
    public MutableDataFlowInfoForArguments getDataFlowInfoForArguments() {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = this.dataFlowInfoForArguments;
        if (mutableDataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(37);
        }
        return mutableDataFlowInfoForArguments;
    }

    @Override
    public boolean hasInferredReturnType() {
        if (!this.completed) {
            this.hasInferredReturnType = this.constraintSystem == null || CallResolverUtilKt.hasInferredReturnType(this.candidateDescriptor, this.constraintSystem);
        }
        assert (this.hasInferredReturnType != null) : "The property 'hasInferredReturnType' was not set when the call was completed.";
        return this.hasInferredReturnType;
    }

    @Override
    public void markCallAsCompleted() {
        if (!this.completed) {
            this.hasInferredReturnType();
        }
        this.trace = null;
        this.constraintSystem = null;
        this.tracing = null;
        this.completed = true;
        this.remainingTasks = null;
    }

    @Override
    public void addRemainingTasks(Function0<Unit> task) {
        if (this.remainingTasks == null) {
            this.remainingTasks = new ArrayDeque<Function0<Unit>>();
        }
        this.remainingTasks.add(task);
    }

    @Override
    public void performRemainingTasks() {
        if (this.remainingTasks == null) {
            return;
        }
        while (!this.remainingTasks.isEmpty()) {
            this.remainingTasks.poll().invoke();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    private void assertNotCompleted(String elementName) {
        assert (!this.completed) : elementName + " is erased after resolution completion.";
    }

    @Override
    @Nullable
    public TypeSubstitutor getKnownTypeParametersSubstitutor() {
        return this.knownTypeParametersSubstitutor;
    }

    @Override
    public void setSmartCastDispatchReceiverType(@NotNull KotlinType smartCastDispatchReceiverType) {
        if (smartCastDispatchReceiverType == null) {
            ResolvedCallImpl.$$$reportNull$$$0(38);
        }
        this.smartCastDispatchReceiverType = smartCastDispatchReceiverType;
    }

    @Override
    @Nullable
    public KotlinType getSmartCastDispatchReceiverType() {
        return this.smartCastDispatchReceiverType;
    }

    @Override
    public void updateExtensionReceiverWithSmartCastIfNeeded(@NotNull KotlinType smartCastExtensionReceiverType) {
        if (smartCastExtensionReceiverType == null) {
            ResolvedCallImpl.$$$reportNull$$$0(39);
        }
        if (this.extensionReceiver instanceof ImplicitClassReceiver) {
            this.extensionReceiver = new CastImplicitClassReceiver(((ImplicitClassReceiver)this.extensionReceiver).getClassDescriptor(), smartCastExtensionReceiverType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracing";
                break;
            }
            case 3: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfoForArguments";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiverKind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintSystem";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgument";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatus";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartCastDispatchReceiverType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartCastExtensionReceiverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueArgumentsMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentsToParameterMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeArgumentsMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracingStrategy";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCall";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateDescriptor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitReceiverKind";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueArguments";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentMapping";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFlowInfoForArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addStatus";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setResultingSubstitutor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setConstraintSystem";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "recordValueArgument";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "recordArgumentMatchStatus";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentMapping";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setSmartCastDispatchReceiverType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateExtensionReceiverWithSmartCastIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

