/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CompanionObjectIntrinsicAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.types.KotlinType;

public final class ReferenceTranslator {
    private static final Set<FqNameUnsafe> DECLARATIONS_WITHOUT_SIDE_EFFECTS = new HashSet<FqNameUnsafe>(Arrays.asList(new FqNameUnsafe("kotlin.coroutines.experimental.intrinsics.COROUTINE_SUSPENDED"), new FqNameUnsafe("kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED"), KotlinBuiltIns.FQ_NAMES.unit));

    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression2, context).translateAsGet();
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(2);
        }
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(2);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsValueReference(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(3);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(4);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(4);
        }
        JsExpression result2 = ReferenceTranslator.translateAsValueReferenceWithoutType(descriptor2, context);
        MetadataProperties.setType(result2, ReferenceTranslator.getType(descriptor2));
        if (ReferenceTranslator.isValueWithoutSideEffect(descriptor2)) {
            MetadataProperties.setUnit(result2, true);
            MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
            MetadataProperties.setSynthetic(result2, true);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(5);
        }
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(5);
        }
        return jsExpression;
    }

    @Nullable
    private static KotlinType getType(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(6);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(6);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getDefaultType();
        }
        if (descriptor2 instanceof CallableDescriptor) {
            if (descriptor2 instanceof ValueParameterDescriptor) {
                ValueParameterDescriptor parameter = (ValueParameterDescriptor)descriptor2;
                if (parameter.getContainingDeclaration() instanceof AnonymousFunctionDescriptor) {
                    return DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
                }
                if (parameter.getContainingDeclaration() instanceof PropertySetterDescriptor) {
                    PropertySetterDescriptor setter2 = (PropertySetterDescriptor)parameter.getContainingDeclaration();
                    return TranslationUtils.getReturnTypeForCoercion(setter2.getCorrespondingProperty(), false);
                }
            }
            return ((CallableDescriptor)descriptor2).getReturnType();
        }
        return null;
    }

    @NotNull
    private static JsExpression translateAsValueReferenceWithoutType(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(7);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(8);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(8);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            JsExpression jsExpression = context.getInnerReference(descriptor2);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(9);
            }
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$1(9);
            }
            return jsExpression;
        }
        JsExpression alias = context.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(10);
            }
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$1(10);
            }
            return jsExpression;
        }
        if (ReferenceTranslator.shouldTranslateAsFQN(descriptor2)) {
            JsExpression jsExpression = context.getQualifiedReference(descriptor2);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(11);
            }
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$1(11);
            }
            return jsExpression;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)descriptor2;
            if (ReferenceTranslator.isLocallyAvailableDeclaration(context, property) || ReferenceTranslator.isValueWithoutSideEffect(property)) {
                JsExpression jsExpression = context.getInnerReference(property);
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$0(12);
                }
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$1(12);
                }
                return jsExpression;
            }
            JsExpression qualifier = context.getInnerReference(property.getContainingDeclaration());
            JsName name2 = context.getNameForDescriptor(property);
            JsNameRef jsNameRef = new JsNameRef(name2, qualifier);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(13);
            }
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$1(13);
            }
            return jsNameRef;
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)descriptor2;
            if (!ReferenceTranslator.isLocallyAvailableDeclaration(context, descriptor2)) {
                if (ReferenceTranslator.isValueWithoutSideEffect(classDescriptor2)) {
                    JsExpression jsExpression = context.getInnerReference(descriptor2);
                    if (jsExpression == null) {
                        ReferenceTranslator.$$$reportNull$$$0(14);
                    }
                    if (jsExpression == null) {
                        ReferenceTranslator.$$$reportNull$$$1(14);
                    }
                    return jsExpression;
                }
                JsExpression jsExpression = ReferenceTranslator.getLazyReferenceToObject(classDescriptor2, context);
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$0(15);
                }
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$1(15);
                }
                return jsExpression;
            }
            JsNameRef functionRef = JsAstUtils.pureFqn(context.getNameForObjectInstance(classDescriptor2), null);
            JsInvocation jsInvocation = new JsInvocation((JsExpression)functionRef, new JsExpression[0]);
            if (jsInvocation == null) {
                ReferenceTranslator.$$$reportNull$$$0(16);
            }
            if (jsInvocation == null) {
                ReferenceTranslator.$$$reportNull$$$1(16);
            }
            return jsInvocation;
        }
        JsExpression jsExpression = context.getInnerReference(descriptor2);
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(17);
        }
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(17);
        }
        return jsExpression;
    }

    private static boolean isValueWithoutSideEffect(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(18);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(18);
        }
        return DECLARATIONS_WITHOUT_SIDE_EFFECTS.contains(DescriptorUtils.getFqName(descriptor2));
    }

    @NotNull
    public static JsExpression translateAsTypeReference(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(19);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(20);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(19);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(20);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            JsExpression jsExpression = context.getInnerReference(descriptor2);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(21);
            }
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$1(21);
            }
            return jsExpression;
        }
        if ((DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) && !ReferenceTranslator.isLocallyAvailableDeclaration(context, descriptor2)) {
            JsExpression jsExpression = ReferenceTranslator.getPrototypeIfNecessary(descriptor2, ReferenceTranslator.getLazyReferenceToObject(descriptor2, context));
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(22);
            }
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$1(22);
            }
            return jsExpression;
        }
        JsExpression jsExpression = context.getInnerReference(descriptor2);
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(23);
        }
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(23);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getPrototypeIfNecessary(@NotNull ClassDescriptor descriptor2, @NotNull JsExpression reference) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(24);
        }
        if (reference == null) {
            ReferenceTranslator.$$$reportNull$$$1(25);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(24);
        }
        if (reference == null) {
            ReferenceTranslator.$$$reportNull$$$0(25);
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            JsNameRef getPrototypeRef = JsAstUtils.pureFqn("getPrototypeOf", (JsExpression)JsAstUtils.pureFqn("Object", null));
            JsInvocation getPrototypeInvocation = new JsInvocation((JsExpression)getPrototypeRef, reference);
            MetadataProperties.setSideEffects(getPrototypeInvocation, SideEffectKind.PURE);
            reference = JsAstUtils.pureFqn("constructor", (JsExpression)getPrototypeInvocation);
        }
        JsExpression jsExpression = reference;
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(26);
        }
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(26);
        }
        return jsExpression;
    }

    private static boolean isLocallyAvailableDeclaration(@NotNull TranslationContext context, @NotNull DeclarationDescriptor descriptor2) {
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(27);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(28);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(27);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(28);
        }
        return context.isFromCurrentModule(descriptor2) && (!context.isPublicInlineFunction() || !DescriptorUtilsKt.shouldBeExported(descriptor2, context.getConfig()));
    }

    @NotNull
    private static JsExpression getLazyReferenceToObject(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(29);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(30);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(29);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(30);
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        JsExpression qualifier = context.getInnerReference(container2);
        JsNameRef jsNameRef = new JsNameRef(context.getNameForDescriptor(descriptor2), qualifier);
        if (jsNameRef == null) {
            ReferenceTranslator.$$$reportNull$$$0(31);
        }
        if (jsNameRef == null) {
            ReferenceTranslator.$$$reportNull$$$1(31);
        }
        return jsNameRef;
    }

    private static boolean shouldTranslateAsFQN(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(32);
        }
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(32);
        }
        return ReferenceTranslator.isLocalVarOrFunction(descriptor2);
    }

    private static boolean isLocalVarOrFunction(DeclarationDescriptor descriptor2) {
        return descriptor2.getContainingDeclaration() instanceof FunctionDescriptor && !(descriptor2 instanceof ClassDescriptor);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            ReferenceTranslator.$$$reportNull$$$1(33);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(34);
        }
        if (referenceExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(33);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(34);
        }
        if (DescriptorPsiUtilsKt.isBackingFieldReference(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression))) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context);
            if (backingFieldAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(35);
            }
            if (backingFieldAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$1(35);
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, referenceExpression, null);
            if (variableAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(36);
            }
            if (variableAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$1(36);
            }
            return variableAccessTranslator;
        }
        if (CompanionObjectIntrinsicAccessTranslator.isCompanionObjectReference(referenceExpression, context)) {
            CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = CompanionObjectIntrinsicAccessTranslator.newInstance(referenceExpression, context);
            if (companionObjectIntrinsicAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(37);
            }
            if (companionObjectIntrinsicAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$1(37);
            }
            return companionObjectIntrinsicAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context);
        if (referenceAccessTranslator == null) {
            ReferenceTranslator.$$$reportNull$$$0(38);
        }
        if (referenceAccessTranslator == null) {
            ReferenceTranslator.$$$reportNull$$$1(38);
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$1(39);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$1(40);
        }
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(39);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(40);
        }
        KtSimpleNameExpression simpleNameExpression = null;
        if (expression2 instanceof KtQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        } else if (expression2 instanceof KtSimpleNameExpression) {
            simpleNameExpression = (KtSimpleNameExpression)expression2;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
        return descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof ValueParameterDescriptor) && !(descriptor2 instanceof FakeCallableDescriptorForTypeAliasObject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 20: 
            case 27: 
            case 30: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "translateSimpleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsTypeReference";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototypeIfNecessary";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyReferenceToObject";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateSimpleName";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValueWithoutSideEffect";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "translateAsTypeReference";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPrototypeIfNecessary";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyAvailableDeclaration";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLazyReferenceToObject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldTranslateAsFQN";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 20: 
            case 27: 
            case 30: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "translateSimpleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsTypeReference";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototypeIfNecessary";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyReferenceToObject";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateSimpleName";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValueWithoutSideEffect";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "translateAsTypeReference";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPrototypeIfNecessary";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyAvailableDeclaration";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLazyReferenceToObject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldTranslateAsFQN";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

