/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a*\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"getDefaultParamsNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "args", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "params", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "initialized", "", "getNameFromInitializer", "isInitializedExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "isNameInitialized", "name", "initializer", "markAssignmentAsStaticRef", "", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "removeDefaultInitializers", "arguments", "parameters", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "js.translator"})
public final class RemoveDefaultInitializersKt {
    /*
     * WARNING - void declaration
     */
    public static final void removeDefaultInitializers(@NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2, @NotNull JsBlock body) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Set<JsName> toRemove = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments2, parameters2, true);
        Set<JsName> toExpand = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments2, parameters2, false);
        List<JsStatement> list2 = body.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
        List<JsStatement> statements = list2;
        Iterable $this$flatMap$iv = statements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<JsStatement> list3;
            JsStatement it = (JsStatement)element$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"it");
            JsName name2 = RemoveDefaultInitializersKt.getNameFromInitializer(jsStatement);
            if (name2 != null && !RemoveDefaultInitializersKt.isNameInitialized(name2, it)) {
                throw (Throwable)((Object)new AssertionError((Object)"Unexpected initializer structure"));
            }
            if (name2 != null && toRemove.contains(name2)) {
                boolean bl2 = false;
                list3 = CollectionsKt.emptyList();
            } else if (name2 != null && toExpand.contains(name2)) {
                JsStatement thenStatement;
                Intrinsics.checkExpressionValueIsNotNull((Object)((JsIf)it).getThenStatement(), (String)"(it as JsIf).thenStatement");
                RemoveDefaultInitializersKt.markAssignmentAsStaticRef(name2, thenStatement);
                List<JsStatement> list4 = JsAstUtils.flattenStatement(thenStatement);
                list3 = list4;
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"flattenStatement(thenStatement)");
            } else {
                list3 = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newStatements = (List)destination$iv$iv;
        statements.clear();
        statements.addAll(newStatements);
    }

    private static final void markAssignmentAsStaticRef(JsName name2, JsNode node) {
        node.accept(new RecursiveJsVisitor(name2){
            final /* synthetic */ JsName $name;

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Pair<JsName, JsExpression> pair = JsAstUtils.decomposeAssignmentToVariable(x);
                if (pair != null) {
                    Pair<JsName, JsExpression> pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair<JsName, JsExpression> $dstr$assignmentTarget$assignmentExpr = pair2;
                    boolean bl3 = false;
                    JsName assignmentTarget = (JsName)$dstr$assignmentTarget$assignmentExpr.component1();
                    JsExpression assignmentExpr = (JsExpression)$dstr$assignmentTarget$assignmentExpr.component2();
                    if (Intrinsics.areEqual((Object)assignmentTarget, (Object)this.$name)) {
                        MetadataProperties.setStaticRef(assignmentTarget, assignmentExpr);
                    }
                }
                super.visitBinaryExpression(x);
            }
            {
                this.$name = $captured_local_variable$0;
            }
        });
    }

    private static final JsName getNameFromInitializer(JsStatement statement2) {
        JsStatement elseStmt;
        JsIf ifStmt;
        JsStatement jsStatement = statement2;
        if (!(jsStatement instanceof JsIf)) {
            jsStatement = null;
        }
        JsIf jsIf = ifStmt = (JsIf)jsStatement;
        JsExpression testExpr = jsIf != null ? jsIf.getIfExpression() : null;
        JsIf jsIf2 = ifStmt;
        JsStatement jsStatement2 = elseStmt = jsIf2 != null ? jsIf2.getElseStatement() : null;
        if (elseStmt == null && testExpr instanceof JsBinaryOperation) {
            return RemoveDefaultInitializersKt.getNameFromInitializer((JsBinaryOperation)testExpr);
        }
        return null;
    }

    private static final JsName getNameFromInitializer(JsBinaryOperation isInitializedExpr) {
        JsExpression arg1 = isInitializedExpr.getArg1();
        JsExpression arg2 = isInitializedExpr.getArg2();
        JsBinaryOperator jsBinaryOperator = isInitializedExpr.getOperator();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperator, (String)"isInitializedExpr.operator");
        JsBinaryOperator op = jsBinaryOperator;
        if (arg1 == null || arg2 == null) {
            return null;
        }
        if (op == JsBinaryOperator.REF_EQ && JsAstUtils.isUndefinedExpression(arg2)) {
            JsExpression jsExpression = arg1;
            if (!(jsExpression instanceof JsNameRef)) {
                jsExpression = null;
            }
            JsNameRef jsNameRef = (JsNameRef)jsExpression;
            return jsNameRef != null ? jsNameRef.getName() : null;
        }
        return null;
    }

    private static final boolean isNameInitialized(JsName name2, JsStatement initializer) {
        JsExpression expr;
        JsStatement jsStatement = initializer;
        if (jsStatement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsIf");
        }
        JsStatement jsStatement2 = ((JsIf)jsStatement).getThenStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"(initializer as JsIf).thenStatement");
        JsStatement thenStmt = jsStatement2;
        List<JsStatement> list2 = JsAstUtils.flattenStatement(thenStmt);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"flattenStatement(thenStmt)");
        JsStatement lastThenStmt = (JsStatement)CollectionsKt.last(list2);
        JsStatement jsStatement3 = lastThenStmt;
        if (!(jsStatement3 instanceof JsExpressionStatement)) {
            jsStatement3 = null;
        }
        JsExpressionStatement jsExpressionStatement = (JsExpressionStatement)jsStatement3;
        JsExpression jsExpression = expr = jsExpressionStatement != null ? jsExpressionStatement.getExpression() : null;
        if (!(expr instanceof JsBinaryOperation)) {
            return false;
        }
        JsBinaryOperator jsBinaryOperator = ((JsBinaryOperation)expr).getOperator();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperator, (String)"expr.operator");
        JsBinaryOperator op = jsBinaryOperator;
        if (!op.isAssignment()) {
            return false;
        }
        JsExpression arg1 = ((JsBinaryOperation)expr).getArg1();
        return arg1 instanceof HasName && ((HasName)((Object)arg1)).getName() == name2;
    }

    private static final Set<JsName> getDefaultParamsNames(List<? extends JsExpression> args, List<JsParameter> params, boolean initialized) {
        List argsParams = CollectionUtilsKt.zipWithDefault((Iterable)args, (Iterable)params, Namer.getUndefinedExpression());
        Sequence relevantParams2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)argsParams), (Function1)getDefaultParamsNames.relevantParams.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends JsExpression, ? extends JsParameter>, Boolean>(initialized){
            final /* synthetic */ boolean $initialized;

            public final boolean invoke(@NotNull Pair<? extends JsExpression, JsParameter> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.$initialized == !JsAstUtils.isUndefinedExpression((JsExpression)it.getFirst());
            }
            {
                this.$initialized = bl;
                super(1);
            }
        }));
        Sequence names2 = SequencesKt.map((Sequence)relevantParams2, (Function1)getDefaultParamsNames.names.1.INSTANCE);
        return SequencesKt.toSet((Sequence)names2);
    }
}

