/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u000689:;<=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020)2\u0006\u0010-\u001a\u00020%2\u0006\u00103\u001a\u00020\nH\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "captureStackFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "causeGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "causeName", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getCauseName", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "causePropertyName", "Lorg/jetbrains/kotlin/name/Name;", "defaultCtor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "eqeqeqSymbol", "messageGetter", "messageName", "getMessageName", "messagePropertyName", "nameName", "getNameName", "newThrowableFunction", "nothingNType", "nothingType", "pendingSuperUsages", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$DirectThrowableSuccessors;", "propertyGetter", "propertySetter", "stringType", "throwableClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "throwableConstructors", "", "toString", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitType", "isDirectChildOfThrowable", "", "irClass", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ownPropertyAccessor", "irBase", "safeCallToString", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "receiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "DirectThrowableSuccessors", "ThrowableAccessorCreationVisitor", "ThrowableDirectSuccessorTransformer", "ThrowableInstanceCreationLowering", "ThrowableNameSetterTransformer", "ThrowablePropertiesUsageTransformer", "backend.js"})
public final class ThrowableSuccessorsLowering
implements FileLoweringPass {
    private final IrType unitType;
    private final IrType nothingNType;
    private final IrType nothingType;
    private final IrType stringType;
    private final IrType booleanType;
    private final IrSimpleFunctionSymbol propertyGetter;
    private final IrSimpleFunctionSymbol propertySetter;
    private final IrSimpleFunctionSymbol eqeqeqSymbol;
    private final IrClass throwableClass;
    private final List<IrConstructor> throwableConstructors;
    private final IrConstructor defaultCtor;
    private final IrSimpleFunction toString;
    private final Name messagePropertyName;
    private final Name causePropertyName;
    private final IrFunction messageGetter;
    private final IrFunction causeGetter;
    private final IrSimpleFunctionSymbol captureStackFunction;
    private final IrSimpleFunctionSymbol newThrowableFunction;
    private final List<DirectThrowableSuccessors> pendingSuperUsages;

    private final IrConstImpl<String> getMessageName() {
        return JsIrBuilder.INSTANCE.buildString(this.stringType, "message");
    }

    private final IrConstImpl<String> getCauseName() {
        return JsIrBuilder.INSTANCE.buildString(this.stringType, "cause");
    }

    private final IrConstImpl<String> getNameName() {
        return JsIrBuilder.INSTANCE.buildString(this.stringType, "name");
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        this.pendingSuperUsages.clear();
        IrElementVisitorVoidKt.acceptChildrenVoid(irFile, new ThrowableAccessorCreationVisitor());
        Iterable $this$forEach$iv = this.pendingSuperUsages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectThrowableSuccessors it = (DirectThrowableSuccessors)element$iv;
            boolean bl = false;
            it.getKlass().transformChildren(new ThrowableDirectSuccessorTransformer(it), it.getKlass());
        }
        irFile.transformChildren(new ThrowableNameSetterTransformer(), irFile);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new ThrowablePropertiesUsageTransformer());
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new ThrowableInstanceCreationLowering());
    }

    private final IrExpression safeCallToString(IrValueDeclaration receiver2) {
        IrGetValueImpl value = JsIrBuilder.INSTANCE.buildGetValue(receiver2.getSymbol());
        IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.eqeqeqSymbol, this.booleanType, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCall $this$apply = irCall;
        boolean bl3 = false;
        $this$apply.putValueArgument(0, value);
        $this$apply.putValueArgument(1, JsIrBuilder.INSTANCE.buildNull(value.getType()));
        IrCall check2 = irCall;
        IrGetValueImpl value2 = JsIrBuilder.INSTANCE.buildGetValue(receiver2.getSymbol());
        IrCall irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.toString.getSymbol(), this.stringType, null, 4, null);
        boolean bl4 = false;
        boolean bl5 = false;
        IrCall $this$apply2 = irCall2;
        boolean bl6 = false;
        $this$apply2.setDispatchReceiver(value2);
        IrCall call2 = irCall2;
        return JsIrBuilder.INSTANCE.buildIfElse(IrTypesKt.makeNullable$default(this.stringType, false, 1, null), check2, JsIrBuilder.INSTANCE.buildNull(this.stringType), call2);
    }

    private final boolean isDirectChildOfThrowable(IrClass irClass) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = irClass.getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isThrowable(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction ownPropertyAccessor(IrClass irClass, IrFunction irBase) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction irSimpleFunction;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrProperty it = (IrProperty)element$iv$iv;
            boolean bl2 = false;
            if (it.getGetter() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            IrSimpleFunction it$iv$iv = irSimpleFunction;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            boolean bl;
            block8: {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl6 = false;
                Iterable $this$any$iv = it.getOverriddenSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        IrSimpleFunctionSymbol s = (IrSimpleFunctionSymbol)element$iv2;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)((IrSimpleFunction)s.getOwner()), (Object)irBase)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    /*
     * WARNING - void declaration
     */
    public ThrowableSuccessorsLowering(@NotNull JsIrBackendContext context) {
        void $this$filterTo$iv$iv$iv;
        IrDeclarationWithVisibility it;
        void $this$filterTo$iv$iv$iv2;
        Iterable $this$atMostOne$iv;
        Iterable $this$single$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.unitType = context.getIrBuiltIns().getUnitType();
        this.nothingNType = context.getIrBuiltIns().getNothingNType();
        this.nothingType = context.getIrBuiltIns().getNothingType();
        this.stringType = context.getIrBuiltIns().getStringType();
        this.booleanType = context.getIrBuiltIns().getBooleanType();
        this.propertyGetter = (IrSimpleFunctionSymbol)context.getIntrinsics().getJsGetJSField().getSymbol();
        this.propertySetter = (IrSimpleFunctionSymbol)context.getIntrinsics().getJsSetJSField().getSymbol();
        this.eqeqeqSymbol = context.getIrBuiltIns().getEqeqSymbol();
        this.throwableClass = context.getThrowableClass();
        this.throwableConstructors = context.getThrowableConstructors();
        this.defaultCtor = context.getDefaultThrowableCtor();
        Iterable iterable = this.throwableClass.getDeclarations();
        ThrowableSuccessorsLowering throwableSuccessorsLowering = this;
        boolean $i$f$filterIsInstance = false;
        void var4_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<Object> list2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list2;
        boolean $i$f$single = false;
        Iterable single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it2 = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getName(), (Object)Name.identifier("toString"))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = (Iterable)element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        list2 = single$iv;
        throwableSuccessorsLowering.toString = (IrSimpleFunction)((Object)list2);
        Name name2 = Name.identifier("message");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"message\")");
        this.messagePropertyName = name2;
        Name name3 = Name.identifier("cause");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"cause\")");
        this.causePropertyName = name3;
        $this$single$iv = this.throwableClass.getDeclarations();
        throwableSuccessorsLowering = this;
        $i$f$filterIsInstance = false;
        single$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list2;
        boolean $i$f$atMostOne = false;
        Iterable $this$filter$iv$iv = $this$atMostOne$iv;
        boolean $i$f$filter = false;
        Iterable $i$f$filterIsInstanceTo2 = $this$filter$iv$iv;
        Object destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
            it = (IrFunction)element$iv$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.special("<get-message>"))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        list2 = UtilsKt.atMostOne((List)destination$iv$iv$iv);
        ThrowableSuccessorsLowering throwableSuccessorsLowering2 = throwableSuccessorsLowering;
        IrFunction irFunction = (IrFunction)((Object)list2);
        if (irFunction == null) {
            $this$atMostOne$iv = this.throwableClass.getDeclarations();
            throwableSuccessorsLowering = throwableSuccessorsLowering2;
            $i$f$filterIsInstance = false;
            $this$filter$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = list2;
            $i$f$atMostOne = false;
            $this$filter$iv$iv = $this$atMostOne$iv;
            $i$f$filter = false;
            $i$f$filterIsInstanceTo2 = $this$filter$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
                it = (IrProperty)element$iv$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.messagePropertyName)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = UtilsKt.atMostOne((List)destination$iv$iv$iv);
            throwableSuccessorsLowering2 = throwableSuccessorsLowering;
            IrProperty irProperty = (IrProperty)((Object)list2);
            IrSimpleFunction irSimpleFunction = irProperty != null ? irProperty.getGetter() : null;
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irFunction = irSimpleFunction;
        }
        throwableSuccessorsLowering2.messageGetter = irFunction;
        $this$atMostOne$iv = this.throwableClass.getDeclarations();
        throwableSuccessorsLowering = this;
        $i$f$filterIsInstance = false;
        $this$filter$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list2;
        $i$f$atMostOne = false;
        $this$filter$iv$iv = $this$atMostOne$iv;
        $i$f$filter = false;
        Iterable $i$f$filterIsInstanceTo3 = $this$filter$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            it = (IrFunction)element$iv$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.special("<get-cause>"))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        list2 = UtilsKt.atMostOne((List)destination$iv$iv$iv);
        ThrowableSuccessorsLowering throwableSuccessorsLowering3 = throwableSuccessorsLowering;
        IrFunction irFunction2 = (IrFunction)((Object)list2);
        if (irFunction2 == null) {
            void $this$filterTo$iv$iv$iv3;
            $this$atMostOne$iv = this.throwableClass.getDeclarations();
            throwableSuccessorsLowering = throwableSuccessorsLowering3;
            $i$f$filterIsInstance = false;
            $this$filter$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo4 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = list2;
            $i$f$atMostOne = false;
            $this$filter$iv$iv = $this$atMostOne$iv;
            $i$f$filter = false;
            Iterable $i$f$filterIsInstanceTo4 = $this$filter$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv3) {
                it = (IrProperty)element$iv$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.causePropertyName)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = UtilsKt.atMostOne((List)destination$iv$iv$iv);
            throwableSuccessorsLowering3 = throwableSuccessorsLowering;
            IrProperty irProperty = (IrProperty)((Object)list2);
            IrSimpleFunction irSimpleFunction = irProperty != null ? irProperty.getGetter() : null;
            if (irSimpleFunction == null) {
                Intrinsics.throwNpe();
            }
            irFunction2 = irSimpleFunction;
        }
        throwableSuccessorsLowering3.causeGetter = irFunction2;
        this.captureStackFunction = context.getSymbolTable().referenceSimpleFunction((FunctionDescriptor)CollectionsKt.single(context.getInternalFunctions("captureStack")));
        this.newThrowableFunction = context.getSymbolTable().referenceSimpleFunction((FunctionDescriptor)CollectionsKt.single(context.getInternalFunctions("newThrowable")));
        throwableSuccessorsLowering = this;
        boolean bl = false;
        throwableSuccessorsLowering.pendingSuperUsages = list2 = (List)new ArrayList();
    }

    public static final /* synthetic */ IrType access$getNothingNType$p(ThrowableSuccessorsLowering $this) {
        return $this.nothingNType;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getPropertyGetter$p(ThrowableSuccessorsLowering $this) {
        return $this.propertyGetter;
    }

    public static final /* synthetic */ IrConstImpl access$getMessageName$p(ThrowableSuccessorsLowering $this) {
        return $this.getMessageName();
    }

    public static final /* synthetic */ IrConstImpl access$getCauseName$p(ThrowableSuccessorsLowering $this) {
        return $this.getCauseName();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$DirectThrowableSuccessors;", "", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "message", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "cause", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "getCause", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getKlass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getMessage", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    private static final class DirectThrowableSuccessors {
        @NotNull
        private final IrClass klass;
        @NotNull
        private final IrField message;
        @NotNull
        private final IrField cause;

        @NotNull
        public final IrClass getKlass() {
            return this.klass;
        }

        @NotNull
        public final IrField getMessage() {
            return this.message;
        }

        @NotNull
        public final IrField getCause() {
            return this.cause;
        }

        public DirectThrowableSuccessors(@NotNull IrClass klass2, @NotNull IrField message, @NotNull IrField cause) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            this.klass = klass2;
            this.message = message;
            this.cause = cause;
        }

        @NotNull
        public final IrClass component1() {
            return this.klass;
        }

        @NotNull
        public final IrField component2() {
            return this.message;
        }

        @NotNull
        public final IrField component3() {
            return this.cause;
        }

        @NotNull
        public final DirectThrowableSuccessors copy(@NotNull IrClass klass2, @NotNull IrField message, @NotNull IrField cause) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new DirectThrowableSuccessors(klass2, message, cause);
        }

        public static /* synthetic */ DirectThrowableSuccessors copy$default(DirectThrowableSuccessors directThrowableSuccessors, IrClass irClass, IrField irField, IrField irField2, int n, Object object) {
            if ((n & 1) != 0) {
                irClass = directThrowableSuccessors.klass;
            }
            if ((n & 2) != 0) {
                irField = directThrowableSuccessors.message;
            }
            if ((n & 4) != 0) {
                irField2 = directThrowableSuccessors.cause;
            }
            return directThrowableSuccessors.copy(irClass, irField, irField2);
        }

        @NotNull
        public String toString() {
            return "DirectThrowableSuccessors(klass=" + this.klass + ", message=" + this.message + ", cause=" + this.cause + ")";
        }

        public int hashCode() {
            IrClass irClass = this.klass;
            IrField irField = this.message;
            IrField irField2 = this.cause;
            return ((irClass != null ? irClass.hashCode() : 0) * 31 + (irField != null ? irField.hashCode() : 0)) * 31 + (irField2 != null ? irField2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DirectThrowableSuccessors)) break block3;
                    DirectThrowableSuccessors directThrowableSuccessors = (DirectThrowableSuccessors)object;
                    if (!Intrinsics.areEqual((Object)this.klass, (Object)directThrowableSuccessors.klass) || !Intrinsics.areEqual((Object)this.message, (Object)directThrowableSuccessors.message) || !Intrinsics.areEqual((Object)this.cause, (Object)directThrowableSuccessors.cause)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$ThrowableNameSetterTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
    public final class ThrowableNameSetterTransformer
    implements IrElementTransformer<IrDeclarationParent> {
        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration, declaration);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data) {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                declaration.transformChildren(this, data);
                if (!declaration.isPrimary()) {
                    return declaration;
                }
                IrClass klass2 = (IrClass)data;
                Boolean bl = IrTypeUtilsKt.isThrowableTypeOrSubtype(IrUtilsKt.getDefaultType(klass2));
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"klass.defaultType.isThrowableTypeOrSubtype()");
                if (!bl.booleanValue()) break block4;
                IrBody irBody = declaration.getBody();
                if (!(irBody instanceof IrBlockBody)) {
                    irBody = null;
                }
                IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
                if (irBlockBody2 != null) {
                    IrBlockBody irBlockBody3 = irBlockBody2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    IrBlockBody it = irBlockBody3;
                    boolean bl4 = false;
                    Collection collection = it.getStatements();
                    IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ThrowableSuccessorsLowering.this.propertySetter, ThrowableSuccessorsLowering.this.unitType, null, 4, null);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    IrCall $this$apply = irCall;
                    boolean bl7 = false;
                    IrValueParameter irValueParameter = klass2.getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irValueParameter.getSymbol()));
                    $this$apply.putValueArgument(1, ThrowableSuccessorsLowering.this.getNameName());
                    IrType irType = ThrowableSuccessorsLowering.this.stringType;
                    String string = klass2.getName().asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"klass.name.asString()");
                    $this$apply.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(irType, string));
                    bl5 = false;
                    collection.add(irCall);
                }
            }
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclaration declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$ThrowableInstanceCreationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;)V", "extractConstructorParameters", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.js"})
    public final class ThrowableInstanceCreationLowering
    extends IrElementTransformerVoid {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            void messageArg;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (!CollectionsKt.contains((Iterable)ThrowableSuccessorsLowering.this.throwableConstructors, (Object)expression2.getSymbol().getOwner())) {
                return super.visitCall(expression2);
            }
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Object object = this.extractConstructorParameters(expression2);
            IrExpression irExpression = (IrExpression)object.component1();
            IrExpression causeArg = (IrExpression)object.component2();
            object = expression2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            IrCallImpl irCallImpl = new IrCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrFunctionSymbol)ThrowableSuccessorsLowering.this.newThrowableFunction, ThrowableSuccessorsLowering.this.newThrowableFunction.getDescriptor(), null, null, 96, null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrCallImpl it = irCallImpl;
            boolean bl6 = false;
            it.putValueArgument(0, (IrExpression)messageArg);
            it.putValueArgument(1, causeArg);
            return irCallImpl;
        }

        private final Pair<IrExpression, IrExpression> extractConstructorParameters(IrFunctionAccessExpression expression2) {
            Pair pair;
            Function0 nullValue2 = (Function0)new Function0<IrConstImpl>(this, expression2){
                final /* synthetic */ ThrowableInstanceCreationLowering this$0;
                final /* synthetic */ IrFunctionAccessExpression $expression;

                @NotNull
                public final IrConstImpl invoke() {
                    return IrConstImpl.Companion.constNull(this.$expression.getStartOffset(), this.$expression.getEndOffset(), ThrowableSuccessorsLowering.access$getNothingNType$p(this.this$0.ThrowableSuccessorsLowering.this));
                }
                {
                    this.this$0 = throwableInstanceCreationLowering;
                    this.$expression = irFunctionAccessExpression;
                    super(0);
                }
            };
            if (expression2.getValueArgumentsCount() == 0) {
                pair = new Pair(nullValue2.invoke(), nullValue2.invoke());
            } else if (expression2.getValueArgumentsCount() == 2) {
                IrFunctionAccessExpression irFunctionAccessExpression = expression2;
                boolean bl = false;
                boolean bl2 = false;
                IrFunctionAccessExpression $this$run = irFunctionAccessExpression;
                boolean bl3 = false;
                IrExpression irExpression = $this$run.getValueArgument(0);
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression irExpression2 = $this$run.getValueArgument(1);
                if (irExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                pair = new Pair((Object)irExpression, (Object)irExpression2);
            } else {
                IrExpression arg;
                IrExpression irExpression = expression2.getValueArgument(0);
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                pair = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull$default((arg = irExpression).getType(), false, 1, null)) ? new Pair(nullValue2.invoke(), (Object)arg) : new Pair((Object)arg, nullValue2.invoke());
            }
            return pair;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$ThrowableAccessorCreationVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;)V", "createBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "name", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "createPropertyAccessor", "", "fakeAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "field", "visitClass", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "backend.js"})
    public final class ThrowableAccessorCreationVisitor
    implements IrElementVisitorVoid {
        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            if (ThrowableSuccessorsLowering.this.isDirectChildOfThrowable(declaration)) {
                IrSimpleFunction existedCauseAccessor;
                IrField messageField = this.createBackingField(declaration, ThrowableSuccessorsLowering.this.messagePropertyName, ThrowableSuccessorsLowering.this.messageGetter.getReturnType());
                IrField causeField = this.createBackingField(declaration, ThrowableSuccessorsLowering.this.causePropertyName, ThrowableSuccessorsLowering.this.causeGetter.getReturnType());
                IrSimpleFunction existedMessageAccessor = ThrowableSuccessorsLowering.this.ownPropertyAccessor(declaration, ThrowableSuccessorsLowering.this.messageGetter);
                if (Intrinsics.areEqual((Object)existedMessageAccessor.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) {
                    this.createPropertyAccessor(existedMessageAccessor, messageField);
                }
                if (Intrinsics.areEqual((Object)(existedCauseAccessor = ThrowableSuccessorsLowering.this.ownPropertyAccessor(declaration, ThrowableSuccessorsLowering.this.causeGetter)).getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) {
                    this.createPropertyAccessor(existedCauseAccessor, causeField);
                }
                Collection collection = ThrowableSuccessorsLowering.this.pendingSuperUsages;
                DirectThrowableSuccessors directThrowableSuccessors = new DirectThrowableSuccessors(declaration, messageField, causeField);
                boolean bl = false;
                collection.add(directThrowableSuccessors);
            }
        }

        private final IrField createBackingField(IrClass declaration, Name name2, IrType type2) {
            WrappedFieldDescriptor fieldDescriptor = new WrappedFieldDescriptor(null, null, 3, null);
            IrFieldSymbolImpl fieldSymbol = new IrFieldSymbolImpl(fieldDescriptor);
            IrDeclarationOrigin irDeclarationOrigin = JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE;
            IrFieldSymbol irFieldSymbol = fieldSymbol;
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PRIVATE");
            Object object = new IrFieldImpl(-1, -1, irDeclarationOrigin, irFieldSymbol, name2, type2, visibility, true, false, false);
            boolean bl = false;
            boolean bl2 = false;
            IrFieldImpl $this$apply = object;
            boolean bl3 = false;
            $this$apply.setParent(declaration);
            fieldDescriptor.bind((IrDeclaration)$this$apply);
            IrFieldImpl fieldDeclaration = object;
            object = declaration.getDeclarations();
            bl = false;
            object.add(fieldDeclaration);
            return fieldDeclaration;
        }

        private final void createPropertyAccessor(IrSimpleFunction fakeAccessor, IrField field) {
            block1: {
                Name name2 = fakeAccessor.getName();
                IrSimpleFunction irSimpleFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, name2, fakeAccessor.getReturnType(), fakeAccessor.getParent(), null, null, false, false, false, false, null, 1016, null);
                boolean bl = false;
                boolean bl2 = false;
                IrSimpleFunction $this$apply = irSimpleFunction;
                boolean bl3 = false;
                Collection collection = $this$apply.getOverriddenSymbols();
                Iterable iterable = fakeAccessor.getOverriddenSymbols();
                boolean bl4 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                $this$apply.setCorrespondingProperty(fakeAccessor.getCorrespondingProperty());
                IrValueParameter irValueParameter = fakeAccessor.getDispatchReceiverParameter();
                $this$apply.setDispatchReceiverParameter(irValueParameter != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, $this$apply, null, 0, 0, 0, null, null, null, null, false, false, 2046, null) : null);
                IrSimpleFunction function2 = irSimpleFunction;
                IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
                if (irValueParameter2 == null) {
                    Intrinsics.throwNpe();
                }
                IrGetValueImpl thisReceiver2 = JsIrBuilder.INSTANCE.buildGetValue(irValueParameter2.getSymbol());
                IrGetFieldImpl returnValue = JsIrBuilder.buildGetField$default(JsIrBuilder.INSTANCE, (IrFieldSymbol)field.getSymbol(), thisReceiver2, null, field.getType(), 4, null);
                IrReturnImpl returnStatement = JsIrBuilder.INSTANCE.buildReturn(function2.getSymbol(), returnValue, ThrowableSuccessorsLowering.this.nothingType);
                function2.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf((Object)returnStatement)));
                IrProperty irProperty = fakeAccessor.getCorrespondingProperty();
                if (irProperty == null) break block1;
                irProperty.setGetter(function2);
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$ThrowableDirectSuccessorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "successor", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$DirectThrowableSuccessors;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$DirectThrowableSuccessors;)V", "extractConstructorParameters", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "parent", "fillThrowableInstance", "receiver", "Lkotlin/Function0;", "messageArg", "causeArg", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "declaration", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.js"})
    private final class ThrowableDirectSuccessorTransformer
    implements IrElementTransformer<IrDeclarationParent> {
        private final DirectThrowableSuccessors successor;

        @Override
        @NotNull
        public IrClass visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, declaration);
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
            IrField irField;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
            if (Intrinsics.areEqual((Object)(irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null), (Object)ThrowableSuccessorsLowering.this.throwableClass) ^ true) {
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            }
            expression2.transformChildren(this, data);
            if (Intrinsics.areEqual((Object)expression2.getSymbol().getOwner(), (Object)ThrowableSuccessorsLowering.this.messageGetter)) {
                irField = this.successor.getMessage();
            } else if (Intrinsics.areEqual((Object)expression2.getSymbol().getOwner(), (Object)ThrowableSuccessorsLowering.this.causeGetter)) {
                irField = this.successor.getCause();
            } else {
                String string = "Unknown accessor";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            IrField superField = irField;
            IrCall irCall = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$run = irCall;
            boolean bl3 = false;
            return new IrGetFieldImpl($this$run.getStartOffset(), $this$run.getEndOffset(), (IrFieldSymbol)superField.getSymbol(), $this$run.getType(), $this$run.getDispatchReceiver(), $this$run.getOrigin(), null, 64, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            void causeArg;
            void messageArg;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            if (!ThrowableSuccessorsLowering.this.throwableConstructors.contains(expression2.getSymbol().getOwner())) {
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }
            expression2.transformChildren(this, data);
            Triple<IrExpression, IrExpression, List<IrStatement>> triple = this.extractConstructorParameters(expression2, data);
            IrExpression irExpression = (IrExpression)triple.component1();
            IrExpression irExpression2 = (IrExpression)triple.component2();
            List paramStatements = (List)triple.component3();
            IrDelegatingConstructorCall irDelegatingConstructorCall = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrDelegatingConstructorCall $this$run = irDelegatingConstructorCall;
            boolean bl3 = false;
            IrDelegatingConstructorCallImpl newDelegation = new IrDelegatingConstructorCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrConstructorSymbol)ThrowableSuccessorsLowering.this.defaultCtor.getSymbol(), ThrowableSuccessorsLowering.this.defaultCtor.getDescriptor());
            IrClass klass2 = this.successor.getKlass();
            Function0 receiver2 = (Function0)new Function0<IrGetValueImpl>(expression2, klass2){
                final /* synthetic */ IrDelegatingConstructorCall $expression;
                final /* synthetic */ IrClass $klass;

                @NotNull
                public final IrGetValueImpl invoke() {
                    int n = this.$expression.getStartOffset();
                    int n2 = this.$expression.getEndOffset();
                    IrValueParameter irValueParameter = this.$klass.getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    return new IrGetValueImpl(n, n2, irValueParameter.getSymbol(), null, 8, null);
                }
                {
                    this.$expression = irDelegatingConstructorCall;
                    this.$klass = irClass;
                    super(0);
                }
            };
            List<IrStatement> fillStatements = this.fillThrowableInstance(expression2, (Function0<? extends IrExpression>)receiver2, (IrExpression)messageArg, (IrExpression)causeArg);
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = expression2;
            boolean bl4 = false;
            boolean bl5 = false;
            IrDelegatingConstructorCall $this$run2 = irDelegatingConstructorCall2;
            boolean bl6 = false;
            return new IrCompositeImpl($this$run2.getStartOffset(), $this$run2.getEndOffset(), $this$run2.getType(), $this$run2.getOrigin(), CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)paramStatements, (Object)newDelegation), (Iterable)fillStatements));
        }

        private final List<IrStatement> fillThrowableInstance(IrFunctionAccessExpression expression2, Function0<? extends IrExpression> receiver2, IrExpression messageArg, IrExpression causeArg) {
            IrFunctionAccessExpression irFunctionAccessExpression = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionAccessExpression $this$run = irFunctionAccessExpression;
            boolean bl3 = false;
            IrSetFieldImpl setMessage = new IrSetFieldImpl($this$run.getStartOffset(), $this$run.getEndOffset(), (IrFieldSymbol)this.successor.getMessage().getSymbol(), (IrExpression)receiver2.invoke(), messageArg, ThrowableSuccessorsLowering.this.unitType, null, null, 192, null);
            IrFunctionAccessExpression irFunctionAccessExpression2 = expression2;
            bl2 = false;
            boolean bl4 = false;
            IrFunctionAccessExpression $this$run2 = irFunctionAccessExpression2;
            boolean bl5 = false;
            IrSetFieldImpl setCause = new IrSetFieldImpl($this$run2.getStartOffset(), $this$run2.getEndOffset(), (IrFieldSymbol)this.successor.getCause().getSymbol(), (IrExpression)receiver2.invoke(), causeArg, ThrowableSuccessorsLowering.this.unitType, null, null, 192, null);
            IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), ThrowableSuccessorsLowering.this.unitType, ThrowableSuccessorsLowering.this.captureStackFunction);
            bl4 = false;
            boolean bl6 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl7 = false;
            $this$apply.putValueArgument(0, (IrExpression)receiver2.invoke());
            IrCallImpl setStackTrace = irCallImpl;
            return CollectionsKt.listOf((Object[])new IrExpression[]{setMessage, setCause, setStackTrace});
        }

        private final Triple<IrExpression, IrExpression, List<IrStatement>> extractConstructorParameters(IrFunctionAccessExpression expression2, IrDeclarationParent parent2) {
            Triple triple;
            Function0 nullValue2 = (Function0)new Function0<IrConstImpl>(this, expression2){
                final /* synthetic */ ThrowableDirectSuccessorTransformer this$0;
                final /* synthetic */ IrFunctionAccessExpression $expression;

                @NotNull
                public final IrConstImpl invoke() {
                    return IrConstImpl.Companion.constNull(this.$expression.getStartOffset(), this.$expression.getEndOffset(), ThrowableSuccessorsLowering.access$getNothingNType$p(this.this$0.ThrowableSuccessorsLowering.this));
                }
                {
                    this.this$0 = throwableDirectSuccessorTransformer;
                    this.$expression = irFunctionAccessExpression;
                    super(0);
                }
            };
            if (expression2.getValueArgumentsCount() == 0) {
                triple = new Triple(nullValue2.invoke(), nullValue2.invoke(), (Object)CollectionsKt.emptyList());
            } else if (expression2.getValueArgumentsCount() == 2) {
                IrExpression irExpression = expression2.getValueArgument(0);
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression msg = irExpression;
                IrExpression irExpression2 = expression2.getValueArgument(1);
                if (irExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression cus = irExpression2;
                IrVariable irValM = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, msg.getType(), parent2, null, false, false, false, msg, 60, null);
                IrVariable irValC = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, cus.getType(), parent2, null, false, false, false, cus, 60, null);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ThrowableSuccessorsLowering.this.eqeqeqSymbol, ThrowableSuccessorsLowering.this.booleanType, null, 4, null);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irValM.getSymbol()));
                $this$apply.putValueArgument(1, (IrExpression)nullValue2.invoke());
                IrCall check2 = irCall;
                IrWhen msgElvis = JsIrBuilder.INSTANCE.buildIfElse(IrTypesKt.makeNullable$default(ThrowableSuccessorsLowering.this.stringType, false, 1, null), check2, ThrowableSuccessorsLowering.this.safeCallToString(irValC), JsIrBuilder.INSTANCE.buildGetValue(irValM.getSymbol()));
                triple = new Triple((Object)msgElvis, (Object)JsIrBuilder.INSTANCE.buildGetValue(irValC.getSymbol()), (Object)CollectionsKt.listOf((Object[])new IrVariable[]{irValM, irValC}));
            } else {
                IrExpression irExpression = expression2.getValueArgument(0);
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression arg = irExpression;
                IrVariable irVal = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, arg.getType(), parent2, null, false, false, false, arg, 60, null);
                IrGetValueImpl argValue = JsIrBuilder.INSTANCE.buildGetValue(irVal.getSymbol());
                triple = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull$default(arg.getType(), false, 1, null)) ? new Triple((Object)ThrowableSuccessorsLowering.this.safeCallToString(irVal), (Object)argValue, (Object)CollectionsKt.listOf((Object)irVal)) : new Triple((Object)argValue, nullValue2.invoke(), (Object)CollectionsKt.listOf((Object)irVal));
            }
            return triple;
        }

        public ThrowableDirectSuccessorTransformer(DirectThrowableSuccessors successor) {
            Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
            this.successor = successor;
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclaration declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering$ThrowablePropertiesUsageTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableSuccessorsLowering;)V", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.js"})
    public final class ThrowablePropertiesUsageTransformer
    extends IrElementTransformerVoid {
        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            if (expression.getSuperQualifierSymbol() == null) ** GOTO lbl-1000
            v0 = expression.getSuperQualifierSymbol();
            if (Intrinsics.areEqual((Object)(v0 != null ? (IrClass)v0.getOwner() : null), (Object)ThrowableSuccessorsLowering.access$getThrowableClass$p(ThrowableSuccessorsLowering.this))) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = transformRequired = false;
            }
            if (!transformRequired) {
                return super.visitCall(expression);
            }
            IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
            var4_4 = owner = expression.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)var4_4, (Object)ThrowableSuccessorsLowering.access$getMessageGetter$p(ThrowableSuccessorsLowering.this))) {
                var5_5 = new IrCallImpl(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), ThrowableSuccessorsLowering.access$getPropertyGetter$p(ThrowableSuccessorsLowering.this));
                var6_7 = false;
                var7_9 = false;
                $this$apply = var5_5;
                $i$a$-apply-ThrowableSuccessorsLowering$ThrowablePropertiesUsageTransformer$visitCall$1 = false;
                v2 = expression.getDispatchReceiver();
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                $this$apply.putValueArgument(0, v2);
                $this$apply.putValueArgument(1, ThrowableSuccessorsLowering.access$getMessageName$p(ThrowableSuccessorsLowering.this));
                v3 = var5_5;
            } else if (Intrinsics.areEqual((Object)var4_4, (Object)ThrowableSuccessorsLowering.access$getCauseGetter$p(ThrowableSuccessorsLowering.this))) {
                var5_6 = new IrCallImpl(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), ThrowableSuccessorsLowering.access$getPropertyGetter$p(ThrowableSuccessorsLowering.this));
                var6_8 = false;
                var7_10 = false;
                $this$apply = var5_6;
                $i$a$-apply-ThrowableSuccessorsLowering$ThrowablePropertiesUsageTransformer$visitCall$2 = false;
                v4 = expression.getDispatchReceiver();
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                $this$apply.putValueArgument(0, v4);
                $this$apply.putValueArgument(1, ThrowableSuccessorsLowering.access$getCauseName$p(ThrowableSuccessorsLowering.this));
                v3 = var5_6;
            } else {
                v3 = expression;
            }
            return v3;
        }
    }
}

